/***************************************************************************
  Windows Sockets Client Application Support Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/
/*
  MODULE: WS_IP.C

  Based on code published in UNIX Network Programming by W. Richard Stevens

  These are common routines that will be needed by many different programs
  and should not be modified for a specific instance.
*/
#include "ws_glob.h"
#include "ws_ftp.h"
#include <stdlib.h>

SOCKET connectTCP(char *host,char *service)
{
  return connectsock(host,service,"tcp");
}

SOCKET connectUDP(char *host,char *service)
{
  return connectsock(host,service,"udp");
}

SOCKET connectsock(char *host,char *service,char *protocol)
{
  struct hostent *pHostEntry;      // pointer to host entry
  struct servent FAR *pServiceEntry;   // pointer to service entry
  struct protoent FAR *pProtoEntry;    // pointer to protocol entry
  SOCKET sSocket;                  // socket
  int nSocketType;                 // socket type
  short pproto;

  DoPrintf("  ");
  // initialize socket address structure
  memset((char *)&saSockAddr,0,sizeof(saSockAddr));
  saSockAddr.sin_family=AF_INET;
  // get service port number from name
  if(pServiceEntry=getservbyname(service,protocol))
    saSockAddr.sin_port=pServiceEntry->s_port;
  else if((saSockAddr.sin_port=htons((u_short)atoi(service)))==0) {
    if(strcmpi(service,"FTP")==0)
      saSockAddr.sin_port=htons(21);
    else {
      DoPrintf("can't get \"%s\" service entry",service);
      return INVALID_SOCKET;
    }
  }
  // map host to ip, allow ip
  if(pHostEntry=gethostbyname(host))
    memcpy((char *)&saSockAddr.sin_addr,pHostEntry->h_addr,
             pHostEntry->h_length);
//  memcpy(pHostEntry->h_addr,(char *)&saSockAddr.sin_addr,pHostEntry->h_length);
  else if((saSockAddr.sin_addr.s_addr=inet_addr(host))==INADDR_NONE) {
    DoPrintf("can't get \"%s\" host entry",host);
    return INVALID_SOCKET;
  }
  // map protocol name to protocol number
  if((pProtoEntry=getprotobyname(protocol))==0) {
    if(strcmpi(protocol,"TCP")==0)
      pproto=6;
    else {
      DoPrintf("can't get \"%s\" protocol entry",protocol);
      return INVALID_SOCKET;
    }
  } else pproto=pProtoEntry->p_proto;
  // use protocol to choose socket type
  if(strcmp(protocol,"udp")==0)
    nSocketType=SOCK_DGRAM;
  else
    nSocketType=SOCK_STREAM;
  // allocate a socket
  sSocket=socket(AF_INET,nSocketType,pproto);
  if(sSocket==INVALID_SOCKET) {
    ReportWSError("create socket",WSAGetLastError());
    return INVALID_SOCKET;
  }

  memcpy((LPSTR)&saSockAddr1,(LPSTR)&saSockAddr,sizeof(saSockAddr));
  saSockAddr1.sin_port=htons(20);

  DoPrintf("connecting to %s ...",inet_ntoa(saSockAddr.sin_addr));
  // connect the socket
  if(connect(sSocket,(struct sockaddr *)&saSockAddr,sizeof(saSockAddr))
      ==SOCKET_ERROR) {
//  DoPrintf("Can't connect to %s %s service.",host,service);
    ReportWSError("Connect failed -",WSAGetLastError());
    return INVALID_SOCKET;
  }

  DoPrintf("Connected to %s port %u",
    inet_ntoa(saSockAddr.sin_addr),ntohs(saSockAddr.sin_port));

  return sSocket;
}

int sendstr(SOCKET sSocket,LPSTR pBuf,int nBytesToWrite)
{
  int nBytesLeft,nWritten;

  nBytesLeft=nBytesToWrite;
  while(nBytesLeft > 0) {                   // while we haven't written enough
    nWritten=send(sSocket,pBuf,((nBytesLeft>1024)?1024:nBytesLeft),0); // write what we can
    DoPrintf("[%u] %u send %u",sSocket,nBytesLeft,nWritten);
    if(nWritten <= 0) {
      ReportWSError("send",WSAGetLastError());
      return(nWritten);  // error occured
    }
    nBytesLeft -= nWritten;                 // count what we wrote
    pBuf   += nWritten;                     // adjust buffer pointer
  }
  return(nBytesToWrite - nBytesLeft);       // return count of bytes written
}

