
ChkPRO							User's Manual					ChkPRO
					Last revision date: September 24, 1995

NAME
	ChkPRO - checks ProBoard configuration records

SYNOPSIS
	chkpro -[bfmpv] [-l file] [-r] [-c] [-h]

DESCRIPTION
	Note:  this program supercedes BinFix. It has the same functionality
	plus a lot of additional features.  If you have ChkPRO, you don't need
	BinFix. Also note that the userbase processing has been immensely
	optimized as the program will no longer search the userbase for each
	record in the binary log, but will store all processed names in a
	binary search tree, so each unique user is processed only once.  This
	speeds up things considerably.

	ChkPRO is a MS-DOS command-line utility designed to check ProBoard's
	configuration records for the filebase, messagebase, the binary log,
	and the general paths.

	No modifications will be done unless the '-r' option is specified.

	Binary Log
		Sometimes, entries creep up in it for users that have been deleted
		from the userbase. This may cause some programs to choke and
		display incorrect results (early versions of Who Called have been
		known to do this).  ChkPRO will scan the binary log file for
		records of users that are no longer in the userbase and warn you
		of any such entries.  If '-r' option is specified, all these
		entries will be removed from the file and the old BINLOG.PB will
		be saved as BINLOG.BAK

	Filebase
		When you do a lot of shuffling and changes of your file areas,
		some errors are common:  you specify an invalid path for the data
		directory or a bad file name for the listing file.  This program
		will check these and report the errors.  If the '-r' option is
		specified, ChkPRO will try to create the missing directories.  It
		will not do anything for the description files.

		ChkPRO also knows about the FA_???.CTL mechanism of ProBoard for
		specifying a list of directories that belong to the same file
		area.  It will check to see if the number of the FA_???.CTL file
		given on the data path is the same as the area number (it must be
		or ProBoard will not recognize it) and warn you if there are any
		discrepancies. The '-r' switch does nothing in this case.

		Also, ChkPRO will warn you if you have definitions of file groups
		that are empty, i.e. no file areas belong to these groups.

	Message base
		For the message base scan, ChkPRO will check for valid paths and
		file names (were applicable) of each message area.

		If an area is Hudson, it will check the userbase path in your
		configuration.  This is where your Hudson messagebase files go.
		Also, it will check if the area number is higher than 200, which
		is an error since Hudson cannot store more than 200 areas.  The
		'-r' option will cause the program to attemt to create the
		directory.

		If an area is Squish or JAM, ChkPRO will see if for the specified
		root name there exists a database file.  It will check for the
		files that store message text (*.SQD and *.JDT).  The '-r' option
		has no effect on these areas.

		For Fido *.MSG type areas, ChkPRO will check for a valid
		directory.  The '-r' option will cause the program to attempt to
		create the directory.

		Also, ChkPRO will warn you if you have definitions of message groups
		that are empty, i.e. no message areas belong to these groups.

	General paths
		Since v2.12 of ProBoard, this option has limited usefulness since
		ProCFG will not let you have any non-existen directories.  The
		following paths will be checked and if '-r' is specified, created:

		Textfiles, Menus, Msg, Upload, Nodelist, Private Upload, PEX, RIP
		and Icons paths.

	You must have the PROBOARD environment variable set up to point to
	you ProBoard system directory because ChkPRO uses it to locate all the
	files it needs.

OPTIONS
	Every option is preceded by the '-' character, note that the case
	is significant, so make sure you use the correct letters. Options
	can be grouped under on switch except when taking additional
	arguments, in which case the argument must follow the option letter
	(with optional whitespace between them) and should be separated from
	the next option with at least on whitepace character.

	-b
		check the binary log file

	-f
		check the filebase

	-m
		check the messagebase

	-p
		check paths in the general configuration

	-r
		repair (see notes under each section)

	-l file
		log everything to 'file'.  You can specify a full path to the
		logfile.  ChkPRO uses the same format as ProBoard, so you can even
		log your changes to PROBOARD.LOG Note:  you must specify the full
		path to the log file or else it will be created in the current
		directory where ChkPRO was started from.

	-h
		displays a brief summary of correct usage

	-v
		displays version information

	-c
		displays copyright and license notice

EXAMPLES
	chkpro -bfmp
		Check all configuration, do not attempt to repair anything

	chkpro -brl chkpro.log
		Check the binary log, fix it if necessary and log all changes to
		the file CHKPRO.LOG in the current directory.

FILES
	CHKPRO.EXE

DIAGNOSTICS
	ChkPRO displays a lot of messages and all of them are
	self-explanatory.  Note that errors will be logged to the logfile if
	one is specified on the command line.

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.0r1
	Release Date: September 22, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

LEGAL
	ChkPRO is using source code from PBLib, Copyright (C) 1995 by
	Branislav L. Slantchev

	ChkPRO was compiled with the following products:

	BCC 3.1, TLINK 5.22b, TLIB 3.02, MAKE 3.6, Copyright by Borland Int'l.

	ChkPRO (all executables, source and documentation files)
	are Copyright (C) 1995 by Branislav L. Slantchev.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT.DOC). I will really appreciate that.

