/*
 * ChkPro v1.0r1 - ProBoard Configuration Checking Utility
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, part of the PB-GNU Project
 *
 * For details, see the file "copying".
 *
*/
#include <stdio.h>
#include <dir.h>
#include <proutil.h>
#include <fsys.h>

/* these are defined in the main module */
extern void _pascal logexit(const char *format, ...);
extern void _pascal log(const char *format, ...);

#define NELEM(a)  ( sizeof(a) / sizeof(a[0]) )
#define LASTCH(s)  ( s[strlen(s) - 1] )

static struct{
	char path[MAXPATH];
	char name[20];
} pathList[9] = {
	{ "", "Text files" },
	{ "", "Menu" },
	{ "", "Message base" },
	{ "", "Upload" },
	{ "", "Nodelist" },
	{ "", "Private upload" },
	{ "", "PEX" },
	{ "", "RIP" },
	{ "", "Icons" }
};

/*************************************************************************\
 ** Main processing function
\*************************************************************************/
	int _pascal
do_config(bool repair)
{
	CONFIG  buf;
	FILE   *fpSrc;
	int     i, retval = 0;
	char    curDir[MAXPATH];

	if( NULL == (fpSrc = pbfopen(fnCONFIG, "rb")) )
		logexit("Could not open main configuration file '%s'\n", fnCONFIG);
	fread( &buf, sizeof(buf), 1, fpSrc );
	fclose(fpSrc);

	strcpy(pathList[0].path, buf.txtpath); LASTCH(pathList[0].path) = EOS;
	strcpy(pathList[1].path, buf.mnupath); LASTCH(pathList[1].path) = EOS;
	strcpy(pathList[2].path, buf.msgpath); LASTCH(pathList[2].path) = EOS;
	strcpy(pathList[3].path, buf.uploadpath); LASTCH(pathList[3].path) = EOS;
	strcpy(pathList[4].path, buf.nodelistdir); LASTCH(pathList[4].path) = EOS;
	strcpy(pathList[5].path, buf.pvtuploadpath); LASTCH(pathList[5].path) = EOS;
	strcpy(pathList[6].path, buf.pexpath); LASTCH(pathList[6].path) = EOS;
	strcpy(pathList[7].path, buf.RIPpath); LASTCH(pathList[7].path) = EOS;
	strcpy(pathList[8].path, buf.iconspath); LASTCH(pathList[8].path) = EOS;

	getcwd(curDir, sizeof(curDir));

	for( i = 0; i < NELEM(pathList); ++i ){
		if( -1 == chdir(pathList[i].path) ){
			int stat;

			if( repair ) stat = mkDirTree(pathList[i].path);
			log("%s path does not exist.%s\n", pathList[i].name, repair ?
				((-1 == stat) ? "..create failed" : "..created") : "" );
			retval = -1;
		}
	}

	chdir(curDir);
	return retval;
}

#undef NELEM
#undef LASTCH
