' 
' Program Title: Menu Jumper
'     Copyright: None... Freebie Ware :)
'        Author: Freejack's Software by Gary Price
' Last Modified: 10/18/95
' 
$CPU 80386                ' program for 386 machines or better

$OPTIMIZE SIZE            ' make smallest possible executable
$COMPILE EXE  "JUMP.EXE"  ' compile to an EXE

$DEBUG MAP OFF            ' turn off map file generation
$DEBUG PBDEBUG OFF        ' don't include pbdebug support in our executable

$LIB COM        OFF       ' turn off PowerBASIC's communications library.
$LIB CGA        OFF       ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF       ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF       ' turn off PowerBASIC's VGA graphics library.
$LIB HERC       OFF       ' turn off PowerBASIC's hercules graphics library.
$LIB LPT        OFF       ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF       ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF       ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   OFF       ' turn off bounds checking
$ERROR NUMERIC  OFF       ' turn off numeric checking
$ERROR OVERFLOW OFF       ' turn off overflow checking
$ERROR STACK    OFF       ' turn off stack checking

'$FLOAT PROCEDURE         ' use procedural floating point to optimize for
                          ' machines without a co-processor
$COM    0                 ' set communications buffer to nothing
$STRING 16                ' set largest string size at 16k
$STACK  2048              ' let's use a 2k stack
$SOUND  1                 ' smallest music buffer possible

'$DIM ARRAY                ' force arrays to be pre-dimensioned before they can
                           ' be used
'$DYNAMIC                  ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF     ' don't allow Ctrl-Break to exit program

DEFINT A-Z                ' default all variables to integers for maximum
			  ' speed and minimum size
'===========================================================================
' File Name: "DOORS.TMP"
TYPE DoorTMP
	TimeLeftAtLogon AS INTEGER
	CurrentFileArea AS INTEGER
	CurrentMessageConference AS INTEGER
	FrontEndTime AS INTEGER
	WhereTheDoorWasCalledFrom AS INTEGER
	LanguageNumber AS INTEGER
	NumberOfFilesFlagged AS INTEGER
	TimeInDOORSYS AS INTEGER
	UserRecordNumber AS LONG
	BaudRate AS LONG
	FrontEndBaudRate AS LONG
	TimeWhenUserLoggedOn AS LONG
	BitFields AS STRING * 10
END TYPE
DIM DoorTMP AS DoorTMP

ON ERROR GOTO ErrorHandler

IF LEN(DIR$("JUMP.CFG")) = 0 THEN GOTO ConfigFileMissing
OPEN "JUMP.CFG" FOR INPUT AS #1
  LINE INPUT #1, Node$
CLOSE #1

Node$ = RTRIM$(Node$, ANY " " + CHR$(0))
IF LEN(DIR$(Node$, 16)) = 0 THEN GOTO PathNotFound

S$ = UCASE$(RTRIM$(COMMAND$, ANY " " + CHR$(0)))
SELECT CASE S$
       CASE = "DOORS"    'DOORS
          q = 0
       CASE = "NEWUSER"  'NEWUSER
          q = 1
       CASE = "SEC"      'SECnnn
          q = 2
       CASE = "LOGON"    'LOGON
          q = 3
       CASE = "MAIN"     'MAIN
          q = 4
       CASE = "FILES"    'FILES
          q = 5
       CASE = "MESS"     'MESSAGE
          q = 6
       CASE = "SYS"      'SYSOP
          q = 7
       CASE = ""
          GOTO CommandLineMissing
       CASE ELSE
          GOTO WrongCommandLineName
END SELECT

IF LEN(DIR$(Node$ + "\NWORK\DOORS.TMP")) = 0 THEN GOTO DONE
OPEN Node$ + "\NWORK\DOORS.TMP" FOR RANDOM ACCESS READ WRITE SHARED AS #1 LEN=LEN(DoorTMP)
        GET #1, 1, DoorTMP
           DoorTMP.WhereTheDoorWasCalledFrom = q
        PUT #1,1,DoorTMP

DONE:
CLOSE #1
END
'========================== Error Checking Below ===========================
PathNotFound:
CLS
   LOCATE 13, 26, 0: COLOR 12, 0: PRINT "Path Not Found ";
   :COLOR 14, 0: PRINT "'";Node$;"'"
GOTO DONE


ConfigFileMissing:
CLS
   LOCATE 13, 28, 0: COLOR 12, 0: PRINT "Can Not Find Jump.Cfg";
GOTO DONE

WrongCommandLineName:
CLS
   LOCATE 13, 25, 0: COLOR 12, 0: PRINT "Improper Command Line Name ";
   :COLOR 14, 0: PRINT "'";S$;"'"
GOTO DONE

CommandLineMissing:
CLS
   LOCATE 13, 28, 0: COLOR 12, 0: PRINT "Command Line Missing!"
GOTO DONE

ErrorHandler:
CLS
SELECT CASE ERR
   LOCATE 13, 30, 0: COLOR 12, 0: PRINT "Error # ";ERR
END SELECT

RESUME DONE