;----------------------------------------------------------------------
; (c) copyright 1993 Santronics Software
; All Rights Reserved World Wide
; Version 5.00
;----------------------------------------------------------------------
; THIS XPMENU.CTL WORKS FOR VERSION 5.0x OF XPMAIL.EXE ONLY. THE OLDER
; 3.0x or 4.0x XPMENU.CTL FORMAT WILL NOT WORK WITH VERSION 5.0x.
;----------------------------------------------------------------------
;
; Silver Xpress Menu System is a dynamic menu system.  You can define upto
; 20 different menus with each menu having 20 different items. Since Silver
; Xpress is a very sophiscated application, it has alot of options users
; can use.  All the options are security based (Xpress security).  This
; default menus and options defined here will give your user the MOST of
; Silver Xpress. It is also setup for the SYSOP to have some other sysop
; only options. Pay attention to the security values.
;
;----------------------------------------------------------------------

; Defining the top menu and configuration menu.
; There are two special menus Xpress looks for:
;
;    TopMenuName        REQUIRED  - Top Level Menu
;    ConfigMenuName     OPTIONAL  - Displayed to first time user
;
; TopMenuName     This menu will be the FIRST MENU DISPLAY to the user
;                 every time he enters Silver Xpress. The only exception
;                 is if the user is a FIRST TIME USER and ConfigMenuName
;                 keyword is defined.
;
; ConfigMenuName  If defined, this is the menu which will be shown the
;                 first time the user enters Silver Xpress. This allows
;                 Xpress to present Xpress configuration options first.
;                 If this keyword is not defined, no configuration menu
;                 will be showned and the user will be taken to the top
;                 menu.

TopMenuName  MAIN
ConfigMenuName CONFIG

;----------------------------------------------------------------------
; Defining macros for the menus
;
; Xpress 5.0x has a new macro system which allows you to add tremendous
; power to Silver Xpress (like it needed any more <grin>).  As you will
; see below, each menu items you define use action codes (tags). You
; can basically STACK this action codes into macros and then use the
; macros for your menu items.  To offer macros, create a MACRO block.
;
;    MACRO
;       <MacroName> <Security> <keystrokes> [description]
;       .
;       .
;    ENDMACRO
;
;    MacroName       This is the name of the macro that you can use with
;                    the _MACRO action code.
;    Security        The Xpress user security required to access this macro
;    Keystrokes      Keystrokes that are used for this macro.
;    Description     Optional description beginning with double quote.
;

MACRO
 LIST       0     @174             "List all available macros
 SCANOPX    0     @153@107         "Scan and pack an OPX mail Packet
 SCANQWK    0     @154@107         "Scan and pack a QWK mail Packet
 ANSI       0     @119@122         "Set ansi and novice menu level
 BYE        0     @131             "Exit Xpress
 DEFAULT    0     @111Z@112Z@153   "Set ZModem, ZIP and OPX mode
 ARCH       0     @112             "Select an archiver
 XFER       0     @111             "Select a protocol
 RIPON      0     @175             "Turn off RIP graphics
 RIPOFF     0     @176             "Turn ON RIP Graphics
 MAIN       0     @135             "Return to main menu
 DL         200   @105             "Download file (SYSOP command)
 KEYWORD    0     @114             "Edit Keywords
 DOS        40000 @104             "Shell to Dos"
ENDMACRO

; The following keywords defined the POWER and MACRO keys the user
; can use at the menus. It is highly recommended that you don't change
; them unless there was a real need. Note: Any ascii character can be
; used except ';' (semi-colon) and '|' (vertical bar);

; Power Char is used with a action code number, i,e,. @112 where 112 is
; the action code.  Macro Char is used with a macro command, i.e., \ANSI

POWERCHAR @
MACROCHAR \

; The ACTION CODE list allows you to define the security for each available
; command in Xpress.  The security only works within the MACRO or POWER
; command system, not in the menus. In other words, if you use a _DNLDFILE
; option in one of the menus, the menu option security overrides the action
; code security.  The action code security is used when the user attempts
; to use a macro or power command from any menu level, i.e., \DL

ACTIONCODE
 _USRLIST         0
 _RUSRLIST        0
 _LOG             0
 _SHELL           40000
 _DNLDFILE        200
 _UPLDFILE        0
 _DNLDMAIL        0
 _UPLDMAIL        0
 _USERLOG         0
 _SELECT          0
 _XFERTYPE        0
 _ARCHTYPE        0
 _BULLETINS       0
 _KEYWORDS        0
 _OWNMAIL         0
 _GRPMAIL         0
 _LASTDATE        0
 _RESTORELR       0
 _COLOR           0
 _HOTKEY          0
 _IBMCHAR         0
 _NOVICE          0
 _VETERAN         0
 _GXPRESS         0
 _RPASSWORD       0
 _DPASSWORD       0
 _VACSAVER        0
 _FILESCAN        0
 _FILEDATE        0
;_FILEFREQ        200
 _DELXAM          0
 _QUIT            0
 _HELP            0
 _RETURN          0
 _GOODBYE         0
 _TOPMENU         0
 _NORIP           0
 _AUTOSTART       0
 _SYSPARM         0
 _CHAT            200
 _DISPLAY         0
 _VACPAC          0
 _DISPVER         0
 _DNLDUPD         0
 _SAVEINFO        0
 _AVATAR          0
 _TTYMODE         0
 _PKTOPX          0
 _PKTQWK          0
 _PKTTEXT         0
 _QWKSTRIPK       0
 _QWKCAPHDR       0
 _QWKNDX          0
 _SENDXFILES      0
 _SELAREAS        0
 _PKTCOUNT        0
 _CHANGELR        0
 _GOSUB           0
 _USEFLEXASST     0
 _SHOWMAILONLY    0
 _QWKWWRAP        0
 _TOSSDUMP        0
 _XNLIST1         0
 _XNLIST2         0
 _MACRO           0
 _MACROLIST       0
 _RIPON           0
 _RIPOFF          0
 _RULESEARCH      0
 _SRCHTEXT        0
 _REPRECEIPT      0
 _ANSILIST        0
ENDACTION

;----------------------------------------------------------------------
; Defining a Menu to Present to the user.
;
; Each Menu is defined using the MENU and ENDMENU block keywords.
;
;           MENU MenuName Security
;             ITEMCOLOR  <hotkey color> <option color>
;             ITEM  <security> <actiontag [optional data]> <description>
;             ITEM ......
;             ITEM ......
;           ENDMENU
;
;    MenuName        The name of the menu. You can use this name in you
;                    _GOSUB menu action codes.
;    Security        The Xpress user security required to access this menu.
;
; Each ITEM has the following format:
;
;    ITEM  <security> <actiontag [optional data]> <description>
;
;    Security        The Xpress user security to access this item
;    ActionTag       Action to be taken. See doc for available action tags.
;                    Some action tags required optional data.
;                    _DISPLAY <filename>
;                    _DNLDFILE <filename or ? for prompt>
;                    _UPLDFILE <filename or ? for prompt>
;                    _GOSUB    <Name of Menu to link>
;                    _MACRO    <macro name in macro block>
;    description     This is the description the user sees in the menu.
;                    The hot key for this item must be surrounded by carets.
;                    If you precede the description with a quote character,
;                    no leading spaces will be removed. If you end the line
;                    a semi-colon, then no carriage return and linefeed will
;                    be added. The semi-colon is good for creating 2 column
;                    menus.
;
;                    If the description has any of the % parameters, a
;                    substition will be made.
;
;                      %sa   - # of selected areas
;                      %tm   - file transfer protocol
;                      %cm   - compression method
;                      %gb   - general bulletins
; obselete             %kw   - total keywords
;                      %ro   - receive own mail
;                      %rg   - receive group mail
;                      %ld   - last usage date
;                      %ag   - Color Graphics (Ansi)
;                      %av   - Avatar Graphics
;                      %hk   - Menu Hot Keys
;                      %ic   - IBM Characters
;                      %nm   - Novice Menu Mode
;                      %xm   - Veteran Menu Mode
;                      %gx   - Gold Xpress Menu Mode
;                      %vs   - Vacation saver
;                      %fs   - file scan
;                      %fd   - file scan date
;                      %pt   - packet type
;                      %sk   - strip kludges in mail
;                      %ch   - capitalize header in qwk mail
;                      %sn   - Do not Send NDX files
;                      %sx   - Do not send QWK/X files
;                      %so   - send selected areas only
;                      %hr   - HMS (QBBS/RA) last read value
;                      %pc   - Use Packet Counter
;                      %fa   - Use flex assistance
;                      %mo   - Show area with mail only
;                      %ww   - Perform Word Wrapping for QWK
;                      %nr   - NO Rip Graphics
;                      %nl1  - Xpress nodelist 1
;                      %nl2  - Xpress nodelist 2
;                      %as   - Auto Start Xpress
;                      %sb   - search body of text
;                      %rr   - send reply receipt
;
;----------------------------------------------------------------------
;
; A menu block must begin with a MENU command, the first parameter is the
; menu name and the optional second parameter is the Xpress Security
; value. If no security is define, then it becomes 0 and all users will
; see this menu.


MENU MAIN

; This is the prompt shown to the user when he has Gold Xpress mode enabled.
; These are usually short keywords which a smart comm program can pick up
; to display off-loaded menus.

  GXPROMPT  SX_MAIN>
;
; NTITLE is the title shown during novice mode, VTITLE is the title shown
; during veteran (expert) mode, and RTITLE is use during RIP mode. NTITLE
; is commented out because the title is display using JUNK menu items. See
; below.
;
; NTITLE    YELLOW Silver Xpress Main Menu
; VTITLE    YELLOW Main Menu
  VTITLE    YELLOW Ȫ֫HtΥD (Ĥ@H)
  RIPTITLE  Silver Xpress Main Menu
;
;
; name of help file
; (also name of optional menu ansi file shown, x.ANS or x.TXT or x.RIP)
;
  HELP      main
;
; Menu items. In this example, the NTITLE is commented out and menuitems are
; used to draw a TITLE HEADER for the menu.  The _JUNK xpress menu token is
; used to tell Xpress the menu option is meaningless.
;
  ITEMCOLOR WHITE LRED
; MENUITEM  0 _JUNK     'Ŀ'
  MENUITEM  0 _JUNK     'zwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww{'
; MENUITEM  0 _JUNK     '                   ^Silver Xpress Main Menu^                   '
  MENUITEM  0 _JUNK     'x^  Sonic BBs (Sonic Studio.)tplT      b: 18388229 ùA]  ^x'
  MENUITEM  0 _JUNK     'x^  Ȫ֫H[t Silver Xpress (SX)      UNz: tpl T  ^x'
; MENUITEM  0 _JUNK     ''
  MENUITEM  0 _JUNK     '|wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww}'
  ITEMCOLOR YELLOW WHITE

; MENUITEM  0  _GOSUB SYSOP   ' [^#^]..System Information        ;
  MENUITEM 100 _GOSUB SYSOP   ' [^#^]..Mο                     ;
  RIP # Sysop Options

  ITEMCOLOR LRED WHITE
; MENUITEM  0  _DISPLAY DLGUIDE ' [^A^]..Download DOOR User Guide
  MENUITEM  0  _DISPLAY DLGUIDE ' [^A^]..Uǥ~{ϥλ
  RIP # Download Door Guide

  ITEMCOLOR LCYAN WHITE
; MENUITEM  0  _SELECT        ' [^S^]..Change Selected Areas     ;
  MENUITEM  0  _SELECT        ' [^S^]..ܫH                       ;
  RIP # Change Selected Areas

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0  _GOSUB CONFIG  '  [^C^]..Configuration
  MENUITEM  0  _GOSUB CONFIG  ' [^C^]..򥻳]w
  RIP Configuration

  ITEMCOLOR LCYAN WHITE
; MENUITEM  0 _DISPLAY  DLRDR ' [^R^]..Download Xpress Reader    ;
  MENUITEM  0 _DISPLAY  DLRDR ' [^R^]..UǻȪ֫HŪH{            ;
  RIP Download Xpress Reader

  ITEMCOLOR LCYAN WHITE
; MENUITEM  0 _GOSUB ASSIST   '  [^X^]..Xpress Assistant
  MENUITEM  0 _GOSUB ASSIST   '  [^X^]..Ȫ֫HSO
  RIP Xpress Assistant

  ITEMCOLOR LGREEN WHITE
  MENUITEM
; MENUITEM  0 _MACRO SCANOPX  ' [^D^]..Scan/Download OPX Packet  ;
  MENUITEM  0 _MACRO SCANOPX  ' [^D^]..y/U OPX 榡H]        ;
  RIP Scan/Download OPX Packet (Xpress Reader Only)

  ITEMCOLOR LGREEN WHITE
; MENUITEM  0 _MACRO SCANQWK  '  [^K^]..Scan/Download QWK Packet
  MENUITEM  0 _MACRO SCANQWK  '  [^K^]..y/U QWK榡H]
  RIP Scan/Download QWK Packet

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _UPLDMAIL       ' [^U^]..Upload Your Mail          ;
  MENUITEM  0 _UPLDMAIL       ' [^U^]..WǱz^^HH] *.REP          ;
  RIP Upload Your Mail

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _VACPAC         '  [^V^]..Check Vacation Mail
  MENUITEM  0 _VACPAC         '  [^V^]..ˬdȧ֩wOdH]
  RIP Check Vacation Mail

  ITEMCOLOR LBLUE WHITE
; MENUITEM  0 _USERLOG        ' [^L^]..Personal Log              ;
  MENUITEM  0 _USERLOG        ' [^L^]..[ݭӤHO                    ;
  RIP See Personal Log

  ITEMCOLOR LCYAN YELLOW
; MENUITEM  0 _HELP           '  [^?^]..Show help
  MENUITEM  0 _HELP           '  [^?^]..ܽuWUe
  RIP ? HELP

  ITEMCOLOR WHITE LCYAN
; MENUITEM  0 _QUIT           ' [^Q^]..Return to Main System      ;
  MENUITEM  0 _QUIT           ' [^Q^]..^^ B B S Dt               ;
  RIP QUIT
;
; if you do not want to have a goodbye option, then comment out the
; goodbye option. If do you comment it out, uncomment the _JUNK MENUITEM
; below it.
;
  ITEMCOLOR WHITE LCYAN
; MENUITEM  0 _GOODBYE        '  [^G^]..GoodBye (Logoff)
  MENUITEM  0 _GOODBYE        '  [^G^]..u} (Logoff)
  RIP GoodBye
; MENUITEM
  ITEMCOLOR WHITE LRED
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
;
; Normally, the menu system will allow a carriage return to go to previous menu.
; It will normally use the LAST hotkey defined. Since the last menuitem is not
; a normal option, RETURNKEY is used to define the key that will be used
; when carriage return is hit.
;
  RETURNKEY Q
;
; This is the line shown during veteran mode
;
;  VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
   VETERAN   YELLOW WHITE Ī: [^%keys^]
;
; This is the prompt shown to users. Highlight color, normal color,
; and the prompt color is the order of the format. Only two substitutions
; can be made, %tr time remaining, %fn user's first name.
;
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

;
; configuration menu.
;

MENU CONFIG
  GXPROMPT  SX_CFG>
  VTITLE    WHITE Configuration Menu
  VTITLE    WHITE 򥻻Ȫ֫H]w
  RIPTITLE  Silver Xpress Configuration Menu
  HELP      config
; ITEM COLOR 63 WHITE
  ITEMCOLOR WHITE LRED
; MENUITEM  0 _JUNK      '^ Configuration Menu ^'
  MENUITEM  0 _JUNK      'wwwwwwwwww^ 򥻻Ȫ֫H]w ^wwwwwwwwwww'

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _SELECT     ' [^S^]....Select Mail Areas,   - %sa selected
  MENUITEM  0 _SELECT     ' [^S^]....ܫH           - %sa ӫHϤw
  RIP Select Mail Areas

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _XFERTYPE   ' [^F^]....File Transfer Method - %tm
  MENUITEM  0 _XFERTYPE   ' [^F^]....H]ǿw]w     - %tm
  RIP File Transfer Method

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _ARCHTYPE   ' [^A^]....Archiver Method      - %cm
  MENUITEM  0 _ARCHTYPE   ' [^A^]....H]Y榡]w     - %cm
  RIP Archiver Method

  ITEMCOLOR LCYAN WHITE
  MENUITEM
; MENUITEM  0 _GOSUB MAILOPTS  ' [^M^]....Mail Options
  MENUITEM  0 _GOSUB MAILOPTS  ' [^M^]....H]򥻳]w
  RIP Mail Options

  ITEMCOLOR LCYAN WHITE
; MENUITEM  0 _GOSUB SERVICES  ' [^X^]....Xpress Services
  MENUITEM  0 _GOSUB SERVICES  ' [^X^]....Ȫ֫HAȿ
  RIP Xpress Services

  ITEMCOLOR LCYAN WHITE
; MENUITEM  0 _GOSUB TERMINAL  ' [^T^]....Terminal Options
  MENUITEM  0 _GOSUB TERMINAL  ' [^T^]....׺ݾҦ򥻳]w
  RIP Terminal Options

  ITEMCOLOR LGREEN WHITE
; MENUITEM  0 _SAVEINFO   ' [^C^]....Save Current Configuration
  MENUITEM  0 _SAVEINFO        ' [^C^]....N{b]ws
  RIP Save Configuration

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _HELP       ' [^?^]....Show help
  MENUITEM  0 _HELP            ' [^?^]....ܽuWUe
  RIP ? HELP

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _RETURN     ' [^Q^]....Return to Main Menu
  MENUITEM  0 _RETURN          ' [^Q^]....^^W@
  RIP Quit

  ITEMCOLOR WHITE LRED
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

;
; mail options
;

MENU MAILOPTS
  GXPROMPT  SX_MOPT>
; VTITLE    WHITE Mail Options
  VTITLE    WHITE H]򥻳]w
  RIPTITLE  Mail Options
  HELP      moptions
; ITEM COLOR 63 WHITE
  ITEMCOLOR WHITE LGREEN
; MENUITEM  0 _JUNK         '^ Mail Options ^'
  MENUITEM  0 _JUNK          'wwwwwwwwwwww^ H]򥻳]w ^wwwwwwwwwwwww'

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _KEYWORDS      ' [^K^]....Define Search Rules (Keywords)
  MENUITEM  0 _KEYWORDS      ' [^K^]....]ww]jMHr
  RIP Define Keywords

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _SRCHTEXT      ' [^B^]....Search Message Body w/ Keywords - ^%sb^
  MENUITEM  0 _SRCHTEXT      ' [^B^]....̩ҳ]wrjMH󤺮e      - ^%sb^
  RIP Search Message Body

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _OWNMAIL       ' [^Y^]....Receive Your Own Mail           - ^%ro^
  MENUITEM  0 _OWNMAIL       ' [^Y^]....zۤvgH              - ^%ro^
  RIP Receive Your OWN Mail

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _GRPMAIL       ' [^G^]....Receive Group Mail              - ^%rg^
  MENUITEM  0 _GRPMAIL       ' [^G^]....H                    - ^%rg^
  RIP Receive Group Mail

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _GOSUB PACKET  ' [^P^]....Choose Mail Packet Format       - ^%pt^ format
  MENUITEM  0 _GOSUB PACKET  ' [^P^]....ܫH]]榡                - ^%pt^
  RIP Choose Packet Format

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _PKTCOUNT      ' [^C^]....Use Packet Extension Counter    - ^%pc^
  MENUITEM  0 _PKTCOUNT      ' [^C^]....H]ɪ[Ʀrp(*.O??)     - ^%pc^
  RIP Use Packet Extension

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _SELAREAS      ' [^S^]....ueXwܪH              - ^%so^
  MENUITEM  0 _SELAREAS      ' [^S^]....ueXwܪH              - ^%so^
  RIP Send Selected

  ITEMCOLOR YELLOW LCYAN
; MENUITEM  0 _USEFLEXASST   ' [^F^]....Use Flex Assistant at Mail Scan - ^%fa^
  MENUITEM  0 _USEFLEXASST   ' [^F^]....H]yɨϥμuʫO          - ^%fa^
  RIP Flex Assistant

  ITEMCOLOR YELLOW LCYAN
; MENUITEM  0 _SHOWMAILONLY  ' [^O^]....Show Areas with Mail Only       - ^%mo^
  MENUITEM  0 _SHOWMAILONLY  ' [^O^]....HɥuܦH󪺫H        - ^%mo^
  RIP Show Areas With Mail

  ITEMCOLOR YELLOW LCYAN
  MENUITEM  0
; MENUITEM  0 _LASTDATE      ' [^D^]....Change Mail Pointers By Date
  MENUITEM  0 _LASTDATE      ' [^D^]....קH
  RIP Change Pointers by Date

  ITEMCOLOR YELLOW LCYAN
; MENUITEM  0 _CHANGELR      ' [^N^]....Change Mail Pointers By Number
  MENUITEM  0 _CHANGELR      ' [^N^]....קHs
  RIP Change Pointers by Number

  ITEMCOLOR LBLUE WHITE
; MENUITEM  0 _RESTORELR     ' [^R^]....Restore Entry Mail Pointers
  MENUITEM  0 _RESTORELR     ' [^R^]....mHŪ
  RIP Restore Enter Pointers

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _HELP          ' [^?^]....Show help
  MENUITEM  0 _HELP          ' [^?^]....ܽuWUe
  RIP ? HELP

  ITEMCOLOR LRED LCYAN
; MENUITEM  0 _TOPMENU       ' [^/^]....Main Menu
  MENUITEM  0 _TOPMENU       ' [^/^]....^^D
  RIP / (Main)

  ITEMCOLOR LGREEN WHITE
; MENUITEM  0 _RETURN        ' [^Q^]....Return to Previous Menu
  MENUITEM  0 _RETURN        ' [^Q^]....^^W@
  RIP Quit

  ITEMCOLOR WHITE LGREEN
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

;
; terminal options
;
MENU TERMINAL
  GXPROMPT  SX_TOPT>
; VTITLE     WHITE Terminal Options
  VTITLE     WHITE ׺ݾ򥻳]w
  RIPTITLE   Terminal Options
  HELP      terminal
; ITEM COLOR 63 WHITE
  ITEMCOLOR WHITE LCYAN
; MENUITEM  0 _JUNK      '^ Terminal Options ^ '
  MENUITEM  0 _JUNK       'wwwwwwwwww^ ׺ݾҦ򥻳]w ^wwwwwwwwwww'

  ITEMCOLOR LCYAN LBLUE
; MENUITEM  0 _COLOR      ' [^C^]....Ansi Color              - %ag
  MENUITEM  0 _COLOR      ' [^C^]....ANSImϧάɭ}    - %ag
  RIP Use Ansi (Color)

  ITEMCOLOR WHITE WHITE
; MENUITEM  0 _TTYMODE    ' [^T^]....TTY (No Color)          - %at
  MENUITEM  0 _TTYMODE    ' [^T^]....TTY ϧάɭ}    - %at
  RIP Use TTY

  ITEMCOLOR YELLOW LCYAN
; MENUITEM  0 _AVATAR     ' [^A^]....Avatar Graphics         - %av
  MENUITEM  0 _AVATAR     ' [^A^]....Avatarmϧάɭ}  - %av
  RIP Use Avatar

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _HOTKEY     ' [^H^]....Menu Hot Keys           - %hk
  MENUITEM  0 _HOTKEY     ' [^H^]....Ҧ            - %hk
  RIP Use Menu Hot Keys

  ITEMCOLOR WHITE LGREEN
; MENUITEM  0 _IBMCHAR    ' [^I^]....IBM Characters          - %ic
  MENUITEM  0 _IBMCHAR    ' [^I^].... IBM r(奲) - %ic
  RIP Use IBM Characters

  ITEMCOLOR LRED LCYAN
; MENUITEM  0 _NOVICE     ' [^N^]....Novice Menu Mode        - %nm
  MENUITEM  0 _NOVICE     ' [^N^]....泾ŧ֫HҦ      - %nm
  RIP Novice Menu Mode

  ITEMCOLOR YELLOW WHITE
; MENUITEM  0 _VETERAN    ' [^V^]....Veteran Menu Mode       - %xm
  MENUITEM  0 _VETERAN    ' [^V^]....Ѥ֫HҦ        - %xm
  RIP Veteran Menu Mode

  ITEMCOLOR YELLOW LRED
; MENUITEM  0 _GXPRESS    ' [^X^]....Gold Xpress Menu Mode   - %gx
  MENUITEM  0 _GXPRESS    ' [^X^]....֫HҦ        - %gx
  RIP Gold Xpress Menu Mode

  ITEMCOLOR LRED WHITE
; MENUITEM  0 _NORIP      ' [^G^]....Skip RIP Graphics       - %nr
  MENUITEM  0 _NORIP      ' [^G^]....Od RIP ϧܬɭ   - %nr
  RIP Skip RIP Graphics

  ITEMCOLOR YELLOW LCYAN
  MENUITEM  0
; MENUITEM  0 _HELP       ' [^?^]....Show help               ;
  MENUITEM  0 _HELP       ' [^?^]....ܽuWUe        ;
  RIP ? HELP

  ITEMCOLOR WHITE LCYAN
; MENUITEM  0 _TOPMENU    '  [^/^]....Main Menu
  MENUITEM  0 _TOPMENU    '  [^/^]....^^D
  RIP / (Main)

  ITEMCOLOR WHITE LCYAN
; MENUITEM  0 _RETURN     ' [^Q^]....Return Previous Menu
  MENUITEM  0 _RETURN     ' [^Q^]....^^W@
  RIP Quit

  ITEMCOLOR WHITE LCYAN
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

;
; services menu
;

MENU SERVICES
  GXPROMPT  SX_SERV>
; VTITLE     WHITE Xpress Service Menu
  VTITLE     WHITE Ȫ֫HAȰ򥻳]w
  RIPTITLE  Silver Xpress Services Menu
  HELP      services
  ITEMCOLOR 63 WHITE
; MENUITEM  0 _JUNK      '^ Xpress Service Options ^'
  MENUITEM  0 _JUNK      'wwwwwwwwww^ Ȫ֫HAȰ򥻳]w ^wwwwwwwwwwww'
  ITEMCOLOR YELLOW CYAN
; MENUITEM  0 _VACSAVER   ' [^V^]....Xpress Vacation Saver    - %vs
  MENUITEM  0 _VACSAVER   ' [^V^]....wOdȪ֫HH]     - %vs
  RIP Xpress Vacation Saver
; MENUITEM  0 _FILESCAN   ' [^F^]....Scan for New Files       - %fs
  MENUITEM  0 _FILESCAN   ' [^F^]....ysiɮצC         - %fs
  RIP Scan for New Files
; MENUITEM  0 _FILEDATE   ' [^C^]....Change File Scan Date    - %fd
  MENUITEM  0 _FILEDATE   ' [^C^]....קɮױy         - %fd
  RIP Change File Scan Date
; MENUITEM  0 _ANSILIST   ' [^L^]....Ansi New Files List      - %al
  MENUITEM  0 _ANSILIST   ' [^L^]....ANSIsɦC         - %al
  RIP Ansi New Files List
; MENUITEM  0 _BULLETINS  ' [^B^]....Receive Bulletins        - %gb
  MENUITEM  0 _BULLETINS  ' [^B^]....ܩʤG         - %gb
  RIP Send Bulletins
; MENUITEM  0 _AUTOSTART  ' [^A^]....Auto Start Xpress        - %as
  MENUITEM  0 _AUTOSTART  ' [^A^]....۰ʶ}lȪ֫H         - %as
  RIP Auto Start Xpress
; MENUITEM  0 _REPRECEIPT ' [^S^]....Send REPLY Receipt       - %rr
  MENUITEM  0 _REPRECEIPT ' [^S^]....eX^^HH]i
  RIP Send Reply Receipt
; MENUITEM  0 _DELXAM     ' [^E^]....Erase Mail Recording
  MENUITEM  0 _DELXAM     ' [^E^]....RH]O
  RIP Erase Mail Recording
; MENUITEM  0 _RPASSWORD  ' [^R^]....Reader Password
  MENUITEM  0 _RPASSWORD  ' [^R^]....]wiJŪH{KX
  RIP Set Reader Password
; MENUITEM  0 _DPASSWORD  ' [^D^]....Door Password
  MENUITEM  0 _DPASSWORD  ' [^D^]....]wiJ֫HtαKX
  RIP Set Door Password
; MENUITEM  0 _HELP       ' [^?^]....Show help
  MENUITEM  0 _HELP       ' [^?^]....ܽuWUe
  RIP ? HELP
; MENUITEM  0 _TOPMENU    ' [^/^]....Main Menu
  MENUITEM  0 _TOPMENU    ' [^/^]....^^D
  RIP / (Main)
; MENUITEM  0 _RETURN     ' [^Q^]....Return to Previous Menu
  MENUITEM  0 _RETURN     ' [^Q^]....^^W@
  RIP Quit
  ITEMCOLOR WHITE WHITE
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

;
; sysop menu, only the Xpress sysop can use the action codes in this
; menu. It doesn't matter if you moved them to another menu.
;

MENU SYSOP 0
  GXPROMPT  SX_SYS>
; VTITLE     YELLOW System Information
  VTITLE     YELLOW Ȫ֫HMο
  RIPTITLE   Xpress Sysop Menu
  HELP      sysop
  ITEMCOLOR 63 WHITE
; MENUITEM  0   _JUNK         '^ System Information ^'
  MENUITEM  0   _JUNK         'wwwwwwwww^ Ȫ֫H򥻳]w ^wwwwwwwww'
  ITEMCOLOR YELLOW CYAN
; MENUITEM   0  _USRLIST      ' [^1^] See User List
  MENUITEM   0  _USRLIST      ' [^1^] [ݩҦϥΪ̦C
  RIP 1-Xpress User List
; MENUITEM   0  _RUSRLIST     ' [^2^] See Registered User List
  MENUITEM   0  _RUSRLIST     ' [^2^] [ݵUϥΪ̦C
  RIP 2-Registered Users
; MENUITEM  200 _DNLDFILE  ?  ' [^3^] Download File
  MENUITEM  200 _DNLDFILE  ?  ' [^3^] U   
  RIP 3-Download a File
; MENUITEM  200 _UPLDFILE  ?  ' [^4^] Upload File.
  MENUITEM  200 _UPLDFILE  ?  ' [^4^] W   
  RIP 4-Upload a File
; MENUITEM  10  _SYSPARM      ' [^5^] Xpress Variables
  MENUITEM  10  _SYSPARM      ' [^5^] CXȪ֫HѼƳ]w
  RIP 5-Xpress Variables
; MENUITEM  200 _LOG          ' [^6^] See Xpress Log
  MENUITEM  200 _LOG          ' [^6^] [ݻȪ֫HO
  RIP 6-Xpress Log
; MENUITEM  200 _SHELL        ' [^7^] Shell to DOS
  MENUITEM  200 _SHELL        ' [^7^] Ȯɲ DOS U
  RIP 7-Shell to DOS
; MENUITEM  200 _CHAT         ' [^8^] Remote Activated Chat
  MENUITEM  200 _CHAT         ' [^8^] ݷnʥ
  RIP 8-Chat Window
; MENUITEM  200 _TOSSDUMP     ' [^9^] Toss Mail in Dump Area
  MENUITEM  200 _TOSSDUMP     ' [^9^] 뻼bmϤHHϤ
  RIP 9-Toss Dump Mail
; MENUITEM  0   _MACROLIST    ' [^L^] List Available Macros
  MENUITEM  0   _MACROLIST    ' [^L^] CXwsbO(Macros)
  RIP L-List Macros
; MENUITEM  0   _DISPVER      ' [^V^] Display Version Information
  MENUITEM  0   _DISPVER      ' [^V^] ܪT
  RIP V-Version Information
; MENUITEM  200 _FILEFREQ     ' [^R^] Request File From BBS
; MENUITEM  200 _FILEFREQ     ' [^R^] DBBS Wɮ
; RIP R-Request File From BBS
; MENUITEM  200 _HELP         ' [^?^] Show help
  MENUITEM  200 _HELP         ' [^?^] ܽuWUe
  RIP ? HELP
; MENUITEM   0  _RETURN       ' [^Q^] Return
  MENUITEM   0  _RETURN       ' [^Q^] ^^W@
  RIP Quit
  ITEMCOLOR WHITE WHITE
; MENUITEM   0  _JUNK         ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU


;
; Menu for Xpress Packet Type
;

MENU PACKET
  GXPROMPT  SX_PKT>
; VTITLE    WHITE Mail Packet Type
  VTITLE    WHITE H]榡]w
  RIPTITLE  Mail Packet Type and QWK Options
  HELP      pkttype
  ITEMCOLOR 63 WHITE
; MENUITEM  0 _JUNK      '^ Mail Packet Type ^'
  MENUITEM  0 _JUNK      'wwwwwwwwwwww^ H]榡]w ^wwwwwwwwwwww'
  ITEMCOLOR YELLOW CYAN
; MENUITEM  0 _JUNK        Current Packet Type : ^%pt^
  MENUITEM  0 _JUNK        {bҳ]wH]榡 : ^%pt^
  MENUITEM
; MENUITEM  0 _PKTOPX     ' [^O^]....OPX Silver Xpress Mail Packets
  MENUITEM  0 _PKTOPX     ' [^O^].... OPX Ȫ֫HH]榡
  RIP Create OPX Packets
; MENUITEM  0 _PKTQWK     ' [^K^]....QWK Mail Packets Compatible with QWK Readers
  MENUITEM  0 _PKTQWK     ' [^K^]....ܬۮe QWK ŪH{ QWK H]榡
  RIP Create QWK Packets
; MENUITEM  0 _GOSUB QWKOPTS  ' [^M^]....QWK Mail Options
  MENUITEM  0 _GOSUB QWKOPTS  ' [^M^]....QWK H]򥻳]w
  RIP QWK Mail Options
  MENUITEM
; MENUITEM  0 _HELP       ' [^?^]....Show help
  MENUITEM  0 _HELP       ' [^?^]....ܽuWUe
  RIP ? HELP
; MENUITEM  0 _TOPMENU    ' [^/^]....Main Menu
  MENUITEM  0 _TOPMENU    ' [^/^]....^^D
  RIP / (Main)
; MENUITEM  0 _RETURN     ' [^Q^]....Return to Previous Menu
  MENUITEM  0 _RETURN     ' [^Q^]....^^W@
  RIP Quit
  ITEMCOLOR WHITE WHITE
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

;
; QWK Menu Options
;

MENU QWKOPTS
  GXPROMPT  SX_QWKOPT>
; VTITLE    WHITE Mail Packet Type
  VTITLE    WHITE QWK H]򥻳]w
  RIPTITLE  Mail Packet Type
  HELP      qwkopts
  ITEMCOLOR 63 WHITE
; MENUITEM  0 _JUNK      '^ QWK Mail Options ^'
  MENUITEM  0 _JUNK      'wwwwwwwwwww^ QWK H]򥻳]w ^wwwwwwwwwww'
  MENUITEM
  ITEMCOLOR YELLOW CYAN
; MENUITEM  0 _QWKSTRIPK  ' [^K^]....Strip Kludges Lines         %sk
  MENUITEM  0 _QWKSTRIPK  ' [^K^]....h Kludges C             %sk
  RIP Send Kludges Lines
; MENUITEM  0 _QWKCAPHDR  ' [^C^]....Capitalize Message Header   %ch
  MENUITEM  0 _QWKCAPHDR  ' [^C^]....HDQ                %ch
  RIP Capitalize QWK Header
; MENUITEM  0 _QWKNDX     ' [^N^]....Send NDX Index Files        %sn
  MENUITEM  0 _QWKNDX     ' [^N^]....eX NDX ɮ           %sn
  RIP Send NDX Index Files
; MENUITEM  0 _QWKWWRAP   ' [^W^]....Perform Word Wrapping       %ww
  MENUITEM  0 _QWKWWRAP   ' [^W^]....rӪO_ܤU@C      %ww
  RIP Perform Word Wrapping
  MENUITEM  0
; MENUITEM  0 _HELP       ' [^?^]....Show help
  MENUITEM  0 _HELP       ' [^?^]....ܽuWUe
  RIP ? HELP
; MENUITEM  0 _TOPMENU    ' [^/^]....Main Menu
  MENUITEM  0 _TOPMENU    ' [^/^]....^^D
  RIP / (Main)
; MENUITEM  0 _RETURN     ' [^Q^]....Return to Previous Menu
  MENUITEM  0 _RETURN     ' [^Q^]....^^W@
  RIP Quit
  ITEMCOLOR WHITE WHITE
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU

MENU ASSIST
  GXPROMPT  SX_ASST>
; VTITLE    WHITE Xpress Assistant
  VTITLE    WHITE Ȫ֫HSO
  RIPTITLE  Xpress Assistant
  HELP      pkttype
  ITEMCOLOR 63 WHITE
; MENUITEM  0 _JUNK      '^ Xpress Assistant ^'
  MENUITEM  0 _JUNK      'wwwwwwwwwww^ Ȫ֫HSO ^wwwwwwwwwww'
  MENUITEM
  ITEMCOLOR YELLOW CYAN
; MENUITEM  0 _DISPLAY EXPLAIN ' [^E^]....Explain what a BBS is?
  MENUITEM  0 _DISPLAY EXPLAIN ' [^E^]....O BBS qlGi?
  RIP Explain a BBS
; MENUITEM  0 _DISPLAY ASSIST  ' [^A^]....Explain Xpress with Example
  MENUITEM  0 _DISPLAY ASSIST  ' [^A^]....O֫H(]td)
  RIP Xpress Assistant
; MENUITEM  0 _DISPLAY NEWUSER ' [^N^]....New User Information
  MENUITEM  0 _DISPLAY NEWUSER ' [^N^]....siϥΪ̸T
  RIP New User Information
; MENUITEM  0  _DISPLAY DLGUIDE ' [^L^]....Download DOOR User Guide
  MENUITEM  0  _DISPLAY DLGUIDE ' [^L^]....Uǥ~{ϥλ
  RIP # Download Door Guide
; MENUITEM  0 _RETURN          ' [^Q^]....Return to Previous Menu
  MENUITEM  0 _RETURN          ' [^Q^]....^^W@
  RIP Quit
  MENUITEM
  ITEMCOLOR WHITE WHITE
; MENUITEM  0 _JUNK      ''
  MENUITEM  0 _JUNK      'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
  RETURNKEY Q
; VETERAN   YELLOW WHITE Valid Keys: [^%keys^]
  VETERAN   YELLOW WHITE Ī: [^%keys^]
; PROMPT    LGREEN WHITE YELLOW [^%tr mins^] %fn Enter Command :
  PROMPT    LGREEN WHITE YELLOW [^ѤU %tr ^] %fn пJON :
ENDMENU
