;----------------------------------------------------------------
;
;    TERM14.ASM
;
;    Interrupt 14 terminal program
;
;    (C)opyright 1994, 1995, Robert B. Ton
;    The Grotto Lounge BBS, Arvada, CO
;    (303) 421-6965, (303) 421-7186 (V.32bis)
;    (303) 421-1683 - FIDO NetMail Only (V.34)
;
;    This program was assembled using Borland TASM version 3.1 and
;    linked using Borland TLINK version 5.1.
;
;---------------------------------------------------------------
;
;    03Apr95 - V1.04 - Robert Ton
;       Added file capture capability.  Cheesy and easy implementation.
;
;    11Mar95 - V1.03 - Robert Ton
;       Fixed EXEC call to FDSZ.  It appears that the FDSZ string doesn't
;       want to end with a <CR>.  Also added text responses to errors
;       returned by EXEC (DOS function 4B) in case this wasn't really
;       the problem.
;
;    10Mar95 - V1.02 - Robert Ton
;       Added Zmodem interface to Chuck Forsberg's FOSSIL DSZ (FDSZ)
;       shareware program.  Added stack.
;
;    29Jan95 - V1.01 - Clayton Zekelman
;       The Footnote TBBS, Tecumseh, ON, CA
;       +1-519-979-9379 BBS
;       +1-519-979-2691 FAX
;
;       Removed translation table function, and replaced with doorway
;       scancode mode support, to allow use of F-keys.
;       Makes using the remote console in SYSOM MUCH easier.
;
;       The doc file from Robert B. Ton released this program to
;       the public domain, but the source code still carries a
;       copyright.  I'm not sure what that means, but I'll leave it in,
;       just incase he didn't REALLY mean to release it.
;
;       complaints > /dev/null
;
;
; equates
;
cr      equ     13
lf      equ     10
escape  equ     27
bs      equ     8
eos     equ     '$'
stksize equ     512

DATA segment para public 'data'
;
; signon message
;
signon  db      cr,lf,lf
        db      "TERM14 V1.04",cr,lf
        db      "INT 14 Mini-Terminal",cr,lf
        db      "Copyright (C) 1994, 1995, Robert B. Ton",cr,lf
        db      "Doorway Mode Support added by Clayton Zekelman",cr,lf,lf,lf
        db      "Press <Enter> to establish connection",cr,lf
        db      "Type Ctrl-A to exit",cr,lf,lf,eos

upprompt db     cr,lf,lf,"Upload -> enter filename: ",eos
upesc   db      cr,lf,"Upload request aborted",cr,lf,eos

zfdsz   db      "PCZ.EXE",0
zdnld   db      6,"f rz",cr
zupld   db      0,"f sz "
zupld1  db      128 DUP (0)

fcb1    db      0
        db      "dummy   fcb"
        db      0,0,0,0

fcb2    db      0
        db      "dummy   fcb"
        db      0,0,0,0

epb     dw      0
        dw      0
        dw      SEG DATA
        dw      offset fcb1
        dw      SEG DATA
        dw      offset fcb2
        dw      SEG DATA

apoll   db      27,"[6n",0
apollc  dw      0
apollr  db      27,"[1;1R",0

fdszerr db      "***Error calling ZM.EXE: ",eos
fdsz1   db      "Invalid function call",cr,lf,eos
fdsz2   db      "File not found",cr,lf,eos
fdsz3   db      "Path not found",cr,lf,eos
fdsz5   db      "Access denied",cr,lf,eos
fdsz8   db      "Insufficient memory",cr,lf,eos
fdsza   db      "Bad environment",cr,lf,eos
fdszb   db      "Bad file format",cr,lf,eos
fdszx   db      "Unknown error code",cr,lf,eos

fcaphan dw      0               ; file capture handle
fcapnam db      128 DUP (?)     ; file capture name
fcapbuf db      1024 DUP (?)    ; file capture local buffer
fcapptr dw      0               ; file capture buffer pointer
fcprompt db     cr,lf,lf,"File capture -> enter filename: ",eos
fcesc   db      cr,lf,"File capture request aborted",cr,lf,eos
fcclos  db      cr,lf,"Capture file closed",cr,lf,eos

DATA ends


CODE segment para public 'code'
        assume cs:code, ds:data, ss:nothing, es:nothing

ss_sav  dw      ?
sp_sav  dw      ?

start:
        mov     ax,SEG data     ; make DSEG
        mov     ds,ax           ;   addressable
;
; free unused memory so that FDSZ can load
;
        mov     ax,es
        mov     bx,ss
        sub     bx,ax
        add     bx,stksize/16
        mov     ah,4ah
        int     21h
;
; sign us on
;
        mov     dx,offset signon
        mov     ah,9
        int     21h

;
; here's the terminal loop...
;
xloop:
;
; check for data ready from link
;
        mov     ah,3            ; get port status
        sub     dx,dx           ; port 0
        int     14h
        and     ax,0100h        ; data ready?
        jz      ckkbd           ; nope, check keyboard
;
; char ready from link -- fetch it and check for cls
;
        mov     ah,2            ; get char
        sub     dx,dx           ; port 0
        int     14h             ; char is in al
        cmp     al,0ch          ; IBM clear-screen?
        jnz     ckky2           ; nope...
;
; clear screen detected - do it
;
        mov     ah,2
        sub     bh,bh
        sub     dx,dx
        int     10h             ; home cursor
        sub     al,al
        mov     bh,7
        sub     cx,cx
        mov     dh,24           ; 25 lines
        mov     dl,79           ; 80 chars per
        mov     ah,6
        int     10h             ; clear screen
        mov     ah,1            ; set cursor
        mov     cx,0607H
        int     10H
        jmp     xloop
;
; handle file capture if on
;
ckky2:
        cmp     [fcaphan],0     ; is it on?
        jz      ckpoll          ; nope, go handle other special cases
        call    fcap            ; yes, capture it to file
;
; check for ansi poll
;
ckpoll:
        mov     di,offset apoll
        mov     cx,[apollc]
        add     di,cx           ; point to char in canned string
        cmp     al,[di]         ; a match?
        jz      pgud            ; yes
        and     cx,cx           ; any previous matches?
        jz      outscr          ; nope
;
; bad match for ANSI poll -- we need to pass what we've seen so far
; on to the display driver, else it'll screw everything up
;
        push    ax              ; save char we just got
        mov     di, offset apoll
spitlp:
        mov     dl,[di]         ; get from canned string
        mov     ah,2            ; out to ansi drvr
        int     21h             ; via DOS
        inc     di              ; point next
        loop    spitlp          ; loop for as many chars as we've seen
        mov     [apollc],0      ; and clear counter
        pop     ax              ; get newest char
        mov     dl,al           ; into dl and
        mov     ah,2            ;   out to ansi drvr
        int     21h             ;   via DOS
        jmp     xloop           ; back to main loop
pgud:
        inc     [apollc]        ; bump poll counter
        inc     di              ; bump pointer
        cmp     byte ptr[di],0  ; do we have a full match?
        jnz     xloop           ; nope, keep on truckin'
;
; we've matched... send response
;
        call    respond
        mov     [apollc],0      ; reset for next time
        jmp     xloop           ; back to the top
outscr:
        mov     dl,al           ; move char to dl for DOS
        mov     ah,2            ; char out fcn
        int     21h             ; do it
;
; check keyboard for other half of link
;
ckkbd:
        mov     ah,1h           ; get keyboard status
        int     16h             ; via BIOS
        jnz     ckkbd1          ; key ready....
        jmp     xloop           ; back to loop if not
ckkbd1:
        sub     ah,ah           ; get key
        int     16h             ; via BIOS, ah,al=scan,val
;
; check for PgDn (download) request
;
        cmp     ax,5100h        ; pgdn?
        jnz     ckkbd2          ; nope...
        call    download        ; yes, download file
        jmp     xloop           ; back to loop
;
; check for PgUp (upload) request
;
ckkbd2:
        cmp     ax,4900h        ; pgup?
        jnz     ckkbd3          ; nope...
        call    upload          ; yes, upload file
        jmp     xloop           ; and back to loop
;
; check for ALT-F1 (file capture) request
;
ckkbd3:
        cmp     ax,6800h        ; alt-f1?
        jnz     ckkbd4          ; nope
        call    filecap         ; yes, capture file
        jmp     xloop           ; and back to loop
;
; do we need to send in doorway mode?
;
ckkbd4:
        and     al,al           ; z = extended kbd
        jnz     kbd1            ; normal ascii - skip
        mov     cx,ax           ; outlnk clobbers ax
        call    outlnk          ; 00h = doorway ext kbd mode, send it
        mov     ax,cx           ; bring back ax
        mov     al,ah           ; actual scancode
        jmp     xmtlink         ; send it
;
; check for CTRL-A; exit if so
;
kbd1:
        cmp     al,1            ; ctrl-a?
        jz      xit             ; yup, bail out...
;
; ASCII code is in al; send it to port
;
xmtlink:
        call    outlnk
reloop:
        jmp     xloop           ; and keep loopin'

xit:
;
;  send "0XX" to host -- logoff
;
;       mov     al,'0'
;       mov     ah,1            ; output char
;       sub     dx,dx           ; port 0
;       int     14h             ; ship it out
;       mov     al,'X'
;       mov     ah,1            ; output char
;       sub     dx,dx           ; port 0
;       int     14h
;       mov     al,'X'
;       mov     ah,1            ; output char
;       sub     dx,dx           ; port 0
;       int     14h
;
; Clear DTR
;
        mov     ax,0500h        ; read modem status
        sub     dx,dx           ; port 0
        int     14h             ; status in al
;       or      bl,1
        and     bl,0feh         ; clear DTR
        mov     al,1            ; write it
        int     14h
;
; close any pending file capture
;
        cmp     [fcaphan],0
        jz      godos
        call    filecap
;
; back to DOS
;
godos:
        mov     ah,04ch         ; terminate
        sub     al,al           ; errorlevel 0
        int     21h             ; fast exit

respond:
        mov     di,offset apollr        ; point to canned response
rlp:
        mov     al,byte ptr[di] ; get a char
        and     al,al           ; end of string?
        jz      rxit            ; yup, we're done
        call    outlnk          ; nope, ship it to link
        inc     di              ; point next
        jmp     rlp             ;   and loop
rxit:
        ret

outlnk:
        mov     ah,1            ; output char
        sub     dx,dx           ; port 0
        int     14h             ; ship it out
        ret
;
;====================================================================
;
;   download -- download file
;
;====================================================================
;
download:
        push    ds
        pop     es
        mov     dx,offset zdnld
        mov     [epb+2],dx
        mov     dx,offset zfdsz
        mov     bx,offset epb
        sub     al,al
        mov     ah,4bh
        int     21h
        ret

;
;====================================================================
;
;   upload -- upload file
;
;====================================================================
;
upload:
;
; prompt for a filename...
;
        mov     dx,offset upprompt
        mov     ah,9
        int     21h
;
; get filename from console
;
        mov     di,offset zupld1        ; point to command tail tail
        mov     cx,0                    ; no chars so far
upldlp:
        sub     ah,ah           ; get key
        int     16h             ; via BIOS, ah,al=scan,val
        and     al,al
        jz      upldlp          ; throw away anything extended
;
; allow an exit -- esc aborts
;
        cmp     al,escape
        jnz     ckbs
        mov     dx,offset upesc
        mov     ah,9
        int     21h
        jmp     upldxit
;
; be nice and let 'em backspace
;
ckbs:
        cmp     al,bs
        jnz     upld1
        and     cx,cx
        jz      upldlp
        dec     cx
        dec     di
        mov     dl,bs
        mov     ah,2
        int     21h
        mov     dl,' '
        mov     ah,2
        int     21h
        mov     dl,bs
        mov     ah,2
        int     21h
        jmp     upldlp
;
; echo to screen
;
upld1:
        push    ax
        mov     dl,al
        mov     ah,2
        int     21h
        pop     ax
upldx:
        mov     byte ptr[di],al ; otherwise, save it
        inc     di              ; and bump pointer
        inc     cx              ; and counter
;
; was that an <enter> I just saw?
;
        cmp     al,cr
        jnz     upldlp          ; guess not, keep loopin'
;
; finish up...
;
        add     cx,6            ; add length of command line tail prefix
        mov     byte ptr[zupld],cl
        push    ds
        pop     es
        mov     dx,offset zupld
        mov     [epb+2],dx
        mov     dx,offset zfdsz
        mov     bx,offset epb
        sub     al,al
        mov     ah,4bh
        int     21h
        jnc     upldxit
        push    ax
        mov     dx,offset fdszerr
        mov     ah,9
        int     21h
        pop     ax
        cmp     ax,1
        jnz     fderr2
        mov     dx,offset fdsz1
        jmp     fdderr
fderr2:
        cmp     ax,2
        jnz     fderr3
        mov     dx,offset fdsz2
        jmp     fdderr
fderr3:
        cmp     ax,3
        jnz     fderr5
        mov     dx,offset fdsz3
        jmp     fdderr
fderr5:
        cmp     ax,5
        jnz     fderr8
        mov     dx,offset fdsz5
        jmp     fdderr
fderr8:
        cmp     ax,8
        jnz     fderra
        mov     dx,offset fdsz8
        jmp     fdderr
fderra:
        cmp     ax,0ah
        jnz     fderrb
        mov     dx,offset fdsza
        jmp     fdderr
fderrb:
        cmp     ax,0bh
        jnz     fderrx
        mov     dx,offset fdszb
        jmp     fdderr
fderrx:
        mov     dx,offset fdszx
fdderr:
        mov     ah,9
        int     21h
upldxit:
        ret


;
;====================================================================
;
;   filecap - toggle file capture
;
;====================================================================
;
filecap:
;
;  are we opening or closing?
;
        cmp     [fcaphan],0             ; valid handle?
        jz      fgetfn                  ; nope, must be opening
;
;  we're closing... anything in the buffer?
;
        cmp     [fcapptr],0
        jz      fcclose
;
;  buffer isn't empty; flush it
;
        mov     dx,offset fcapbuf
        mov     bx,[fcaphan]
        mov     cx,[fcapptr]
        mov     ah,40h
        int     21h
        mov     [fcapptr],0

fcclose:
        mov     bx,[fcaphan]
        mov     ah,3eh                  ; close file
        int     21h
        mov     dx,offset fcclos        ; tell operator
        mov     ah,9
        int     21h
        mov     [fcaphan],0             ; turn mainline off
        ret
;
; prompt for a filename...
;
fgetfn:
        mov     dx,offset fcprompt
        mov     ah,9
        int     21h
;
; get filename from console
;
        mov     di,offset fcapnam       ; point to command tail tail
        mov     cx,0                    ; no chars so far
gnlp:
        sub     ah,ah           ; get key
        int     16h             ; via BIOS, ah,al=scan,val
        and     al,al
        jz      gnlp            ; throw away anything extended
;
; toss anything that looks bogus
;
        cmp     al,'?'
        jz      gnlp
        cmp     al,'*'
        jz      gnlp
        cmp     al,' '
        jz      gnlp
;
; allow an exit -- esc aborts
;
        cmp     al,escape
        jnz     fckbs
        mov     dx,offset fcesc
        mov     ah,9
        int     21h
        ret
;
; be nice and let 'em backspace
;
fckbs:
        cmp     al,bs
        jnz     fcgn1
        and     cx,cx
        jz      gnlp
        dec     cx
        dec     di
        mov     dl,bs
        mov     ah,2
        int     21h
        mov     dl,' '
        mov     ah,2
        int     21h
        mov     dl,bs
        mov     ah,2
        int     21h
        jmp     gnlp
;
; check buffer limits
;
fcgn1:
        cmp     cx,128
        jge     gnlp

;
; echo to screen
;
fcgn1a:
        push    ax
        mov     dl,al
        mov     ah,2
        int     21h
        pop     ax
fcgn2:
;
; was that an <enter> I just saw?
;
        cmp     al,cr
        jnz     fcgn3           ; guess not, save it
        mov     byte ptr[di],0  ; terminate string
        jmp     fcgotfn         ; done...
fcgn3:
        mov     byte ptr[di],al ; otherwise, save it
        inc     di              ; and bump pointer
        inc     cx              ; and counter
        jmp     gnlp            ; keep loopin'

fcgotfn:
        mov     dx,offset fcapnam
        sub     cx,cx
        mov     ah,4eh
        int     21h             ; does this file exist?
        jnc     fcopenit        ; nope, create file
;
;  file exists; handle it
;
fcopenit:
        mov     dx,offset fcapnam
        sub     cx,cx           ; normal file
        mov     ah,3ch          ; create it
        int     21h
        mov     [fcaphan],ax    ; save handle
        mov     [fcapptr],0     ; zero out buffer pointer
        ret

;
;====================================================================
;
;   fcap - capture incoming data to buffer; write buffer to disk
;
;====================================================================
;
fcap:
        push    ax
        mov     di,offset fcapbuf
        add     di,[fcapptr]
        mov     [di],al
        inc     [fcapptr]
        cmp     [fcapptr],1024
        jnz     fcapx
        mov     dx,offset fcapbuf
        mov     bx,[fcaphan]
        mov     cx,1024
        mov     ah,40h
        int     21h
        mov     [fcapptr],0
fcapx:
        pop     ax
        ret

CODE ends

_STACK  segment para stack 'STACK'
        db      stksize dup (?)
_STACK  ends

        end     start
