/****************************** COUNT-UP TIMER******************************
Count-up timer                                      Digital displays of time

   Custom version created for Jim Magin, Ellicott City, MD per his specs.

                                   M\Cooper
                           3425 Chestnut Ridge Rd.
                         Grantsville, MD  21536-9801
                         ---------------------------
                         Email:   thegrendel@aol.com
****************************************************************************/

/* #define DEBUG */

#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <stdlib.h>
#include <graphics.h>
#include <dos.h>
#include "oscr.hpp"
#include "bt.hpp"


char R[] =  "Press a key to reset timer";
char S[] =  "Press a key to restart timer";
char ST[] = "RETURN stop | SPACE restart";
void main()
{
   randomize();
   opening_screen();
   play();
}

void CountdownTimer::clock_on()
{
   time_t prev_sec;
   int ch;

      text_color = LIGHTRED;

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      settextjustify( LEFT_TEXT, TOP_TEXT );

      startn_t = time ( NULL );  //Click on stopwatch.
      setcolor( BKGRND_COLOR );
      outtextxy( NAME_POS, 100, R );
      outtextxy( NAME_POS, 100, S );
      outtextxy( NAME_POS, 100, ST );
      setcolor( LIGHTBLUE );
      outtextxy( NAME_POS, 100, ST );


/***************************AAAAA*************************************/

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, BIGNUMSIZE );
      display_time();  //Otherwise initial time not displayed...

      while( !( ch = kbhit() ) )
	 {
	 prev_sec = seconds;
	 interval_t = time( NULL ) - start_t;
	 running_t = total_seconds + interval_t;
	 convert( running_t );

	 if( seconds - prev_sec )
	    {
	    display_time();

	    if( !seconds )
	       if( minutes == warning )
		  if( !hours )
		     if( time_warning_flag )
			blatt();

	    if( visual_ticking_flag ) // Show blinking box ticks?
	       {
	       setfillstyle( random ( PATTERNS ), random ( COLORS ) );
	       setcolor ( random ( COLORS ) );
	       setlinestyle( SOLID_LINE, 0xFFF, NORM_WIDTH );
	       bar( X_C - RADIUS, Y_C - RADIUS,
		    X_C + RADIUS, Y_C + RADIUS );
	       }
	    }


	 }

      ch = getch();
      if( ch == ESC )
	 exit__();  // Quit.
      
      if( ch == CR )
         {
      running_flag = OFF; // Reset each time.
      setcolor( BKGRND_COLOR );
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      outtextxy( NAME_POS, 100, S );
      outtextxy( NAME_POS, 100, ST );
      outtextxy( NAME_POS, 100, R );
      setcolor( CYAN );
      outtextxy( NAME_POS, 100, S );
      ch = getch();
      if( ch == ESC )
	 exit__(); // Quit.
      }
      reset_timer(); 

      return;

}

void CountdownTimer::display_moves()
{
   char buf[ 5 ];
   static char ebuf[ 5 ];

      if( moves > 1 )
	 {
	 setcolor( WHITE );
	 settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
	 settextjustify( CENTER_TEXT, TOP_TEXT );
	 outtextxy( MOVES_X, MOVES_Y, ebuf );
	 }

      sprintf( buf, "%003d", moves );
      sprintf( ebuf, buf );
      setcolor( GREEN );
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      settextjustify( CENTER_TEXT, TOP_TEXT );
      outtextxy( MOVES_X, MOVES_Y, buf );
      
      return;
}

void graphics_setup( int background_color )
{
   int grdriver = VGA,
       grmode = VGAHI;

       registerfarbgidriver( EGAVGA_driver_far );
       registerfarbgifont( gothic_font_far );
       registerfarbgifont( triplex_font_far );
       initgraph( &grdriver, &grmode, "" );
       setbkcolor( background_color );

}

void exit__()
{
      closegraph();
      exit( QUIT );
}

	/***************Routine to erase old numbers*************/
void CountdownTimer::erase_numbers()
{
      #ifdef DEBUG
         setcolor( CYAN );
      #else
         setcolor ( WHITE ); 
      #endif
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, BIGNUMSIZE );

      if( seconds == 0 )        //At minute intervals
	 outtextxy( BLK_TIME, Y_TIMEPOS, line_clear );
      else
      if( !( seconds % 10 ) )   //At 10 second intervals
		outtextxy( BLK_TIME + POS1_OFFSET, Y_TIMEPOS,
			   line_clear + 6 );
	  else                         //At second intervals
	     outtextxy( BLK_TIME + POS_OFFSET, Y_TIMEPOS,
			line_clear + 7 ); 

	 return;

}


void play()
{
   int hrs,
       min;
   char inputstr[ MAXLEN ],
	inp;

      clrscr();

      textcolor ( RED );
      CountdownTimer t1( 0 );

      textcolor( CYAN );
      cprintf( "\n\n                         Enable flashing clock ticks? " );
      inp = getche();
      if( inp == 'y' || inp == 'Y' )
	 t1.visual_ticking_flag = ON;
      else
	 t1.visual_ticking_flag = OFF;

      cprintf( "\n                                                      Enable time warning? " );
      inp = getche();
      if( inp == 'y' || inp == 'Y' )
	 {
	 t1.time_warning_flag =  ON;
	 cprintf( "                                                          At how many minutes? " );
	 gets( inputstr );
	 t1.warning = atoi( inputstr );
	 }
      else
	 t1.time_warning_flag = OFF;

      textcolor( YELLOW | BLINK );
      _setcursortype( _NOCURSOR );
      printf( "\n\n\n\n\n\n\n\n\n\n\n\n" );
      cprintf( "                             PRESS A KEY TO BEGIN" );
      while ( !getch() );

      graphics_setup( WHITE );

      settextjustify( CENTER_TEXT, CENTER_TEXT );
      settextstyle( GOTHIC_FONT, HORIZ_DIR, 4 );
      setcolor( LIGHTMAGENTA );
      outtextxy( TOPX, TOPY - 30, title_msg );  /*******************/

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      setcolor( LIGHTGREEN );
      outtextxy( TOPX, TOPY + 20, esc_msg );

      t1.initialize_clock();
      t1.moves++;
      t1.display_moves();
      t1.clock_on();

      while ( PLAY )  //Forever, until keypress
	 {
	 t1.moves++;  
	 t1.display_moves();
	 t1.clock_on();
	 }


} // End play()


void opening_screen()
{
   char topline[] = "Count Up Timer",
	by_line[] = "by",
	name_line[] = "M\\Cooper",
	endline[] = "PRESS A KEY TO BEGIN";

      graphics_setup( LIGHTCYAN );
      settextstyle( GOTHIC_FONT, HORIZ_DIR, HEADLINE_SIZE );
      settextjustify( CENTER_TEXT, CENTER_TEXT );
      setcolor( LIGHTRED );
      outtextxy( TOPX, TOPY, topline );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, BY_LINE_SIZE );
      setcolor( BLUE );
      outtextxy( BY_LINE_X, BY_LINE_Y, by_line );

      setfillstyle( BAR_PATTERN, BAR_COLOR );
      bar3d( BAR_LEFT, BAR_TOP, BAR_RIGHT, BAR_BOTTOM, BAR_DEPTH, BAR_TOPFLAG );

      setfillstyle( PIE_PATTERN, PIE_COLOR );
      pieslice( PIE1_X, PIE_Y, PIE_STARTANGLE, PIE_ENDANGLE, PIE_RADIUS );
      circle( PIE1_X, PIE_Y, CIRC_RAD );
      setlinestyle( SOLID_LINE, 0xFFFF, THICK_WIDTH );
      setcolor( LIGHTRED );
      line( LINE1_X, LINE_Y1, LINE1_X, LINE_Y2 );
      setfillstyle( PIE_PATTERN, WHITE );
      bar( B1_LEFT, B1_TOP, B1_RIGHT, B_BOTTOM );


      settextstyle( TRIPLEX_FONT, HORIZ_DIR, NAME_LINE_SIZE );
      setcolor( BLUE );
      outtextxy( NAME_LINE_X, NAME_LINE_Y, name_line );

      sleep( DELAY / 2 );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, ENDLINE_SIZE );
      setcolor( RED );
      outtextxy( ENDLINE_X, ENDLINE_Y, endline );

      getch();
      closegraph();

      return;
}


void CountdownTimer::erase()
{
      display_time();
      setcolor( WHITE );
      outtextxy( BLK_TIME, Y_TIMEPOS, line_clear ); /* Erase time display */

}

void CountdownTimer::reset_timer()
{
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 5 );
      erase();
      convert ( total_seconds_mem ); /***RESET TIME*****/
      initialize_clock();

      return;

}
