/*
 * AMP/2 1.00 WorkPlace folder installation program.
 *
 * This program creates a folder to hold program objects,
 * then creates program objects for each executable.  It only needs to be
 * run once (unless you change the AMP directory)
 * Run this program in the AMP directory (where you unpacked the archive).
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

say''
say''
say'[0;1;34;44m[0;30;44m[40m'
say'[1;34;44m [0;30;44m [40m'
say'[1;34;44m              [33mAMP 1.00 WorkPlace folder installation program              [0;30;44m [40m'
say'[1;34;44m           [33mAMP 1.00 [36mis Copyrighted (c) 1993-95 by [31mAlexander Kuiper        [0;30;44m [40m'
say'[1;34;44m                           [36mAll rights reserved                            [0;30;44m [40m'
say'[1;34;44m [0;30;44m [40m'
say'[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m                    [1;37mHave you read the AMP.DOC file yet?                  [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m           [1;37mBy running this program, you agree to the license             [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m                       [1;37mas specified in that file,                        [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m         [1;37mIt tells you how to install AMP, so you should read it.         [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m                                 [1;37mPlease?                                 [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say'[1;34;44m[0;30;44m[0m'

/*
 * allow user to eliminate associations from being placed on AV/2.
 * seemed to upset some fellow on CIS (I guess he doesn't know about
 * Settings notebooks on WPS objects).
 */
assocfilter = ';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0,READ.ME,README,README.1ST,README.OS2,REGISTER.TXT'
existed = ''
parse upper arg dummy
if dummy = 'NOASSOC' then assocfilter = ''

rc = stream('amp2.exe','c','query exists')
if rc = '' then
do
  say '[0;1;31mSorry, AMP2.EXE not found.  Must not be right directory.  Terminating.[0m'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */

say ''
say 'This program creates Desktop objects for AMP.'
say 'If you do not want create the Desktop Objects,'
say 'press CTRL + C the press Enter.'
say ''



say '[0;1;35mPress [Enter] to continue...[0m'
pull dummy .
say ''


/* save current directory */

curdir = directory()

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

'cls'
say ''
say ''
say ''
say "[0;1;5;31mCreating The Automatic Maintenance Pro folder and objects...[0m"

/* first, create AMP folder */

title = "Automatic Maintenance Pro"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<AMP_Folder>;OPEN=DEFAULT'
result=SysCreateObject(classname,title,location,setup,f)

/* NOTE:  remove following 9 lines for unattended use... */
if result = 0 then
do
  assocfilter = ''
  existed = 'TRUE'
  say ''
  say '[0;1;31mThe Automatic Maintenance Pro folder already exists.'
  say '[33mShould I update the objects? (Y/n)[0m'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in AMP/2 folder */

title = "AMP"
classname = 'WPProgram'
location = '<AMP_Folder>'
setup = 'OBJECTID=<AMP>;EXENAME='curdir'\AMP2.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

title = "AMP Configuration"
classname = 'WPProgram'
location = '<AMP_Folder>'
setup = 'OBJECTID=<AMP Configuration>;EXENAME='curdir'\AMPSETUP.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS=%*'
call SysCreateObject classname,title,location,setup,u

rc = stream('AMP.NEW','c','query exists')
if rc \= '' then
do
  title = "What's New in AMP 1.00"
  classname = 'WPProgram'
  location = '<AMP_Folder>'
  setup = 'OBJECTID=<New in AMP>;EXENAME=e.exe;PARAMETERS='curdir'\new.amp;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('AMP.DOC','c','query exists')
if rc \= '' then
do
  title = "AMP 1.00 Text Doc's"
  classname = 'WPProgram'
  location = '<AMP_Folder>'
  setup = 'OBJECTID=<AMP 1.00 Documentation>;EXENAME=e.exe;PARAMETERS='curdir'\amp.doc;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('UPGRADE.DOC','c','query exists')
if rc \= '' then
do
  title = "UPGRADE.DOC"
  classname = 'WPShadow'
  location = '<AMP_Folder>'
  setup = 'SHADOWID='rc
  call SysCreateObject classname,title,location,setup,u
end

/* Final words */
'cls'

say ''
say ''
say ''
say ''
say ''
say ' [0;1;34;44m[40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m    [36mIf you find a need to move AMP to a different Directory, delete the   [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m      [36mAMP Desktop folder and re-run INSTALL2 in the New AMP Directory.    [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m[1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m            [1;37mI am now done Installing the AMP Desktop Folder!             [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [1;37mPlease be sure to check all the settings for each program, as a default [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m     [1;37mall programs will be opened in a window instead of a full screen    [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m                                                                         [1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m    [1;31mIf you havent Registered AMP yet,  please remember to do so soon.    [34m [40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m[1;34m [40m'
say '[A[79C[0;30;44m[1C[1;34m[0;30;44m[40m'
say '[A[79C[44m[0m'
