/* */

Signal On Halt Name CatchHalt

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Call Setup

Call AskQ1
Select
   When Q1 = '0' Then
      Do
         Call SysCls
         Exit
      End
   When Q1 = '1' Then
      Call Install
   Otherwise
      Call Rebuild
End

Exit


CatchHalt:
   Call SysCls
   Call SysCurPos 5, 20
   Say 'Installation Aborted'
   Call SysCurPos 10, 0
   Exit


Setup:
   /* FTypes: 1=EXE  2=DLL  3=DOC */
   /* These match the directories */
   FList.0  = 15;             FType.0  = 15
   FList.1  = 'GCPTALK.EXE';  FType.1  = 1
   FList.2  = 'GCPTALKD.EXE'; FType.2  = 1
   FList.3  = 'GCPCLM.EXE';   FType.3  = 1
   FList.4  = 'GCPHELP.EXE';  FType.4  = 1
   FList.5  = 'GCPBRAND.EXE'; FType.5  = 1
   FList.6  = 'GCPUI001.DLL'; FType.6  = 2
   FList.7  = 'GCPLIB01.DLL'; FType.7  = 2
   FList.8  = 'GCPTCP01.DLL'; FType.8  = 2
   FList.9  = 'GCPTALK.HLP';  FType.9  = 3
   FList.10 = 'GCPCLM.HLP';   FType.10 = 3
   FList.11 = 'GCP.ICO';      FType.11 = 1
   FList.12 = 'TALKREQ.WAV';  FType.12 = 1
   FList.13 = 'GCPTALK.DOC';  FType.13 = 3
   FList.14 = 'GCPTALK.REG';  FType.14 = 3
   FList.15 = 'BOOTDRV.EXE';  FType.15 = 1

   Dir.0 = 4
   Dir.1 = 'C:\GIBBON\EXE'
   Dir.2 = 'C:\GIBBON\DLL'
   Dir.3 = 'C:\GIBBON\DOC'
   Dir.4 = 'C:\GIBBON'

   Return


AskQ1:
   Call Logo
   Call DrawBox 12, 15, 50, 9
   Call SysCurPos 14, 20
   Call CharOut , '0.  Get out without doing anything'
   Call SysCurPos 15, 20
   Call CharOut , '1.  Install Gibbon Talk'
   Call SysCurPos 16, 20
   Call CharOut , '2.  Rebuild Gibbon Talk Desktop Objects'
   Call SysCurPos 18, 20
   Call CharOut , 'What do you want to do? '

   Call ClearInput

   Do Forever
      Q1 = SysGetKey('NOECHO')
      If Q1 < '0' | Q1 > '2' Then
         Iterate
      Call CharOut , Q1
      Leave
   End

   Return


Install:
   If InstallDirs() = 'BAD' Then Return
   If InstallOpts() = 'BAD' Then Return
   If InstallMakeDirs() = 'BAD' Then Return
   If InstallCopy() = 'BAD' Then Return
   Call SysSleep 3
   If Opt.3 = 'Y' Then Do
      If InstallWPS() = 'BAD' Then Return
      Call SysSleep 3
   End
   If InstallINI() = 'BAD' Then Return
   drv = '0'
   Do Forever
      rc = InstallCFG()
      If rc = 'RERUN' Then Iterate
      If rc = 'RENAME1' Then
         cfgmsg = 4
      Else If rc = 'RENAME2' Then
         cfgmsg = 5
      Else If rc = 'BAD' Then
         cfgmsg = 3
      Else If updpath = 0 & updhelp = 0 & updlib = 0 Then
         cfgmsg = 0
      Else If Opt.2 = 'Y' Then
         cfgmsg = 1
      Else
         cfgmsg = 2
      Leave
   End

   Call SysSleep 3
   Call Logo
   If cfgmsg = 0 Then Do
      Call DrawBox 11, 1, 78, 7
      Call SysCurPos 13, 28
      Say 'Installation Completed!'
      Call SysCurPos 15, 21
   End
   Else Do
      Call DrawBox 11, 1, 78, 11
      Call SysCurPos 13, 28
      Say 'Installation Completed!'
      If cfgmsg = 1 Then Do
         Call SysCurPos 15, 22
         Say 'Your CONFIG.SYS file was changed.'
         Call SysCurPos 16, 14
         Say 'You must reboot your system to activate the changes.'
      End
      Else If cfgmsg = 2 Then Do
         Call SysCurPos 15, 4
         Say 'A CONFIG.GCP file was created in the same directory as your CONFIG.SYS.'
         Call SysCurPos 16, 7
         Say 'You must manually update your CONFIG.SYS file with the changes in'
         Call SysCurPos 17, 21
         Say 'CONFIG.GCP and then reboot your system.'
      End
      Else If cfgmsg = 3 Then Do
         Call SysCurPos 15, 6
         Say 'Your CONFIG.SYS file could not be found.  You will have to add the'
         Call SysCurPos 16, 18
         Say 'appropriate entries to PATH, LIBPATH and HELP.'
      End
      Else If cfgmsg = 4 Then Do
         Call SysCurPos 15, 5
         Say "WARNING!  I couldn't rename CONFIG.SYS to CONFIG.GCP.  Your updated"
         Call SysCurPos 16, 5
         Say 'CONFIG.SYS is CONFIG.GCX.  Copy CONFIG.GCX to CONFIG.SYS and reboot.'
      End
      Else Do
         Call SysCurPos 15, 7
         Say 'WARNING!  There was a problem renaming your CONFIG files.  Check'
         Call SysCurPos 16, 7
         Say 'for CONFIG.SYS, CONFIG.GCP and CONFIG.GCX files.  Make sure the'
         Call SysCurPos 17, 5
         Say 'one with the changes is named CONFIG.SYS, then reboot your computer.'
      End
      Call SysCurPos 19, 21
   End

   Say 'Please read GCPTALK.DOC and GCPTALK.REG'
   Call SysCurPos 23, 0
   Call SysSleep 5
   Call SysSetObjectData '<GCP_TALKDOC>','OPEN=DEFAULT'
   Call SysSetObjectData '<GCP_TALKREG>','OPEN=DEFAULT'
   Return

InstallDirs:
   Opt.1 = 'N'

   inipath = SysIni('USER', 'Gibbon', 'Gibbon INI Path')
   If inipath = 'ERROR:' Then
      Opt.1 = 'Y'
   Else
      Dir.4 = inipath

   Do Forever
      Call SysCls
      Call DrawBox 5, 1, 78, 12
      Call SysCurPos 7, 20
      Call CharOut , "Here's a list of the installation directories:"
      Call SysCurPos 9, 3
      Call CharOut , '1 Programs:       ' Dir.1
      Call SysCurPos 10, 3
      Call CharOut , '2 DLLs:           ' Dir.2
      Call SysCurPos 11, 3
      Call CharOut , '3 Documentation:  ' Dir.3
      Call SysCurPos 12, 3
      Call CharOut , '4 GIBBON.INI file:' Dir.4
      Call SysCurPos 14, 10
      Call CharOut , "Enter the number to change, 'Y' to accept or 'X' to exit "
      Do Forever
         Call ClearInput
         Ans = SysGetKey("NOECHO")
         Select
            When Ans > '0' & Ans < '5' Then
               Do
                  Call SysCurPos 18, 5
                  Say 'Enter the new path:'
                  Call SysCurPos 19, 5
                  Parse Upper Pull Dir.Ans
                  Leave
               End
            When Ans = 'y' | Ans = 'Y' Then Leave
            When Ans = 'x' | Ans = 'X' Then Leave
            Otherwise Iterate
         End
      End
      If Ans = 'x' | Ans = 'X' Then
         Do
            Call SysCls
            Call SysCurPos 5, 20
            Say 'Installation Aborted'
            Call SysCurPos 10, 0
            Return 'BAD'
         End
      If Ans = 'y' | Ans = 'Y' Then Leave
   End

   Return 'OK'


InstallOpts:
   Call SysCls
   Call DrawBox 5, 20, 40, 8
   Call SysCurPos 7, 25
   Call CharOut , 'Do you want me to:'
   Call SysCurPos 9, 25
   Call CharOut , 'Update Your CONFIG.SYS file?'
   Call SysCurPos 10, 25
   Call CharOut , 'Add Objects to your desktop?'
   Call SysCurPos 9, 54
   Opt.2 = GetYN()
   Call SysCurPos 10, 54
   Opt.3 = GetYN()
   Return 'OK'

InstallMakeDirs:
   Do i = 1 to 4
      rc = BuildPath(Dir.i)
      If (rc \= 'OK') Then Do
         Call SysCls
         Call SysCurPos 5, 0
         Say 'Error' rc 'trying to create the following directory:'
         Say ''
         Say Dir.i
         Say ''
         Say 'Installation aborted.'
         Say ''
         Say 'WARNING: Some directories may have been created.'
         Say '         You might want to check, and remove them.'
         Say ''
         Return 'BAD'
      End
   End

   Return 'OK'


InstallCopy:
   Call SysCls
   Call DrawBox 5, 10, 60, 16
   Call SysCurPos 7, 26
   Call CharOut , 'Installing Gibbon Talk Files'
   Call SysCurPos 9, 12

   Do i = 1 to FList.0
      If UnPackFile(FList.i, FType.i) = 'BAD' Then Return 'BAD'
   End
   Return 'OK'


InstallWPS:
   Call SysCls
   Call DrawBox 5, 10, 60, 16
   Call SysCurPos 7, 27
   Call CharOut , 'Installing Desktop Objects'
   row = 9
   ObjErrs = 0

   Class    = 'WPFolder'
   Title    = 'Gibbon^ Applications'
   Location = '<WP_DESKTOP>'
   Setup    = 'OBJECTID=<GCP_APPS>'
   If CreateObj() = 'BAD' Then Do
      If row > 19 Then
         ScrollWindow
      Call ClearInput
      Call SysCurPos 19, 20
      Call CharOut , 'Press any key to end install.'
      Call SysGetKey
      Call SysCls
      Call SysCurPos 5, 20
      Say 'Installation Incomplete'
      Call SysCurPos 10, 0
      Return 'BAD'
   End

   Class = 'WPProgram'
   Location = '<GCP_APPS>'
   Title = 'Gibbon Common^ Logon Manager'
   Setup = 'PROGTYPE=PM;EXENAME='Dir.1'\GCPCLM.EXE;OBJECTID=<GCP_CLM>;STARTUPDIR='Dir.1
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'Gibbon^ Talk Daemon'
   Setup = 'PROGTYPE=PM;EXENAME='Dir.1'\GCPTALKD.EXE;OBJECTID=<GCP_TALKD>;STARTUPDIR='Dir.1
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'Gibbon^ Talk'
   Setup = 'PROGTYPE=PM;EXENAME='Dir.1'\GCPTALK.EXE;OBJECTID=<GCP_TALK>;STARTUPDIR='Dir.1
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'Gibbon^ Brand'
   Setup = 'PROGTYPE=WINDOWABLEVIO;EXENAME='Dir.1'\GCPBRAND.EXE;OBJECTID=<GCP_BRAND>;STARTUPDIR='Dir.1
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'Gibbon^ Help Viewer'
   Setup = 'PROGTYPE=PM;EXENAME='Dir.1'\GCPHELP.EXE;OBJECTID=<GCP_HELP>;PARAMETERS=[What .HLP file?];STARTUPDIR='Dir.3
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'Gibbon Talk^ Help File'
   Setup = 'PROGTYPE=PM;EXENAME='Dir.1'\GCPHELP.EXE;OBJECTID=<GCP_TALKHLP>;STARTUPDIR='Dir.3';PARAMETERS=GCPTALK.HLP'
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'Gibbon CLM^ Help File'
   Setup = 'PROGTYPE=PM;EXENAME='Dir.1'\GCPHELP.EXE;OBJECTID=<GCP_CLMHLP>;STARTUPDIR='Dir.3';PARAMETERS=GCPCLM.HLP'
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Class = 'WPShadow'
   Title = 'GCPTALK.DOC'
   Setup = 'SHADOWID='Dir.3'\GCPTALK.DOC;OBJECTID=<GCP_TALKDOC>'
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1
   Title = 'GCPTALK.REG'
   Setup = 'SHADOWID='Dir.3'\GCPTALK.REG;OBJECTID=<GCP_TALKREG>'
   If CreateObj() = 'BAD' Then
      ObjErrs = ObjErrs + 1

   If ObjErrs > 0 Then Do
      If row > 18 Then
         Call ScrollWindow
         Call ScrollWindow
      Call SysCurPos 18, 20
      Call CharOut , ObjErrs ' Objects not installed!'
      Call ClearInput
      Call SysCurPos 19, 20
      Call CharOut , 'Press any key to continue.'
      Call SysGetKey 'NOECHO'
   End

   Return 'OK'


InstallINI:
   Call SysCls
   Call DrawBox 10, 14, 46, 5
   Call SysCurPos 12, 16
   Call CharOut , 'Adding Gibbon INI Path to OS2.INI....'
   Call SysSleep 1
   Call SysIni 'USER', 'Gibbon', 'Gibbon INI Path', Dir.4
   Call CharOut , 'Done'
   Call SysSleep 3
   Return 'OK'


InstallCFG:
   Call ClearInput
   Call SysCls
   Call DrawBox 5, 15, 50, 12
   Call SysCurPos 7, 28
   If drv = '0' Then Do
      cmdline = Dir.1'\bootdrv'
      Address CMD cmdline
      cfgfile = d2c(RC+64) || ':\CONFIG.'
   End
   Else
      cfgfile = drv':\CONFIG.'
   Call CharOut , 'Processing' cfgfile'SYS'
   Call ClearInput
   Call SysCurPos 9, 17
   Call CharOut , 'Analyzing...'
   Call SysFileTree cfgfile'SYS', cfgfiles, 'FO'
   If cfgfiles.0 = 0 Then Do
      Call CharOut , "Couldn't find CONFIG.SYS!"
      Call SysCurPos 11, 17
      Call CharOut , 'Type the drive letter where your CONFIG.SYS'
      Call SysCurPos 12, 17
      Call CharOut , 'file is, or press "0" to bypass CONFIG.SYS'
      Call SysCurPos 13, 17
      Call CharOut , 'processing: '
      Call ClearInput
      drv = SysGetKey('ECHO')
      If drv = '0' Then Do
         Call SysCls
         Call SysCurPos 5, 20
         Say 'Installation Incomplete'
         Call SysCurPos 10, 0
         Return 'BAD'
      End
      Return 'RERUN'
   End

   If Opt.2 \= 'Y' Then
      newcfg = cfgfile'GCP'
   Else
      newcfg = cfgfile'GCX'
   Call SysFileDelete(newcfg)
   oldcfg = cfgfile'GCP'
   Call SysFileDelete(oldcfg)
   cfgfile = cfgfile'SYS'
   updpath = 0
   updhelp = 0
   updlib = 0

   Do While (Lines(cfgfile) > 0)
      cfgline = LineIn(cfgfile)
      Parse Value cfgline With word1 '=' rest
      Parse Upper Value word1 With set ' ' var
      If set \= 'REM' Then Do
         Parse Upper Var rest search
         If set = 'SET' Then Do
            If var = 'PATH' & updpath = 0 Then Do
               If Pos(Dir.1,search) = 0 Then Do
                  updpath = 1
                  If SubStr(rest, Length(rest)) \= ';' Then
                     rest = rest || ';'
                  rest = rest || dir.1 || ';'
                  Call LineOut newcfg, word1'='rest
                  Iterate
               End
            End
            Else If var = 'HELP' & updhelp = 0 Then Do
               If Pos(Dir.3,search) = 0 Then Do
                  updhelp = 1
                  If SubStr(rest, Length(rest)) \= ';' Then
                     rest = rest || ';'
                  rest = rest || dir.3 || ';'
                  Call LineOut newcfg, word1'='rest
                  Iterate
               End
            End
         End
         Else If set = 'LIBPATH' & updlib = 0 Then Do
            If Pos(Dir.2,search) = 0 Then Do
               updlib = 1
               If SubStr(rest, Length(rest)) \= ';' Then
                  rest = rest || ';'
               rest = rest || dir.2 || ';'
               Call LineOut newcfg, word1'='rest
               Iterate
            End
         End
      End
      If Opt.2 = 'Y' Then
         Call LineOut newcfg, cfgline
   End

   Call Stream newcfg, 'C', 'CLOSE'
   Call Stream cfgfile, 'C', 'CLOSE'

   Call SysCurPos 11, 20
   If updpath = 0 & updhelp = 0 & updlib = 0 Then
      Call CharOut , 'No updates were required'
   Else Do
      Call CharOut , 'Updated: '
      If updpath = 1 Then Call CharOut ,'PATH '
      If updhelp = 1 Then Call CharOut ,'HELP '
      If updlib = 1 Then Call CharOut ,'LIBPATH '
      Call SysCurPos 13, 20
      If Opt.2 \= 'Y' Then
         Call CharOut , 'The changes are in' newcfg
      Else Do
         Address CMD 'ren' cfgfile oldcfg '>NUL 2>&1'
         If RC \= 0 Then Do
            Address CMD 'ren' newcfg cfgfile '>NUL 2>&1'
            Return 'RENAME1'
         End
         Address CMD 'ren' newcfg cfgfile '>NUL 2>&1'
         If RC \= 0 Then Return 'RENAME2'
         If Stream(newcfg, 'C', 'QUERY EXISTS') \= '' Then Return 'RENAME2'
         If Stream(cfgfile, 'C', 'QUERY EXISTS') = '' Then Return 'RENAME2'
         Call CharOut , 'The old CONFIG.SYS has been saved as'
         Call SysCurPos 14, 25
         Call CharOut , oldcfg
      End
   End

   Call SysSleep 5
   Return 'OK'


Rebuild:
   If InstallDirs() = 'BAD' Then Return
   If InstallOpts() = 'BAD' Then Return
   If Opt.3 = 'Y' Then Do
      If InstallWPS() = 'BAD' Then Return
      Call SysSleep 3
   End
   If InstallINI() = 'BAD' Then Return
   drv = '0'
   Do Forever
      rc = InstallCFG()
      If rc = 'RERUN' Then Iterate
      If rc = 'RENAME1' Then
         cfgmsg = 4
      Else If rc = 'RENAME2' Then
         cfgmsg = 5
      Else If rc = 'BAD' Then
         cfgmsg = 3
      Else If updpath = 0 & updhelp = 0 & updlib = 0 Then
         cfgmsg = 0
      Else If Opt.2 = 'Y' Then
         cfgmsg = 1
      Else
         cfgmsg = 2
      Leave
   End

   Call SysSleep 3
   Call Logo

   If cfgmsg = 0 Then Do
      Call DrawBox 11, 1, 78, 5
      Call SysCurPos 13, 26
      Say 'Desktop Rebuild Completed!'
      Call SysCurPos 20, 0
   End
   Else Do
      Call DrawBox 11, 1, 78, 9
      Call SysCurPos 13, 26
      Say 'Desktop Rebuild Completed!'
      If cfgmsg = 1 Then Do
         Call SysCurPos 15, 22
         Say 'Your CONFIG.SYS file was changed.'
         Call SysCurPos 16, 14
         Say 'You must reboot your system to activate the changes.'
      End
      Else If cfgmsg = 2 Then Do
         Call SysCurPos 15, 4
         Say 'A CONFIG.GCP file was created in the same directory as your CONFIG.SYS.'
         Call SysCurPos 16, 7
         Say 'You must manually update your CONFIG.SYS file with the changes in'
         Call SysCurPos 17, 21
         Say 'CONFIG.GCP and then reboot your system.'
      End
      Else If cfgmsg = 3 Then Do
         Call SysCurPos 15, 6
         Say 'Your CONFIG.SYS file could not be found.  You will have to add the'
         Call SysCurPos 16, 18
         Say 'appropriate entries to PATH, LIBPATH and HELP.'
      End
      Else If cfgmsg = 4 Then Do
         Call SysCurPos 15, 5
         Say "WARNING!  I couldn't rename CONFIG.SYS to CONFIG.GCP.  Your updated"
         Call SysCurPos 16, 5
         Say 'CONFIG.SYS is CONFIG.GCX.  Copy CONFIG.GCX to CONFIG.SYS and reboot.'
      End
      Else Do
         Call SysCurPos 15, 7
         Say 'WARNING!  There was a problem renaming your CONFIG files.  Check'
         Call SysCurPos 16, 7
         Say 'for CONFIG.SYS, CONFIG.GCP and CONFIG.GCX files.  Make sure the'
         Call SysCurPos 17, 5
         Say 'one with the changes is named CONFIG.SYS, then reboot your computer.'
      End
      Call SysCurPos 19, 21
   End

   Return


Logo:
   Call SysCls
   Call SysCurPos 3, 0
   Call DrawBox 3, 1, 78, 7
   Call SysCurPos 5, 25
   Call CharOut , 'Gibbon Computer Products, Inc.'
   Call SysCurPos 7, 24
   Call CharOut , 'Gibbon Talk Program Installation'
   Return


DrawBox:
   Arg StLine, StCol, Chars, Lines
   Call SysCurPos StLine, StCol
   Call CharOut , ''
   Call CharOut , Copies('', Chars - 2)
   Call CharOut , ''
   Do l = 1 to Lines - 2
      Call SysCurPos StLine + l, StCol
      Call CharOut , ''
      Call SysCurPos StLine + l, StCol + Chars - 1
      Call CharOut , ''
   End
   Call SysCurPos StLine + Lines - 1, StCol
   Call CharOut , ''
   Call CharOut , Copies('', Chars - 2)
   Call CharOut , ''
   Return


GetYN:
   Arg echoit
   Call ClearInput
   Do Forever
      Parse Upper Value SysGetKey('NOECHO') With YN
      If YN = 'Y' | YN = 'N' Then
         Leave
   End
   Call CharOut , YN
   Return YN


BuildPath:
   Arg dir
   dirpart = ''
   Do While (Length(dir) > 0)
      Parse Value dir With part '\' dir
      If SubStr(part, 2, 1) = ':' Then
         dirpart = part || '\'
      Else
         dirpart = dirpart || part
      rc = SysMkDir(dirpart)
      If rc \= 0 & rc \= 5 Then
         Return rc
      If SubStr(part, 2, 1) \= ':' Then
         dirpart = dirpart || '\'
   End

   Return 'OK'


UnPackFile:
   Arg fname, dirnum
   dirname = Dir.dirnum
   If Length(dirname) > 35 Then
      dirname = '...'Right(dirname, 32)
   Parse Value SysCurPos() With row col
   row = row + 1
   If row > 19 Then
      Call ScrollWindow

   Call SysCurPos row, 12
   Call CharOut , 'Copy' fname '==>' dirname
   UNPACK 'GCPTALK.PKG' Dir.dirnum '/N:'fname '>NUL 2>&1'
   If RC \= 0 Then Do
      row = row + 1
      If row > 17 Then Do
         Call ScrollWindow
         Call ScrollWindow
      End
      Call ClearInput
      Call SysCurPos 18, 20
      Call CharOut , 'ERROR: Failed to copy file!'
      Call SysCurPos 19, 20
      Call CharOut , 'Press any key to end install.'
      Call SysGetKey
      Call SysCls
      Call SysCurPos 5, 20
      Say 'Installation Incomplete'
      Call SysCurPos 10, 0
      Return 'BAD'
   End

   Return 'OK'


ScrollWindow:
   Do scrl = 10 to 19
      line = SysTextScreenRead(scrl, 12, 57)
      Call SysCurPos scrl-1, 12
      Call CharOut , line
   End
   Call SysCurPos 19, 12
   Call CharOut , Copies(' ', 57)
   row = 19
   Return


ClearInput:
   Do While Chars()
      Call SysGetKey 'NOECHO'
   End
   Return


CreateObj:
   If row > 19 Then
      Call ScrollWindow

   Call SysCurPos row, 12
   row = row + 1
   Call CharOut , Title'...'

   If Class = 'WPFolder' Then
      rc = SysCreateObject(Class, Title, Location, Setup, 'U')
   Else
      rc = SysCreateObject(Class, Title, Location, Setup, 'R')
   If rc=0 Then Do
      Call CharOut , 'Object creation failed!'
      Return 'BAD'
   End

   Call CharOut , 'Object created'

   If Class = 'WPFolder' Then Do
      Call SysCurPos row, 12
      row = row + 1
      Call CharOut , 'Setting Folder Icon...'
      rc = SysSetObjectData('<GCP_APPS>', 'ICONFILE='Dir.1'\GCP.ICO')
      If rc=1 Then
         say 'Icon set'
      else
         say "Couldn't set icon!"
   End

   Return 'OK'
