/* DANSK.CMD: Installr MEMSIZE p dansk. */

'@Echo Off'
'CHCP 850'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installrer MEMSIZE...'
Say ''


/* Verify the existence of the various component files. */

Language = 'DANSK'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEJL: MEMSIZE.EXE ikke fundet!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEJL: 'Language'.DLL ikke fundet!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEJL: 'Language'.HLP ikke fundet!'
  Signal DONE
  End

/* Sprg efter installationskataloget. */

Say 'Venligst indtast den fulde sti der peger p hvor du nsker'
Say '  MEMSIZE installeret (standard C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Dan installationskataloget hvis ndvendigt. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEJL: Kan ikke oprette installationskataloget.'
    Signal DONE
    End
  End
Say ''


/* Sprg efter installations folder - (Ask for the target folder.) */

Say 'nsker du at placere MEMSIZE i start folderen? (J/N)'
Pull YesNo
If YesNo = "J" Then
  Do
  Folder = '<WP_START>'
  Say 'Objekt bliver placeret i start folderen.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Objekt placeres p arbejdspladsen.'
  End
Say ''


/* Udfr installationen. */

Say 'Kopierer MEMSIZE til ' Directory '...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( Language".INF", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy Language".INF" Directory"\MEMSIZE.INF"  '1>NUL'
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say 'Opretter program objekt...'
Type = 'WPProgram'
Title = 'Systemresourcer'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE >;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objekt oprettet!  Frdig.'
Else
  Say 'FEJL: Objekt ikke oprettet.'

Signal DONE

FAILURE:
Say 'REXX fejl.'
Signal DONE

HALT:
Say 'REXX stoppet.'
Signal DONE

SYNTAX:
Say 'REXX syntax fejl.'
Signal DONE

DONE:
Exit
