/****************************************************************** ITEMS.CPP
 *                                                                          *
 *                     Display Item Class Functions                         *
 *                                                                          *
 ****************************************************************************/

#define INCL_BASE
#define INCL_PM
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "debug.h"
#include "os20memu.h"
#include "support.h"
#include "restring.h"

#include "items.h"


VOID Item::Paint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  PSZ Text,
  ULONG NewValue
) {

  WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle,
    TextColor, BackColor, DT_RIGHT | DT_BOTTOM | DT_ERASERECT ) ;

  WinDrawText ( hPS, strlen(PCHAR(Label)), Label, &Rectangle,
    TextColor, BackColor, DT_LEFT | DT_BOTTOM ) ;

  Value = NewValue ;
}


VOID Item::Measure ( HPS hPS, RECTL &Rectangle ) {
   BYTE Text [100] ;
   sprintf ( PCHAR(Text), "%s 1,234,567K", QueryLabel() ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle, 0L, 0L, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
}


VOID Clock::Measure ( HPS hPS, RECTL &Rectangle ) {
   BYTE Text [100] ;
   sprintf ( PCHAR(Text), " MMM, MM-DD HH:MM%sx ", ShowSeconds?":SS":"" ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle, 0L, 0L, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
}

struct Date_Time {
   unsigned Weekday : 3 ;
   unsigned Month : 4 ;
   unsigned Day : 5 ;
   unsigned Hours : 5 ;
   unsigned Minutes : 6 ;
   unsigned Seconds : 6 ;
} ;

ULONG Clock::NewValue ( void ) {

  DATETIME DateTime ;
  DosGetDateTime ( &DateTime ) ;

  struct Date_Time Dttm = { 
     DateTime.weekday, 
     DateTime.month, 
     DateTime.day, 
     DateTime.hours, 
     DateTime.minutes, 
     0 
  } ;

  if ( ShowSeconds ) 
     Dttm.Seconds = DateTime.seconds ;

  ULONG Time = * ( (PULONG) &Dttm ) ;

  return ( Time ) ;
}


VOID Clock::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Time = NewValue ( ) ;

  if ( Mandatory || ( Time != Value ) ) {

    struct Date_Time Dttm = * ( (struct Date_Time*) &Time ) ;
    ULONG Dow    = Dttm.Weekday ;
    ULONG Month  = Dttm.Month ;
    ULONG Day    = Dttm.Day ;
    ULONG Hour   = Dttm.Hours ;
    ULONG Minute = Dttm.Minutes ;
    ULONG Second = Dttm.Seconds ;

    BYTE Text [100] ;
    sprintf ( PCHAR(Text), "%0.3s, ", PSZ(*DaysOfWeek) + Dow*3 ) ;

    switch ( CountryInfo.fsDateFmt ) {

      case DATEFMT_DD_MM_YY:
        sprintf ( PCHAR(Text)+strlen(PCHAR(Text)), "%02lu%s%02lu ",
          Day, CountryInfo.szDateSeparator, Month ) ;
        break ;

      case DATEFMT_YY_MM_DD:
      case DATEFMT_MM_DD_YY:
      default:
        sprintf ( PCHAR(Text)+strlen(PCHAR(Text)), "%02lu%s%02lu ",
          Month, CountryInfo.szDateSeparator, Day ) ;
        break ;
    }

    if ( CountryInfo.fsTimeFmt ) {
      sprintf ( PCHAR(Text)+strlen(PCHAR(Text)), "%02lu%s%02lu",
        Hour,
        CountryInfo.szTimeSeparator,
        Minute ) ;
    } else {
      PCHAR AmPm ;

      if ( Hour ) {
        if ( Hour < 12 ) {
          AmPm = szAm ;
        } else if ( Hour == 12 ) {
          if ( Minute )
            AmPm = szPm ;
          else
            AmPm = szAm ;
        } else if ( Hour > 12 ) {
          Hour -= 12 ;
          AmPm = szPm ;
        }
      } else {
        Hour = 12 ;
        if ( Minute )
          AmPm = szAm ;
        else
          AmPm = szPm ;
      }
      if ( ShowSeconds )
         sprintf ( PCHAR(Text)+strlen(PCHAR(Text)), "%02lu%s%02lu%s%02lu%s",
            Hour, CountryInfo.szTimeSeparator, Minute, CountryInfo.szTimeSeparator, Second, AmPm ) ;
      else
         sprintf ( PCHAR(Text)+strlen(PCHAR(Text)), "%02lu%s%02lu%s",
            Hour, CountryInfo.szTimeSeparator, Minute, AmPm ) ;
    }

    WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle,
      TextColor, BackColor, DT_CENTER | DT_BOTTOM | DT_ERASERECT ) ;

    Value = Time ;
  }
}


VOID ElapsedTime::Measure ( HPS hPS, RECTL &Rectangle ) {
   BYTE Text [100] ;
   sprintf ( PCHAR(Text), "%s XX %s, XX:XX%s", QueryLabel(), PSZ(*Days), ShowSeconds?":XX":"" ) ;
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle, 0L, 0L, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
}


ULONG ElapsedTime::NewValue ( void ) {
   ULONG Milliseconds ;
   DosQuerySysInfo ( QSV_MS_COUNT, QSV_MS_COUNT, &Milliseconds, sizeof(Milliseconds) ) ;
   return ( Milliseconds / 1000 ) ;
}


VOID ElapsedTime::Repaint (
   HPS hPS,
   RECTL &Rectangle,
   COLOR TextColor,
   COLOR BackColor,
   BOOL Mandatory
) {

   ULONG Time = NewValue ( ) ;

   if ( Mandatory || ( Time != Value ) ) {

      BYTE Text [100] ;
      memset ( Text, 0, sizeof(Text) ) ;

      ULONG NumberOfDays = Time / ( 60 * 60 * 24 ) ;
      Time -= NumberOfDays * 60 * 60 * 24 ;
      ULONG Hours   = Time / ( 60 * 60 ) ;
      Time -= Hours * 60 * 60 ;
      ULONG Minutes = Time / 60 ;
      ULONG Seconds = Time % 60 ;

      if ( NumberOfDays ) {
         sprintf ( PCHAR(Text), "%lu %s, ",
            NumberOfDays, NumberOfDays > 1 ? PSZ(*Days) : PSZ(*Day) ) ;
      } /* endif */

      if ( ShowSeconds )
         sprintf ( PCHAR(Text+strlen(PCHAR(Text))), "%lu%s%02lu%s%02lu",
            Hours, CountryInfo.szTimeSeparator, Minutes,
            CountryInfo.szTimeSeparator, Seconds ) ;
      else
         sprintf ( PCHAR(Text+strlen(PCHAR(Text))), "%lu%s%02lu",
            Hours, CountryInfo.szTimeSeparator, Minutes ) ;

      Paint ( hPS, Rectangle, TextColor, BackColor, Text, Time ) ;
   }
}


APIRET16 APIENTRY16 Dos16MemAvail ( PULONG pulAvailMem ) ;

ULONG MemoryFree::NewValue ( void ) {

  // Try DosMemAvail first.
  ULONG Space ;
  Dos16MemAvail ( &Space ) ;

  // If the available space is over 512K, it will be correct.
  if ( Space > 512 * 1024 )
     return ( Space ) ;

  // If smaller, then if OS20MEMU is available, try asking it for a better number.
  if ( EP_get_general_info ) {
     // Get the general information block.
     struct os20memu_general_info GeneralInfo ;
     GeneralInfo.gi_cpids = 1 ;
     APIRET Status = EP_get_general_info ( &GeneralInfo ) ;
     if ( ( Status == 0 ) || ( Status == 122 ) ) {
        // If successful, return what it says to be the free physical memory.
        return ( GeneralInfo.gi_free_mem * 4096 ) ;
     } /* endif */
  } /* endif */

  // If OS20MEMU couldn't answer for some reason, return the number from DosMemAvail.
  return ( Space ) ;
}


VOID MemoryFree::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) ) {
    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    {
      PBYTE p1, p2 ;
      BYTE Work[100] ;

      p1 = Text ;
      p2 = Work ;
      while ( *p1 )
      {
        *p2 = *p1 ;
        p1 ++ ;
        p2 ++ ;
        if ( *p1 )
        {
          if ( strlen((PCHAR)p1) % 3 == 0 )
          {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
          }
        }
      }
      *p2 = 0 ;
      strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
    }

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}


ULONG VirtualFree::NewValue ( void ) {
  ULONG Space ;
  DosQuerySysInfo ( QSV_TOTAVAILMEM, QSV_TOTAVAILMEM, &Space, sizeof(Space) ) ;
  return ( Space ) ;
}


VOID VirtualFree::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) ) {
    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    {
      PBYTE p1, p2 ;
      BYTE Work[100] ;

      p1 = Text ;
      p2 = Work ;
      while ( *p1 )
      {
        *p2 = *p1 ;
        p1 ++ ;
        p2 ++ ;
        if ( *p1 )
        {
          if ( strlen((PCHAR)p1) % 3 == 0 )
          {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
          }
        }
      }
      *p2 = 0 ;
      strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
    }

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}


ULONG SwapSize::NewValue ( void )
{
  char Path [_MAX_PATH+1] ;

  strcpy ( Path, (PCHAR)SwapPath ) ;

  if ( Path[strlen(Path)-1] != '\\' ) {
    strcat ( Path, "\\" ) ;
  }

  strcat ( Path, "SWAPPER.DAT" ) ;

  ULONG SwapSize = 0 ;
  FILESTATUS3 Status ;
  if ( DosQueryPathInfo ( (PSZ)Path, FIL_STANDARD, &Status, sizeof(Status) ) == 0 ) {
    SwapSize = Status.cbFileAlloc ;
  }

  return ( SwapSize ) ;
}


VOID SwapSize::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) )
  {
    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    {
      PBYTE p1, p2 ;
      BYTE Work[100] ;

      p1 = Text ;
      p2 = Work ;
      while ( *p1 ) {
        *p2 = *p1 ;
        p1 ++ ;
        p2 ++ ;
        if ( *p1 ) {
          if ( strlen((PCHAR)p1) % 3 == 0 ) {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
          }
        }
      }
      *p2 = 0 ;
      strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
    }

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}


ULONG SwapFree::NewValue ( void ) {

  DosError ( FERR_DISABLEHARDERR ) ;
  FSALLOCATE Allocation ;
  DosQueryFSInfo ( SwapPath[0]-'A'+1, FSIL_ALLOC, PBYTE(&Allocation), sizeof(Allocation) ) ;
  DosError ( FERR_ENABLEHARDERR ) ;

  ULONG SwapFree = Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ;

  if ( SwapFree < ULONG(MinFree*1024) )
    return ( 0 ) ;
  else
    return ( ULONG ( ( SwapFree - ULONG(MinFree*1024) ) / (1024*1024) ) * (1024*1024) ) ;
}


VOID SwapFree::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) ) {

    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    {
      PBYTE p1, p2 ;
      BYTE Work[100] ;

      p1 = Text ;
      p2 = Work ;
      while ( *p1 )
      {
        *p2 = *p1 ;
        p1 ++ ;
        p2 ++ ;
        if ( *p1 )
        {
          if ( strlen((PCHAR)p1) % 3 == 0 )
          {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
          }
        }
      }
      *p2 = 0 ;
      strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
    }

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}


ULONG SpoolSize::NewValue ( void ) {

   ULONG PathSize ;
   DosQuerySysInfo ( QSV_MAX_PATH_LENGTH, QSV_MAX_PATH_LENGTH, &PathSize, sizeof(PathSize) ) ;

   PBYTE Path = PBYTE ( malloc ( size_t(PathSize) ) ) ;
   if ( Path == NULL ) 
      return ( 0 ) ;

   PFILEFINDBUF3 Found = PFILEFINDBUF3 ( malloc ( size_t( PathSize + sizeof(FILEFINDBUF3) ) ) ) ;
   if ( Found == NULL ) {
      free ( Path ) ;
      return ( 0 ) ;
   } /* endif */

   strcpy ( (PCHAR)Path, (PCHAR)SpoolPath ) ;
   strcat ( (PCHAR)Path, "\\*.*" ) ;

   HDIR hDir = (HDIR) HDIR_CREATE ;
   ULONG Count = 1 ;
   ULONG TotalSize = 0 ;

   if ( !DosFindFirst2 ( Path, &hDir,
     FILE_NORMAL | FILE_READONLY | FILE_DIRECTORY | FILE_ARCHIVED,
     Found, PathSize+sizeof(FILEFINDBUF3), &Count, FIL_STANDARD ) ) {

    do {

      if ( !strcmp ( (PCHAR)Found->achName, "." ) OR !strcmp ( (PCHAR)Found->achName, ".." ) ) 
        continue ;

      if ( Found->attrFile & FILE_DIRECTORY ) {

        HDIR hDir2 = (HDIR) HDIR_CREATE ;

        strcpy ( (PCHAR)Path, (PCHAR)SpoolPath ) ;
        strcat ( (PCHAR)Path, "\\" ) ;
        strcat ( (PCHAR)Path, (PCHAR)Found->achName ) ;
        strcat ( (PCHAR)Path, "\\*.*" ) ;

        ULONG Count2 = 1 ;
        if ( !DosFindFirst2 ( Path, &hDir2,
          FILE_NORMAL | FILE_READONLY | FILE_ARCHIVED,
          Found, PathSize+sizeof(FILEFINDBUF3), &Count2, FIL_STANDARD ) ) {
          do {
            TotalSize += Found->cbFileAlloc ;
          } while ( !DosFindNext ( hDir2, Found, PathSize+sizeof(FILEFINDBUF3), &Count2 ) ) ;
          DosFindClose ( hDir2 ) ;
        } /* endif */
      } else {
        TotalSize += Found->cbFileAlloc ;
      } /* endif */
    } while ( !DosFindNext ( hDir, Found, PathSize+sizeof(FILEFINDBUF3), &Count ) ) ;

    DosFindClose ( hDir ) ;

  } /* enddo */

  free ( Path ) ;
  free ( Found ) ;

  return ( TotalSize ) ;
}


VOID SpoolSize::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) )
  {
    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    {
      PBYTE p1, p2 ;
      BYTE Work[100] ;

      p1 = Text ;
      p2 = Work ;
      while ( *p1 )
      {
        *p2 = *p1 ;
        p1 ++ ;
        p2 ++ ;
        if ( *p1 )
        {
          if ( strlen((PCHAR)p1) % 3 == 0 )
          {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
          }
        }
      }
      *p2 = 0 ;
      strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
    }

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}


ULONG CpuLoad::NewValue ( void ) {
  MaxCount = (ULONG) max ( MaxCount, *IdleCount ) ;
  ULONG Load = ( ( MaxCount - *IdleCount ) * 100 ) / MaxCount ;
  return ( Load ) ;
}


VOID CpuLoad::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Load = NewValue ( ) ;

  if ( Mandatory || ( Load != Value ) )
  {
    BYTE Text [100] ;
    sprintf ( (PCHAR)Text, "%lu%%", Load ) ;
    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Load ) ;
  }
}


ULONG TaskCount::NewValue ( void )
{
  return ( WinQuerySwitchList ( Anchor, PSWBLOCK(NULL), 0 ) ) ;
}


VOID TaskCount::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Count = NewValue ( ) ;

  if ( Mandatory || ( Count != Value ) )
  {
    BYTE Text [100] ;
    sprintf ( (PCHAR)Text, "%lu ", Count ) ;
    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Count ) ;
  }
}


VOID DriveFree::Measure ( HPS hPS, RECTL &Rectangle ) {
   BYTE Text [100] ;
   if ( ShowFileSystemName ) {
      if ( ShowDiskLabel ) {
         sprintf ( PCHAR(Text), "%s (%s,%s) 1,234,567K", QueryLabel(), DiskLabel, FileSystem ) ;
      } else {
         sprintf ( PCHAR(Text), "%s (%s) 1,234,567K", QueryLabel(), FileSystem ) ;
      } /* endif */
   } else {
      if ( ShowDiskLabel ) {
         sprintf ( PCHAR(Text), "%s (%s) 1,234,567K", QueryLabel(), DiskLabel ) ;
      } else {
         sprintf ( PCHAR(Text), "%s 1,234,567K", QueryLabel() ) ;
      } /* endif */
   } /* endif */
   WinQueryWindowRect ( HWND_DESKTOP, &Rectangle ) ;
   WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle, 0L, 0L, DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT ) ;
}


ULONG DriveFree::NewValue ( void )
{
  if ( Error )
  {
    return ( 0 ) ;
  }

  DosError ( FERR_DISABLEHARDERR ) ;

  FSALLOCATE Allocation ;
  APIRET Status = DosQueryFSInfo ( DriveNumber, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;

  DosError ( FERR_ENABLEHARDERR ) ;

  if ( Status )
  {
    Error = TRUE ;
    return ( 0 ) ;
  }

  return ( Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ) ;
}


VOID DriveFree::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) )
  {
    BYTE Text [100] ;

    if ( Error )
    {
      strcpy ( PCHAR(Text), PCHAR(*DriveError) ) ;
    }
    else
    {
      if ( Size < 0x80000 )
        sprintf ( (PCHAR)Text, "%lu", Size ) ;
      else
        sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

      {
        PBYTE p1, p2 ;
        BYTE Work[100] ;

        p1 = Text ;
        p2 = Work ;
        while ( *p1 )
        {
          *p2 = *p1 ;
          p1 ++ ;
          p2 ++ ;
          if ( *p1 )
          {
            if ( strlen((PCHAR)p1) % 3 == 0 )
            {
              *p2 = CountryInfo.szThousandsSeparator [0] ;
              p2 ++ ;
            }
          }
        }
        *p2 = 0 ;
        strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
      }

      Text[strlen(PCHAR(Text))+1] = 0 ;
      if ( Size < 0x80000 )
        Text[strlen((PCHAR)Text)] = ' ' ;
      else
        Text[strlen((PCHAR)Text)] = 'K' ;
    }

    WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle,
      TextColor, BackColor, DT_RIGHT | DT_BOTTOM | DT_ERASERECT ) ;

    if ( ShowFileSystemName ) {
       if ( ShowDiskLabel ) {
          sprintf ( PCHAR(Text), "%s (%s,%s)", QueryLabel(), DiskLabel, FileSystem ) ;
       } else {
          sprintf ( PCHAR(Text), "%s (%s)", QueryLabel(), FileSystem ) ;
       } /* endif */
    } else {
       if ( ShowDiskLabel ) {
          sprintf ( PCHAR(Text), "%s (%s)", QueryLabel(), DiskLabel ) ;
       } else {
          sprintf ( PCHAR(Text), "%s", QueryLabel() ) ;
       } /* endif */
    } /* endif */

    WinDrawText ( hPS, strlen(PCHAR(Text)), Text, &Rectangle,
      TextColor, BackColor, DT_LEFT | DT_BOTTOM ) ;

    Value = Size ;
  }
}


ULONG TotalFree::NewValue ( void )
{
  ULONG Free = 0 ;
  ULONG Mask = Drives >> 2 ;

  for ( int Drive=3; Drive<=26; Drive++ )
  {
    if ( Mask & 1 )
    {
      DosError ( FERR_DISABLEHARDERR ) ;

      FSALLOCATE Allocation ;
      APIRET Status = DosQueryFSInfo ( Drive, FSIL_ALLOC, (PBYTE)&Allocation, sizeof(Allocation) ) ;

      DosError ( FERR_ENABLEHARDERR ) ;

      if ( Status )
      {
        Drives &= ~ ( 1 << (Drive-1) ) ;
      }
      else
      {
        Free += Allocation.cUnitAvail*Allocation.cSectorUnit*Allocation.cbSector ;
      }
    }
    Mask >>= 1 ;
  }

  return ( Free ) ;
}


VOID TotalFree::Repaint
(
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
)
{
  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) )
  {
    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    {
      PBYTE p1, p2 ;
      BYTE Work[100] ;

      p1 = Text ;
      p2 = Work ;
      while ( *p1 )
      {
        *p2 = *p1 ;
        p1 ++ ;
        p2 ++ ;
        if ( *p1 )
        {
          if ( strlen((PCHAR)p1) % 3 == 0 )
          {
            *p2 = CountryInfo.szThousandsSeparator [0] ;
            p2 ++ ;
          }
        }
      }
      *p2 = 0 ;
      strcpy ( (PCHAR)Text, (PCHAR)Work ) ;
    }

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}


ULONG SwapSlack::NewValue ( void ) {
   LONG Slack = pVirtualFree->QueryFlag() ? pVirtualFree->QueryValue() : pVirtualFree->NewValue() ;
   Slack -= pSwapFree->QueryFlag() ? pSwapFree->QueryValue() : pSwapFree->NewValue() ;
   Slack -= pMemFree->QueryFlag() ? pMemFree->QueryValue() : pMemFree->NewValue() ;
   return ( ULONG ( max ( 0, Slack ) ) ) ;
}


VOID SwapSlack::Repaint (
  HPS hPS,
  RECTL &Rectangle,
  COLOR TextColor,
  COLOR BackColor,
  BOOL Mandatory
) {

  ULONG Size = NewValue ( ) ;

  if ( Mandatory || ( Size != Value ) ) {

    BYTE Text [100] ;

    if ( Size < 0x80000 )
      sprintf ( (PCHAR)Text, "%lu", Size ) ;
    else
      sprintf ( (PCHAR)Text, "%lu", (Size+512)/1024 ) ;

    BYTE Work[100] ;
    PBYTE p1 = Text ;
    PBYTE p2 = Work ;
    while ( *p1 ) {
      *p2 = *p1 ;
      p1 ++ ;
      p2 ++ ;
      if ( *p1 ) {
        if ( strlen((PCHAR)p1) % 3 == 0 ) {
          *p2 = CountryInfo.szThousandsSeparator [0] ;
          p2 ++ ;
        }
      }
    }
    *p2 = 0 ;
    strcpy ( (PCHAR)Text, (PCHAR)Work ) ;

    Text[strlen(PCHAR(Text))+1] = 0 ;
    if ( Size < 0x80000 )
      Text[strlen((PCHAR)Text)] = ' ' ;
    else
      Text[strlen((PCHAR)Text)] = 'K' ;

    Paint ( hPS, Rectangle, TextColor, BackColor, Text, Size ) ;
  }
}



