/* areas.c
**
**  Released into the public domain by John Dennis, 1994.
**  written by jim nutt, John Dennis
**
**  This file contains the routines to select one of the areas
**  specified in the config files.  It pops up a list with all the
**  areas and lets the user chose.
**
*/

#include "msged.h"
#include "main.h"
#include "menu.h"
#include "keys.h"

extern int msgederr;

void  areascan(void);

static char **alist;

static void BuildList(void);
static int AreaBox(char **Itms, int y1, int y2, int len, int def, 
    unsigned long wid, int Sel, int Norm, int indent);

int  selectarea(void)
{
    WND   *hCurr, *hWnd;
    int    ret;
    int    wid, dep, i;

    msgederr = 0;
    wid      = maxx - 1;
    dep      = maxy - 1; /* min(maxy - 6, SW->areas + 2); */
    
    hCurr = Wtop();
    if ((hWnd = WPopUp(wid, dep, SBDR, cm[MN_BTXT], cm[MN_NTXT])) == NULL)
        return SW->area;

    WTitle(" Select Message Area ", cm[MN_BTXT]);
    WWriteStr(4,  0, cm[MN_BTXT], "Area Description");
    WWriteStr(44, 0, cm[MN_BTXT], "Msgs");
    WWriteStr(58, 0, cm[MN_BTXT], "Last");
    WWriteStr(69, 0, cm[MN_BTXT], "Unread");
    BuildList();

    ret = AreaBox(alist, 
                 1, 
                 min(dep - 2, SW->areas), 
                 wid - 1, 
                 SW->area, 
                 hWnd->wid, 
                 cm[MN_STXT], 
                 cm[MN_NTXT], 
                 2);

    for (i = 0; i < SW->areas; i++)
        free(alist[i]);

    free(alist);

    if (ret < 0)
        msgederr = 1;

    WClose(hWnd);
    WCurr(hCurr);

    return ((ret < 0) ? SW->area : ret);
}

static void BuildList(void)
{
    AREA  *a;
    char   line[81];
    int    i;
    unsigned long   unread;
    unsigned long   current;

    alist = calloc(SW->areas + 2, sizeof(char *));

    for (i = 0; i < SW->areas; i++)
    {
        a = arealist + i;

        if ((a->messages != 0) || (SW->scanned))
        {
            current = a->current;
            if (current > a->messages)
            {
                current = a->messages;
            }
            unread = a->messages - current;
            sprintf(line, 
                    "%c %-30.30s        %6lu        %6lu       %6lu",
                    ((unread != 0) ? '\x10' : ' '),
                    a->description,
                    a->messages,
                    current,
                    unread);
        }
        else
            sprintf(line, 
                    "  %-30.30s           unscanned",
                    a->description);

        alist[i] = strdup(line);
    }
    alist[i] = NULL;
}

static void SelShowItem(char *text, int y, int len, int Attr, int indent)
{
    char line[256];

    memset(line, ' ', 40);
    strcpy(line + indent, text);
    WPutsn(0, y, len, Attr, line);
}

static void SelShowPage(char **text, int top, int bot, int len, 
    int pos, int Attr, int indent)
{
    int i;
    int y = top;

    for (i = pos; text[i] != NULL; i++)
    {
        if (y > bot)
            break;

        SelShowItem(text[i], y++, len, Attr, indent);
    }
    if (y <= bot)
    {
        while (y <= bot)
            SelShowItem(" ", y++, len, Attr, indent);
    }
}

static void CalcDef(int max, int cur, int *top, int miny, int maxy, int *y)
{
    int dif = maxy - miny;

    unused(cur);
    if ((max - 1) - *top < dif && max > dif)
    {
        *y   = maxy;
        *top = (max - 1) - dif;
    }
}

static int AreaBox(char **Itms, int y1, int y2, int len, int def, 
    unsigned long wid, int Sel, int Norm, int indent)
{
    EVT    e;
    int    Cnt    = 0;
    int    Stuff  = 0;
    int    done;
    int    Cury;
    int    Msg;
    int    Curr;
    int    Top;
    int    page;
    int    i;

    for (i = 0; Itms[i] != NULL; i++)
        Cnt++;

    Curr = def;
    Cury = y1;
    page = y2 - y1;
    Top  = Curr;

    if (Curr + y1 < y1)
    {
        Cury = y1 + Curr;
        Top  = 0;
    }
    else
    {
        if ((Cnt - Curr) <= (y2 - y1))
        {
            Top   -= ((y2 - y1 + 1) - (Cnt - Top));
            Cury   = y1 + (def - Top);
            if (Top < 0)
            {
                Top = 0;
                Cury--;
            }
        }
    }
    done = 0;

    SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
    SelShowItem(Itms[Curr], Cury, len, Sel, indent);

    TTClearQue();                  /* clear input queue */

    while (!done)
    {
        if (!Stuff)
            Msg = MnuGetMsg(&e, wid);
        else
        {
            e.msgtype = WM_CHAR;
            Msg       = Stuff;
            Stuff     = 0;
        }

        switch (e.msgtype)
        {
            case WM_MOUSE:
                switch (Msg)
                {
                    case RMOU_CLCK:
                    case MOU_RBTUP:
                        return -1;

                    case LMOU_RPT:
                    case MOU_LBTDN:
                    /*case MOU_LBTUP:*/
                    case LMOU_CLCK:
                    case MOUSE_EVT:
                        {
                            int x, y;

                            WndGetRel(e.x, e.y, &x, &y);
                            if (y >= y1 && y <= y2)            /* in window */
                            {
                                Stuff = 0;
                                if (x >= 0 && x < len )
                                {
                                    if (y == Cury)
                                    {
                                        if (Msg == LMOU_CLCK || Msg == MOU_LBTUP)
                                            return Curr;
                                        else
                                            continue;
                                    }

                                    SelShowItem(Itms[Curr], Cury, len, Norm, indent);

                                    if (y > Cury)
                                        Curr += y - Cury;
                                    else
                                        Curr -= Cury - y;

                                    Cury = y;

                                    SelShowItem(Itms[Curr], Cury, len, Sel, indent);

                                    if (Msg == LMOU_CLCK || Msg == MOU_LBTUP)
                                        return Curr;
                                }
                            }
                            else
                            {
                                if (Msg != LMOU_CLCK)
                                {
                                    if (y < y1)
                                        Stuff = Key_Up;
                                    else
                                        Stuff = Key_Dwn;
                                }
                            }
                        }
                        break;

                    default:
                        break;
                }
                break;

            case WM_CHAR:
                switch (Msg)
                {
                    case Key_Home:
                        if (!Curr) break;
                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        Curr = 0;
                        Top  = 0;
                        Cury = y1;
                        SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        break;

                    case Key_End:
                        if (Curr == Cnt - 1) break;
                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        Curr = Cnt - 1;
                        while (Curr && Curr >= (Cnt - page))
                            Curr--;
                        Top  = Curr;
                        Curr = Cnt  - 1;
                        Cury = Curr - Top + y1;
                        CalcDef(Cnt, Curr, &Top, y1, y2, &Cury);
                        SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        break;

                    case Key_Dwn:
                        if (Curr == Cnt - 1)
                            break;

                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        Curr++;
                        if (Cury == y2)
                        {
                            WScroll(0, y1, len - 1, y2, 1);
                            Top++;
                        }
                        else
                            Cury++;
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        break;

                    case Key_Up:
                        if (!Curr)
                            break;

                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        Curr--;
                        if (Cury == y1)
                        {
                            WScroll(0, y1, len - 1, y2, 0);

                            if (Top)
                                Top--;
                        }
                        else
                            Cury--;
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        break;

                    case Key_PgUp:
                        if (!Curr)
                            break;

                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        if ((Curr -= page) < 0)
                            Curr = 0;

                        Top  = Curr;
                        Cury = y1;
                        SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        break;

                    case Key_PgDn:
                        if (Curr == Cnt - 1)
                            break;

                        SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                        Top = Curr;

                        if ((Curr += page) > Cnt - 1)
                            Curr = Cnt - 1;

                        Cury = Curr - Top + y1;
                        CalcDef(Cnt, Curr, &Top, y1, y2, &Cury);
                        SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        break;

                    case Key_Ent:
                        return Curr;

                    case Key_Esc:
                        return -1;

                    case '*':
                        area_scan();
                        for (i = 0; i < SW->areas; i++)
                            free(alist[i]);

                        free(alist);

                        BuildList();
                        Itms = alist;
                        
                        SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                        SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                        
                        break;
                        
                    default:
                        if (Msg > 31 && Msg < 127) 
                        {
                            i = Curr + 1;

                            while (i < Cnt)
                            {
                                if (toupper(*(Itms[i] + 2)) == toupper((char) Msg))
                                    break;
                                i++;
                            }
                            if (i == Cnt)
                            {
                                for (i = 0; i < Curr; i++)
                                    if (toupper(*(Itms[i] + 2)) == toupper((char) Msg))
                                        break;
                            }
                            if (i != Curr)
                            {
                                SelShowItem(Itms[Curr], Cury, len, Norm, indent);
                                Curr = i;
                                Cury = y1;
                                Top  = Curr;

                                /*
                                ** Get the cursor position right...
                                */

                                if ((Cnt - 1) - Curr < y2 - y1)
                                {
                                    if (Curr > y2 - y1)
                                    {
                                        Cury = y2;
                                        Top  = Curr - (y2 - y1);
                                    }
                                    else
                                    {
                                        Cury = Curr + y1;
                                        Top  = 0;
                                    }
                                }
/*                              CalcDef(Cnt, Curr, &Top, y1, y2, &Cury); */
                                SelShowPage(Itms, y1, y2, len, Top, Norm, indent);
                                SelShowItem(Itms[Curr], Cury, len, Sel, indent);
                            }
                        }
                        break;

                }
                break;
        }
    }
    return -1;
}

