/* bmg - emulate Boyer-More-Gosper routines, without actually doing
   it, because MSGED/SQ doesn't use the proper functionality, for
   unknown reasons. */
/* Written by Paul Edwards and released to the public domain */   

#include <string.h>
#include <ctype.h>

#include "bmg.h"
#include "strextra.h"

static char search_string[256];

void bmg_setsearch(char *search)
{
    strcpy(search_string, search);
    return;
}

char *bmg_search(char *text)
{
    return (bmg_find(text, search_string));
}

char *bmg_find(char *text, char *search)
{
    int lent, lens;
    char *endText;
    char *p;
    register int searchStart;
    
    lent = strlen(text);
    lens = strlen(search);
    if (lens > lent) 
    {
        return (NULL);
    }
    searchStart = toupper(*search);
    p = text;
    endText = p + (lent - lens) + 1;
    for (; p != endText; p++)
    {
        if (toupper(*p) == searchStart)
        {
            if (strncmpi(p, search, lens) == 0)
            {
                return (p);
            }
        }
    }
    return (NULL);
}
