/* ibmscrn.c
**
**  Released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
**  Screen definitions & routines for the ibm pc only;
**  EGA/VGA support not using a commercial screen product.
**
**  Uses an even queue for mouse and keyboard input.  Currently dosen't
**  ask for a desq buffer and doesn't give up any ticks - this should
**  be implemented in some compiler independant fashion.
*/

#include "msged.h"
#include "winsys.h"
#include "vio.h"
#include "unused.h"
#include "dosasm.h"

#define EBUFSZ 100

#define DEBUG    0
#define TERMDEF  1

/* #define NO_MOUSE 1 */

#ifdef  MSDOS

#include <time.h>
#include <sys/timeb.h>

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <bios.h>

#define NCOL 80
#define NROW 25

#include <stdio.h>
#include <dos.h>
/* #include "vio.h" */
/* #include "mou.h" */

/* ===[ variables ]=== */

TERM term = {
    NCOL,
    NROW,
    0,
    };

unsigned int          color;
int           LButton = 0;
int           RButton = 0;
int           cur_start = 6; /* these are ega/vga defaults */
int           cur_end = 7;
static EVT    EVent[EBUFSZ];    /* event circular queue */
static int    ebufin  = 0;      /* event in */
static int    ebufout = 0;      /* event out */
static MOU    mstatus = {0, 40, 12, 0, 0, 1, 1, 0};   /* mouse status */
static int    mouse_avail = 0;
static int    mousex      = 40;
static int    mousey      = 12;

static int mykbhit(void);
static int FullBuffer(void);

/* ====[ functions ]==== */

int TTScolor(unsigned int Attr)
{
    VIOsetfore(Attr & 0x000f);
    VIOsetback((Attr & 0xfff0) / 0x10);
    color = Attr;
    return 0;
}

int TTBeep(void)
{
    return 0;
}

int TTCurSet(int st)
{
    union REGS regs;

    if (st)  {                     /* Restores cursor               */
        regs.h.ah = 0x01;          /* BIOS Set Cursor Type          */
        regs.h.ch = cur_start;     /* Retrieve starting scan line   */
        regs.h.cl = cur_end;       /* Retrieve ending scan line     */
        int86(0x10, &regs, &regs); /* Call BIOS                     */
    }
    else {                          /* Removes cursor                */
        regs.h.ah = 0x01;           /* BIOS Set Cursor Type          */
        regs.h.ch = 0x20;           /* Set bit 5 in CH               */
        int86(0x10, &regs, &regs);  /* Call BIOS                     */
    }
    return 0;
}

int TTgotoxy(int row, int col)
{
    VIOgotoxy(col, row);
    VIOupdate();
    return 0;
}

int TTgetxy(int *row, int *col)
{
    *row = VIOwherex();
    *col = VIOwherey();
    return 0;
}

int TTGetKey(void)
{
    return (obtkey());
}

int TTPutChr(unsigned int Ch)
{
    VIOputc(Ch);
    VIOupdate();
    return 0;
}

int TTWriteStr(unsigned short *b, int len, int row, int col)
{
    VIOputr(col, row, len, 1, b);
    return 0;
}

int TTStrWr(unsigned char *s, int row, int col)
{
    unsigned short line[200];
    int i  = 0;

    while (*s)
    {
        line[i] = ((unsigned) *s & 0xff) | (color << 8);
        s++;  i++;
    }
    TTWriteStr(line, i, row, col);

/*  VIOgotoxy(col,row);
    VIOputs(s); */
    return 0;
}

int TTReadStr(unsigned short *b, int len, int row, int col)
{
    VIOgetra(col, row, col + len - 1, row, b);
    return 0;
}

int TTClear(int x1, int y1, int x2, int y2)
{
    VIOclear(x1, y1, x2, y2);
    return 0;
}

int TTScroll(int x1, int y1, int x2, int y2, int lines, int Dir)
{
    if (Dir)
        VIOscrollup(x1, y1, x2+1, y2, lines);
    else
        VIOscrolldown(x1, y1, x2+1, y2, lines);
    return 0;
}

int TTEeol(void)
{
    int row, col;

    TTgetxy(&row, &col);
    TTScroll(col, row, NCOL-1, row, 0, 1);
    return 0;
}

int TTChngRez(int a)
{
    unused(a);
    return 0;
}

int TTdelay(int mil)
{
#ifdef __TURBOC__
    delay(mil);
#else
    unused(mil);    
#endif
    return 0;
}

void TTSendMsg(int msg, int x, int y, int msgtype)
{
    if (((ebufin + 1) % EBUFSZ) != ebufout)
    {
        EVent[ebufin].msg     = msg;
        EVent[ebufin].x       = x;
        EVent[ebufin].y       = y;
        EVent[ebufin].msgtype = msgtype;
        ebufin                = (ebufin + 1) % EBUFSZ;
    }
}


/* ======================================== */

/*
**
** This is primarily the input section of the file.
** All messages are handled here...
**
*/


#define CLICKMAX                 50       /* second max */
#define REPEAT_PAUSE             800
#define T_DOS                    1
#define T_DV                     2
#define T_WINDOWS                3

int ms_reset(int *mousetype);
int ms_show_cursor(void);
int ms_hide_cursor(void);
int ms_get_mouse_pos(int *horizpos, int *vertpos);

static unsigned long rtimer = -1;
static unsigned long ltimer = -1;
static int   mtask  = T_DOS;

#include <dos.h>

void pause(void)
{
    switch (mtask)
    {
        case T_DOS:
            dospause();
            break;

        case T_DV:
            dvpause();
            break;

        case T_WINDOWS:
            winpause();
            break;
        default:
            break;
    }
}

static unsigned long hsec_time(void)
{
    static unsigned long old_id = 0;
    unsigned long i;
#ifdef __TURBOC__
    struct time t;

    gettime(&t);

    i = (t.ti_sec*100L) + t.ti_hund;
#else
    struct _dostime_t dtime;

    _dos_gettime(&dtime);
    i = (dtime.second*100L) + dtime.hsecond;
#endif

    return (old_id = i);
}


/* we should give up some ticks here... typically when polling this routine */
/* it is quite possible to loop through this in less than a millisecond...  */
/* Obviuosly this resolution is not needed :-)                              */

int collect_events(void)
{
    static int oy    = 0, ox  = 0;
    int        moved = 0;
    int        evt   = 0;
    int        ret;

    if (mouse_avail)
    {
        ret = ms_get_mouse_pos(&mousex, &mousey);

        if (mousex != ox || mousey != oy)
        {
            ox      = mstatus.x = mousex;
            oy      = mstatus.y = mousey;
            moved   = 1;
        }
        if (mstatus.lrelease && (ret & 1))
        {
            evt = 1;
            mstatus.lbutton  = 1;
            mstatus.lrelease = 0;
            ltimer           = hsec_time() + CLICKMAX;
            TTSendMsg(MOU_LBTDN, ox, oy, WM_MOUSE);
        }

        if (mstatus.lbutton && !(ret & 1))
        {
            evt = 1;
            mstatus.lbutton  = 0;
            mstatus.lrelease = 1;
            TTSendMsg(MOU_LBTUP, ox, oy, WM_MOUSE);
            if (hsec_time() < ltimer)
                TTSendMsg(LMOU_CLCK, ox, oy, WM_MOUSE);
        }

        if (mstatus.rrelease && (ret & 2))
        {
            evt = 1;
            mstatus.rbutton  = 1;
            mstatus.rrelease = 0;
            rtimer           = hsec_time() + CLICKMAX;
            TTSendMsg(MOU_RBTDN, ox, oy, WM_MOUSE);
        }

        if (mstatus.rbutton && !(ret & 2))
        {
            evt = 1;
            mstatus.rbutton  = 0;
            mstatus.rrelease = 1;
            TTSendMsg(MOU_RBTUP, ox, oy, WM_MOUSE);
            if (hsec_time() < rtimer)
                TTSendMsg(RMOU_CLCK, ox, oy, WM_MOUSE);
        }

        if (!evt)
        {
            if (mstatus.lbutton || mstatus.rbutton)
            {
                if (mstatus.lbutton && hsec_time() > ltimer)
                    TTSendMsg(LMOU_RPT, ox, oy, WM_MOUSE);

                if (mstatus.rbutton && hsec_time() > rtimer)
                    TTSendMsg(RMOU_RPT, ox, oy, WM_MOUSE);

                if (moved)
                    TTSendMsg(MOUSE_EVT, ox, oy, WM_MOUSE);
            }
        }

        if (mykbhit())
            TTSendMsg(TTGetKey(), 0, 0, WM_CHAR);
    }
    else
        if (mykbhit())
            TTSendMsg(TTGetKey(), 0, 0, WM_CHAR);

    return 0;
}

int TTGetMsg(EVT *event)
{
    while (ebufin == ebufout)
    {
        pause();
        collect_events();
    }

    event->msg     = EVent[ebufout].msg;
    event->msgtype = EVent[ebufout].msgtype;
    event->x       = EVent[ebufout].x;
    event->y       = EVent[ebufout].y;
    event->id      = 0;
    ebufout        = (ebufout + 1) % EBUFSZ;

    return event->msg;
}

int TTPeekQue(void)
{
    collect_events();
    return (ebufin != ebufout);
}

void TTClearQue(void)
{
    ebufin = ebufout;
}

int TTGetChr(void)
{
    EVT e;

    TTGetMsg(&e);
//    while (e.msgtype != WM_CHAR)
//    {
//        TTGetMsg(&e);
//    }
    return e.msg;
}

void MouseON(void)
{
    if (mouse_avail)
        ms_show_cursor();
}

void MouseOFF(void)
{
    if (mouse_avail)
        ms_hide_cursor();
}

int GetMouInfo(int *x, int *y)
{
    if (mouse_avail)
    {
        ms_get_mouse_pos(&mousex, &mousey);
        *x  = mousex;
        *y  = mousey;
    }
    else
    {
        *x = *y = 0;
    }
    return 0;
}

int TTKopen(void)
{
    return 0;
}

int TTKclose(void)
{
    return 0;
}

int TTclose(void)
{
    if (mouse_avail)
        ms_hide_cursor();

    VIOclose();

    return 0;
}

int dv_running(void)
{
    int ret;

    ret = dvcheck();
    return ret;
}

int TTopen(void)
{
    int m = 0;

    if (dv_running())
    {
        mtask = T_DV;
    }

    VIOopen();
    term.NRow = VIOrows();
    term.NCol = VIOcolumns();
    TTScolor(0x07);

    mouse_avail = 0;
    if (!(term.Abil & NOMOUSE))
    {
        if (ms_reset(&m))
        {
            if (m != 0)
            {
                mouse_avail = 1;
                MouseON();
                ms_get_mouse_pos(&mousex, &mousey);
            }
        }
    }

    return 0;
}

static int mykbhit(void)
{
    int ret;
    
    if (FullBuffer())
    {
        return (0);
    }
    ret = kbdhit();
    return (ret);
}

static int FullBuffer(void)
{
    if (((ebufin + 1) % EBUFSZ) != ebufout)
    {
        return (0);
    }
    else
    {
        return (1);
    }
}


#if  DEBUG

int main(void)
{
    char line[255];
    MOU  test;
    int  ret;
    char text[40];
    int  done = 0, x, y;
    long event = 0, rclick = 0, lclick = 0, repeat = 0;

    TTopen();
    while (!done)
    {
        ret = TTGetMsg(&x, &y);
        sprintf(line, "Event: %ld", event++);
        TTStrWr(line, 3, 0);
        switch (ret) {
            case RMOU_CLCK:
            case LMOU_CLCK:
            case RMOU_RPT:
            case LMOU_RPT:
            case MOUSE_EVT:
            case MOU_LBTUP:
            case MOU_LBTDN:
            case MOU_RBTUP:
            case MOU_RBTDN:
                sprintf(text, "Mouse pos x : %02d  y : %02d", x, y);
                TTStrWr(text, 0, 0);
                switch (ret)
                {
                    case RMOU_CLCK:
                        sprintf(text, "Right Button clicked %ld", rclick++);
                        TTStrWr(text, 2, 40);
                        done = 1;
                        break;
                    case LMOU_CLCK:
                        sprintf(text, "Left Button clicked %ld", lclick++);
                        TTStrWr(text, 1, 40);
                        break;
                    case LMOU_RPT:
                    case RMOU_RPT:
                        sprintf(text, "Repeating %ld" , repeat++);
                        TTStrWr(text, 4, 0);
                        break;
                    case MOU_LBTDN:
                        TTStrWr("Left Button Pressed ", 1, 0);
                        break;
                    case MOU_LBTUP:
                        TTStrWr("Left Button Released", 1, 0);
                        break;
                    case MOU_RBTDN:
                        TTStrWr("Right Button Pressed  ", 2, 0);
                        break;
                    case MOU_RBTUP:
                        TTStrWr("Right Button Released", 2, 0);
                        break;
                }
                break;

            default :
                sprintf(text, "Key Pressed : %0.04d", ret);
                TTStrWr(text, 5, 0);
                if (ret == 27 || (x == 79 && y == 24))
                    done = 1;
                break;
        }
    }
    TTclose();
    return (0);
}

#endif
#endif /* #if MSDOS */
