/* main.h
**
** released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
** Contains global variables for use by system.
** Most common prototypes are also here.
**
*/

#include "winsys.h"
#include "menu.h"

#define CM_NTXT     0
#define CM_QTXT     1
#define CM_KTXT     2
#define CM_TTXT     3
#define CM_ITXT     4
#define CM_DTXT     5
#define CM_FTXT     6
#define CM_HTXT     7
#define CM_BTXT     8
#define CM_ETXT     9
#define CM_WTXT     10
#define CM_NINF     11           /* net information */

#define MN_BTXT     12           /* menu border text */
#define MN_NTXT     13           /* menu normal text */
#define MN_STXT     14           /* menu selected text */

#define HP_BTXT     15           /* help window border text */
#define HP_TTXT     16           /* help window title text */
#define HP_NTXT     17           /* help normal text */
#define HP_HTXT     18           /* help highlighted text */

#define IN_BTXT     19
#define IN_NTXT     20

#define IP_BTXT     21
#define IP_NTXT     22
#define IP_ETXT     23

#define DL_BTXT     24           /* border */
#define DL_WTXT     25           /* window */
#define DL_CNRM     26           /* checkbox normal */
#define DL_CSEL     27           /* checkbox selected */
#define DL_ENRM     28           /* entry normal */
#define DL_ESEL     29           /* entry selected */
#define DL_BSEL     30           /* button selected */
#define DL_BNRM     31           /* button normal */
#define DL_BSHD     32           /* button shadow */

#define LS_BTXT     33           /* border */
#define LS_TTXT     34           /* title */
#define LS_NTXT     35           /* normal text */
#define LS_ITXT     36           /* info text */
#define LS_STXT     37           /* seletected text */

#define ID_MGRGT   100
#define ID_MGLFT   101
#define ID_SCRUP   102
#define ID_SCRDN   103
#define ID_QUIT    104
#define ID_EDIT    105
#define ID_SCAN    106
#define ID_AREA    107
#define ID_SETUP   108
#define ID_LNUP    109
#define ID_LNDN    110
#define ID_LIST    111           /* list */
#define ID_PARE    112           /* prev area */
#define ID_NARE    113           /* next area */

#define MNU_LEN    34

#ifdef INCL_MAIN

int cm[] = {                /* color table */

/* Main window colors */

    CYAN   | _BLACK,        /* normal text */
    LGREY  | _BLACK,        /* quoted text */
    GREEN  | _BLACK,        /* kludge lines */
    CYAN   | _BLACK,        /* template lines */
    CYAN   | _BLUE,         /* info line (top) */
    CYAN   | _BLACK,        /* divider line & text (header/msg) */
    GREEN  | _BLACK,        /* information header text (info) */
    CYAN   | _BLACK,        /* header text */
    LCYAN  | _BLUE,         /* block text */
    CYAN   | _BLUE,         /* Edited Feilds */
    RED    | _BLUE,         /* warning! */
    YELLOW | _BLACK,        /* net information */

/* Menu colors */

    LCYAN | _BLUE,          /* border */
    CYAN  | _BLUE,          /* normal text */
    WHITE | _BLACK,         /* selected text */

/* Help colors */

    BLACK  | _LGREY,        /* border */
    YELLOW | _LGREY,        /* window title text */
    BLACK  | _LGREY,        /* normal text */
    CYAN   | _LGREY,        /* highlighted text */

/* Info colors */

    BLACK | _GREEN,         /* border */
    BLACK | _GREEN,         /* normal text */

/* Input colors */

    BLACK | _LGREY,         /* border */
    BLACK | _LGREY,         /* normal */
    BLACK | _CYAN,          /* edit fields */

/* Dialog colors */

    BLACK | _LGREY,             /* border */
    BLACK | _LGREY,             /* window */
    BLACK | _LGREY,             /* checkbox normal */
    BLACK | _LGREY,             /* checkbox selected */
    BLACK | _CYAN,              /* entry normal */
    BLACK | _CYAN,              /* entry selected */
    WHITE | _CYAN,              /* button selected */
    BLACK | _CYAN,              /* button normal */
    BLACK | _LGREY,             /* button shadow */

/* list colors */

    RED    | _BLACK,
    YELLOW | _BLACK,
    CYAN   | _BLACK,
    GREEN  | _BLACK,
    CYAN   | _BLUE
};

WND *hMnScr;              /* handle to main screen window */

#else

extern int  cm[];
extern WND *hMnScr;              /* handle to main screen window */
extern MC   MouseMnu;

#endif


void  AreaScan(void);

/* functions from init.c */

int   InitVars(void);
void  DeinitMem(void);

/* end */
