/* textfile.c

released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
Changes released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis

Handles import and export of textfiles

*/

#include "msged.h"
#include "date.h"
#include "main.h"
#include "menu.h"
#include "keys.h"
#include "dialogs.h"
#include "nshow.h"

#if 0
#ifdef __EMX__
#include <sys/types.h>
#endif
#endif

#ifdef __MSC__
#   include <sys/types.h>
#endif
#if 0
#include <sys\stat.h>
#endif

#define TEXTLEN 2048

LINE *  makequote(LINE *, char *);
int     wrap(LINE *cl, int x, int y, int rm);
FILE *  repapp(char *path);

void  import(LINE *l)
{
    static char  fn[PATHLEN + 1] = "";
    char         line[TEXTLEN + 1];
    FILE        *fp;
    LINE        *n;
    int          ret;

    ret = GetString(" Import File ", "Name of file to import?", fn, PATHLEN);

    TTCurSet(1);

    if (!ret)
        return;

    if ((fp = fopen(fn, "r")) != NULL)
    {
        while (fgets(line, TEXTLEN, fp) != NULL)
        {
            if (l->text != NULL)
            {
                if ((n = (LINE *) calloc(1, sizeof(LINE))) == NULL)
                {
                    return;
                }
                n->prev = l;
                n->next = l->next;

                if (n->next != NULL)
                    n->next->prev = n;

                l->next = n;
                l       = n;
            }
            else
                n = l;

            n->text = strdup(line);
            if (strlen(n->text) > (size_t) SW->rm)
            {
                l = n->next;
                wrap(n, 1, maxy, SW->rm);

                if (!l)
                {
                    while (n->next)
                        n = n->next;
                }
                else
                    n = l->prev;

                l = n;
            }
        }
        fclose(fp);
        return;
    }
    return;
}

void  export(LINE *f)
{
    FILE  *fp;
    char   fn[PATHLEN + 1];
    int    ret;

    if (ST->outfile)
        strcpy(fn, ST->outfile);
    else
        strcpy(fn, "");

    ret = GetString(" Export File ", "Name of file to export?", fn, PATHLEN);

    if (!ret)
        return;

    release(ST->outfile);
    ST->outfile = strdup(fn);

    if (*fn == '+')
        fp = fopen(fn+1,"a");
    else
        fp = fopen(fn,"w");

    if (fp != NULL)
    {
        fputc('\n', fp);
        for (; f != NULL; f = f->next)
        {
            if (f->text && (*(f->text) != '\01' || SW->shownotes))
            {
                fputs(f->text, fp);
                if (strchr(f->text, '\n') == NULL)
                    fputc('\n', fp);
            }
        }
        fclose(fp);
    }
    TTCurSet(1);
}

void  writetxt()
{
    static char *modes[] = {"Text", "Quote", "Msged", NULL};
    static char *ovr[]   = {"Append", "Replace", NULL};
    char         cr[]    = "\n";
    LINE        *f       = message->text;
    char         fn[PATHLEN];
    static int   mode = 0;
    int          ret;
    FILE        *fp;
    char        *s;

    if (ST->outfile)
        strcpy(fn, ST->outfile);
    else
        strcpy(fn, "");

    ret = GetString(" Export File ", "Name of file to export?", fn, PATHLEN);

    if (!ret)
        return;

    release(ST->outfile);
    ST->outfile = strdup(fn);

    if ((s = strchr(fn, ',')) != NULL)
        *s++ = '\0';

    if (s && *s == 't')
        mode = 0;
    else if (s && *s == 'q')
        mode = 1;
    else if ((s && (*s == 'm')) || !s)
        mode = 2;

    if (*fn == '?')
    {
        mode = DoMenu(61, 2, 69, 4, modes, mode);
        if (mode == -1)
        {
            mode = 0;
            return;
        }
    }

    if (*fn == '+')
        fp = fopen(fn+1,"a");
    else if (*fn == '?')
    {
        if ((fp = fopen(fn+1,"r")) == NULL)
            fp = fopen(fn+1,"w");
        else if (isatty(fileno(fp)))
        {
            fclose(fp);
            fp   = fopen(fn+1,"w");
            mode = 0;
        }
        else
        {
            ret = DoMenu(61, 2, 69, 3, ovr, 0);
            if (ret == -1)
                return;

            fclose(fp);

            if (ret)
                fp = fopen(fn+1,"w");
            else
                fp = fopen(fn+1,"a");
        }
    }
    else
        fp = fopen(fn,"w");

    if (fp == NULL)
        return;

    if (mode == 0)
    {
        fprintf(fp, "%sDate:   %s", cr, atime(message->timestamp));
        fprintf(fp, "%sFrom:   %s", cr, (message->isfrom) ? message->isfrom : "");

        if (CurArea.netmail) fprintf(fp," of %s", show_address(&message->from));

        fprintf(fp, "%sTo:     %s", cr, (message->isto) ? message->isto : "");

        if (CurArea.netmail) fprintf(fp," of %s", show_address(&message->to));

        fprintf(fp, "%sSubj:   %s", cr, (message->subj) ? message->subj : "");

        MakeMsgAttrs(fn, &message->attrib, message->scanned);

        fprintf(fp, "%sAttr:   %s", cr, fn);
        fprintf(fp, "%s%-30s -------------------------------", cr, CurArea.description);
        fprintf(fp, "%s%s", cr, cr);
    }
    else if (mode == 1)
    {
        f = makequote(message->text, message->isfrom);
        f = message->text;
    }

    for (; f != NULL; f = f->next)
    {
        if (f->text && (*(f->text) != '\01' || SW->shownotes))
        {
            fputs(f->text, fp);
            if (!strchr(f->text, '\n') && (!mode || mode == 1))
                fprintf(fp, "%s", cr);
        }
    }
    fclose(fp);
}

FILE *  repapp(char *path)
{
    char  *choices[] = {"Replace", "Append", NULL};
    FILE *fp;
    int   ch;

    if ((fp = fopen(path,"r")) == NULL)
        return(fp = fopen(path,"w"));

    if (isatty(fileno(fp)))
    {
        fclose(fp);
        return(fp = fopen(path,"w"));
    }

    ch = DoMenu(61, 2, 69, 4, choices, 0);

    if (ch == 0)
        fp = fopen(path,"a");
    else
        fp = fopen(path,"w");

    return fp;
}

/* end */
