/*
**  By: Jim Nutt
*/

#ifndef VIO_H
#define VIO_H

#if (defined(__WATCOMC__) && defined(MSDOS))
#define VIOPREF cdecl
#else
#define VIOPREF
#endif

/* initialization and termination functions */

int   VIOPREF VIOopen(void);
void  VIOPREF VIOclose(void);

/* scrolling functions */

void  VIOPREF VIOscrollright(int x1, int y1, int x2, int y2, int count);
void  VIOPREF VIOscrollleft(int x1, int y1, int x2, int y2, int count);
void  VIOPREF VIOscrollup(int x1, int y1, int x2, int y2, int count);
void  VIOPREF VIOscrolldown(int x1, int y1, int x2, int y2, int count);

/* screen clear */

void  VIOPREF VIOclear(int x1, int y1, int x2, int y2);

/* write to screen */

void  VIOPREF VIOputc(const char c);
void  VIOPREF VIOputs(const char far * s);
void  VIOPREF VIOputr(int x, int y, int w, int h, unsigned short far * b);

/* read from screen */

int   VIOPREF VIOgetca(const int x, const int y);
void  VIOPREF VIOgetra(int x1, int y1, int x2, int y2, unsigned short far * b);

/* set colors */

void  VIOPREF VIOsetfore(const int c);
void  VIOPREF VIOsetback(const int c);

/* get current color settings */

int   VIOPREF VIOgetfore(void);
int   VIOPREF VIOgetback(void);

/* set the write cursor */

void  VIOPREF VIOgotoxy(int x, int y);

/* update the screen and visible cursor */

void  VIOPREF VIOupdate(void);

/* get the current write cursor position */

int   VIOPREF VIOwherex(void);
int   VIOPREF VIOwherey(void);

/* get screen information */

unsigned int   VIOPREF VIOsegment(void);

int   VIOPREF VIOcolumns(void);
int   VIOPREF VIOrows(void);
int   VIOPREF VIOmode(void);
int   VIOPREF VIOheight(void);

/* set segment information */

void  VIOPREF VIOsetSegment(unsigned int s);
void  VIOPREF VIOsetRows(int r);
void  VIOPREF VIOsetCols(int c);

/* get BIOS cursor location */

void  VIOPREF VIOcursor(int  * x, int  * y, int  * shape);


#endif
