/* maintmsg.c
**
** released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
** Changes released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
** Handles message maintenance.
*/

#define TEXTLEN 256

#include "msged.h"
#include "date.h"
#include "main.h"
#include "keys.h"
#include "menu.h"
#include "makemsgn.h"
#include "template.h"

extern int direction;
extern int msgederr;

static char *formenu[] = {"Move Message",
                          "Copy Message",
                          "Redirect Message",
                          "Forward Message",
                           NULL};


/*
**
** Deletes the current message
**
*/
                           
void  deletemsg(void)
{
    unsigned long   n    = CurArea.current;
    msg    *from = NULL;
    msg    *to   = NULL;
    int     i;

    if (message == NULL)
    {
        if ((message = readmsg(CurArea.current)) == NULL)
            return;
    }

    if (!confirm())
        return;                                 /* patch up reply links */

    for (i = 0; i < 10; i++)
    {
        if (message->replies[i] != 0)
        {
            from = MsgReadHeader(message->replies[i], RD_HEADER);
            if (from)
            {
                from->replyto = 0;
                MsgWriteHeader(from, WR_HEADER);
                dispose(from);
            }
        }
    }
    to = MsgReadHeader(message->replyto, RD_HEADER);
    if (to)
    {
        for (i = 0; i < 10; i++)
        {
            if (to->replies[i] == n)
            {
                to->replies[i] = 0;
            }
        }
        MsgWriteHeader(to, WR_HEADER);
        dispose(to);
    }

    MsgDelete(message->msgnum);      /* we re-scan the area to be safe */
    MsgAreaClose();
    message          = KillMsg(message);
    CurArea.messages = MsgAreaOpen(&CurArea);
    CurArea.current  = min(max(1, n), CurArea.messages);
}


/*
**
** Forwards the current message
**
*/

void  forward_msg(void)
{
    msg    *m       = NULL;
    msg    *oldm    = NULL;
    int     fr_area = SW->area;
    time_t  now     = time(NULL);
    int     to_area;

    to_area = selectarea();

    if (msgederr)
        return;

    /*
    ** Save the current message and make the global pointer equal
    ** to null (forcing a re-read).
    */

    oldm    = duplicatemsg(message);
    m       = message;
    message = NULL;

    set_area(to_area);

    if (!CurArea.status)
    {
        dispose(oldm);
        dispose(m);
        set_area(fr_area);
        return;
    }

    if ((m->reply && (fr_area != to_area)) || CurArea.netmail)
        release(m->reply);

    release(m->msgid);
    release(m->isfrom);
    release(m->isto);
    release(m->from.domain);
    release(m->to.domain);

    m->from = CurArea.addr;

    if (CurArea.addr.domain)
        m->from.domain = strdup(CurArea.addr.domain);

    clear_attributes(&m->attrib);
    memset(&m->replies, 0, sizeof(m->replies));

    CurArea.new     = 1;
    m->isfrom       = strdup(ST->username);
    m->new          = 1;
//    m->movecopy     = 1;
    m->msgnum       = MsgnToUid(CurArea.messages) + 1;
    m->attrib.local = 1;
    m->attrib.sent  = 0;
    m->timestamp    = now;
    m->scanned      = 0;
    m->replyto      = 0;
    m->attrib.private = CurArea.priv;

    if ((EditHeader(m) == Key_Esc) && confirm())
        set_area(fr_area);
    else
    {
        MakeTemplateMsg(m, oldm, fr_area, MT_FOR);
        save(m);
        set_area(fr_area);
    }
    dispose(oldm);
    dispose(m);
}


/*
**
** Redirects the current message
**
*/

void  redirect_msg(void)
{
    msg    *m       = NULL;
    msg    *oldm    = NULL;
    int     fr_area = SW->area;
    int     to_area;

    to_area = selectarea();

    if (msgederr)
        return;

    oldm    = duplicatemsg(message);
    m       = message;
    message = NULL;
    set_area(to_area);

    if (!CurArea.status)
    {
        dispose(oldm);
        dispose(m);
        set_area(fr_area);
        return;
    }

    memset(&m->replies, 0, sizeof(m->replies));

    if ((m->reply && (fr_area != to_area)) || CurArea.netmail)
        release(m->reply);

    release(m->msgid);
    release(m->isto);
    clear_attributes(&m->attrib);

    CurArea.new     = 1;
    m->new          = 1;
    m->movecopy     = 1;
    m->attrib.local = 1;
    m->attrib.sent  = 0;
    m->msgnum       = MsgnToUid(CurArea.messages) + 1;
    m->scanned      = 0;
    m->replyto      = 0;
    m->attrib.private = CurArea.priv;

    if ((EditHeader(m) == Key_Esc) && confirm())
        set_area(fr_area);
    else
    {
        MakeTemplateMsg(m, oldm, fr_area, MT_RED);
        save(m);
        set_area(fr_area);
    }
    dispose(oldm);
    dispose(m);
}


/*
**
** Copies the current message
**
*/

void  copy_msg(void)
{
    msg    *m       = NULL;
    int     fr_area = SW->area;
    int     to_area;

    to_area = selectarea();

    if (msgederr)
        return;

    m       = message;
    message = NULL;

    set_area(to_area);
    if (!CurArea.status)
    {
        dispose(m);
        set_area(fr_area);
        return;
    }

    clear_attributes(&m->attrib);
    CurArea.new     = 1;
    release(m->from.domain);
    m->from = CurArea.addr;
    if (CurArea.addr.domain)
	    m->from.domain = strdup(CurArea.addr.domain);
    m->msgnum       = MsgnToUid(CurArea.messages) + 1;
    m->new          = 1;
    m->movecopy     = 1;
    m->attrib.sent  = 0;
    m->attrib.local = 1;
    m->scanned      = 0;
    m->attrib.private = CurArea.priv;

    memset(&m->replies,0,sizeof(m->replies));
    m->replyto = 0; 

    writemsg(m);
    set_area(fr_area);
    dispose(m);
}


/*
**
** Moves the current message
**
*/

void  move_msg(void)
{
    msg    *m       = NULL;
    int     fr_area = SW->area;
    int     t       = SW->confirmations;
    int     to_area;
	int     status;

    to_area = selectarea();

    if (msgederr)
        return;

    m                 = message;     /* save the msg so we can write it */
    message           = NULL;

    set_area(to_area);
    if (!CurArea.status)
    {
        set_area(fr_area);
        dispose(m);
        return;
    }

    clear_attributes(&m->attrib);
    CurArea.new     = 1;
    release(m->from.domain);
    m->from = CurArea.addr;
    if (CurArea.addr.domain)
	    m->from.domain = strdup(CurArea.addr.domain);
    m->msgnum       = MsgnToUid(CurArea.messages) + 1;
    m->new          = 1;
    m->movecopy     = 1;
    m->attrib.sent  = 0;
    m->attrib.local = 1;
    m->scanned      = 0;
    m->attrib.private = CurArea.priv;

    memset(&m->replies,0,sizeof(m->replies));
    m->replyto = 0; 

    status = writemsg(m);
    dispose(m);
    set_area(fr_area);
	
	if (status == TRUE)
    {
        SW->confirmations = 0;           /* delete msg unconditionally */
        deletemsg();
        SW->confirmations = t;
    }
}


/*
**
** Allows forwarding, redirecting, moving and copying of msgs.
**
**
*/

void  movemsg(void)
{
    int     ch;

    ch = DoMenu((maxx/2)-8, (maxy/2)-1, (maxx/2)+8, (maxy/2)+2, formenu, 0);

    switch (ch)
    {
        case 0:                                      /* Move */
            move_msg();
            return;

        case 1:                                      /* Copy */
            copy_msg();
            return;

        case 2:    /* Redirect */
            redirect_msg();
            return;

        case 3:                                      /* Forward */
            forward_msg();
            return;

        case -1:                                     /* Escape */
            return;

    }
}

/* end of file */
