/* nshow.c
**
** released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
** Routines for displaying message information on
** the screen.  This includes both text and header
** information.
*/

#include "msged.h"
#include "date.h"
#include "main.h"
#include "menu.h"
#include "keys.h"
#include "nshow.h"
#include "dialogs.h"

static LINE *top    = NULL;          /* top of screen */
static LINE *bottom = NULL;          /* bottom of screen */

static char  line[256];              /* used as temporary storage */
static WND  *hMsgWnd, *hMsgCurr;     /* main window and Msg window */
HotGroup     Hot;

char *v7lookupsystem(ADDRESS *faddr, char *system);

/*/$/ int InitScreen(void);
**
** Initializes the (basic) screen.
**
** returns -1 on failure (terminate).
*/

int InitScreen(void)
{
    if (SW->usemouse == NO)
        term.Abil |= NOMOUSE;

    TTopen();

    maxx = term.NCol;
    maxy = term.NRow;

    if ((hMnScr = WndOpen(0, 0, maxx-1, maxy-1, NBDR, 0, cm[CM_NTXT])) == NULL)
        return 0;

    SW->redraw = TRUE;

    return 0;
}


/*
** Adds an item to a HotGroup.
*/

void AddHG(HotGroup *h, int num, int id, int x1, int y1, int x2, int y2)
{
    h->harr[num].id = id;
    h->harr[num].x1 = x1;
    h->harr[num].y1 = y1;
    h->harr[num].x2 = x2;
    h->harr[num].y2 = y2;
}


/*/$/ void BuildHotSpots(void);
**
** Builds the Hot spots on the main window and
** initializes the menu system.  We cannot use
** a hotspot for the menu system;  We wish to
** send the messages un-altered to the menu
** processing function.
*/

void BuildHotSpots(void)
{
    Hot.wid = hMnScr->wid;
    Hot.num = 6;

    AddHG(&Hot, 0, ID_MGRGT, maxx - 2, 6,         maxx - 1, maxy - 1);
    AddHG(&Hot, 1, ID_MGLFT, 0,        6,         1,        maxy - 1);
    AddHG(&Hot, 2, ID_SCRUP, 0,        6,         maxx - 1, 7);
    AddHG(&Hot, 3, ID_SCRDN, 0,        maxy - 2,  maxx - 1, maxy - 1);
    AddHG(&Hot, 4, ID_LNDN,  65,       2,               69, 2);
    AddHG(&Hot, 5, ID_LNUP,  70,       2,               75, 2);

    /* Push the group onto the HotHroup stack */

    PushHotGroup(&Hot);

    /* Setup the mouse menu on top of the screen  */
    /* It'll use the parent window for displaying */
    /* the menu, and we send any messages in that */
    /* vicinity for processing by it              */

    MouseMnu.cmdtab[0].col = 0 +  maxx - MNU_LEN - 1;
    MouseMnu.cmdtab[1].col = 7 +  maxx - MNU_LEN - 1;
    MouseMnu.cmdtab[2].col = 14 + maxx - MNU_LEN - 1;
    MouseMnu.cmdtab[3].col = 21 + maxx - MNU_LEN - 1;
    MouseMnu.cmdtab[4].col = 28 + maxx - MNU_LEN - 1;
    MnuSetColours(cm[MN_BTXT], cm[MN_NTXT], cm[MN_STXT]);

    /*
    ** Set up the dialog box colours.
    */

    SetDialogColors();
}

/*/$/ void KillHotSpots(void);
**
** Kills the HotSpots on the stack.
*/

void KillHotSpots(void)
{
    PopHotGroup();
}


/*/$/ void DrawHeader(void);
**
** Draws the msg header on the screen.  This should
** only have to be drawn once during normal operation.
*/

void DrawHeader(void)
{
    EVT e;

    WClear(0, 0, maxx - 1, 0, cm[CM_ITXT]);

    WWriteStr(0, 1, cm[CM_FTXT], "From:");        /* header info */
    WWriteStr(0, 2, cm[CM_FTXT], "To:");
    WWriteStr(0, 3, cm[CM_FTXT], "Subj:");
    WWriteStr(0, 4, cm[CM_FTXT], "Attr:");

    memset(line, '', maxx + 1);                  /* clear dividing line */
    WPutsn(0, 5, maxx, cm[CM_DTXT], line);
                                                  /* mouse menu */
    ProcessMenu(&MouseMnu, &e, 1);
}


/*/$/ void ClearScreen(void);
**
** Clears the screen (only used with the list function to
** make it look bwtter when it returns).
**
*/

void ClearScreen(void)
{
    WClear(0, 0,  maxx - 1, maxy - 1, cm[CM_FTXT]);
}


/*/$/ void ClearMsgScreen(void);
**
** Clears message information (header and text)
** from the screen.
**
*/

void ClearMsgScreen(void)
{
    WClear(7, 1,  maxx - 1, 4, cm[CM_FTXT]);       /* clear header info */
    RefreshMsg(NULL, 6);
}


/*/$/ void ShowNewArea(void);
**
** Shows a new area on the screen.
**
*/

void ShowNewArea(void)
{
    memset(line, '', maxx + 1);                  /* clear dividing line */
    WPutsn(0, 5, maxx, cm[CM_DTXT], line);
    WWriteStr(1, 5, cm[CM_NINF], CurArea.description);
    if (SW->showaddr)
    {                                  /* then show the current address */
        sprintf(line, "%s", show_address(&CurArea.addr));
        WWriteStr(strlen(CurArea.description) + 2, 5, cm[CM_NINF], line);
    }
}


int OpenMsgWnd(int wid, int dep, char *title, char *msg, int x, int y)
{
    hMsgCurr = Wtop();
    hMsgWnd  = WPopUp(wid, dep, INSBDR|SHADOW, cm[IP_BTXT], cm[IP_NTXT]);

    if (!hMsgWnd)
        return 0;

    if (title)
    {
        WTitle(title, cm[IP_BTXT]);
    }

    if (msg)
    {
        WWriteStr(x, y, cm[IP_NTXT], msg);
    }
    return 1;
}

void SendMsgWnd(char *msg, int y)
{
    WND *hCurr;

    hCurr = Wtop();

    if (!hCurr) return;

    WClearLine(y, cm[IP_NTXT]);
    WPutsCen(y, cm[IP_NTXT], msg);
}

int CloseMsgWnd(void)
{
    WClose(hMsgWnd);
    WCurr(hMsgCurr);
    return (0);
}



/*/$/ void MakeMsgAttrs(char *buf, struct _attributes *att);
**
** Builds a text version of the attributes set
** in an _attribute structure.
**
*/

void MakeMsgAttrs(char *buf, struct _attributes *att, int scanned)
{
    char nul[] = "";

    sprintf(buf, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
                      (att->private)  ? "priv "   : nul,
                      (att->crash)    ? "crash "  : nul,
                      (att->recvd)    ? "recvd "  : nul,
                      (att->sent)     ? "sent "   : nul,
                      (att->attached) ? "f/a "    : nul,
                      (att->killsent) ? "k/s "    : nul,
                      (att->freq)     ? "freq "   : nul,
                      (att->ureq)     ? "ureq "   : nul,
                      (att->hold)     ? "hold "   : nul,
                      (att->orphan)   ? "orph "   : nul,
                      (att->forward)  ? "trans "  : nul,
                      (att->local)    ? "local "  : nul,
                      (att->direct)   ? "dir "    : nul,
                      (att->rreq)     ? "rreq "   : nul,
                      (att->rcpt)     ? "rcpt "   : nul,
                      (att->areq)     ? "areq "   : nul,
                      (scanned)       ? "scanned ": nul);
}

void ShowAddress(ADDRESS *addr, int y)
{
    sprintf(line, "  %s", show_address(addr));
    WPutsn(32, y, 26, cm[CM_HTXT], line);
    return;
}

void ShowNameAddress(char *name, ADDRESS *addr, int y, int newrcvd, int nm_only)
{
	char tmp[256];
	
    if (addr->fidonet || (addr->notfound && !(CurArea.uucp || CurArea.news)))
    {
        /*
        ** Show fidonet-type names.
        */

        if (nm_only)
        {
            if (name)
                sprintf(line, "%s,", name);
            else
                strcpy(line, ", ");
        }
        else
        {
            if (CurArea.netmail || (CurArea.echomail && y == 1))
            {
                if (name)
                    sprintf(line, "%s, %s", name, show_address(addr));
                else
                    sprintf(line, ", %s", show_address(addr));
					
				if (SW->showsystem && v7lookupsystem(addr, tmp))
				{
					strcat(line, ", ");
					strcat(line, tmp);
				}
            }
            else
            {
                if (name)
                    sprintf(line, "%s", name);
                else
                    strcpy(line, " ");
            }
        }
        if (newrcvd)
            WPutsn(7,  y, 52, cm[CM_BTXT], line);
        else
            WPutsn(7,  y, 52, cm[CM_HTXT], line);
    }
    else
    {
        /*
        ** Show internet-type names.
        */

        if (name == NULL)
        {
            sprintf(line, "%s", show_address(addr));
            WPutsn(7, y, 53, cm[CM_HTXT], line);
        }
        else
        {
            sprintf(line, "%s (%s)", show_address(addr), name);
            if (newrcvd)
                WPutsn(7, y, 53, cm[CM_BTXT], line);
            else
                WPutsn(7, y, 54, cm[CM_HTXT], line);
        }
    }
}

void ShowSubject(char *subj)
{
    WPutsn(7, 3, 72, cm[CM_HTXT], subj);
}

void ShowAttrib(msg *m)
{
    MakeMsgAttrs(line, &m->attrib, m->scanned);
    if (SW->datearrived)
        WPutsn(7, 4, 52, cm[CM_HTXT], line);
    else
        WPutsn(7, 4, 72, cm[CM_HTXT], line);
}


/*/$/ void ShowMsgHeader(msg *m);
**
** Puts the message header onto the screen.
**
*/

void ShowMsgHeader(msg *m)
{
    int  i, r = 0;
    unsigned long rep = 0;

    if (!m)
    {
        strcpy(line, "0 of 0          ");
    }
    else
    {
        sprintf(line, 
                "%ld of %ld          ", 
                CurArea.current, 
                CurArea.messages);
    }

    line[16] = '\0';
    
    WPutsn(0, 0, 16, cm[CM_ITXT], line);

#if defined(MSDOS)
    sprintf(line, " %ld ", corerem());
    WWriteStr(67, 5, cm[CM_DTXT], line);
#endif

    if (m == NULL)
        return;

    /*
    ** Show the date of creation and the date of arrival.
    */

    WPrintf(60, 1, cm[CM_HTXT], "%s", mtime(m->timestamp));

    if (SW->datearrived && m->time_arvd != 0 && m->time_arvd != m->timestamp)
        WPrintf(60, 4, cm[CM_HTXT], "%s", mtime(m->time_arvd));
    else
        WPutsn(60, 4, 19, cm[CM_HTXT], " ");

    /*
    ** Show the message links, up and down.
    */

    if (m->replyto)
    {
        sprintf(line, "%6ld\x11", m->replyto);
    }
    else
    {
        strcpy(line, "       ");
    }
    line[7] = '\0';
    WPrintf(63, 2, cm[CM_FTXT], line);

    for (i = 0; i < 10; i++)
    {
        if (m->replies[i] != 0)
        {
            if (!rep)
            {
                rep = m->replies[i];
            }
            r++;
        }
    }

    if (rep && (r == 1))
    {
        sprintf(line, "\x10%ld      ", rep);
    }
    else if (rep && (r > 1))
    {
        sprintf(line, "\x10\x10%ld     ", rep);
    }
    else
    {
        strcpy(line,  "        ");
    }
    line[8] = '\0';
    WWriteStr(70, 2, cm[CM_FTXT], line);

    /*
    ** Display the rest of the header information.
    */

    ShowNameAddress(m->isfrom, &m->from, 1, 0, 0);
    ShowNameAddress(m->isto,   &m->to,   2, m->newrcvd, 0);
    ShowSubject(m->subj);
    ShowAttrib(m);
}

void PutLine(LINE *l, int y)
{
    int   Attr = (l->block) ? cm[CM_BTXT] : (l->quote) ? cm[CM_QTXT] : (l->hide) ? cm[CM_KTXT] : (l->templt) ? cm[CM_TTXT] : cm[CM_NTXT];
    char *s;

/* debug mode, so we can see the details.. */

    strcpy(line, l->text);

    if ((s = strchr(line, '\n')) != NULL)
    {
        if (SW->showcr)
            *s = '';
        else
            *s = '\0';
    }

    if (SW->showeol && SW->showcr)
        strcat(line, "");

    WPutsn(0, y, maxx, Attr, line);
}

void MsgScroll(int Dir)
{
    WScroll(0, 6, maxx-1, maxy - 1, Dir);
}

void Go_Up(void)
{
    if (!message)
        return;

    if (top->prev)
    {
        while (top->prev)          /* we want to skip hidden lines */
        {
            top = top->prev;
            if (SW->shownotes || (*(top->text) != '\01'))
            {
                MsgScroll(0);
                PutLine(top, 6);
                break;             /* stop when we atctually write something */
            }
        }
    }
}

void Go_Dwn(void)
{
    int i = 1;

    if (!message)
        return;

    for (bottom = top; i < maxy - 6; bottom = bottom->next)
    {
        if (!bottom->next) break;
        i++;
    }

    if (i == maxy - 6)
    {
        if (bottom->next)
        {
            bottom = bottom->next;
            top    = top->next;
            MsgScroll(1);
            PutLine(bottom, maxy - 1);
        }
    }
}

void Go_PgDwn(void)
{
    int i;

    if (!message)
        return;

    for (i = 0; i < maxy - 6; i++)
    {
        if (!top->next) break;
        top = top->next;
    }
    if (i != 0)
        RefreshMsg(top, 6);
}

void Go_PgUp(void)
{
    int i;

    if (!message)
        return;

    for (i = 0; i < maxy - 6; i++)
    {
        if (!top->prev) break;
        top = top->prev;
    }
    if (i != 0)
        RefreshMsg(top, 6);
}

void RefreshMsg(LINE *line, int y)
{
    LINE *t = line;
    LINE  l = {" ", 0, 0, 0, 0, 0, NULL, NULL};
    int   i = y;

    top = line;

    if (y >= maxy)
        return;

    if (!line)
    {
        WClear(0, y, maxx - 1, maxy - 1, cm[CM_NTXT]);
        return;
    }

    while (t && i <= maxy - 1)
    {
        PutLine(t, i);
        t = t->next; i++;
    }
    if (i <= maxy - 1)
    {
        while (i <= maxy - 1)
        {
            PutLine(&l, i);
            i++;
        }
    }
}

/* end */
