/***********************************************************************\
 *                              Thread.c                               *
 *              Copyright (C) by Stangl Roman, 1994, 1995              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * Thread.c     PC/2's object window working thread.                   *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Thread.c Version 1.90 05,1995 $ (LBL)";

#define         _FILE_  "PC/2 - Thread.c V1.90"

#include        "PC2.h"                 /* User include files */
#include        "Error.h"

typedef struct  _ColorWindow    COLORWINDOW;

struct  _ColorWindow
{
ULONG   ulBackgroundRGB;                /* RGB background color of window drawn on overview window */
ULONG   ulForegroundRGB;                /* RGB foreground color of window text */
};

HPS     hpsClient;                      /* PC/2's client area presentation space */
SWP     swpApplications[128];           /* Window position of all enumerated applications
                                           except Window List, PC/2 and optionally Desktop */
ULONG   ulApplicationsCount;            /* Counter of last filled entry within array
                                           swpApplications */

                                        /* PC/2's working thread */
void _Optlink   PC2_Thread(void *ThreadArg)
{
HAB     habThread;
HMQ     hmqThread;
QMSG    qmsgThread;
HDC     hdcClient;                      /* Client area DC */
SIZEL   sizelClient;

while(TRUE)
{
                                        /* Initialize anchor block and message queue */
    if(WinStartUp(&habThread, &hmqThread)==FALSE)
        {
        USR_ERR(pHP->hwndFrame, HELP_CREATEWINDOW, MB_ERROR|MB_OK|MB_MOVEABLE|MB_DEFBUTTON1,
            "Initializing thread's PM environment failed, PC/2 can't continue. You may have run out "\
            "of resources, close some windows or applications and retry. Exiting...");
                                        /* On error shut down PC/2 */
        pHP->ulStatusFlag|=PC2EMERGENCYEXIT;
        WinPostMsg(pHP->hwndClient, WM_QUIT, NULL, NULL);
        break;
        }
    if(!WinRegisterClass(               /* Register window class */
        habThread,                      /* Handle of anchor block */
        (PSZ)PC2_CLASSNAME_THREAD,      /* Window class name */
        (PFNWP)PC2_ThreadWindowProc,    /* Address of window procedure */
        CS_SIZEREDRAW | CS_SAVEBITS,
        0))                             /* Extra window words */
        {
        PM_ERR(habThread, pHP->hwndFrame, HELP_CREATEWINDOW, MB_ERROR|MB_OK|MB_MOVEABLE|MB_DEFBUTTON1,
            "Initializing thread's PM environment failed, PC/2 can't continue. You may have run out "\
            "of resources, close some windows or applications and retry. Exiting...");
                                        /* On error shut down PC/2 */
        pHP->ulStatusFlag|=PC2EMERGENCYEXIT;
        WinPostMsg(pHP->hwndClient, WM_QUIT, NULL, NULL);
        break;
        }
    pHP->hwndThread=WinCreateWindow(
        HWND_OBJECT,                    /* Parent window */
        PC2_CLASSNAME_THREAD,           /* Window class */
        NULL,                           /* Window text */
        0,                              /* Window style */
                                        /* Windos position & size */
        0, 0, 0, 0,
        HWND_OBJECT,                    /* Owner window */
        HWND_BOTTOM,                    /* Sibling window */
        ID_PC2MAINWINDOW,               /* Window ID */
        NULL,                           /* Control data */
        NULL);                          /* Presentation parameters */
                                        /* Create a standard window */
/*                                                                                      *\
 * Now setup working thread's required data.                                            *
\*                                                                                      */
                                        /* Get presentation space for PC/2's client window */
    sizelClient.cx=pHP->DesktopSize.x;
    sizelClient.cy=pHP->DesktopSize.y;
                                        /* Get device context and a presentation space associated
                                           for client window */
    hdcClient=WinOpenWindowDC(pHP->hwndClient);
    hpsClient=GpiCreatePS(pHP->habPc2, hdcClient, &sizelClient, PU_PELS|GPIA_ASSOC);
    GpiCreateLogColorTable(hpsClient,   /* Change color table into RGB mode */
        0L,                             /* Options */
        LCOLF_RGB,                      /* Set color table into RGB mode */
        0L, 0L, NULL);                  /* Starting, ending item, table */
                                        /* Post message to query Desktop's/PM window handle */
    WinPostMsg(pHP->hwndThread, WM_SETDESKTOPHANDLE, NULL, NULL);
                                        /* If required expand WPS */
    if(pHP->ulStatusFlag & EXPANDWPS)
        WinPostMsg(pHP->hwndThread, WM_EXPANDWPS, (MPARAM)TRUE, NULL);
                                        /* Load PM background bitmap */
    WinPostMsg(pHP->hwndThread, WM_BACKGROUNDBITMAP, NULL, NULL);
                                        /* Enumerate all windows */
    WinPostMsg(pHP->hwndThread, WM_SETUPSIZEPOSITION, NULL, NULL);
                                        /* Change to all local drives root directory */
    WinPostMsg(pHP->hwndThread, WM_SETDRIVEROOT, NULL, NULL);
                                        /* Post this message as the last one into the message queue,
                                           to inform client window that working thread is ready then */
    WinPostMsg(pHP->hwndThread, WM_THREADSTARTUPREADY, NULL, NULL);
/*                                                                                      *\
 * Here we loop dispatching the messages...                                             *
\*                                                                                      */
    while(WinGetMsg(habThread, &qmsgThread, 0, 0, 0))
                                            /* Dispatch messages to window procedure */
        WinDispatchMsg(habThread, &qmsgThread);
    break;
}
                                        /* Release presentation space */
GpiDestroyPS(hpsClient);
                                        /* Release device context */
DevCloseDC(hdcClient);
                                        /* Close window */
WinDestroyWindow(pHP->hwndThread);
WinDestroyMsgQueue(hmqThread);
WinTerminate(habThread);
_endthread();                           /* Terminate C thread code */
DosExit(EXIT_THREAD, 0UL);              /* Terminate thread */
}

/*--------------------------------------------------------------------------------------*\
 * This procedure is the PC/2 working thread window procedure (is an object window).    *
\*--------------------------------------------------------------------------------------*/
MRESULT EXPENTRY PC2_ThreadWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_PRESPARAMCHANGED:
    if((ULONG)mp1==PP_FONTNAMESIZE)
        {
        FATTRS  *pfatPC2Font;
        USHORT  usMaxBaselineExt;
        SIZEF   sizefFont;

        if(pHP->ulDebug>=DEBUG_FULL)
            printf("Thread: WM_PRESPARAMCHANGEDTHREADSTARTUPREADY\n");
                                        /* Get overview window font */
        pfatPC2Font=(FATTRS *)PVOIDFROMMP(mp2);
                                        /* For outline fonts the baseline is expected 0 */
        usMaxBaselineExt=(USHORT)pfatPC2Font->lMaxBaselineExt;
        if(pfatPC2Font->fsFontUse&FATTR_FONTUSE_OUTLINE)
            pfatPC2Font->lMaxBaselineExt=0;
                                        /* Delete previous logical font */
        GpiDeleteSetId(HPSDRAW, LCID_FONT);
                                        /* Create the logical font and select it */
        GpiCreateLogFont(HPSDRAW, NULL, LCID_FONT, pfatPC2Font);
        GpiSetCharSet(HPSDRAW, LCID_FONT);
        sizefFont.cx=MAKEFIXED(usMaxBaselineExt, 0);
        sizefFont.cy=MAKEFIXED(usMaxBaselineExt, 0);
        GpiSetCharBox(HPSDRAW, &sizefFont);
        free(pfatPC2Font);              /* Free structure allocated by main thread */
                                        /* Repaint overview window */
        WinPostMsg(hwnd, WM_PAINT, NULL, NULL);
        }
    break;

/*                                                                                      *\
 * Syntax: WM_AUTOSTART, NULL, NULL                                                     *
\*                                                                                      */
case WM_AUTOSTART:
/*                                                                                      *\
 * This message is posted during initialization of the working thread to autostart all  *
 * menu items that have the autostart flag.                                             *
 * Ref.:                                                                                *
 *      pPopupMenu                                                                      *
\*                                                                                      */
                                        /* Scan recursively through Popup-Menu and start
                                           all applications that have the autostart flag
                                           by simulating a selection of the application from
                                           the Popup-Menu. */
    if(pHP->ulDebug>=DEBUG_FULL)
        printf("Thread: Received WM_AUTOSTART\n");
    SearchAutoStartItem(pHP->pPopupMenu);
    break;

/*                                                                                      *\
 * Syntax: WM_THREADSTARTUPREADY, NULL, NULL                                            *
\*                                                                                      */
case WM_THREADSTARTUPREADY:
/*                                                                                      *\
 * Working thread is now ready, make overview window visible when requested.            *
\*                                                                                      */
                                        /* Inform client window that working thread is now ready */
    WinPostMsg(pHP->hwndClient, WM_THREADSTARTUPREADY, NULL, NULL);
    break;
/*                                                                                      *\
 * Syntax: WM_PAINT, NULL, NULL                                                         *
\*                                                                                      */
case WM_PAINT:
/*                                                                                      *\
 * This message is send by PC/2's client window when a repaint is needed.               *
 * Ref.:                                                                                *
 *          none                                                                        *
\*                                                                                      */
    {
    RECTL       rcClient;               /* Rectangle to redraw */
    LONG        lX, lY;                 /* Position (x|y) on client area */
    LONG        lXSize, lYSize;         /* Length on client area */
    SWP         swpWindow;              /* Any window to be drawn on overview window */
    ULONG       ulWindowIndex;          /* Index in Windows.wdWindow[] */
                                        /* RGB colors available to draw winwdows */
    COLORWINDOW ColorWindow[]={ {RGB_BLACK,  RGB_WHITE}, {RGB_BLUE,  RGB_WHITE}, {RGB_GREEN, RGB_BLACK},
                                {RGB_CYAN,   RGB_BLACK}, {RGB_RED,   RGB_WHITE}, {RGB_PINK,  RGB_WHITE},
                                {RGB_YELLOW, RGB_BLACK} };
#ifndef SLOWVIDEO
    POINTL      ptl;
#endif /* SLOWVIDEO */

                                        /* Set background to dialog background */
    WinQueryWindowRect(pHP->hwndClient, &rcClient);
    WinFillRect(HPSDRAW, &rcClient, WinQuerySysColor(HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L));
                                        /* Now get scale factor to scale virtual Desktop
                                           to client area */
    pHP->fScaleX=(float)(pHP->swpPC2Client.cx-1)/
        (pHP->ulHorizontalDesktops*pHP->DesktopSize.x);
    pHP->fScaleY=(float)(pHP->swpPC2Client.cy)/
        (pHP->ulVerticalDesktops*pHP->DesktopSize.y);
                                        /* Get coordinates (0|0) origin, relativ to (0|0) of
                                           the Virtual Desktop */
    pHP->ptlOrigin.x=(pHP->VirtualDesktopPos.x-pHP->VirtualDesktopMin.x)*
        pHP->fScaleX;
    pHP->ptlOrigin.y=(pHP->VirtualDesktopPos.y-pHP->VirtualDesktopMin.y)*
        pHP->fScaleY;
                                        /* Get size of one of the number of Desktops that must fit into
                                           the client area */
    lXSize=pHP->swpPC2Client.cx/pHP->ulHorizontalDesktops;
    lYSize=pHP->swpPC2Client.cy/pHP->ulVerticalDesktops;
                                        /* If WPS is expanded to whole Virtual Desktop draw Desktop
                                           first before drawing the borders of the Virtual Desktop */
    if(pHP->ulStatusFlag & EXPANDWPS)
        {
                                        /* Calculate and draw window */
        swpWindow.x=pHP->ptlOrigin.x+
            (float)pHP->Windows.wdWindow[pHP->Windows.ulDesktop].swpWindow.x*pHP->fScaleX;
        swpWindow.y=pHP->ptlOrigin.y+
            (float)pHP->Windows.wdWindow[pHP->Windows.ulDesktop].swpWindow.y*pHP->fScaleY;
        swpWindow.cx=(float)pHP->Windows.wdWindow[pHP->Windows.ulDesktop].swpWindow.cx*pHP->fScaleX;
        swpWindow.cy=(float)pHP->Windows.wdWindow[pHP->Windows.ulDesktop].swpWindow.cy*pHP->fScaleY;
                                        /* Display Window List title or titlebar */
        if(strlen(pHP->Windows.wdWindow[pHP->Windows.ulDesktop].ucWindowTitle))
            DrawWindow(HPSDRAW, &swpWindow,
                ColorWindow[pHP->Windows.ulDesktop % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulBackgroundRGB,
                ColorWindow[pHP->Windows.ulDesktop % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulForegroundRGB,
                FOREGROUND_WND, pHP->Windows.wdWindow[pHP->Windows.ulDesktop].ucWindowTitle);
        else
            DrawWindow(HPSDRAW, &swpWindow,
                ColorWindow[pHP->Windows.ulDesktop % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulBackgroundRGB,
                ColorWindow[pHP->Windows.ulDesktop % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulForegroundRGB,
                FOREGROUND_WND, pHP->Windows.wdWindow[pHP->Windows.ulDesktop].ucPgmTitle);
        }
    swpWindow.cx=lXSize-1;
    swpWindow.cy=lYSize-1;
                                        /* Draw all Virtual Desktops */
    for(lX=0; lX<pHP->ulHorizontalDesktops; lX++)
        for(lY=0; lY<pHP->ulVerticalDesktops; lY++)
            {
            swpWindow.x=lX*lXSize;
            swpWindow.y=lY*lYSize;
            DrawWindow(HPSDRAW, &swpWindow,
                WinQuerySysColor(HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L), 0L,
                (pHP->ulStatusFlag & EXPANDWPS) ? BACKGROUND_WND | BORDERONLY_WND : BACKGROUND_WND,
                NULL);
            }
                                        /* Draw physical Desktop window */
    swpWindow.x=pHP->ptlOrigin.x;
    swpWindow.y=pHP->ptlOrigin.y;
    DrawWindow(HPSDRAW, &swpWindow, RGB_WHITE, RGB_BLACK, FOREGROUND_WND, "Display");
                                        /* Now display the windows from topmost to bottommost */
    for(ulWindowIndex=pHP->Windows.ulWindowLast;
        ulWindowIndex!=(ULONG)-1 && pHP->Windows.ulWindowLast!=(ULONG)-1;
        ulWindowIndex--)
        {
                                        /* Ignore invisible windows or when WPS is expanded to
                                           Virtual Desktop */
        if((!(pHP->Windows.wdWindow[ulWindowIndex].ulStatus & VISIBLE)) ||
            ((pHP->ulStatusFlag & EXPANDWPS) && (ulWindowIndex==pHP->Windows.ulDesktop)))
            continue;

                                        /* Calculate and draw window */
        swpWindow.x=pHP->ptlOrigin.x+
            (float)pHP->Windows.wdWindow[ulWindowIndex].swpWindow.x*pHP->fScaleX;
        swpWindow.y=pHP->ptlOrigin.y+
            (float)pHP->Windows.wdWindow[ulWindowIndex].swpWindow.y*pHP->fScaleY;
        swpWindow.cx=(float)pHP->Windows.wdWindow[ulWindowIndex].swpWindow.cx*pHP->fScaleX;
        swpWindow.cy=(float)pHP->Windows.wdWindow[ulWindowIndex].swpWindow.cy*pHP->fScaleY;
                                        /* Display Window List title or titlebar */
        if(strlen(pHP->Windows.wdWindow[ulWindowIndex].ucWindowTitle))
            DrawWindow(HPSDRAW, &swpWindow,
                ColorWindow[ulWindowIndex % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulBackgroundRGB,
                ColorWindow[ulWindowIndex % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulForegroundRGB,
                FOREGROUND_WND, pHP->Windows.wdWindow[ulWindowIndex].ucWindowTitle);
        else
            DrawWindow(HPSDRAW, &swpWindow,
                ColorWindow[ulWindowIndex % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulBackgroundRGB,
                ColorWindow[ulWindowIndex % (sizeof(ColorWindow)/sizeof(COLORWINDOW))].ulForegroundRGB,
                FOREGROUND_WND, pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle);
        }
#ifndef SLOWVIDEO
                                    /* Draw the whole memory bitmap into the client area,
                                       without any background or foreground color because
                                       we have no monochrome bitmap */
    ptl.x=ptl.y=0;
    WinDrawBitmap(hpsClient, pHP->hbmMemory, NULL, &ptl, 0L, 0L, DBM_NORMAL);
#endif /* SLOWVIDEO */
    }
    break;

/*                                                                                      *\
 * Syntax: WM_DESKTOPMOVE, LONG SlidingXFactor, LONG SlidingYFactor                     *
\*                                                                                      */
case WM_DESKTOPMOVE:
/*                                                                                      *\
 * The hook found that the pointer was over one of the border rows and/or columns of    *
 * the physical Desktop or the user doubleclicked on a virtual Desktop on the overview  *
 * window. The passed parameter mp1 contains the number of pixels to slide all windows  *
 * on the virtual Desktop horizontally. We calculate if and where the physical Desktop  *
 * must be moved, or ignore it, if we're allready at a border position of the virtual   *
 * Desktop. If move request is finished successfully, WM_THREADREADY is posted.         *
\*                                                                                      */
    {
                                        /* Slide in x direction in pixels */
    LONG        lSlidingXFactor=LONGFROMMP(mp1);
                                        /* Slide in y direction in pixels */
    LONG        lSlidingYFactor=LONGFROMMP(mp2);
    ULONG       ulWindowIndex=0;        /* Index in WINDOWS structure */
    BOOL        bChanged=FALSE;         /* TRUE is at least one window has been changed
                                           (added, removed, moved, sized,...) */

    if(pHP->ulDebug>=DEBUG_ENTRY)
        {
        DosBeep(1000,250);
        }
    if(pHP->ulDebug>=DEBUG_FULL)
        printf("Thread: WM_DESKTOPMOVE\n");
    ulApplicationsCount=0;              /* Begin with first window */
                                        /* From all windows select the ones we are
                                           interested to move */
    for( ; ulWindowIndex<=pHP->Windows.ulWindowLast; ulWindowIndex++)
        {
                                        /* Ignore known windows not being a movable frame window. */
        if(!(pHP->Windows.wdWindow[ulWindowIndex].ulStatus & FRAMECLASS))
            continue;
                                        /* Preserve Window list */
        if(!strcmp(pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle, pHP->ucWindowListName))
            continue;
                                        /* Preserve PC/2's window, locating by titlebar or frame
                                           window handle */
        if((strstr(pHP->Windows.wdWindow[ulWindowIndex].ucWindowTitle, "PC/2")) ||
            (strstr(pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle, "PC/2"))) continue;
        if(pHP->Windows.wdWindow[ulWindowIndex].swpWindow.hwnd==pHP->hwndFrame) continue;
                                        /* Only move certain window */
        pHP->Windows.wdWindow[ulWindowIndex].swpWindow.x+=lSlidingXFactor;
        pHP->Windows.wdWindow[ulWindowIndex].swpWindow.y+=lSlidingYFactor;
                                        /* Now compare current one if it changed */
        if(memcmp(&swpApplications[ulApplicationsCount], &pHP->Windows.wdWindow[ulWindowIndex].swpWindow, sizeof(SWP)))
            {
            bChanged=TRUE;
            memcpy(&swpApplications[ulApplicationsCount], &pHP->Windows.wdWindow[ulWindowIndex].swpWindow, sizeof(SWP));
                                        /* Move window only if not marked non-movable. Such a window
                                           appears on every Virtual Desktop but may change its position
                                           relative to the lower left corner so we have to compare its
                                           old and new position to update overview window correctly */
            if(pHP->Windows.wdWindow[ulWindowIndex].SwpFlag & SWP_NOMOVE)
                swpApplications[ulApplicationsCount].fl=SWP_NOADJUST;
            else
                swpApplications[ulApplicationsCount].fl=SWP_MOVE | SWP_NOADJUST;
            }
        ulApplicationsCount++;
        }
                                        /* Now move all windows */
    if(lSlidingXFactor || lSlidingYFactor)
        {
        if(WinSetMultWindowPos(pHP->habPc2, swpApplications, ulApplicationsCount))
            {
            bChanged=TRUE;              /* If windows were successfully moved update overview window */
                                        /* Adjust physical Desktop within virtual Desktop */
            pHP->VirtualDesktopPos.x-=lSlidingXFactor;
            pHP->VirtualDesktopPos.y-=lSlidingYFactor;
                                        /* Windows have changed, request repaint client area */
            WinSendMsg(hwnd, WM_PAINT, NULL, NULL);
                                        /* Indicate that working thread is ready after moving windows
                                           from one Virtual Desktop to another */
            WinPostMsg(pHP->hwndClient, WM_THREADREADY, MPFROMLONG(THREADMOVEBUSY), NULL);
            }
        else
                                        /* If windows weren't successfully moved retry */
            WinPostMsg(hwnd, WM_DESKTOPMOVE, MPFROMLONG(lSlidingXFactor), MPFROMLONG(lSlidingYFactor));
        }
    else
        {
                                        /* If windows changed, request repaint client area */
        if(bChanged) WinSendMsg(hwnd, WM_PAINT, NULL, NULL);
                                        /* Indicate that working thread is ready after enumerating
                                           windows */
        WinPostMsg(pHP->hwndClient, WM_THREADREADY, MPFROMLONG(THREADWINDOWBUSY), NULL);
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETDESKTOPHANDLE, NULL, NULL                                              *
\*                                                                                      */
case WM_SETDESKTOPHANDLE:
/*                                                                                      *\
 * Query the window handle of the Desktop windows and load them into PC2HOOK.DLL        *
 * library. If the WPS is installed, we can obtain its handle by searching for a window *
 * class of #37. Even if the WPS is installed, we can also obtain the the window handle *
 * of the PM, which is also present, if the WPS isn't installed.                        *
 * Ref.:                                                                                *
 *          Windows ........... WINDOWS structure containing all windows control data   *
\*                                                                                      */
    {
    UCHAR       ucClass[8];             /* Save class name here */
    HWND        hwndWPS;                /* Save WPS window handle */
    HWND        hwndDesktop;            /* Save PM window handle */
    HENUM       henumWindows;           /* Enumerate windows */

                                        /* Get to bottommost window handle of the "Desktop" */
    hwndDesktop=WinQueryWindow(HWND_DESKTOP, QW_BOTTOM);
                                        /* Enumerate all windows at "Desktop" bottom z-order,
                                           that is all windows the WPS consists of. The window
                                           we are interested in is the client area which is a
                                           WC_CONTAINER class windo */
    henumWindows=WinBeginEnumWindows(hwndDesktop);
    while((hwndWPS=WinGetNextWindow(henumWindows))!=NULLHANDLE)
        {
                                        /* Now get the class name of that window handle */
        WinQueryClassName(hwndWPS, sizeof(ucClass), (PCH)ucClass);
                                        /* If we find the required "Desktop" window (it
                                           has a class name of #37, which is reserved in the
                                           Toolkit) set this value into the Hook DLL.
                                           The "Desktop" is just a WC_CONTAINER class.
                                           This class is owned by the WPS, so we found the
                                           WPS' window handle */
        if(!strcmp(ucClass, DESKTOP_CLASS)) break;
        }
    WinEndEnumWindows(henumWindows);    /* End enumeration */
/*                                                                                      *\
 * Now get the PM window handle for the case, that the WPS is not installed, or moved   *
 * outwards of the display (by setting the move Desktop checkbox).                      *
\*                                                                                      */
                                        /* Without WPS installed we can only get the
                                           "Desktop" window handle */
    hwndDesktop=WinQueryDesktopWindow(pHP->habPc2, NULLHANDLE);
                                        /* Inform DLL if Desktop windows handles have
                                           changed */
    if((hwndWPS!=pHP->hwndWPS) || (hwndDesktop!=pHP->hwndDesktop))
        {
        pHP->hwndWPS=hwndWPS;
        pHP->hwndDesktop=hwndDesktop;
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPSIZEPOSITION, ULONG ulMsg, NULL                                      *
\*                                                                                      */
case WM_SETUPSIZEPOSITION:
/*                                                                                      *\
 * This message is posted as a result of a user event in the hook. All windows running  *
 * in the system are queried and registered in the Windows control structure.           *                                                                           *
 * The Window List is queried to find the Window List entries of the PM windows.        *
 * Ref.:                                                                                *
 *          Windows ........... WINDOWS structure containing all windows control data   *
\*                                                                                      */
    {
    ULONG       ulWindowIndex;          /* Index in Windows.wdWindow[] */
    HENUM       henumDesktop;           /* Window handle of WC_FRAME class Desktop */
    HWND        hwndApplication;        /* Window handles of enumerated application */
    ULONG       ulWindowListCount, ulWindowListIndex;
    MENUDATA    *pMD;                   /* Pointer to MENUDATA structure of corresponding window */
    PSWBLOCK    pSwBlock;               /* Pointer to window list */
    BOOL        bFoundItem;             /* TRUE if current window was found within PC/2 Popup-Menu */

    if(pHP->ulDebug>=DEBUG_FULL)
        printf("Thread: WM_SETUPSIZEPOSITION\n");
                                        /* Query the number of entries in window list */
    ulWindowListCount=WinQuerySwitchList(pHP->habPc2, NULL, 0);
                                        /* Allocate space for window list */
    pSwBlock=(PSWBLOCK)malloc(ulWindowListCount=(ulWindowListCount*sizeof(SWENTRY)+sizeof(HSWITCH)));
                                        /* Enumerate window list to query how the Session title of a
                                           frame window (using it's window handle) is spelled in the
                                           Window list */
    ulWindowListCount=WinQuerySwitchList(pHP->habPc2, pSwBlock, ulWindowListCount);
    pHP->Windows.ulDesktop=(ULONG)-1;   /* Set to -1 if we don't find the Desktop's name */
                                        /* Set to -1 if we don't find the Window List's name */
    pHP->Windows.ulWindowList=(ULONG)-1;
    ulWindowIndex=(ULONG)-1;            /* Begin with offset 0 in first iteration */
                                        /* Enumerate all descendants of HWND_DESKTOP,
                                           which are the frame windows seen on Desktop,
                                           but not having necessarily the class WC_FRAME */
    henumDesktop=WinBeginEnumWindows(HWND_DESKTOP);
    while((hwndApplication=WinGetNextWindow(henumDesktop))!=NULLHANDLE)
        {
        ulWindowIndex++;
                                        /* Asume window visible */
        pHP->Windows.wdWindow[ulWindowIndex].ulStatus|=VISIBLE;
        pHP->Windows.wdWindow[ulWindowIndex].ulStatus|=FRAMECLASS;
                                        /* Get window's size and position */
        WinQueryWindowPos(hwndApplication, &pHP->Windows.wdWindow[ulWindowIndex].swpWindow);
        if(pHP->Windows.wdWindow[ulWindowIndex].swpWindow.fl & SWP_HIDE)
                                        /* Get window's titlebar */
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
                                        /* Get window's class name */
        WinQueryClassName(hwndApplication, CLASSNAMESIZE,
            pHP->Windows.wdWindow[ulWindowIndex].ucClassName);
                                        /* If it is an minimized icon text class window
                                           treat it as an invisible one */
        if(!strcmp(pHP->Windows.wdWindow[ulWindowIndex].ucClassName, "#32765"))
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
                                        /* If it is a menu treat it as an invisible one and
                                           not being a frame window */
        if(!strcmp(pHP->Windows.wdWindow[ulWindowIndex].ucClassName, "#4"))
            {
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~FRAMECLASS);
            }
                                        /* If it is a combobox treat it as an invisible one and
                                           not being a frame window */
        if(!strcmp(pHP->Windows.wdWindow[ulWindowIndex].ucClassName, "#7"))
            {
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~FRAMECLASS);
            }
                                        /* Get window's titlebar */
        WinQueryWindowText(hwndApplication, MAXNAMEL+1,
            pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle);
                                        /* If we found the index of the Window List save it */
        if(strstr(pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle, pHP->ucWindowListName))
            {
            pHP->hwndWindowList=hwndApplication;
            pHP->Windows.ulWindowList=ulWindowIndex;
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~FRAMECLASS);
            }
                                        /* If we found the index of the Desktop save it */
        if(strstr(pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle, pHP->ucDesktopName))
            {
            pHP->Windows.ulDesktop=ulWindowIndex;
            if(!(pHP->ulStatusFlag & (MOVEDESKTOP | EXPANDWPS)))
                pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~FRAMECLASS);
            }
                                        /* If we found a "shadow" window created by seamless
                                           WIN-OS2 ignore it. E.g. a dropdown menu is painted
                                           into a PM window named "Seamless" to allow the menu
                                           to be displayed outside any area coverd by the WIN-OS2
                                           application too */
        if(strstr(pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle, "Seamless"))
            {
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~FRAMECLASS);
            }
                                        /* If we found PC/2, or any of PC/2's dialogs save it */
        if(hwndApplication==pHP->hwndFrame)
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
        if(strstr(pHP->Windows.wdWindow[ulWindowIndex].ucPgmTitle, "PC/2"))
            pHP->Windows.wdWindow[ulWindowIndex].ulStatus &= (~VISIBLE);
                                        /* If we don't find an entry in the Window List set
                                           it to default empty string */
        strcpy(pHP->Windows.wdWindow[ulWindowIndex].ucWindowTitle, "");
                                        /* If we don't find an entry set to 0 */
        pHP->Windows.wdWindow[ulWindowIndex].hswitchWindow=0;
        for(ulWindowListIndex=0; ulWindowListIndex<=ulWindowListCount; ulWindowListIndex++)
            {                           /* If window handle of frame window and window handle in
                                           window list equal, copy the name of the entry from the
                                           window list */
            if(pSwBlock->aswentry[ulWindowListIndex].swctl.hwnd==pHP->Windows.wdWindow[ulWindowIndex].swpWindow.hwnd)
                {
                strcpy(pHP->Windows.wdWindow[ulWindowIndex].ucWindowTitle,
                    pSwBlock->aswentry[ulWindowListIndex].swctl.szSwtitle);
                                        /* Get the switch handle */
                pHP->Windows.wdWindow[ulWindowIndex].hswitchWindow=pSwBlock->aswentry[ulWindowListIndex].hswitch;
                break;                  /* If found we need no further seek */
                }
            }
                                        /* Search if current window is contained in PC/2's
                                           Popup-Menu */
        bFoundItem=FALSE;
        pMD=SearchTitle(pHP->pPopupMenu, &pHP->Windows.wdWindow[ulWindowIndex], &bFoundItem);
        if(pMD!=NULL)
                                        /* If found copy flag because we need to determine
                                           if window should be moved on virtual Desktops
                                           and how it should be restored when hotkeying to it */
            {
            pHP->Windows.wdWindow[ulWindowIndex].SwpFlag=pMD->SwpFlag;
            memcpy(&pHP->Windows.wdWindow[ulWindowIndex].KeyData, &(pMD->KeyData), sizeof(KEYDATA));
            if(pMD->SwpFlag & SWP_MOVEWINDOW)
                {
                SWP     swp;
                USHORT  usSwp;
                                        /* If window was only invisible because of the movement
                                           make it visible again */
                if(pMD->SwpFlag & SWP_MOVEWINDOWVISIBLE)
                    usSwp=SWP_MOVE | SWP_SHOW | SWP_NOADJUST;
                else
                    usSwp=SWP_MOVE | SWP_NOADJUST;
                                        /* If this flag is set we found an application's window
                                           the first time after invokation and we have to reposition
                                           it and reset the flag */
                pMD->SwpFlag&=(~(SWP_MOVEWINDOW | SWP_MOVEWINDOWVISIBLE));
                                        /* Now calculate window's position on Virtual Desktops and
                                           move it to its absolute (relative to logical 0|0) position */
                swp.fl=usSwp;
                swp.x=pMD->InitXPos-pHP->VirtualDesktopPos.x,
                swp.y=pMD->InitYPos-pHP->VirtualDesktopPos.y,
                swp.hwndInsertBehind=HWND_TOP;
                swp.hwnd=pHP->Windows.wdWindow[ulWindowIndex].swpWindow.hwnd;
                WinSetMultWindowPos(pHP->habPc2, &swp, 1);
                }
            }
        else
            {
            pHP->Windows.wdWindow[ulWindowIndex].SwpFlag=0;
            memset(&pHP->Windows.wdWindow[ulWindowIndex].KeyData, 0, sizeof(KEYDATA));
            }
        }
    WinEndEnumWindows(henumDesktop);    /* End enumeration */
    pHP->Windows.ulWindowLast=ulWindowIndex;
    free(pSwBlock);
    WinPostMsg(hwnd, WM_DESKTOPMOVE, MPFROMLONG(0), MPFROMLONG(0));
    }
    break;

/*                                                                                      *\
 * Syntax: WM_BUTTON1DBLCLK, (LONG mp1), (LONG mp2)                                     *
\*                                                                                      */
case WM_BUTTON1DBLCLK:
/*                                                                                      *\
 * This message detected and passed from the PC/2 window procedure is used to switch    *
 * between Virtual Desktops.                                                            *
 * Ref.:                                                                                *
 *          Windows ........... WINDOWS structure containing all windows control data   *
\*                                                                                      */
    {
    LONG        lClickX, lClickY;       /* Pointer position during click */
    LONG        lSlidingXFactor;        /* Slide in x direction in pixels */
    LONG        lSlidingYFactor;        /* Slide in y direction in pixels */

    if(pHP->ulDebug>=DEBUG_ENTRY)
        {
        DosBeep(1000,250);
        }
    if(pHP->ulDebug>=DEBUG_FULL)
        printf("Thread: WM_BUTTON1DBLCLK\n");
                                        /* Get the virtual Desktop the user doubleclicked on */
    lClickX=pHP->VirtualDesktopMin.x;
    lClickY=pHP->VirtualDesktopMin.y;
    lClickX+=((LONG)(SHORT1FROMMP(mp1)))/
        (pHP->swpPC2Client.cx/pHP->ulHorizontalDesktops)*pHP->DesktopSize.x;
    lClickY+=((LONG)(SHORT2FROMMP(mp1)))/
        (pHP->swpPC2Client.cy/pHP->ulVerticalDesktops)*pHP->DesktopSize.y;
                                        /* The right and top borders are the limit (necessary because
                                           the frame rectangle is sized pointwise and the virtual Desktops
                                           drawn are sized every n points leaving 0 to n-1 points outside.
                                           Can be fixed by allowing the frame also sized only every n
                                           points, but this requires subclassing of the frame. */
    if(lClickX>(pHP->VirtualDesktopMax.x-pHP->DesktopSize.x))
        lClickX=(pHP->VirtualDesktopMax.x-pHP->DesktopSize.x);
    if(lClickY>(pHP->VirtualDesktopMax.y-pHP->DesktopSize.y))
        lClickY=(pHP->VirtualDesktopMax.y-pHP->DesktopSize.y);
                                        /* Calculate Desktop move in pixel */
    lSlidingXFactor=pHP->VirtualDesktopPos.x-lClickX;
    lSlidingYFactor=pHP->VirtualDesktopPos.y-lClickY;
    if(lSlidingXFactor || lSlidingYFactor)
                                        /* Now move the windows */
        WinPostMsg(pHP->hwndThread, WM_DESKTOPMOVE, MPFROMLONG(lSlidingXFactor), MPFROMLONG(lSlidingYFactor));
    else
                                        /* Indicate that working thread is ready because it doesn't need
                                           to move windows from one Virtual Desktop to another */
        WinPostMsg(pHP->hwndClient, WM_THREADREADY, MPFROMLONG(THREADMOVEBUSY), NULL);
    }
    break;

/*                                                                                      *\
 * Syntax: WM_HOTKEY, (USHORT usFlags, USHORT usCh), ULONG ulKeyDataIndex               *
 *                                                                                      *
\*                                                                                      */
case WM_HOTKEY:
/*                                                                                      *\
 * WM_HOTKEY is a WM_CHAR message, passed when a hotkey was detected in PC2Hook.DLL.    *
 * The key passed from the input hook is flaged as used. Either the running program     *
 * corresponding to the hotkey is switched into the foreground, or if it is not already *
 * running it is started.                                                               *
 * Ref.:                                                                                *
 *          Windows ........... WINDOWS structure containing all windows control data   *
\*                                                                                      */
    {
                                        /* Get key code */
    USHORT      usFlags=SHORT1FROMMP(mp1);
                                        /* Get ASCII key value */
    USHORT      usCh=SHORT2FROMMP(mp1);
                                        /* Index in KeyData of HotKey found */
    ULONG       ulKeyDataIndex=LONGFROMMP(mp2);
    POINTL      VirtualDesktopPos;      /* Copy structure from HookParameters */
    ULONG       ulWindowIndex;          /* Index in Windows.wdWindow[] */
    POINTL      HotKeyWindow;           /* Position of the window the Hotkey is defined for
                                           in coordinates relative to logical (0|0) point */
    LONG        lSlidingXFactor=0;      /* Slide in x direction in pixels */
    LONG        lSlidingYFactor=0;      /* Slide in y direction in pixels */
    LONG        lDiff;
    USHORT      usfl;                   /* Flags for WinSetMultWindowPos() */

    if(pHP->ulDebug>=DEBUG_FULL)
        printf("Thread: WM_HOTKEY\n");
    VirtualDesktopPos=pHP->VirtualDesktopPos;
                                        /* Find match between actual hotkey pressed and
                                           any (available) window this hotkey is defined for */
    for(ulWindowIndex=0; ulWindowIndex<=pHP->Windows.ulWindowLast; ulWindowIndex++)
        {
        if((pHP->Windows.wdWindow[ulWindowIndex].KeyData.usFlags==usFlags) &&
            (pHP->Windows.wdWindow[ulWindowIndex].KeyData.usCh==usCh))
            break;
        }
                                        /* Only do something when a window for a hotkey
                                           is available */
    if(ulWindowIndex<=pHP->Windows.ulWindowLast)
        {                               /* The coordinates in the WINDOWS structure are relative to
                                           PM, which is, if the Virtual Desktop is enabled, relative
                                           to the logical (0|0) point (which is the lower left position
                                           of the Display in the overview window.
                                           To get the position relative to logical (0|0) get the winow's
                                           position on PM and add the logical position of PM relative to
                                           logical (0|0). Compare with the middle of the hotkeyed window. */
        HotKeyWindow.x=pHP->VirtualDesktopPos.x+
            pHP->Windows.wdWindow[ulWindowIndex].swpWindow.x+(pHP->Windows.wdWindow[ulWindowIndex].swpWindow.cx>>1);
        HotKeyWindow.y=pHP->VirtualDesktopPos.y+
            pHP->Windows.wdWindow[ulWindowIndex].swpWindow.y+(pHP->Windows.wdWindow[ulWindowIndex].swpWindow.cy>>1);
                                        /* Move physical Desktop right, but not over the
                                           right border of the virtual Desktop until
                                           the hotkeyed window's horizontal position comes
                                           onto the Desktop */
        while(HotKeyWindow.x>(VirtualDesktopPos.x+pHP->SlidingXFactor))
            {                           /* Move physical Desktop right one additional unit,
                                           can also be seen to move all windows in virtual
                                           Desktop left one additional unit */
            lSlidingXFactor-=pHP->SlidingXFactor;
            VirtualDesktopPos.x+=pHP->SlidingXFactor;
            lDiff=VirtualDesktopPos.x-(pHP->VirtualDesktopMax.x-pHP->DesktopSize.x);
            if(lDiff>0)                 /* Correct if we moved out of the physical Desktop */
                {
                lSlidingXFactor+=lDiff;
                break;                  /* We can't move further */
                }
            }
                                        /* Do the same left */
        while(HotKeyWindow.x<VirtualDesktopPos.x)
            {                           /* Move physical Desktop left one additional unit */
            lSlidingXFactor+=pHP->SlidingXFactor;
            VirtualDesktopPos.x-=pHP->SlidingXFactor;
            lDiff=VirtualDesktopPos.x-pHP->VirtualDesktopMin.x;
            if(lDiff<0)                 /* Correct if we moved out of the physical Desktop */
                {
                lSlidingXFactor+=lDiff;
                break;                  /* We can't move further */
                }
            }
                                        /* Move physical Desktop up, but not over the
                                           top border of the virtual Desktop until
                                           the hotkeyed window's vertiacal position comes
                                           onto the Desktop */
        while(HotKeyWindow.y>(VirtualDesktopPos.y+pHP->SlidingYFactor))
            {                           /* Move physical Desktop up one additional unit,
                                           can also be seen to move all windows in virtual
                                           Desktop down one additional unit */
            lSlidingYFactor-=pHP->SlidingYFactor;
            VirtualDesktopPos.y+=pHP->SlidingYFactor;
            lDiff=VirtualDesktopPos.y-(pHP->VirtualDesktopMax.y-pHP->DesktopSize.y);
            if(lDiff>0)                 /* Correct if we moved out of the physical Desktop */
                {
                lSlidingYFactor+=lDiff;
                break;                  /* We can't move further */
                }
            }
                                        /* Do the same downwards */
        while(HotKeyWindow.y<VirtualDesktopPos.y)
            {                           /* Move physical Desktop down one additional unit */
            lSlidingYFactor+=pHP->SlidingYFactor;
            VirtualDesktopPos.y-=pHP->SlidingYFactor;
            lDiff=VirtualDesktopPos.y-pHP->VirtualDesktopMin.y;
            if(lDiff<0)                 /* Correct if we moved out of the physical Desktop */
                {
                lSlidingYFactor+=lDiff;
                break;                  /* We can't move further */
                }
            }
        if(lSlidingXFactor || lSlidingYFactor)
                                        /* Now move the windows and activate window after move. Prior
                                           version 1.80 WinPostMsg() was used to switch to a Virtual
                                           Desktop. This worked unless the window we switched to with
                                           the Hotkey was minmized. In this case the window got
                                           activated first by the WinSetMultWindowPos() call, before
                                           the Virtual Desktop got switch by WM_DESKTOPMOVE, causing
                                           the minimized window expanding to the current Desktop, with
                                           a switch to the Virtual Desktop the minimized window was
                                           afterwards.
                                           Version 1.90+ uses WinSendMsg() to switch to the Virtual
                                           Desktop first, before restoring the minimized window. */
            WinSendMsg(pHP->hwndThread, WM_DESKTOPMOVE, MPFROMLONG(lSlidingXFactor), MPFROMLONG(lSlidingYFactor));
                                        /* Get flags WinSetMultWindowPos() */
        usfl=(pHP->Windows.wdWindow[ulWindowIndex].SwpFlag & ~SWP_NOMOVE) | SWP_SHOW;
                                        /* If not switch handle found activate window through
                                           WinSetMultWindowPos() else via WinSwitchToProgram which
                                           also switches to different screen groups */
        if(!pHP->Windows.wdWindow[ulWindowIndex].hswitchWindow)
            usfl|=(SWP_ACTIVATE | SWP_ZORDER);
        pHP->Windows.wdWindow[ulWindowIndex].swpWindow.fl=usfl;
        pHP->Windows.wdWindow[ulWindowIndex].swpWindow.hwndInsertBehind=HWND_TOP;
        WinSetMultWindowPos(pHP->habPc2, &pHP->Windows.wdWindow[ulWindowIndex].swpWindow, 1);
        if(pHP->Windows.wdWindow[ulWindowIndex].hswitchWindow)
            WinSwitchToProgram(pHP->Windows.wdWindow[ulWindowIndex].hswitchWindow);
        }
    else
        {                               /* If no session found for the pressed hotkey, start
                                           the corresponding session */
        WinPostMsg(pHP->hwndClient, WM_COMMAND,
                                        /* Get ID and set it as posted by a menu control */
            MPFROM2SHORT((USHORT)((pHP->pKeyData+ulKeyDataIndex)->pMenuData->id),
                CMDSRC_MENU),
                                        /* Simulate Message a result of a keyboard operation */
            MPFROMCHAR(FALSE));
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_WINDOWLIST, (USHORT x, USHORT y), NULL                                    *
\*                                                                                      */
case WM_WINDOWLIST:
/*                                                                                      *\
 * WM_WINDIWLIST is sent by PC2Hook.dll and passed from PC/2's window procedure, if     *
 * mouse clicks are detected on PM that would display the Window List on the WPS. Be-   *
 * cause the WPS displayed the Window List but not PM, we simulate this on PM.          *
 * Ref.:                                                                                *
 *          Windows ........... WINDOWS structure containing all windows control data   *
\*                                                                                      */
    {                                   /* Mouse position when Window List was requested */
    USHORT      usX=SHORT1FROMMP(mp1), usY=SHORT2FROMMP(mp1);

    if(pHP->Windows.ulWindowList!=(ULONG)-1) /* Display Window List */
        {
                                        /* Place Window List centered under mouse pointer
                                           whenever possible */
        if((pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cx>>1)>usX)
            usX=0;
        else if(pHP->DesktopSize.x-(pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cx>>1)<usX)
            usX=pHP->DesktopSize.x-pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cx;
        else usX=usX-(pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cx>>1);
        if((pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cy>>1)>usY)
            usY=0;
        else if(pHP->DesktopSize.y-(pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cy>>1)<usY)
            usY=pHP->DesktopSize.y-pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cy;
        else usY=usY-(pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.cy>>1);
        pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.fl=
            SWP_MOVE|SWP_SHOW|SWP_ZORDER|SWP_NOADJUST;
        pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.x=usX;
        pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.y=usY;
        pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow.hwndInsertBehind=HWND_TOP;
        WinSetMultWindowPos(pHP->habPc2, &pHP->Windows.wdWindow[pHP->Windows.ulWindowList].swpWindow, 1);
        if(pHP->Windows.wdWindow[pHP->Windows.ulWindowList].hswitchWindow)
            WinSwitchToProgram(pHP->Windows.wdWindow[pHP->Windows.ulWindowList].hswitchWindow);
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_MOVEREQUEST, (USHORT usMouseXPos, USHORT usMouseYPos), (ULONG ulMoveFlag) *
\*                                                                                      */
case WM_MOVEREQUEST:
/*                                                                                      *\
 * This local procedure is called from the PC2DLL_Hook procedure to move the windows    *
 * within the virtual Desktop on its behalf.                                            *
 * Req.:                                                                                *
 *      usMouseXPos.... X Position of mouse pointer during creation of move message     *
 *      usMouseYPos.... Y Position of mouse pointer during creation of move message     *
 *      ulMoveFlag..... Bitmapped flag to control move                                  *
 * Returns:                                                                             *
 *      none                                                                            *
 * Ref.:                                                                                *
 *      Windows ....... WINDOWS structure containing all windows control data           *
\*                                                                                      */
    {
                                        /* Get pointer position */
    LONG        lMouseXPos=(LONG)SHORT1FROMMP(mp1);
    LONG        lMouseYPos=(LONG)SHORT2FROMMP(mp1);
    POINTL      VirtualDesktopPos;      /* Copy structure from HookParameters */
                                        /* Get bitmapped move control flag */
    ULONG       ulMoveFlag=LONGFROMMP(mp2);
    LONG        lSlidingXFactor;        /* Horizontal offset to move */
    LONG        lSlidingYFactor;        /* Vertical offset to move */
    LONG        lDiff;                  /* Difference between movement and Desktop size */

    if(pHP->ulDebug>=DEBUG_ENTRY)
        {
        DosBeep(1000,250);
        }
    if(pHP->ulDebug>=DEBUG_FULL)
        printf("Thread: WM_MOVEREQUEST\n");
    lSlidingXFactor=0;
    lSlidingYFactor=0;
    VirtualDesktopPos=pHP->VirtualDesktopPos;
    if((ulMoveFlag&MOVEXR))
        {                               /* Move physical Desktop left, but not over the
                                           left border of the virtual Desktop */
        lSlidingXFactor=pHP->SlidingXFactor;
        VirtualDesktopPos.x-=pHP->SlidingXFactor;
        lDiff=VirtualDesktopPos.x-pHP->VirtualDesktopMin.x;
        if(lDiff<0)
            {
            lSlidingXFactor+=lDiff;
            }
        }
    if((ulMoveFlag&MOVEXL))
        {                               /* Move physical Desktop right, but not over the
                                           right border of the virtual Desktop */
        lSlidingXFactor=-pHP->SlidingXFactor;
        VirtualDesktopPos.x+=pHP->SlidingXFactor;
        lDiff=VirtualDesktopPos.x-(pHP->VirtualDesktopMax.x-pHP->DesktopSize.x);
        if(lDiff>0)
            {
            lSlidingXFactor+=lDiff;
            }
        }
    if((ulMoveFlag&MOVEYU))
        {                               /* Move physical Desktop down, but not under the
                                           bottom border of the virtual Desktop */
        lSlidingYFactor=pHP->SlidingYFactor;
        VirtualDesktopPos.y-=pHP->SlidingYFactor;
        lDiff=VirtualDesktopPos.y-pHP->VirtualDesktopMin.y;
        if(lDiff<0)
            {
            lSlidingYFactor+=lDiff;
            }
        }
    if((ulMoveFlag&MOVEYD))
        {                               /* Move physical Desktop up, but not over the
                                           top border of the virtual Desktop */
        lSlidingYFactor=-pHP->SlidingYFactor;
        VirtualDesktopPos.y+=pHP->SlidingYFactor;
        lDiff=VirtualDesktopPos.y-(pHP->VirtualDesktopMax.y-pHP->DesktopSize.y);
        if(lDiff>0)
            {
            lSlidingYFactor+=lDiff;
            }
        }
                                        /* If there is nothing to move, because we are
                                           on a border position, don't do further processing
                                           but return */
    if(lSlidingXFactor || lSlidingYFactor)
        {                               /* Move pointer so that it is on that pixel it
                                           would be, if we hadn't moved the windows. Also
                                           change the pixel which gets the message. */
        if(pHP->ulScrollPercentage==100)
            WinSetPointerPos(HWND_DESKTOP, (lMouseXPos+=lSlidingXFactor*0.5),
                (lMouseYPos+=lSlidingYFactor*0.5));
        else
            WinSetPointerPos(HWND_DESKTOP, (lMouseXPos+=lSlidingXFactor),
                (lMouseYPos+=lSlidingYFactor));
                                        /* Inform working thread to move windows */
        WinPostMsg(pHP->hwndThread, WM_DESKTOPMOVE,
            MPFROMLONG(lSlidingXFactor), MPFROMLONG(lSlidingYFactor));
        }
    else
                                        /* If clicked on absolute border row or column we
                                           don't have to do anything but to reset move busy flag */
        WinPostMsg(pHP->hwndClient, WM_THREADREADY, MPFROMLONG(THREADMOVEBUSY), NULL);
    }
    break;

/*                                                                                      *\
 * Syntax: WM_EXPANDWPS, (BOOL bExpand)                                                 *
\*                                                                                      */
case WM_EXPANDWPS:
/*                                                                                      *\
 * This local procedure is called to resize the WPS either to the whole Virtual         *
 * Desktop or to the size of the physical screen.                                       *
 * Req:                                                                                 *
 *      bExpand ....... TRUE if WPS should expand to whole Virtual Desktop              *
 *                      FALSE otherwise                                                 *
 * Returns:                                                                             *
 *      none                                                                            *
 * Ref.:                                                                                *
\*                                                                                      */
    {
    SWP     swp;

                                        /* If no WPS is running it can't be sized */
    if(!pHP->hwndWPS) break;
    if((BOOL)SHORT1FROMMP(mp1)==TRUE)
        {
                                        /* If WPS should be expanded to whole Virtual Desktop
                                           resize and move WPS */
        if(pHP->ulStatusFlag & EXPANDWPS)
                                        /* Resize WPS which is the parent window of the WC_CONTAINER
                                           class client area we catch mouse clicks on to display
                                           the Popup-Menu */
            swp.fl=SWP_SIZE|SWP_MOVE|SWP_NOADJUST;
            swp.x=pHP->VirtualDesktopMin.x-pHP->VirtualDesktopPos.x-1;
            swp.y=pHP->VirtualDesktopMin.y-pHP->VirtualDesktopPos.y-1;
            swp.cx=pHP->DesktopSize.x*pHP->ulHorizontalDesktops+2;
            swp.cy=pHP->DesktopSize.y*pHP->ulVerticalDesktops+
                WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR)+2;
            swp.hwndInsertBehind=NULLHANDLE;
            swp.hwnd=WinQueryWindow(pHP->hwndWPS, QW_PARENT);
            WinSetMultWindowPos(pHP->habPc2, &swp, 1);
        }
    else
        {                               /* If WPS was expanded to whole Virtual Desktop
                                           resize and move WPS to default */
        swp.fl=SWP_SIZE|SWP_MOVE|SWP_NOADJUST;
        swp.x=-1;
        swp.y=-1;
        swp.cx=pHP->DesktopSize.x+2;
        swp.cy=pHP->DesktopSize.y+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR)+2;
        swp.hwndInsertBehind=NULLHANDLE;
        swp.hwnd=WinQueryWindow(pHP->hwndWPS, QW_PARENT);
        WinSetMultWindowPos(pHP->habPc2, &swp, 1);
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_BACKGROUNDBITMAP, NULL, NULL                                              *
\*                                                                                      */
case WM_BACKGROUNDBITMAP:
/*                                                                                      *\
 * This local procedure is called to change the PM background bitmap.                   *
 * Req:                                                                                 *
 *      HookParameters. Extract bitmap info                                             *
 * Returns:                                                                             *
 *      none                                                                            *
 * Ref.:                                                                                *
\*                                                                                      */
    {
    DESKTOP Desktop;                    /* Desktop state structure */

    Desktop.cbSize=sizeof(DESKTOP);     /* Length */
    Desktop.hbm=0;                      /* Bitmap handle */
    Desktop.x=Desktop.y=0;              /* Bitmap origin coordinates */
                                        /* Desktop background state settings */
    if(pHP->ulStatusFlag & BACKGROUNDBITMAP)
        {
                                        /* Load it from file and destroy existing one */
        Desktop.fl=SDT_LOADFILE;
        if(pHP->ulBackgroundBitmapFlag & BITMAPNORMAL)
            Desktop.fl|=SDT_CENTER;
        if(pHP->ulBackgroundBitmapFlag & BITMAPSCALED)
            Desktop.fl|=SDT_SCALE;
        if(pHP->ulBackgroundBitmapFlag & BITMAPTILED)
            {
            Desktop.fl|=SDT_TILE;
                                        /* Use tile count if set otherwise 0 */
            Desktop.lTileCount=pHP->ulBackgroundBitmapFlag & 0xFFFF;
            }
        else
            Desktop.lTileCount=0;
                                        /* Full qualified path to bitmap file */
        strcpy(Desktop.szFile, pHP->ucBackgroundBitmap);
        }
    else
        {                               /* If no bitmap should be selected unset and destroy it */
        Desktop.fl=SDT_DESTROY | SDT_NOBKGND;
        Desktop.lTileCount=0;           /* No tile count */
        Desktop.szFile[0]='\0';         /* No bitmap file */
        }
                                        /* Set new PM desktop background bitmap */
    WinSetDesktopBkgnd(HWND_DESKTOP, &Desktop);
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETDRIVEROOT, NULL, NULL                                                  *
\*                                                                                      */
case WM_SETDRIVEROOT:
/*                                                                                      *\
 * This message is posted to change to the root directory of all local drives, so that  *
 * before another application is startet via the Popup-Menu all local drives are        *
\*                                                                                      */
    SetDriveRoot();                     /* Change to root */
    break;

default:                                /* Default window procedure must be called */
    return((MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

