
/*
 * This file was generated by the SOM Compiler.
 * FileName: Source\WPS2PC2.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

/*
 *
 *                              WPS2PC2.c
 *              Copyright (C) by Stangl Roman, 1994, 1995
 * This Code may be freely distributed, provided the Copyright isn't
 * removed, under the conditions indicated in the documentation.
 *
 * WPS2PC2.C    PC/2's interface to the WPS. This WPS DLL allows you
 *              to drag WPS objects onto, which are then converted
 *              into a format understandable by PC/2. This newly
 *              structure can then be dropped onto PC/2's Setup dialog
 *              to add Menuentries corresponding to the dropped WPS
 *              objects to PC/2's Popup Menu. E.g. this allows you to
 *              create a Menuentry that is equivalent to a WPS DOS
 *              program object, inclusive any DOS settings.
 *
 * SOMObject
 *    WPObject
 *       WPAbstract
 *
 */


#define Wps2Pc2_Class_Source
#include "Wps2Pc2.ih"
                                        /* Header files for classes we use */
#include    <wpObject.h>
#include    <wpFolder.h>
#include    <wpShadow.h>
#include    <wpPgm.h>
#include    <wpDesk.h>
                                        /* Define method wpQueryObjectID which is available
                                           but not documented in wpObject.h (as are about
                                           20 other methods too) */
/*
 * New Method: wpQueryObjectID
 */
typedef PSZ SOMLINK somTP_WPObject_wpQueryObjectID(WPObject *somSelf);
#pragma linkage(somTP_WPObject_wpQueryObjectID, system)
typedef somTP_WPObject_wpQueryObjectID *somTD_WPObject_wpQueryObjectID;
#define somMD_WPObject_wpQueryObjectID "----"
#define WPObject_wpQueryObjectID(somSelf)\
        (SOM_Resolve(somSelf, WPObject, wpQueryObjectID)\
        (somSelf))
#define _wpQueryObjectID WPObject_wpQueryObjectID

                                        /* C Header files */
#include    <stdio.h>
#include    <string.h>

typedef struct  _DLLPC2WPS              DLLPC2WPS;
typedef struct  _CLIENTWINDOW           CLIENTWINDOW;

struct          _DLLPC2WPS
{
    HMODULE     hDLLWps2Pc2;            /* Handle of WPS2PC2.DLL */
    HAB         habWps2Pc2;             /* Anchor block of the window we create */
    HWND        hwndFrameWps2Pc2;       /* Frame window handle */
    HWND        hwndClientWps2Pc2;      /* Client window handle */
    Wps2Pc2    *psomSelf;               /* Pointer to WPS 2 PC/2 instance. We just assume that
                                           WPS 2 PC/2 just exists once (i.e. it is installed once
                                           and is never copied...) */
    USEITEM     UseItem;                /* Global class usage information */
    VIEWITEM    ViewItem;               /* Global class view information */
    PBYTE       pbSharedMem;            /* Pointer to unnamed shared memory allocated with
                                           DosAllocSharedMem() which is passed to PC2.EXE
                                           during Drag'n Drop and retrieved by DosGetSharedMem().
                                           This pointer is NULL when nothing is allocated. */
    PBYTE       pbSharedMemNextFree;    /* Because shared memory is allocated by not commited
                                           this pointer points to the next free space in shared
                                           memory. It is commited during handling the exception
                                           of the first access.
                                           This pointer is NULL when nothing is allocated. */
    WPSOBJECTLIST
               *pListRoot;              /* Pointer to the first element of the LIST of WPS
                                           Objects extracted from the WPS for the root
                                           recursion depth.
                                           This pointer is NULL if nothing has been extracted
                                           from the WPS, or the user has pressed the Clear
                                           button. */
};

DLLPC2WPS   DLLPc2Wps;                  /* WPS2PC2 WPS DLL control structure */

struct          _CLIENTWINDOW
{
    PSZ         pszClass;
    PSZ         pszName;
    ULONG       flStyle;
    POINTL      ptlPosition;
    POINTL      ptlSize;
    ULONG       Id;
};

CLIENTWINDOW    FrameArea=
    {NULL      , ""                     , 0,
        {9  , 10 }, {266, 126}, 0};

CLIENTWINDOW    StatusArea=
    {NULL      , ""                     , 0,
        {200, 70 }, {27 , 20 }, WPBM_STATUSBITMAP};

CLIENTWINDOW    ClientArea[]= {
    {WC_STATIC , "WPS Objects extracted:", WS_VISIBLE | SS_TEXT | DT_CENTER,
        {5  , 115}, {175, 8  }, WPTF_EXTRACTEDOBJECTS},
    {WC_STATIC , "Status:"               , WS_VISIBLE | SS_TEXT | DT_CENTER,
        {200, 115}, {50 , 8  }, WPTF_STATUSBITMAP},
    {WC_LISTBOX, ""                      , WS_VISIBLE | WS_GROUP | LS_HORZSCROLL,
        {5  , 5  }, {175, 106}, WPLB_EXTRACTEDOBJECTS},
    {WC_BUTTON , "~Clear"                , WS_VISIBLE | WS_GROUP | BS_PUSHBUTTON | BS_DEFAULT,
        {207, 25 }, {40 , 14 }, WPPB_CLEAR},
    {WC_BUTTON , "~Help"                 , WS_VISIBLE | BS_PUSHBUTTON,
        {207, 5  }, {40 , 14 }, WPPB_HELP} };
#define         CLIENTAREASIZE          (sizeof(ClientArea)/sizeof(ClientArea[0]))

/*
 *
 *  OVERRIDE: wpDragOver                                                     ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called when a WPS Object is dragged over the WPS 2 PC2 icon. Accept object if
 *       rendering method DRM_OBJECT and format DRF_OBJECT.
 *
 */

SOM_Scope MRESULT   SOMLINK Wps2Pc2X_wpDragOver(Wps2Pc2 *somSelf,
                HWND hwndCnr,
                PDRAGINFO pdrgInfo)
{
    ULONG   ulItemIndex, ulItemCount;   /* Drag'n Drop counters */
    USHORT  usDORResponse;              /* Drag'n Drop response (DOR_DROP|DOR_NEVERDROP) */

    Wps2Pc2Data *somThis = Wps2Pc2GetData(somSelf);
    Wps2Pc2MethodDebug("Wps2Pc2","Wps2Pc2X_wpDragOver");

    usDORResponse=DOR_DROP;             /* Assume we can accept the instances dropped */
                                        /* Get the number of instances dropped */
    ulItemCount=DrgQueryDragitemCount(pdrgInfo);
    for(ulItemIndex=0; ulItemIndex<ulItemCount;ulItemIndex++)
        {                               /* All instances dropped must be of an WPS object class */
        DRAGITEM    Dragitem;

        DrgQueryDragitem(pdrgInfo, sizeof(Dragitem), &Dragitem, ulItemIndex);
                                        /* WPS objects have a rendering protocol of
                                           DRM_OBJECT, DRF_OBJECT */
        if(!(DrgVerifyRMF(&Dragitem, "DRM_OBJECT", "DRF_OBJECT")))
            {                           /* It isn't a WPS object, don't accept all instances dropped */
            usDORResponse=DOR_NEVERDROP;
            }
        }
    return(MPFROM2SHORT(usDORResponse, DO_UNKNOWN));
/*
 *  return (parent_wpDragOver(somSelf,hwndCnr,pdrgInfo));
 */
}

/*
 *
 *  OVERRIDE: wpDrop                                                         ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called when a WPS Object was dropped over the WPS 2 PC2 icon. Query all objects
 *       dropped, allocate a unnamed shared memory, copy object data into and allow this
 *       shared memory to be dragged to PC/2, which will add Menuentries according to
 *       the objects dropped.
 *
 */

#pragma handler (ConvertObject2MenuData)
SOM_Scope MRESULT   SOMLINK Wps2Pc2X_wpDrop(Wps2Pc2 *somSelf,
                HWND hwndCnr,
                PDRAGINFO pdrgInfo,
                PDRAGITEM pdrgItem)
{
    WPObject   *pWPObjectDropped;       /* WPS instance dropped */
    WPSOBJECTLIST
               *pListInsert;            /* WPS Object extracted */

    Wps2Pc2Data *somThis = Wps2Pc2GetData(somSelf);
    Wps2Pc2MethodDebug("Wps2Pc2","Wps2Pc2X_wpDrop");

                                        /* Allocate unnamed shared memory if required */
    if(!DLLPc2Wps.pbSharedMem) AllocateSharedMem();
                                        /* In DRAGITEM->ulItemID is a pointer to the WPS
                                           instance dropped. This pointer is also available
                                           for non WPS programs, but points not in their address
                                           spaces, so using it only makes sense for WPS
                                           programs running in the WPS address space */
    pWPObjectDropped=OBJECT_FROM_PREC(pdrgItem->ulItemID);
                                        /* Now convert the WPS object classes into a WPSOBJECTLIST
                                           type list structure, sub-allocated in the unnamed shared
                                           memory allocated by AllocateSharedMem(). The list of
                                           PROGDETAILS and UCHAR[] elements (for WPProgram and
                                           WPFolder WPS objects) is recursively filled by
                                           ConvertObject2MenuData() starting with recursion depth 1.
                                           The shared memory can subsequently be dragged onto PC/2's
                                           Config dialog from where the LIST is converted to menuitems of
                                           PC/2's Popup-Menu */
    pListInsert=ConvertObject2MenuData(pWPObjectDropped, 1);
                                        /* We insert the newly extracted element as the last LIST
                                           element into the LIST DLLPc2Wps.pListRoot. pListRoot
                                           is NULL for the first dropping from WPS or after pressing
                                           the Clear button or points to previously extracted elements
                                           otherwise */
    if(DLLPc2Wps.pListRoot)
        {                               /* If this is not the first LIST element to insert, insert
                                           at the end of the list */
        WPSOBJECTLIST  *pListTemp;

                                        /* Find the last element, which is the one that has nothing
                                           following */
        for(pListTemp=DLLPc2Wps.pListRoot; pListTemp->pNext; pListTemp=pListTemp->pNext);
                                        /* Insert it */
        pListTemp->pNext=pListInsert;
        }
    else
        {                               /* If this is the first LIST element to insert, set it as
                                           the first element */
        DLLPc2Wps.pListRoot=pListInsert;
        }
                                        /* Invalidate client area (if available) to redraw status bitmap */
    if(DLLPc2Wps.hwndFrameWps2Pc2)
        WinInvalidateRect(DLLPc2Wps.hwndClientWps2Pc2, NULL, FALSE);
    return (parent_wpDrop(somSelf,hwndCnr,pdrgInfo,pdrgItem));
}

/*
 *
 *  OVERRIDE: wpModifyPopupMenu                                              ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Overwrite to add the "Open->WPS 2 PC/2" menuitem to the "Open->" context menu.
 *
 */

SOM_Scope BOOL   SOMLINK Wps2Pc2X_wpModifyPopupMenu(Wps2Pc2 *somSelf,
                HWND hwndMenu,
                HWND hwndCnr,
                ULONG iPosition)
{
    Wps2Pc2Data *somThis = Wps2Pc2GetData(somSelf);
    Wps2Pc2MethodDebug("Wps2Pc2","Wps2Pc2X_wpModifyPopupMenu");

                                        /* Insert "WPS 2 PC/2" as a submenu menuitem into
                                           the "Open->" menuitem of the context menu */
    _wpInsertPopupMenuItems(somSelf, hwndMenu, 0, DLLPc2Wps.hDLLWps2Pc2,
        ID_WPS2PC2OPENMENU, WPMENUID_OPEN);

    return (parent_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition));
}

/*
 *
 *  OVERRIDE: wpMenuItemHelpSelected                                         ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called when receiving an help event from our menuitem we added to the context menu.
 *
 */

SOM_Scope BOOL   SOMLINK Wps2Pc2X_wpMenuItemHelpSelected(Wps2Pc2 *somSelf,
                ULONG MenuId)
{
    Wps2Pc2Data *somThis = Wps2Pc2GetData(somSelf);
    Wps2Pc2MethodDebug("Wps2Pc2","Wps2Pc2X_wpMenuItemHelpSelected");

                                        /* Display help */
    if(MenuId==ID_WPS2PC2OPEN)
        return(_wpDisplayHelp(somSelf, ID_WPS2PC2MAINWINDOW, PC2_WPS2PC2_HELP));
    return(FALSE);
/*
 *  return (parent_wpMenuItemHelpSelected(somSelf,MenuId));
 */
}

/*
 *
 *  OVERRIDE: wpMenuItemSelected                                             ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called when receiving an event from our menuitem we added to the context menu.
 *
 */

SOM_Scope BOOL   SOMLINK Wps2Pc2X_wpMenuItemSelected(Wps2Pc2 *somSelf,
                HWND hwndFrame,
                ULONG ulMenuId)
{
    Wps2Pc2Data *somThis = Wps2Pc2GetData(somSelf);
    Wps2Pc2MethodDebug("Wps2Pc2","Wps2Pc2X_wpMenuItemSelected");

                                        /* Switch according to the menuitem selected */
    switch(ulMenuId)
    {
                                        /* "Open -> WPS 2 PC/2" is the only thing we
                                            handle, other selections are passed on to WPS */
    case ID_WPS2PC2OPEN:
                                        /* Using wpViewOpen() instead of wpOpen() allows to
                                           switch to an open view instead of opening another
                                           instance */
        _wpViewObject(somSelf, NULLHANDLE, ID_WPS2PC2OPENMENU, 0);
        break;

    default:
        return(parent_wpMenuItemSelected(somSelf, hwndFrame, ulMenuId));
    }
    return(TRUE);                       /* We have processed the message */
/*
 *  return (parent_wpMenuItemSelected(somSelf,hwndFrame,ulMenuId));
 */
}

/*
 *
 *  OVERRIDE: wpOpen                                                         ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called when the WPS2PC2 WPS icon gets opened via the context menu.
 *
 *
 * Class override methods.
 */

SOM_Scope HWND   SOMLINK Wps2Pc2X_wpOpen(Wps2Pc2 *somSelf,
                HWND hwndCnr,
                ULONG ulView,
                ULONG param)
{
    Wps2Pc2Data *somThis = Wps2Pc2GetData(somSelf);
    Wps2Pc2MethodDebug("Wps2Pc2","Wps2Pc2X_wpOpen");

                                        /* Switch accoring to identifier selected */
    switch(ulView)
    {
                                        /* "Open -> WPS 2 PC/2" is the only thing we
                                            handle, other selections are passed on to WPS */
    case ID_WPS2PC2OPENMENU:
        if(!_wpSwitchTo(somSelf, ulView))
            {
            HAB         hab;
            FRAMECDATA  fcdFrameCtrlData;
            SWP         swp;

                                        /* Save the instance going to be opened (We assume
                                           that only one instance is opened) */
            DLLPc2Wps.psomSelf=somSelf;
                                        /* Get an anchor block */
            hab=WinQueryAnchorBlock(HWND_DESKTOP);
                                        /* Register class */
            WinRegisterClass(hab, PC2_CLASSNAME_WPS2PC2, (PFNWP)WPS2PC2_MainWindowProc,
                CS_CLIPSIBLINGS | CS_SYNCPAINT, 0);
                                        /* Create the WPS 2 PC/2 window consisting of a frame
                                           window and a client as its child */
            fcdFrameCtrlData.cb=sizeof(FRAMECDATA);
            fcdFrameCtrlData.flCreateFlags=FCF_WPS2PC2WINDOW;
            fcdFrameCtrlData.hmodResources=DLLPc2Wps.hDLLWps2Pc2;
            fcdFrameCtrlData.idResources=ID_WPS2PC2MAINWINDOW;
            DLLPc2Wps.hwndFrameWps2Pc2=WinCreateWindow(
                HWND_DESKTOP, WC_FRAME, _wpQueryTitle(somSelf), WS_CLIPCHILDREN,
                0, 0, 0, 0, NULLHANDLE, HWND_TOP, 269,
                (PVOID)&fcdFrameCtrlData, NULL);
            if(!DLLPc2Wps.hwndFrameWps2Pc2)
                DebugBox("WPS 2 PC/2", "Creating frame failed");
            DLLPc2Wps.hwndClientWps2Pc2=WinCreateWindow(
                DLLPc2Wps.hwndFrameWps2Pc2, PC2_CLASSNAME_WPS2PC2, NULL, WS_CLIPCHILDREN,
                0, 0, 0, 0, DLLPc2Wps.hwndFrameWps2Pc2, HWND_TOP, FID_CLIENT,
                0, NULL);
            if(!DLLPc2Wps.hwndClientWps2Pc2)
                {
                WinDestroyWindow(DLLPc2Wps.hwndFrameWps2Pc2);
                DebugBox("WPS 2 PC/2", "Creating client failed");
                }
            WinSendMsg(DLLPc2Wps.hwndFrameWps2Pc2, WM_SETICON, MPFROMP(_wpQueryIcon(somSelf)), NULL);
            DLLPc2Wps.habWps2Pc2=WinQueryAnchorBlock(DLLPc2Wps.hwndFrameWps2Pc2);
                                        /* Set window title and position */
            WinSetWindowText(DLLPc2Wps.hwndFrameWps2Pc2, PC2_WPS2PC2_WINDOW);
            WinQueryTaskSizePos(DLLPc2Wps.habWps2Pc2, 0, &swp);
            swp.fl=SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_ZORDER;
            swp.cx=FrameArea.ptlSize.x,
            swp.cy=FrameArea.ptlSize.y,
            swp.hwndInsertBehind=HWND_TOP;
            swp.hwnd=DLLPc2Wps.hwndFrameWps2Pc2;
            WinSetMultWindowPos(DLLPc2Wps.habWps2Pc2, &swp, 1);
            WinShowWindow(DLLPc2Wps.hwndFrameWps2Pc2, TRUE);
                                        /* Return window handle of created window */
            return(DLLPc2Wps.hwndFrameWps2Pc2);
            }
        break;

    default:
        return(parent_wpOpen(somSelf, hwndCnr, ulView, param));
    }
    return(NULLHANDLE);
/*
 * return (parent_wpOpen(somSelf,hwndCnr,ulView,param));
 */
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta
/*
 *
 *  OVERRIDE: wpclsQueryIconData                                             ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called when querying the class's icon.
 *
 */

SOM_Scope ULONG   SOMLINK Wps2Pc2C_wpclsQueryIconData(M_Wps2Pc2 *somSelf,
                PICONINFO pIconInfo)
{
    /* M_Wps2Pc2Data *somThis = M_Wps2Pc2GetData(somSelf); */
    M_Wps2Pc2MethodDebug("M_Wps2Pc2","Wps2Pc2C_wpclsQueryIconData");

                                        /* Fill in class's icon information */
    if(pIconInfo)
        {
        pIconInfo->fFormat=ICON_RESOURCE;
        pIconInfo->hmod=DLLPc2Wps.hDLLWps2Pc2;
        pIconInfo->resid=ID_WPS2PC2MAINWINDOW;
        }
    return(sizeof(ICONINFO));

/*
 *  return (parent_wpclsQueryIconData(somSelf,pIconInfo));
 */
}

/*
 *
 *  OVERRIDE: wpclsInitData                                                  ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called during class initalization.
 *
 */

SOM_Scope void   SOMLINK Wps2Pc2C_wpclsInitData(M_Wps2Pc2 *somSelf)
{
    UCHAR   ucBuffer[256];              /* Error message buffer */
    ULONG   ulControlSize;
    ULONG   ulTemp;

    /* M_Wps2Pc2Data *somThis = M_Wps2Pc2GetData(somSelf); */
    M_Wps2Pc2MethodDebug("M_Wps2Pc2","Wps2Pc2C_wpclsInitData");

                                        /* Initialized control structure */
    memset((void *)&DLLPc2Wps, '\0', sizeof(DLLPc2Wps));
                                        /* Get module handle to extract resources from */
    DosLoadModule((PSZ)ucBuffer, sizeof(ucBuffer), "WPS2PC2", &DLLPc2Wps.hDLLWps2Pc2);
                                        /* Map dialog coordinates from dialog editor to
                                           window coordinates */
    WinMapDlgPoints(HWND_DESKTOP, &FrameArea.ptlPosition, 1, TRUE);
    WinMapDlgPoints(HWND_DESKTOP, &FrameArea.ptlSize, 1, TRUE);
    ulControlSize=WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER);
    FrameArea.ptlSize.x+=ulControlSize*2;
    FrameArea.ptlSize.y+=WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
    FrameArea.ptlSize.y+=ulControlSize*2;
    WinMapDlgPoints(HWND_DESKTOP, &StatusArea.ptlPosition, 1, TRUE);
    WinMapDlgPoints(HWND_DESKTOP, &StatusArea.ptlSize, 1, TRUE);
    for(ulTemp=0; ulTemp<CLIENTAREASIZE; ulTemp++)
        {
        WinMapDlgPoints(HWND_DESKTOP, &ClientArea[ulTemp].ptlPosition, 1, TRUE);
        ClientArea[ulTemp].ptlPosition.x+=ulControlSize;
        ClientArea[ulTemp].ptlPosition.y+=ulControlSize;
        WinMapDlgPoints(HWND_DESKTOP, &ClientArea[ulTemp].ptlSize, 1, TRUE);
        }

    parent_wpclsInitData(somSelf);
}

/*
 *
 *  OVERRIDE: wpclsUnInitData                                                ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Called during class termination.
 *
 */

SOM_Scope void   SOMLINK Wps2Pc2C_wpclsUnInitData(M_Wps2Pc2 *somSelf)
{
    /* M_Wps2Pc2Data *somThis = M_Wps2Pc2GetData(somSelf); */
    M_Wps2Pc2MethodDebug("M_Wps2Pc2","Wps2Pc2C_wpclsUnInitData");

    parent_wpclsUnInitData(somSelf);
}

/*
 *
 *  OVERRIDE: wpclsQueryDefaultHelp                                          ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Add default halp panels for WPS2PC2.
 *
 */

SOM_Scope BOOL   SOMLINK Wps2Pc2C_wpclsQueryDefaultHelp(M_Wps2Pc2 *somSelf,
                PULONG pHelpPanelId,
                PSZ pszHelpLibrary)
{
    /* M_Wps2Pc2Data *somThis = M_Wps2Pc2GetData(somSelf); */
    M_Wps2Pc2MethodDebug("M_Wps2Pc2","Wps2Pc2C_wpclsQueryDefaultHelp");

    if(pHelpPanelId)                    /* Set default help panel ID */
        *pHelpPanelId=ID_WPS2PC2MAINWINDOW;
    if(pszHelpLibrary)                  /* Copy WPS 2 PC/2 help file name */
        strcpy(pszHelpLibrary, PC2_WPS2PC2_HELP);
    return(TRUE);

/*
 *  return (parent_wpclsQueryDefaultHelp(somSelf,pHelpPanelId,pszHelpLibrary));
 */
}

/*
 *  OVERRIDE: wpclsQueryDefaultView                                          ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Returns the default view for a new instance of this object, but WPS2PC2 should
 *       be used only once, we just tell what the default open view is.
 */

SOM_Scope ULONG   SOMLINK Wps2Pc2C_wpclsQueryDefaultView(M_Wps2Pc2 *somSelf)
{
    /* M_Wps2Pc2Data *somThis = M_Wps2Pc2GetData(somSelf); */
    M_Wps2Pc2MethodDebug("M_Wps2Pc2","Wps2Pc2C_wpclsQueryDefaultView");

                                        /* Return default view to be the program not
                                           the settings */
    return(ID_WPS2PC2OPENMENU);
/*
 *   return (parent_wpclsQueryDefaultView(somSelf));
 */
}

/*
 *
 *  OVERRIDE: wpclsQueryStyle                                                ( ) Private
 *                                                                           (x) Public
 *  DESCRIPTION:
 *       Returns the default style, used to inhibit creation of shadows, copies or
 *       templates because WPS 2 PC/2 supports only one instance systemwide.
 *
 */

SOM_Scope ULONG   SOMLINK Wps2Pc2C_wpclsQueryStyle(M_Wps2Pc2 *somSelf)
{
    /* M_Wps2Pc2Data *somThis = M_Wps2Pc2GetData(somSelf); */
    M_Wps2Pc2MethodDebug("M_Wps2Pc2","Wps2Pc2C_wpclsQueryStyle");

    return(parent_wpclsQueryStyle(somSelf) | CLSSTYLE_NEVERLINK | CLSSTYLE_NEVERTEMPLATE |
        CLSSTYLE_NEVERCOPY);
/*
 *  return (parent_wpclsQueryStyle(somSelf));
 */
}

#undef  SOM_CurrentClass

/*
 *
 *  FUNCTION: ConvertObject2MenuData()                                       (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *       Called when a WPS instances have been dropped over WPS2PC2 to query the
 *       instances data, allocate MENUDATA structures in unnamed shared memory and
 *       convert WPS object data into a WPSOBJECTLIST LIST understandable by PC/2.
 *
 */

WPSOBJECTLIST *
        ConvertObject2MenuData(WPObject *pWPObject, ULONG ulRecursionLevel)
{
                                        /* Buffer to write WPS Object title into
                                           WPLB_EXTRACTEDOBJECTS */
    static UCHAR
                ucObjectTitle[CCHMAXPATH];
    PSZ         pszObjectTitle;         /* WPS instance title */
    PSZ         pszObjectClass;         /* WPS instancs class */
    PSZ         pszObjectID;            /* Object ID of "WPObject" dropped, which we take
                                           if it isn't a "WPFolder" or "WPProgram" class
                                           WPS Object */
    UCHAR      *pucFilter;              /* Filter \x0A (LF) characters from the string which
                                           will be used in a MENUDATA.PgmTitle element */
    SOMClass   *pObjectClass;           /* SOM Class definitions for dropped instance */
    SOMClass   *pSOMFolderClass;        /* SOM Class definition for "WPFolder" class */
    SOMCLASS   *pSOMProgramClass;       /* SOM Class definition for "WPProgram" class */
    SOMCLASS   *pSOMShadowClass;        /* SOM Class definition for "WPShadow" class */
    WPSOBJECTLIST
               *pListSelf;              /* WPS object saved into list element which can then be
                                           chained into the list */
    VOID       *pData;                  /* Pointer to the Data element of the LIST WPSOBJECTLIST
                                           structure */
    ULONG       ulProgramDetailsSize;   /* Size of the PROGDETAILS extracted from the WPS, inserted as
                                           the Data element into the LIST for WPProgram objects */

                                        /* Get instance's title */
    pszObjectTitle=_wpQueryTitle(pWPObject);
                                        /* Get instance's class */
    pszObjectClass=(PSZ)_somGetClassName(pWPObject);
                                        /* Get classes of dropped instance and SOM classes it
                                           may belong to */
    pObjectClass=_somClassFromId(SOMClassMgrObject, SOM_IdFromString(pszObjectClass));
                                        /* Get classes for "WPFolder" and "WPFileSytem" */
    pSOMFolderClass=_somClassFromId(SOMClassMgrObject, SOM_IdFromString("WPFolder"));
                                        /* Get class for "WPProgram" */
    pSOMProgramClass=_somClassFromId(SOMClassMgrObject, SOM_IdFromString("WPProgram"));
                                        /* Get class for "WPShadow" */
    pSOMShadowClass=_somClassFromId(SOMClassMgrObject, SOM_IdFromString("WPShadow"));
                                        /* Fill buffer with spaces, because the number of spaces
                                           preceeding the WPS Object title is a measure of the
                                           current recursion depth */
    memset(ucObjectTitle, ' ', sizeof(ucObjectTitle));
    ucObjectTitle[sizeof(ucObjectTitle)-1]='\0';
                                        /* If the Object is a WPShadow, query original and
                                           get data necessary to extract the original Object */
    if(_somDescendedFrom(pObjectClass, pSOMShadowClass))
        {
        pWPObject=_wpQueryShadowedObject(pWPObject, FALSE);
        pszObjectClass=(PSZ)_somGetClassName(pWPObject);
        pObjectClass=_somClassFromId(SOMClassMgrObject, SOM_IdFromString(pszObjectClass));
        }
                                        /* Try to get the WPObject's ObjectID, which we use
                                           for Objects not being of type WPFolder or WPProgram */
    pszObjectID=_wpQueryObjectID(pWPObject);
                                        /* If the current instance is of class "WPProgram" then
                                           query its program details */
    if(_somDescendedFrom(pObjectClass, pSOMProgramClass))
        {
                                        /* Allocate a WPSOBJECTLIST structure for the current
                                           WPProgram type WPS object */
        pListSelf=(WPSOBJECTLIST *)GetFreeSharedMem(sizeof(WPSOBJECTLIST));
        pListSelf->ulType=WPSOBJECTPROGRAM;
                                        /* First request program details, but provide no
                                           space to copy them into. The WPS method returns
                                           the required space then */
        ulProgramDetailsSize=0;
        _wpQueryProgDetails(pWPObject , NULL, &ulProgramDetailsSize);
                                        /* Now allocate required space from shared memory */
        pData=(VOID *)GetFreeSharedMem(++ulProgramDetailsSize);
                                        /* Now we can actually get the details data. Accessing
                                           the allocated shared memory may create an access violation,
                                           which calls the exception handler to commit the memory */
        _wpQueryProgDetails(pWPObject, (PROGDETAILS *)pData, &ulProgramDetailsSize);
                                        /* Link the PROGDETAILS into the WPSOBJECTLIST structure
                                           of the newly extracted WPProgram */
        pListSelf->pData=pData;
                                        /* Replace \x0A chars by spaces */
        for(pucFilter=strchr(((PROGDETAILS *)pListSelf->pData)->pszTitle, '\n');
            pucFilter;
            pucFilter=strchr(pucFilter+1, '\n'))
            *pucFilter=' ';
                                        /* If status window is available add WPProgram's object
                                           title to listbox */
        strcpy(ucObjectTitle+((ulRecursionLevel-1)<<2), ((PROGDETAILS *)pListSelf->pData)->pszTitle);
        if(DLLPc2Wps.hwndFrameWps2Pc2)
            WinSendMsg(WinWindowFromID(DLLPc2Wps.hwndFrameWps2Pc2, WPLB_EXTRACTEDOBJECTS),
                LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucObjectTitle));
        return(pListSelf);              /* Return the newly created WPProgram element */
        }

                                        /* If the current instance is of class "WPFolder" then
                                           recursively chain into the folder */
    if(_somDescendedFrom(pObjectClass, pSOMFolderClass))
        {
                                        /* Allocate a WPSOBJECTLIST structure for the current
                                           WPFolder type WPS object */
        pListSelf=(WPSOBJECTLIST *)GetFreeSharedMem(sizeof(WPSOBJECTLIST));
        pListSelf->ulType=WPSOBJECTFOLDER;
                                        /* Now allocate required space from shared memory */
        if(pszObjectTitle)
            {
            pData=(VOID *)GetFreeSharedMem(strlen(pszObjectTitle)+1);
                                        /* Copy the folder's name used on the WPS */
            strcpy(pData, pszObjectTitle);
            }
        else
            {
            pData=(VOID *)GetFreeSharedMem(strlen("Unknown")+1);
                                        /* Copy the folder's name used on the WPS */
            strcpy(pData, "Unknown");
            }
                                        /* Link the folder's name into the LIST WPSOBJECTLIST
                                           structure of the newly extracted WPFolder */
        pListSelf->pData=pData;
                                        /* Replace \x0A chars by spaces */
        for(pucFilter=strchr((char *)pListSelf->pData, '\n');
            pucFilter;
            pucFilter=strchr(pucFilter+1, '\n'))
            *pucFilter=' ';
        strcpy(ucObjectTitle+((ulRecursionLevel-1)<<2), pListSelf->pData);
        strcat(ucObjectTitle, " >>");
                                        /* If status window is available add WPFolder's object
                                           title to listbox */
        if(DLLPc2Wps.hwndFrameWps2Pc2)
            WinSendMsg(WinWindowFromID(DLLPc2Wps.hwndFrameWps2Pc2, WPLB_EXTRACTEDOBJECTS),
                LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucObjectTitle));
                                        /* Populate folder */
        if(_wpPopulate(pWPObject, 0L, (PSZ)pListSelf->pData, FALSE))
            {
            WPObject       *pWPObjectInFolder;
            WPSOBJECTLIST  *pListObjectInFolder;

                                        /* Enumerate folder and recurively call this
                                           function again to chain through whole tree like
                                           folder structure (depth-first search) */
            for(pWPObjectInFolder=_wpQueryContent(pWPObject, pWPObjectInFolder, QC_FIRST);
                pWPObjectInFolder!=NULL;
                pWPObjectInFolder=_wpQueryContent(pWPObject, pWPObjectInFolder, QC_NEXT))
                {
                                        /* Call function recursively to extract object by object
                                           in this folder. The returned pointer pListSelf can
                                           subsequently be linked into the LIST pListCurrent */
                pListObjectInFolder=ConvertObject2MenuData(pWPObjectInFolder, ulRecursionLevel+1);
                                        /* Now add the extracted objects within the folder to as
                                           child objects within the current LIST level pListCurrent.
                                           The returned pListObjectInFolder is not NULL only for
                                           WPProgram and WPFolder type WPS Objects */
                if(pListObjectInFolder)
                    {
                    if(pListSelf->pFolder)
                        {               /* If this is not the first element within the current folder
                                           to be inserted, insert it as the last one */
                        WPSOBJECTLIST  *pListTemp;

                                        /* Find the last element, which is the one that has nothing
                                           following */
                        for(pListTemp=pListSelf->pFolder; pListTemp->pNext; pListTemp=pListTemp->pNext);
                        pListTemp->pNext=pListObjectInFolder;
                        }
                    else
                        {               /* If this is the first element within the current folder
                                           to be inserted, insert it as the first one */
                        pListSelf->pFolder=pListObjectInFolder;
                        }
                    }
                }
            }
        return(pListSelf);              /* Return the newly created WPFolder element */
        }
                                        /* If the current object is not of class WPFolder or
                                           WPProgram, the last thing we may try to extract that
                                           may be of use for PC/2 is the ObjectID */
    if(pszObjectID)
        {
                                        /* Allocate a WPSOBJECTLIST structure for the current
                                           WPObject type WPS object */
        pListSelf=(WPSOBJECTLIST *)GetFreeSharedMem(sizeof(WPSOBJECTLIST));
        pListSelf->ulType=WPSOBJECTOBJECT;
        if(pszObjectTitle)
            {
                                        /* Now allocate required space from shared memory */
            pData=(VOID *)GetFreeSharedMem(strlen(pszObjectTitle)+strlen(pszObjectID)+3);
                                        /* Copy the ObjectID used on the WPS */
            strcpy(pData, pszObjectTitle);
            strcat(pData, "@");
            strcat(pData, pszObjectID);
            }
        else
            {
            pData=(VOID *)GetFreeSharedMem(strlen("Unknown")+strlen(pszObjectID)+3);
                                        /* Copy the ObjectID used on the WPS */
            strcpy(pData, "Unknown");
            strcat(pData, "@");
            strcat(pData, pszObjectID);
            }
                                        /* Link the WPObject's ObjectID into the LIST WPSOBJECTLIST
                                           structure of the newly extracted WPObject */
                                        /* If status window is available add WPObjects's
                                           ObjectID to listbox */
        pListSelf->pData=pData;
                                        /* Replace \x0A chars by spaces */
        for(pucFilter=strchr((char *)pListSelf->pData, '\n');
            pucFilter;
            pucFilter=strchr(pucFilter+1, '\n'))
            *pucFilter=' ';
        strcpy(ucObjectTitle+((ulRecursionLevel-1)<<2), pListSelf->pData);
                                        /* If status window is available add WPObjects's
                                           ObjectID to listbox */
        if(DLLPc2Wps.hwndFrameWps2Pc2)
            WinSendMsg(WinWindowFromID(DLLPc2Wps.hwndFrameWps2Pc2, WPLB_EXTRACTEDOBJECTS),
                LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucObjectTitle));
        return(pListSelf);              /* Return the newly created WPObject element */
        }
    return(NULL);                       /* For all other WPS Objects return NULL */
}

/*
 *
 *  FUNCTION: AllocateSharedMem()                                            (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *       This function allocates a memory block of an unnamed shared memory, whose
 *       starting address is passed to PC2.EXE via Drag'n Drop which also frees this
 *       memory (otherwise WPS2PC2.DLL provides a menuitem to free it) before a new
 *       shared memory can be allocated. The allocated memory is not commited, so any
 *       access leads to an access violation, which invokes the exception handler to
 *       commit it.
 *
 */

PBYTE   AllocateSharedMem()
{
    APIRET      rc;                     /* DOS APIs return code */

                                        /* Allocate 128kB unnamed shared memory */
    rc=DosAllocSharedMem((PVOID *)&DLLPc2Wps.pbSharedMem, (PSZ)NULL, 131072,
        OBJ_GIVEABLE | OBJ_GETTABLE | PAG_READ | PAG_WRITE);
                                        /* If successful return it, otherwise return NULL */
    if(rc==NO_ERROR)
        DLLPc2Wps.pbSharedMemNextFree=DLLPc2Wps.pbSharedMem;
    else
        {
        DLLPc2Wps.pbSharedMemNextFree=DLLPc2Wps.pbSharedMem=NULL;
        DebugBox("WPS 2 PC/2", "Allocating shared memory failed");
        }
    return(DLLPc2Wps.pbSharedMem);
}

/*
 *
 *  FUNCTION: GetFreeSharedMem()                                             (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *      This function allocated the next free ulSharedMemSize sized block within the
 *      shared memory allocated by AllocateSharedMem(). Pointer DLLPc2Wps.pbSharedMemNextFree
 *      is updated accordingly.
 *
 */

PBYTE   GetFreeSharedMem(ULONG ulSharedMemSize)
{
    PBYTE       pbSharedMemReturned;

                                        /* We can suballocate only when a shared memory
                                           was allocated before */
    if(DLLPc2Wps.pbSharedMem)
        {
                                        /* Round up to nearest DWORD boundary */
        ulSharedMemSize=(ulSharedMemSize+3)&0xFFFFFFFC;
                                        /* Allocate requested shared memory and clear it */
        pbSharedMemReturned=DLLPc2Wps.pbSharedMemNextFree;
        memset(pbSharedMemReturned, '\0', ulSharedMemSize);
        DLLPc2Wps.pbSharedMemNextFree+=ulSharedMemSize;
                                        /* Return suballocated shared memory */
        return(pbSharedMemReturned);
        }
    else                                /* If no shared memory is available return NULL */
        return(NULL);
}

/*
 *
 *  FUNCTION: DeAllocateSharedMem()                                          (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *       This function deallocates the unnamed shared memory allocated with AllocateSharedMem().
 *       The control structure entries about shared memory are updated accordingly.
 *
 */

void    DeAllocateSharedMem(void)
{
                                        /* Return unnamed shared memory to memory pool */
    DosFreeMem(DLLPc2Wps.pbSharedMem);
    DLLPc2Wps.pbSharedMem=DLLPc2Wps.pbSharedMemNextFree=NULL;
}

/*
 *
 *  FUNCTION: _Exception()                                                   (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *       This function is the exception handler for WPS2PC2.DLL. It is only used to commit
 *       unnamed shared memory, which was allocated uncommited and accessed, leading to an
 *       access violation.
 *
 */

ULONG   _Exception(PEXCEPTIONREPORTRECORD pExcRepRecord,
                   PEXCEPTIONREGISTRATIONRECORD pExcRegRecord,
                   PCONTEXTRECORD pCtxRecord,
                   PVOID  pVoid)
{
                                        /* If exception was an access violation, not being
                                           at an unknown address */
    if((pExcRepRecord->ExceptionNum==XCPT_ACCESS_VIOLATION) &&
        (pExcRepRecord->ExceptionAddress!=(PVOID)XCPT_DATA_UNKNOWN))
        {
                                        /* If it was an read or write violation, commit
                                           shared memory block (current 4096B memory page) */
        if((pExcRepRecord->ExceptionInfo[0]==XCPT_READ_ACCESS) ||
            (pExcRepRecord->ExceptionInfo[0]==XCPT_WRITE_ACCESS) ||
            (pExcRepRecord->ExceptionInfo[1]!=XCPT_DATA_UNKNOWN))
            {
            ULONG   ulMemSize;
            ULONG   ulMemAttrs;
            APIRET  rc;                 /* DOS APIs return code */

            ulMemSize=1;
            rc=DosQueryMem((PVOID)pExcRepRecord->ExceptionInfo[1],
                &ulMemSize, &ulMemAttrs);
                                        /* On error continue exception handler chain
                                           probably leading to a trap */
            if(rc!=NO_ERROR) return(XCPT_CONTINUE_SEARCH);
                                        /* If memory is not commited and free, commit it */
            if(!(ulMemAttrs & (PAG_FREE|PAG_COMMIT)))
                {
                                        /* Commit current 4096B page with same access protection
                                           used during creation */
                rc=DosSetMem((PVOID)pExcRepRecord->ExceptionInfo[1], 4096,
                    PAG_COMMIT|PAG_DEFAULT);
                                        /* On error continue exception handler chain
                                           probably leading to a trap */
                if(rc!=NO_ERROR) return(XCPT_CONTINUE_SEARCH);
                                        /* On success continue execution at access violation */
                else return(XCPT_CONTINUE_EXECUTION);
                }
            }
        }
                                        /* For other exceptions continue handler chain to
                                           next exception handler */
    return(XCPT_CONTINUE_SEARCH);
}

/*
 *
 *  FUNCTION: WPS2PC2_MainWindowProc()                                       (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *       This function is the main window procedure of the window created when selecting
 *       "Open -> WPS 2 PC/2" from the "Open ->" submenu at the context menu.
 *
 */

MRESULT WPS2PC2_MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static HBITMAP  hbmEmpty;           /* Bitmap handle of empty status bitmap */
    static HBITMAP  hbmFull;            /* Bitmap handle of filled status bitmap */
    switch(msg)
    {
    case WM_CREATE:
        {
        ULONG       ulTemp;
        HPS         hpsTemp;

        WinDefWindowProc(hwnd, msg, mp1, mp2);
                                        /* Add the window to the in-use list */
        DLLPc2Wps.UseItem.type=USAGE_OPENVIEW;
        DLLPc2Wps.ViewItem.view=ID_WPS2PC2OPENMENU;
        DLLPc2Wps.ViewItem.handle=DLLPc2Wps.hwndFrameWps2Pc2;
        if(!_wpAddToObjUseList(DLLPc2Wps.psomSelf, &DLLPc2Wps.UseItem))
            DebugBox("WPS 2 PC/2", "wpAddToObjUseList failed");
                                        /* Register the window as a new open view */
        if(!_wpRegisterView(DLLPc2Wps.psomSelf, DLLPc2Wps.hwndFrameWps2Pc2,
            _wpQueryTitle(DLLPc2Wps.psomSelf)))
            DebugBox("WPS 2 PC/2", "wpRegisterView failed");
        for(ulTemp=0; ulTemp<CLIENTAREASIZE; ulTemp++)
            {
            HWND    hwndCtl;

            hwndCtl=WinCreateWindow(DLLPc2Wps.hwndFrameWps2Pc2, ClientArea[ulTemp].pszClass,
                ClientArea[ulTemp].pszName, ClientArea[ulTemp].flStyle,
                ClientArea[ulTemp].ptlPosition.x, ClientArea[ulTemp].ptlPosition.y,
                ClientArea[ulTemp].ptlSize.x, ClientArea[ulTemp].ptlSize.y,
                DLLPc2Wps.hwndFrameWps2Pc2, HWND_TOP,
                ClientArea[ulTemp].Id, 0, NULL);
            if(!hwndCtl)
                DebugBox("WPS 2 PC/2", "Creating windows in client area failed");
            }
                                        /* Insert LIST into listbox (the called function
                                           takes care of a possibly empty LIST */
        FillList2Listbox(DLLPc2Wps.pListRoot, 1);
                                        /* Get a PS to load status bitmaps */
        hpsTemp=WinBeginPaint(hwnd, NULLHANDLE, NULL);
        hbmEmpty=GpiLoadBitmap(hpsTemp, DLLPc2Wps.hDLLWps2Pc2, WPBM_EMPTY, 0, 0);
        hbmFull=GpiLoadBitmap(hpsTemp, DLLPc2Wps.hDLLWps2Pc2, WPBM_FULL, 0, 0);
        WinEndPaint(hpsTemp);
                                        /* Set focus to client area */
        WinSetFocus(HWND_DESKTOP, hwnd);
        }
        break;

    case WM_PAINT:
        {
        HPS         hpsClient;
        RECTL       rectlClient;


        hpsClient=WinBeginPaint(hwnd, NULLHANDLE, &rectlClient);
        WinFillRect(hpsClient, &rectlClient, CLR_WHITE);
        if(DLLPc2Wps.pListRoot)
            {                           /* If at least one WPS Object has been extracted
                                           already, draw filled status bitmap */
            WinDrawBitmap(hpsClient, hbmFull, NULL, &StatusArea.ptlPosition, 0, 0, DBM_NORMAL);
            }
        else
            {                           /* If no WPS Object has been extracted, draw
                                           empty status bitmap */
            WinDrawBitmap(hpsClient, hbmEmpty, NULL, &StatusArea.ptlPosition, 0, 0, DBM_NORMAL);

            }
        WinEndPaint(hpsClient);
        break;
        }

    case WM_BEGINDRAG:
        {
        DRAGINFO   *pDraginfo;
        DRAGITEM    Dragitem;
        DRAGIMAGE   Dragimage;
        HPS         hpsTemp;
        HWND        hwndTarget;

        if(!DLLPc2Wps.pbSharedMem)      /* If nothing is available to be dragged,
                                           don't accept Drag'n Drop request */
            break;
        hpsTemp=WinBeginPaint(hwnd, NULLHANDLE, NULL);
        pDraginfo=DrgAllocDraginfo(1);  /* Allocate and initialize a DRAGINFO structure */
        pDraginfo->cbDraginfo=sizeof(DRAGINFO);
        pDraginfo->cbDragitem=sizeof(DRAGITEM);
        pDraginfo->usOperation=DO_MOVE; /* The shared memory passed during Drag'n Drop is
                                           moved, that is freed in WPS2PC2.DLL */
        pDraginfo->hwndSource=hwnd;
        pDraginfo->xDrop=
        pDraginfo->yDrop=0;
        pDraginfo->cditem=1;            /* We drop one item, the pointer to the shared memory */
        pDraginfo->usReserved=0;
                                        /* Initialize the item we drag */
        Dragitem.ulItemID=(ULONG)DLLPc2Wps.pbSharedMem;
        Dragitem.hstrType=DrgAddStrHandle(DRT_WPS2PC2);
        Dragitem.hstrRMF=DrgAddStrHandle(RMF_WPS2PC2);
        Dragitem.hstrContainerName=DrgAddStrHandle(_wpQueryTitle(DLLPc2Wps.psomSelf));
        Dragitem.hstrSourceName=DrgAddStrHandle("");
        Dragitem.hstrTargetName=DrgAddStrHandle("");
        Dragitem.cxOffset=
        Dragitem.cyOffset=0;
                                        /* Object can't be recoverd after move operation */
        Dragitem.fsControl=DC_REMOVEABLEMEDIA;
        Dragitem.fsSupportedOps=DO_MOVEABLE;
                                        /* Initialize the image we drag */
        Dragimage.cb=sizeof(DRAGIMAGE);
        Dragimage.cptl=0;
        Dragimage.hImage=GpiLoadBitmap(hpsTemp, DLLPc2Wps.hDLLWps2Pc2, WPBM_FULL, 0, 0);
                                        /* Size the WPBM_FULL bitmap to icon size and
                                           use it as the image during Drag'n Drop */
        Dragimage.sizlStretch.cx=
        Dragimage.sizlStretch.cy=WinQuerySysValue(HWND_DESKTOP, SV_CXICON);
        Dragimage.fl=DRG_BITMAP | DRG_STRETCH;
        Dragimage.cxOffset=
        Dragimage.cyOffset=0;
                                        /* Add DRAGITEM to DRAGINFO before calling DrgDrag() */
        DrgSetDragitem(pDraginfo, &Dragitem, sizeof(DRAGITEM), 0);
                                        /* Now start dragging */
        hwndTarget=DrgDrag(hwnd, pDraginfo, &Dragimage, 1, VK_ENDDRAG, NULL);
        DrgFreeDraginfo(pDraginfo);
        WinEndPaint(hpsTemp);
        if(hwndTarget)
            {                           /* If Drag'n Drop operation was successfull,
                                           deallocated dragged shared memory */
                                        /* If unnamed shared memory was already allocated
                                           free it */
            DosFreeMem(DLLPc2Wps.pbSharedMem);
            DLLPc2Wps.pbSharedMem=DLLPc2Wps.pbSharedMemNextFree=NULL;
            DLLPc2Wps.pListRoot=NULL;   /* The LIST is empty again */
                                        /* Delete all listbox entries */
            WinSendMsg(WinWindowFromID(DLLPc2Wps.hwndFrameWps2Pc2, WPLB_EXTRACTEDOBJECTS),
                LM_DELETEALL, NULL, NULL);
            }
        }
                                        /* Invalidate client area to redraw status bitmap */
        WinInvalidateRect(DLLPc2Wps.hwndClientWps2Pc2, NULL, FALSE);
        break;

    case WM_COMMAND:
        switch(SHORT1FROMMP(mp1))
        {
        case WPPB_CLEAR:
                                        /* The user has requested to delete the LIST of
                                           WPS Objects extracted so far */
            if(DLLPc2Wps.pbSharedMem)
                {                       /* If unnamed shared memory was already allocated
                                           free it */
                DosFreeMem(DLLPc2Wps.pbSharedMem);
                DLLPc2Wps.pbSharedMem=DLLPc2Wps.pbSharedMemNextFree=NULL;
                }
            DLLPc2Wps.pListRoot=NULL;   /* The LIST is empty again */
                                        /* Delete all listbox entries */
            WinSendMsg(WinWindowFromID(DLLPc2Wps.hwndFrameWps2Pc2, WPLB_EXTRACTEDOBJECTS),
                LM_DELETEALL, NULL, NULL);
                                        /* Invalidate client area to redraw status bitmap */
            WinInvalidateRect(DLLPc2Wps.hwndClientWps2Pc2, NULL, FALSE);
            break;

         case WPPB_HELP:
                                        /* Display help */
            _wpDisplayHelp(DLLPc2Wps.psomSelf, WPID_WPS2PC2DIALOG, PC2_WPS2PC2_HELP);
            break;
        }
        break;

    case WM_CLOSE:
        if(!_wpDeleteFromObjUseList(DLLPc2Wps.psomSelf, &DLLPc2Wps.UseItem))
            DebugBox("WPS 2 PC/2", "wpDeleteFromObjUseList failed");
                                        /* Destray allocated PM resources */
        GpiDeleteBitmap(hbmEmpty);
        GpiDeleteBitmap(hbmFull);
        WinDestroyWindow(DLLPc2Wps.hwndFrameWps2Pc2);
        DLLPc2Wps.hwndFrameWps2Pc2=DLLPc2Wps.hwndClientWps2Pc2=NULLHANDLE;
        break;

    default:                            /* Default window procedure must be called */
        return((MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2));
    }
    return((MRESULT)FALSE);             /* We have handled the message */
}

void *time(void *timer)
{
return(timer);
}

/*
 *
 *  FUNCTION: FillList2Listbox()                                             (x) Private
 *                                                                           ( ) Public
 *  DESCRIPTION:
 *       This function fills the listbox WPLB_EXTRACTEDOBJECT with the current contents of
 *       the LIST DLLPc2Wps.pListRoot. This is necessary, when WPS Objects have been
 *       dropped onto WPS 2 PC/2's Object icon, but the WPS 2 PC/2 Object was not open.
 *       This function is called during WM_CREATE of the window that gets created when
 *       the Object WPS 2 PC/2 is opened.
 *
 */

void    FillList2Listbox(WPSOBJECTLIST *pListRoot, ULONG ulRecursionLevel)
{
                                        /* Buffer to write WPS Object title into
                                           WPLB_EXTRACTEDOBJECTS */
    static UCHAR
                ucObjectTitle[CCHMAXPATH];
    WPSOBJECTLIST
               *pListTemp;

    pListTemp=pListRoot;
    while(pListTemp)
        {                               /* An empty list can't be inserted (test just to be
                                           sure to avoid access vialoations) */
                                        /* Fill buffer with spaces, because the number of spaces
                                           preceeding the WPS Object title is a measure of the
                                           current recursion depth */
        memset(ucObjectTitle, ' ', sizeof(ucObjectTitle));
        if(pListTemp->ulType==WPSOBJECTFOLDER)
            {                           /* If this item was extracted from a WPFolder, pData points
                                           to the character string of a folder's name */
            strcpy(ucObjectTitle+((ulRecursionLevel-1)<<2), (char *)pListTemp->pData);
            strcat(ucObjectTitle, " >>");
            }
        if(pListTemp->ulType==WPSOBJECTPROGRAM)
            {                           /* If this item was extracted from a WPProgram, pData points to
                                           a PROGDETAILS structure, containing the program's properties */
            strcpy(ucObjectTitle+((ulRecursionLevel-1)<<2), ((PROGDETAILS *)pListTemp->pData)->pszTitle);
            }
        if(pListTemp->ulType==WPSOBJECTOBJECT)
            {                           /* If this item was extracted neiter from a WPFolder nor a
                                           WPProgram, but has an ObjectID, pData points to the character
                                           string of the WPObject's ObjectID */
            strcpy(ucObjectTitle+((ulRecursionLevel-1)<<2), (char *)pListTemp->pData);
            }
                                        /* Insert into listbox */
        WinSendMsg(WinWindowFromID(DLLPc2Wps.hwndFrameWps2Pc2, WPLB_EXTRACTEDOBJECTS),
            LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucObjectTitle));
                                        /* If the current LIST element is a folder, insert
                                           recursively the folder contents. The pointer
                                           pTempList->pFolder may be NULL, the function
                                           will return immediately */
        if(pListTemp->ulType==WPSOBJECTFOLDER)
            FillList2Listbox(pListTemp->pFolder, ulRecursionLevel+1);
                                        /* Adjust to next LIST element */
        pListTemp=pListTemp->pNext;
        }
}

