# $Id: unix.mak,v 35004.2 1995/07/04 02:41:50 hawkeye Exp $
########################################################################
#  TinyFugue - programmable mud client
#  Copyright (C) 1994 Ken Keys
#
#  TinyFugue (aka "tf") is protected under the terms of the GNU
#  General Public License.  See the file "COPYING" for details.
#
#  DO NOT EDIT THIS FILE.
#  Any configuration changes should be made to the Config file.
########################################################################

#
# unix section of src/Makefile.
#

CFLAGS     = $(FLAGS)
SHELL      = /bin/sh
BUILDERS   = Makefile


install:  _failmsg _all $(EXE) LIBRARY $(MANPAGE) $(SYMLINK)
	@echo '#####################################################' > exitmsg
	@echo '## TinyFugue installation successful.' >> exitmsg
	@echo "## You can safely delete everything in `cd ..; pwd`". >> exitmsg
	@DIR=`echo $(EXE) | sed 's;/[^/]*$$;;'`; \
	echo ":$(PATH):" | egrep ":$${DIR}:" >/dev/null 2>&1 || \
	{ echo >> exitmsg; \
	  echo "Note:  $$DIR is not in your PATH." >> exitmsg; \
	  echo "To run tf, you will need to type its path name" >> exitmsg; \
	  echo "(e.g., $(EXE))," >> exitmsg; \
	  echo "or add $$DIR to your PATH." >> exitmsg; \
	}

all files:  _all
	@echo '#####################################################' > exitmsg
	@echo '## TinyFugue build successful.' >> exitmsg
	@echo '## Use "make install" to install the files.' >> exitmsg

_all:  tf ../tf-lib/tf-help.idx

_failmsg:
	@echo '#####################################################' > exitmsg
	@echo '#### TinyFugue installation FAILED.' >> exitmsg
	@echo '#### See README for help.' >> exitmsg
	@if [ "$(CC)" = "gcc" ]; then \
	    echo '#### ' >> exitmsg; \
	    echo '#### Perhaps $(CC) is not configured correctly.' >> exitmsg; \
	    echo '#### Before contacting the author, set' >> exitmsg; \
	    echo '#### CC=cc in unix/Config and try again.' >> exitmsg; \
	fi

regexp.o: $(BUILDERS) config.h
	@cd ./regexp; \
	  $(MAKE) CC='$(CC)' CFLAGS='-O' O=o regexp.o 2>$(REGEXP_ERR)
	mv regexp/regexp.o .

tf:     $(OBJS) $(BUILDERS)
	$(CC) $(CFLAGS) -o tf $(OBJS) $(LIBS)
#	@# Some stupid linkers return ok status even if they fail.
	@test -f tf
#	@# ULTRIX's sh errors here if strip isn't found, despite "true".
	-test -z "$(STRIP)" || $(STRIP) tf || true

EXE $(EXE): tf $(BUILDERS)
	-@rm -f $(EXE)
	cp tf $(EXE)
	chmod $(MODE) $(EXE)

SYMLINK $(SYMLINK): $(EXE)
	test -z "$(SYMLINK)" || { rm -f $(SYMLINK) && ln -s $(EXE) $(SYMLINK); }

LIBRARY $(LIBDIR): ../tf-lib/tf-help ../tf-lib/tf-help.idx
	@echo '## Creating library directory...'
#	Overly simplified shell commands, to avoid problems on ultrix
	@if test -z "$(LIBDIR)"; then \
	    echo "LIBDIR is undefined.  Check unix/Config."; false; \
	fi
	-if test -d "$(LIBDIR)"; then true; else \
	    rm -f $(LIBDIR); mkdir $(LIBDIR); \
	fi
	@if test -d "$(LIBDIR)"; then true; else \
	    echo "Can't make $(LIBDIR) directory."; \
	    echo "Make sure there is not already a file with that name."; \
	    false; \
	fi
#	Just in case ultrix didn't understand the above.
	test -d "$(LIBDIR)"
#
#	@#rm -f $(LIBDIR)/*;  # wrong: this would remove local.tf, etc.
	@echo '## Copying library files...'
	cd ../tf-lib; \
	for f in *; do test -f $$f && files="$$files $$f"; done; \
	( cd $(LIBDIR); rm -f $$files tf.help tf.help.index; ); \
	cp $$files $(LIBDIR); \
	cd $(LIBDIR); \
	chmod $(MODE) $$files; chmod ugo-wx $$files
	-rm -f $(LIBDIR)/CHANGES 
	cp ../CHANGES $(LIBDIR)
	chmod $(MODE) $(LIBDIR)/CHANGES; chmod ugo-wx $(LIBDIR)/CHANGES
	chmod $(MODE) $(LIBDIR)
	@echo '## Creating links so old library names still work...'
#	@# note: ln -sf isn't portable.
	@cd $(LIBDIR); \
	rm -f bind-bash.tf;    ln -s  kb-bash.tf   bind-bash.tf;    \
	rm -f bind-emacs.tf;   ln -s  kb-emacs.tf  bind-emacs.tf;   \
	rm -f completion.tf;   ln -s  complete.tf  completion.tf;   \
	rm -f factorial.tf;    ln -s  factoral.tf  factorial.tf;    \
	rm -f file-xfer.tf;    ln -s  filexfer.tf  file-xfer.tf;    \
	rm -f local.tf.sample; ln -s  local-eg.tf  local.tf.sample; \
	rm -f pref-shell.tf;   ln -s  psh.tf       pref-shell.tf;   \
	rm -f space_page.tf;   ln -s  spc-page.tf  space_page.tf;   \
	rm -f speedwalk.tf;    ln -s  spedwalk.tf  speedwalk.tf;    \
	rm -f stack_queue.tf;  ln -s  stack-q.tf   stack_queue.tf;  \
	rm -f worldqueue.tf;   ln -s  world-q.tf   worldqueue.tf;

makehelp: makehelp.c
	$(CC) $(CFLAGS) -o makehelp makehelp.c

../tf-lib/tf-help.idx: ../tf-lib/tf-help
	$(MAKE) -f ../unix/unix.mak CC='$(CC)' CFLAGS='$(FLAGS)' makehelp
	./makehelp < ../tf-lib/tf-help > ../tf-lib/tf-help.idx

MANPAGE $(MANPAGE): $(BUILDERS) tf-$(MANTYPE).man
	cp tf-$(MANTYPE).man $(MANPAGE)
	chmod $(MODE) $(MANPAGE)
	chmod ugo-x $(MANPAGE)

tf-cat.man:  tf-nroff.man
	TERM=vt100; nroff -man tf-nroff.man > tf-cat.man

Makefile: ../unix/Config ../unix/vars.mak ../unix/unix.mak ../unix/tfconfig
	@echo
	@echo "## WARNING: changes in Config, etc. will not be reflected."
	@echo

dist: tf-cat.man ../tf-lib/tf-help.idx

uninstall:
	rm -f $(EXE) $(MANPAGE)
	rm -rf $(LIBDIR)

clean distclean cleanest:
	cd ..; ./unixmake $@


# development stuff, not necessarily portable.

tags: *.[ch]
	ctags -t port.h tf.h *.[ch] 2>/dev/null

dep: *.c
	gcc -E -MM *.c \
		| sed 's;regexp/regexp.h ;;' \
		| sed 's; $$; $$(BUILDERS) ;' \
		> dep

tf.pixie: tf
	pixie -o tf.pixie tf

lint:
	lint -woff 128 $(CCFLAGS) -DHAVE_PROTOTYPES $(SOURCE) $(LIBRARIES)

# The next line is a hack to get around a bug in BSD/386 make.
make:

