/* ========== */
/* setslist.c */
/* ========== */
extern	char	SortCodes[];
/* ====================================================================	*/
/* SetSortList - Sets SortList according to SortSpecs vs OKCodes	*/
/* ====================================================================	*/
PRIVATE	void
SetSortList(char *SortSpecs, char *OKCodes, int *SortList)
{
    for ( ; *SortSpecs; ++SortSpecs)
    {
	char	*NextCode = strchr(SortCodes, *SortSpecs);

	if (NextCode == NULL)
	{
	    printf("Don't know sort code = %c\n",
		*SortSpecs);
	}
	else
	{
	    int     LftShftCt;

	    if (strchr(OKCodes, *SortSpecs))
	    {
		LftShftCt = (int)((sizeof(SortCodes) - 2)
				- (NextCode - SortCodes));
	    }
	    else
	    {
		printf("Improper Sort Code = %c\n",
		    *SortSpecs);
		continue;
	    }

	    *SortList |= (1 << LftShftCt);
	}
    }
}
/* ====================================================================	*/
/* SetSortObjects - Sets SortObjects according to command-line specs	*/
/* ====================================================================	*/
PRIVATE	void
SetSortObjects(char **Argv, char *OKCodes, int  *SortObjects)
{
    /* ---------------------------------------------------------- */
    /* Argv        - (in)  Command-line arguments NULL terminated */
    /* OKCodes     - (in)  Identifiers of acceptable sort targets */
    /* SortObjects - (out) Binary word of Sort-targets specified  */
    /* ---------------------------------------------------------- */

    int     i;
    int     MasterList = 0, NotWanted = 0, Wanted = 0;

    /* -------------------------------------- */
    /* If user wants all sort codes, Geev 'Em */
    /* -------------------------------------- */
    if (OKCodes == (char *) NULL || *OKCodes == EOS)
    {
	OKCodes = SortCodes;
    }

    SetSortList(OKCodes, OKCodes, &MasterList);

    if (MasterList == 0)
    {
	SetSortList(SortCodes, SortCodes, &MasterList);
    }

    for (i = 0; Argv[i]; ++i)
    {
	char	*NextArg = _strupr(Argv[i]);

	if (*NextArg == '-')
	{
	    ++NextArg;
	    SetSortList(NextArg, OKCodes, &NotWanted);
	}
	else				/* '+' or Letter */
	{
	    if (*NextArg == '+')
	    {
		++NextArg;
	    }

	    SetSortList(NextArg, OKCodes, &Wanted);
	}

	/* INDENT OFF */
	/*
	Build Master list of acceptable sort objects
	for all entries in argument list
	    get next Argv
	    Convert to UPPER case
	    if it begins with a '-'
	        bump character pointer over '-'
	        build list of Unwanted sort objects
	    else (assume begins with '+' or Letter)
	        if it begins with '+',
		    bump character pointer over '+'
		end if
	        build list of Wanted sort objects
	    end if-else
	end for

	if Wanted list is not empty
	    set Output list to Wanted list
	else
	    set Output list to exclusive-or of
		Master list and Unwanted list
	*/

	/* INDENT ON */
    }

    if (Wanted)
    {
	*SortObjects = Wanted;
    }
    else
    {
	*SortObjects = MasterList ^ NotWanted;
    }

    if (*SortObjects == 0)
    {
	*SortObjects = MasterList;
    }
}
