/* ============ */
/* tsort.c	*/
/* ============ */
#include <defcodes.h>
#include <assert.h>
/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif
/* INDENT OFF */
extern	void	tsort F((void *, size_t, size_t,
			int (*)(const void *, const void *)));
static	void	TwoWaySort F((long));

static	int	(*Cmpr) F((const void *, const void *));

# undef F

extern long SwapCtr;

static	size_t	DataWidth;
static	char	  *MyBase;
static	char	*TempArea;

/* INDENT ON */

#define DATA(i) (*(int *)(MyBase + ADDR(i-1)))
#define ADDR(i) (ULONG)((ULONG)(i)*((ULONG)DataWidth))

#define CMPR(i, j) (*Cmpr)(From + ADDR(i-1), From + ADDR(j-1))
#define MOVE(i, j)						\
    {								\
	memmove(To + ADDR(j-1), From + ADDR(i-1), DataWidth);	\
	++SwapCtr;						\
    }
#define STOP(Msg)    E1("%s\n", Msg), exit(1);
/* ==================================================================== */
/* tsort - sort a set of elements by the Two-Way Merge Sort method	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
void
tsort(void *Base, size_t Num, size_t Width,
    int(*Compare) (const void *, const void *))
# else
void
tsort(Base, Num, Width, Compare)
void   *Base;
size_t	Num;
size_t	Width;
int	(*Compare)();
# endif
{
    if (Num > 0)
    {
	TempArea = (char *) _halloc(Num, Width);
	D1("tsort(): TempArea = %lp\n", TempArea);

	assert(TempArea != (char *) NULL);

	Cmpr = Compare;
	DataWidth = Width;
	MyBase = Base;

	TwoWaySort((long) Num);

	_hfree(TempArea);
    }
}
/* ==================================================================== */
/* TwoWaySort - Performs Straight Two-way merge-sort algorithm		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
static void
TwoWaySort(long Num)
# else
static void
TwoWaySort(Num)
long	Num;
# endif
{
    char *From	   = TempArea;	   /* For first initialization. */
    char *To	   = MyBase;	   /* For first initialization. */

    int     CmprState, d;
    long    i, j, k, m, p, q, r, x;

    /* ---------------------------------------------------------------- */
    /* Variables i & j point to current positions in source area	*/
    /*		 k & m point to current positions in destination area	*/
    /*		 d is incremental direction of output			*/
    /*		   +1 = forward  (increment)				*/
    /*		   -1 = backward (decrement)				*/
    /*		 p represents number of elements in a run to be merged	*/
    /*		 q & r track number of unmerged elements in a run	*/
    /*		 x is used during side-switching (see comment at S12:)	*/
    /*		 CmprState contains output from comparison function	*/
    /*									*/
    /* Comments that start Sn: coincide with labels in Algorithm S on	*/
    /* page 164 of Knuth, Donald E., "The Art of Computer Programming," */
    /* Volume 3, Sorting and Searching, (Addison-Wesley, 1973)		*/
    /* ---------------------------------------------------------------- */

    for (p = 1; p < Num; p += p)
    {
	/* ---------------------- */
	/* S2:	Prepare for pass. */
	/* ---------------------- */

	{				/* Switch areas. */
	    void    *SwapPtr;

	    SwapPtr = From;
	    From    = To;
	    To	    = SwapPtr;
	}

	i = 1;
	j = Num;
	k = 0;
	m = Num + 1;

	d = 1;
	q = p;
	r = p;

	/* --------------- */
	/* Comparison Loop */
	/* --------------- */
	for (;;)
	{
	    /* -------------------- */
	    /* S3:  Compare Ki : Kj */
	    /* -------------------- */
	    CmprState = CMPR(i, j);

	    if (CmprState <= 0)
	    {
		/* ----------------- */
		/* S4:	Transmit Ri. */
		/* ----------------- */

		k += d;
		MOVE(i, k);
		++i;
		--q;

		/* ---------------- */
		/* S5:	End of run? */
		/* ---------------- */
		if (q > 0)
		{
		    continue;		/* No. Continue Comparison Loop. */
		}

		/* ----------------- */
		/* S6:	Transmit Rj. */
		/* ----------------- */
		for (k += d; k != m; k += d)
		{
		    MOVE(j, k);
		    --j;
		    --r;

		    /* ---------------- */
		    /* S7:  End of run? */
		    /* ---------------- */
		    if (r <= 0)
		    {
			break;		/* Yes. */
		    }
		}
	    }
	    else
	    {
		/* ----------------- */
		/* S8:	Transmit Rj. */
		/* ----------------- */
		k += d;
		MOVE(j, k);
		--j;
		--r;

		/* ---------------- */
		/* S9:	End of run? */
		/* ---------------- */
		if (r > 0)
		{
		    continue;		/* No. Continue Comparison Loop. */
		}

		/* ------------------ */
		/* S10:  Transmit Ri. */
		/* ------------------ */
		for (k += d; k != m; k += d)
		{
		    MOVE(i, k);

		    /* ----------------- */
		    /* S11:  End of run? */
		    /* ----------------- */
		    ++i;
		    --q;

		    if (q <= 0)
		    {
			break;		/* Yes. */
		    }
		}
	    }				/* End of else */

	    /* --------------------------------- */
	    /* S12:  Switch sides of output area */
	    /* unless k == m which means that we */
	    /* are finished with this area.	 */
	    /* --------------------------------- */
	    if (k != m)
	    {
		q = p;
		r = p;
		d = -d; 		/* Change direction	*/

		x = m;			/* Interchange k <--> m */
		m = k;
		k = x;

		/* --------------------------------- */
		/* Check for more runs to be sorted. */
		/* --------------------------------- */
		if ((j - i) >= p)
		{
		    continue;		/* Continue Comparison Loop. */
		}

		/* --------------------------------------- */
		/* Begin direct transfer of extra segment. */
		/* --------------------------------------- */
		for (k += d; k != m; k += d)
		{
		    /* ------------ */
		    /* Transmit Ri. */
		    /* ------------ */
		    MOVE(i, k);
		    ++i;
		}
	    }

	    break;			/* Begin next pass. */
	}				/* End of Comparison Loop */
    }					/* S13. Main Control Loop */

    /* -------------------------------- */
    /* If the final sort is in the temp */
    /* area, move it back to base area. */
    /* -------------------------------- */
    if (To == TempArea)
    {
	From = TempArea;
	To = MyBase;
	for (i = 1; i <= Num; ++i)
	{
	    MOVE(i, i);
	}
    }
}
# if defined(TEST)
#include "tsrtdefs.h"
# if defined(SORT_NAME)
# else
#	define	SORT_NAME	tsort
# endif
void
main(int argc, char **argv)
{
    SORT_TEST_STRU  SortParms;

    SortParms.argc	= argc;
    SortParms.argv	= argv;
    SortParms.SortFun	= SORT_NAME;
    SortParms.OKCodes	= (char *) NULL;
    SortParms.ExecName	= DQ(SORT_NAME);
    SortParms.ExecLabel = "Two-Way Merge Sort";

    tstsort(&SortParms);
}
# endif
