Listing 3: Header File for tstsort.c and Sort
	   Function Wannabes
=============================================

/* ============ */
/* tsrtdefs.h	*/
/* ============ */
/* ============================================ */
/* DEFINES & TYPEDEFS FOR SORT TESTING PROGRAM	*/
/* ============================================ */
# if defined(__TSRTDEFS_H)
# else
#	define __TSRTDEFS_H
#
#define	DQ(name)	ST(##name)
#define ST(name)	#name

#define	PRTIM		'P'	/* Print Time  */
#define NOTIM		'N'	/* Don't Print */

/*  ------------------------------  */
/*  Sort Objects are designated as: */
/*  ------------------------------  */
/*  R   Random			    */
/*  S   Already Sorted		    */
/*  V   Reverse Sorted		    */
/*  H   Reverse Sorted by Halves    */
/*  F   First Item Out of Sort	    */
/*  T   Every Third Item Inverted   */
/*  Q   All Items Equal		    */
/*  E   Every Eighth Item Different */
/*  A   Alternating Pairs	    */
/*  B   Boresight Simulation	    */
/*  ------------------------------  */

static	char	SortCodes[] = "RSVHFTQEAB";

#define	RANDOM		0
#define	ALRDY_SRTD	1
#define	RVRS_SRTD       2
#define	RVRS_HLVS       3
#define	FRST_OUT	4
#define	THRD_INV	5
#define	ALL_SAME	6
#define	EVRY_8TH	7
#define	ALT_PAIRS	8
#define	BORST_SIM	9

#define	WANT(OptionList, OptNum)	\
	(OptionList &			\
	(1 << ((sizeof(SortCodes) - 2) - OptNum)))

typedef	int	CMPR_FUN(const void *, const void *);
typedef	void	SORT_FUN(void *, size_t, size_t,
					 CMPR_FUN *);

typedef	struct	SortTestStru
{
    int        argc;	  /* No. Command-Line Args.  */
    char     **argv;	  /* Command-Line Arguments  */
    SORT_FUN  *SortFun;	  /* Entry Location of Sort  */
    char      *OKCodes;	  /* Sort Objects Permitted  */
    char      *ExecName;  /* Name of Executable File */
    char      *ExecLabel; /* Short Descriptive Label */
}
	SORT_TEST_STRU;

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif
/* INDENT OFF */

extern	void	tstsort F((SORT_TEST_STRU *));

# undef F
/* INDENT ON */

# endif		/* <<< __TSRTDEFS_H >> */
