/* Listing 3		Cosine Table Generation */


#include <math.h>
#include <stdio.h>
#include <stdlib.h>

/*
	This is the routine used to generate the table used in the
	fixed point sine and cosine functions.
*/


#define PI                 3.14159265358979323846
#define DEGREES_IN_CIRCLE  (1L << 12)
#define TABLE_UNITY        (1L << 14)



int main( void )
{
   double degree, step;
   unsigned short value;
   int column;

   step = (2.0 * PI) / DEGREES_IN_CIRCLE;

   for( degree = 0.0, column = 0; degree < PI / 2.0; degree += step )
   {
      value = (unsigned short)(TABLE_UNITY * cos( degree ));
      printf( "0x%04hx,%c", value, ++column % 8 ? ' ' : '\n' );
   }

   return( 0 );
}

