/* Listing 4		Floating Point and Fixed Point Line Routines */

/*
	These functions rely on the Borland graphics library
*/

#include <graphics.h>


#define FixedPointShiftAmount 8

#define FPToInteger( FP )  ( FP >> FixedPointShiftAmount )
#define IntegerToFP( Integer )  ( Integer << FixedPointShiftAmount )


typedef long FixedPnt;


void FloatingPointLine( float x1, float y1, float x2, float y2 )
{
	float t, x, y;

	for( t = 0.0; t < 1.0; t += 0.05 )
	{
		x = x1 + ( x2 - x1 ) * t;
		y = y1 + ( y2 - y1 ) * t;

		putpixel( x, y, 12 );
	}
}


void FixedPointLine( short x1, short y1, short x2, short y2 )
{
	// This dt gives 128 steps
	FixedPnt t, dt = 1 << ( FixedPointShiftAmount - 6 );
	short x, y;

	for( t = 0; t < IntegerToFP( 1 ); t += dt )
	{
		x = x1 + FPToInteger( (( x2 - x1 ) * t ));
		y = y1 + FPToInteger( (( y2 - y1 ) * t ));

		putpixel( x, y, 13 );		
	}
}

