/* Listing 2, check.c, version 1 */
#include <stdio.h>
#include <stdlib.h>

#include "check.h"	/* Listing 1 */

struct Category
   {
   const char * name;
   void (*handler)(void);
   };

static void Exit(void) 
   { exit(EXIT_FAILURE); }
static void CarryOn(void) { }

static struct Category Severity[] =
   {
   { "UNDEFINED", Exit },
   { "WARNING",	CarryOn	},
   };


void DB_Trap(const char pred[], 
               const char call[], 
               int sev )
   {
   FILE * errLog = stderr;

   fprintf(errLog, "\n----Debug-test-failed----\n");
   fprintf(errLog, "CALL: %s\n", call);
   fprintf(errLog, "TYPE: %s\n", Severity[sev].name);
   fprintf(errLog, "TEST: %s\n", pred);
   fprintf(errLog, "-------------------------\n");
   fflush(errLog);
   Severity[sev].handler();
   }

