//
//
// Implementation of a GFX (bitmap output class for MakMan/2)
// using OS/2 GPI (Graphics Programming Interface) calls 
//

#define INCL_GPILOGCOLORTABLE
#define INCL_GPIBITMAPS
#include "pmmain.hh"
#include "pmvars.hh"
#include "pmids.hh"

#include "VideoEngine.hh"
#include "debug.h"

#include <stdlib.h>

BITMAPINFO2 *bitH;
HPS hpsScreen;

// constructor
gpi::gpi()
{
    max_bmp = MAXBMP;

    for (int i = 0; i<max_bmp; i++)
        bitmap_free[i] = TRUE;

    bitmap_data = new char[ 32 * 32 * max_bmp ];

    assert(bitmap_data);
}

// destructor
gpi::~gpi()
{

    delete[] bitmap_data;
}

// init DIVE
gpi::open()
{

    APIRET rc;
    FILE* fpal;
    
    bitH = (BITMAPINFO2*) malloc ( sizeof(BITMAPINFOHEADER2) + 256 * sizeof (RGB2));

    // read the palette from a file
    
    for (int i = 0; i < 256; i++)
    {
	bitH->argbColor[i].bBlue = i;
	bitH->argbColor[i].bGreen= i;
	bitH->argbColor[i].bRed  = i;
	bitH->argbColor[i].fcOptions = PC_EXPLICIT;
    }


    // Initialize the bitmap header
    bitH->cbFix = sizeof(BITMAPINFOHEADER2);
    bitH->cx = 32;
    bitH->cy = 32;
    bitH->cPlanes = 1;
    bitH->cBitCount = 8;
    bitH->ulCompression = BCA_UNCOMP;

    HDC hdc = WinOpenWindowDC ( hwndFrame );
    SIZEL sizl;
    sizl.cx = sizl.cx = 0;

    /* Create presentation space for screen. */
    hpsScreen = GpiCreatePS (habMain, hdc, &sizl, 
			     PU_PELS | GPIT_MICRO | GPIA_ASSOC | GPIF_DEFAULT);
    /* Create presentation space for memory image of screen. */
    hdcMemory = DevOpenDC(hab, OD_MEMORY, (PSZ) "*", 0L, 0L, 0L);
    sizl.cx = 0;
    sizl.cy = 0;
    hpsMemory = GpiCreatePS(hab, hdcMemory, &sizl,
			    PU_PELS | GPIT_MICRO | GPIA_ASSOC | GPIF_DEFAULT);

    /* Create bitmap for memory image of screen. */
    memset(&bmih, 0, sizeof(bmih));
    hbm = GpiCreateBitmap(hpsMemory, &bitH, 0L, NULL, NULL);
    GpiSetBitmap(hpsMemory, hbm);

    /* and a color palette */
    GpiQueryRealColors(hpsScreen, 0, 0, 256, 
		       (PLONG) &bitH->argbColor[0]);
//    GpiCreateLogColorTable(hpsMemory, (ULONG) LCOL_PURECOLOR,
//			   (LONG) LCOLF_CONSECRGB, (LONG) 0L, (LONG) 33L, (PLONG) palette);
    GpiSetBackMix(hpsMemory, BM_OVERPAINT);

    assert(hpsScreen != 0);
    if (debOut)
    {
	fprintf(debOut, "Screen PS %li, DC %li\n", hpsScreen, hdc);
	fflush(debOut);
    }
    return TRUE;

}

// close DIVE
gpi::close()
{

  return TRUE;
}

// set the output offset for the graphics engine
gpi::set_offset ( int, int )
{
    // nothing to do when using GPI
}

char* gpi::alloc_bitmap( int sizex, int sizey, int &id )
{
    int ok = FALSE;

    // we only support 32x32 bitmaps
    assert(sizex == 32);
    assert(sizey == 32);

    int next;

    for (int i = 0; i < max_bmp; i++)
        if ( bitmap_free[i] )
        {
            ok = TRUE;
            id = i;
            bitmap_free[i] = FALSE;
            return &bitmap_data [i*sizex*sizey];
        }

    if (debOut)
    {
	fprintf(debOut, "BMP %3i, ok = %i\n", id, ok);
	fflush(debOut);
    }

    assert(ok);

    return NULL;
}

gpi::free_bitmap ( int id )
{
    assert (id > 0);
    assert (id < max_bmp);
    bitmap_free[id] = TRUE;

    return TRUE;
}
2
gpi::show_bitmap ( int id, int posX, int posY )
{
    APIRET rc;
    POINTL pts[4];

    // There are no visible areas of the game
    if (numVisRects == 0)
        return 0;

    // where to go
    pts[0].x = posX + 1;
    pts[0].y = posY + 1;
    pts[1].x = posX + 32;
    pts[1].y = posY + 32;
    // where to get data from
    pts[2].x = 0;
    pts[2].y = 0;
    pts[3].x = 31;
    pts[3].y = 31;

    /* This is the key to the speed. Instead of doing a GPI call to set the
       color and a GPI call to set the pixel for EACH pixel, we get by
       with only two GPI calls. */
    GpiSetBitmapBits(hpsMemory, 0L, (LONG) (NUM_MASSES_Y-2), &bitmap_data[id*32*32], bitH);
    GpiBitBlt(hps, hpsMemory, 3L, pts, ROP_SRCCOPY, BBO_IGNORE);

    
    return rc;
}
