/*
**  by David Goodenough & Bob Stout
*/

#include <stdio.h>
#include <dos.h>
#include "extkword.h"
#include "ext_keys.h"
#include "mk_fp.h"

#define biosseg 0x40

#define HEAD (*((unsigned short FAR *)MK_FP(biosseg, 0x1a)))
#define TAIL (*((unsigned short FAR *)MK_FP(biosseg, 0x1c)))

/*
**  Detect a pending keypress
*/

int fast_kbhit(void)
{
      return HEAD - TAIL;
}

/*
**  Clear the keyboard buffer
*/

void fast_kbflush(void)
{
      HEAD = TAIL;
}

/*
**  Enhanced work-alike for BASIC's INKEY$ function
*/

int ext_inkey(void)
{
      if (!fast_kbhit())
            return EOF;
      else  return ext_getch();
}

#ifdef TEST

#include <conio.h>
#include <time.h>

main()
{
      clock_t Wait;
      int key;

      puts("Hit some keys while I kill some time...");
      Wait = clock();
      while (2 > ((clock() - Wait) / CLK_TCK))
            ;

      puts("OK, stop hitting keys while I flush the keyboard...");
      Wait = clock();
      while (2 > ((clock() - Wait) / CLK_TCK))
            ;

      fast_kbflush();
      puts("Optionally, hit some key you didn't hit before...");
      Wait = clock();
      while (2 > ((clock() - Wait) / CLK_TCK))
            ;
      if (EOF == (key = ext_inkey()))
            puts("You didn't hit anything");
      else  printf("You hit extended keycode 0x%04X\n", key);
      
      puts("OK, now hit some other key you didn't hit before...");

      while (!fast_kbhit())
            ;
      printf("You hit extended keycode 0x%04X\n", ext_getch());
      return 0;
}

#endif /* TEST */
