/*
 This procedure searches an ascii text file for a specified field.
 Sometimes we are not able to import into dbf's and this routine 
 enables you to search the text file almost as fast as a DBSEEK().
 The way this works is that the pointer is positined at the halfway
 mark and it is then determined which half to search for and so on.
 Please note that the text file, in this case (myfile.txt) has got
 to be of equal length records and sorted. And please give full credits
 to Tom Leylan for original coding. 

 clipper main /n
 blinker fi main
 
 Disclaimer: Sorry dudes but you're on your own on this one. If anything
 goes wrong with this code, fix it yourself. You have the idea and the
 technology I hope. So don't blame us and don't come knocking on our door.
 Good luck and hope this helps you.
*/

#INCLUDE 'FILEIO.CH'    
#DEFINE REC_LEN  12  //This is the record length. Add two for cr + lf.

FUNC MAIN()
  LOCAL nNumtoFind := 0 
  CLS
  @ 1,1 SAY 'Number to find:' GET nNumToFind  PICT '9999999999'
  READ

  IF SearchSDF(nNumToFind)   //function to search the sdf file.
     @ 3,1 SAY 'found'
  ELSE
     @ 4,1 SAY 'NOT found'
  ENDIF

RETURN NIL



FUNCTION SearchSDF(nFind)
   LOCAL nHandle, nLow, nHigh, nEmpl
   LOCAL nNow, lReturn, nCtr:=0
   
   nHandle := FOPEN( 'myfile.txt', FO_READ )

   nLow    := 1
   nHigh   := INT( ( FSEEK( nHandle, 0, FS_END ) / REC_LEN ))

   nNow    := INT( (( nHigh + nLow ) / 2 ))
   nEmpl   := ReadEmp( nHandle, nNow )

   WHILE !( nNow == nHigh ) .AND. !( nEmpl == nFind )

      IF ( nEmpl < nFind )
         IF (( nHigh - nNow ) < 2 )
            nNow := nHigh
         ELSE
            nLow := nNow
            nNow := INT( (( nHigh + nLow ) / 2 ))
         ENDIF
      ELSE
         IF (( nHigh - nNow ) < 2 )
            nNow := nLow
         ELSE
            nHigh := nNow
            nNow := INT( (( nHigh + nLow ) / 2 ))
         ENDIF
      ENDIF

      nEmpl :=  ReadEmp( nHandle, nNow ) 
      
      nCtr++
      IF nCtr >= 50
         EXIT
      END
    
    ENDDO

   FCLOSE( nHandle )

   IF ( nEmpl == nFind )
      lReturn := .T.
   ELSE
      lReturn := .F.
   ENDIF

RETURN lReturn


FUNCTION ReadEmp( nHandle, nRec )
   FSEEK( nHandle, (( nRec * REC_LEN ) - REC_LEN ), FS_SET )
RETURN INT( VAL( FREADSTR( nHandle, ( REC_LEN - 2 ) )))

