#ifndef _FLC_H
#define _FLC_H

#if !defined(_INC_WINDOWS) && !defined(__WINDOWS_H)
    #include <windows.h>
#endif

#ifndef _FLC_C
typedef void FAR*HFLIC;
#endif

// basic functions
HFLIC WINAPI __export FlicCreate(void);
int   WINAPI __export FlicOpen(HFLIC Flic, const char FAR* FileName, HWND Window);
int   WINAPI __export FlicPlay(HFLIC Flic);
int   WINAPI __export FlicStep(HFLIC Flic);
int   WINAPI __export FlicStop(HFLIC Flic);
int   WINAPI __export FlicClose(HFLIC Flic);
int   WINAPI __export FlicDestroy(HFLIC Flic);

// informational functions
int   WINAPI __export FlicIsPlaying(HFLIC Flic);
int   WINAPI __export FlicIsClosed(HFLIC Flic);
int   WINAPI __export FlicWidth(HFLIC Flic);
int   WINAPI __export FlicHeight(HFLIC Flic);
int   WINAPI __export FlicFrameCount(HFLIC Flic);
int   WINAPI __export FlicCurrentFrame(HFLIC Flic);

#endif
