#include <windows.h>
#include <commdlg.h>

#include <stdlib.h>     /* size_t   */
#include <string.h>     /* memset() */

#include "flcplay.h"
#include "test.h"

static HFLIC        Flic;
static HWND         FlicWindow;
static HINSTANCE    ThisInstance;
static int          Closing;

static char szAppName[] = "FlcPlay";
BOOL RegWndClass(HINSTANCE hInstance, char *szAppName);

static void SetClientSize(HWND Win, int Width, int Height)
    {
    RECT    Client, Outer;

    GetClientRect(Win, &Client);
    if(Client.right != Width || Client.bottom != Height)
        {
        int WinWidth, WinHeight;
        GetWindowRect(Win, &Outer);
        WinWidth    = Outer.right  - Outer.left;
        WinHeight   = Outer.bottom - Outer.top;
        SetWindowPos(Win, NULL, 0, 0,
            WinWidth  + (Width  - Client.right),
            WinHeight + (Height - Client.bottom),
            SWP_NOMOVE|SWP_NOACTIVATE|SWP_NOZORDER);
        }
    }

/*
 *  SimpleGetOpenFileName - a simple version of GetOpenFileName().
 *  
 *  Arguments:
 *      ParentWindow -
 *              the handle of the window that will own the common
 *              dialog, or NULL.
 *      FileName -
 *              The output buffer that will receive the user-selected path..
 *      MaxPath -
 *              The maximum length of FileName.
 *      Filter -
 *              a buffer containing pairs of NULL-terminated strings,
 *              terminated by an extra NULL byte. The first string of
 *              each pair is the name of the filter (e.g., "Text files"),

 *              while the second string of each pair contains one or more
 *              sem-colon separated wildcard patterns. If this parameter is
 *              NULL, "All file types\0*.*\0\0" is used.
 */


BOOL    SimpleGetOpenFileName(HWND ParentWindow,
    char FAR *FileName, size_t MaxPath, char FAR *Filter)
    {
    OPENFILENAME    DialogArgs;

    if(Filter == NULL)
        Filter  = "All file types\0*.*\0\0";

    *FileName               = '\0';
    memset(&DialogArgs, 0, sizeof(DialogArgs));
    DialogArgs.lStructSize  = sizeof(DialogArgs);
    DialogArgs.hwndOwner    = ParentWindow;
    DialogArgs.lpstrFilter  = Filter;
    DialogArgs.nFilterIndex = 1;
    DialogArgs.lpstrFile    = FileName;
    DialogArgs.nMaxFile     = MaxPath;
    DialogArgs.Flags        = OFN_FILEMUSTEXIST | OFN_SHOWHELP;

    return GetOpenFileName(&DialogArgs);
    }


typedef BOOL (*DLGCMDHANDLER)(HWND Dialog, UINT Notify,
                               int ControlId, HWND Control);
BOOL    DialogCommand(DLGCMDHANDLER Handler, HWND Dialog,
                               WPARAM Param1, LPARAM Param2)
    {
    UINT    Notify;
    UINT    ControlId;
    HWND    Control;
#if defined(__WIN32__)
    Notify      = HIWORD(Param1);
    ControlId   = LOWORD(Param1);
    Control     = (HWND)Param2;
#else
    Notify      = HIWORD(Param2);
    ControlId   = Param1;
    Control     = (HWND)LOWORD(Param2);
#endif
    return Handler(Dialog, Notify, (int)ControlId, Control);
    }

BOOL EnableControl(HWND Dialog, int ControlId, int Enable)
    {
    return EnableWindow(GetDlgItem(Dialog, ControlId), Enable);
    }

HWND MakeWindow(HWND Owner)
    {
    HWND hWnd;


    if ((hWnd = CreateWindow(szAppName,
            "Flc Player", WS_OVERLAPPED|WS_CAPTION,
            CW_USEDEFAULT, CW_USEDEFAULT,
            30, 30,
            Owner, NULL, ThisInstance, NULL)) == NULL)
        return 0;

    ShowWindow(hWnd, SW_SHOW);
    UpdateWindow(hWnd);

    return hWnd;
}

static int Open(HWND Dialog, const char *Path)
    {
    int Opened = FALSE;

    if(Path[0])
        {
        if(!FlicWindow)
            FlicWindow = MakeWindow(Dialog);
        if(FlicWindow == NULL)
            {
            MessageBox(Dialog, "Could not create playback window!", "FlcPlay", MB_OK);
            return FALSE;
            }
        if(!FlicOpen(Flic, Path, FlicWindow))
            {
            MessageBox(NULL, Path, "Can't open!", MB_OK);
            return FALSE;
            }
        Opened  = TRUE;
        }
    if(!Opened)
        {
        EnableControl(Dialog, ID_PLAY, FALSE);
        EnableControl(Dialog, ID_STEP, FALSE);
        EnableControl(Dialog, ID_STOP, FALSE);
        SetDlgItemText(Dialog, ID_WIDTH, "");
        SetDlgItemText(Dialog, ID_HEIGHT, "");
        SetDlgItemText(Dialog, ID_TOTALCOUNT, "");
        SetDlgItemText(Dialog, ID_CURRENTFRAME, "");
        if(Path[0])
            MessageBox(Dialog, "Can't open that file as a flic file!",
                   "FlcPlay", MB_OK);
        }
    else
        {
        SetClientSize(FlicWindow, FlicWidth(Flic), FlicHeight(Flic));
        EnableControl(Dialog, ID_CLOSE, TRUE);
        EnableControl(Dialog, IDOK, FALSE);
        EnableControl(Dialog, IDCANCEL, FALSE);

        EnableControl(Dialog, ID_PLAY, TRUE);
        EnableControl(Dialog, ID_STEP, TRUE);
        EnableControl(Dialog, ID_BROWSE, FALSE);
        EnableControl(Dialog, ID_FILENAME, FALSE);
        SetDlgItemInt(Dialog, ID_WIDTH, FlicWidth(Flic), TRUE);
        SetDlgItemInt(Dialog, ID_HEIGHT, FlicHeight(Flic), TRUE);
        SetDlgItemInt(Dialog, ID_TOTALCOUNT, FlicFrameCount(Flic), TRUE);
        SetDlgItemInt(Dialog, ID_CURRENTFRAME, FlicCurrentFrame(Flic), TRUE);
        }
    return TRUE;
    }

static void Play(HWND Dialog)
    {
    if(Flic != 0 && !FlicIsPlaying(Flic))
        {
        FlicPlay(Flic);
        EnableControl(Dialog, ID_PLAY, FALSE);
        EnableControl(Dialog, ID_STEP, FALSE);
        EnableControl(Dialog, ID_STOP, TRUE);
        EnableControl(Dialog, ID_BROWSE, FALSE);
        EnableControl(Dialog, ID_FILENAME, FALSE);
        }
    }


#ifdef __BORLANDC__
    #pragma argsused
#endif
static BOOL OnMainDialogCommand(HWND Dialog, UINT Notify,
                                int ControlId, HWND Control)
    {
    char    Path[256];

    if(ControlId == IDOK || ControlId == IDCANCEL)
        {
        if(Flic && FlicDestroy(Flic))
            {
            Flic    = 0;
            EndDialog(Dialog, ControlId);
            }
        else
            MessageBeep(0);
        return TRUE;
        }
    else if(ControlId == ID_BROWSE)
        {
        if(SimpleGetOpenFileName(Dialog, Path, sizeof(Path),
            "Flic files\0*.flc;*.fli\0\0"))
            {
            SetDlgItemText(Dialog, ID_FILENAME, Path);
            Open(Dialog, Path);
            }
        }
    else if(ControlId == ID_FILENAME)
        {
        if(Notify == EN_KILLFOCUS)
            {
            GetDlgItemText(Dialog, ID_FILENAME, Path, sizeof(Path)-1);
            Open(Dialog, Path);
            }
        }
    else if(ControlId == ID_PLAY)
        {
        if(Flic != 0 && !FlicIsPlaying(Flic))
            Play(Dialog);
        else
            MessageBeep(0);
        }
    else if(ControlId == ID_STOP)
        {
        if(Flic)
            {
            EnableControl(Dialog, ID_PLAY, TRUE);
            EnableControl(Dialog, ID_STEP, TRUE);
            }
        if(Flic != 0 && FlicIsPlaying(Flic))
            FlicStop(Flic);
        else
            MessageBeep(0);
        }
    else if(ControlId == ID_STEP)
        {
        if(Flic)
            EnableControl(Dialog, ID_PLAY, TRUE);
        if(Flic != 0 && !FlicIsPlaying(Flic))
            FlicStep(Flic);
        else
            MessageBeep(0);
        }
    else if(ControlId == ID_CLOSE)
        {
        FlicClose(Flic);
        Closing = TRUE;
        }
    return FALSE;
    }

BOOL CALLBACK MainDialog(HWND Dialog, UINT Message, WPARAM Param1, LPARAM Param2)
    {
    if(Message == WM_INITDIALOG)
        {
        /* perform any initialization you need */
        EnableControl(Dialog, ID_PLAY, FALSE);
        EnableControl(Dialog, ID_STEP, FALSE);
        EnableControl(Dialog, ID_STOP, FALSE);
        EnableControl(Dialog, ID_CLOSE, FALSE);

        SetTimer(Dialog, 666, 100, NULL);

        Flic    = FlicCreate();

        return TRUE; /* FALSE if you called SetFocus() */
        }
    else if(Message == WM_TIMER)
        {
        if(Flic != 0)
            {
            BOOL Foo;
            if((int)GetDlgItemInt(Dialog, ID_CURRENTFRAME, &Foo, TRUE) !=
                            FlicCurrentFrame(Flic))
                SetDlgItemInt(Dialog, ID_CURRENTFRAME,
                              FlicCurrentFrame(Flic), TRUE);
            }
        if(Closing)
            {
            if(Flic && FlicIsClosed(Flic))
                {
                EnableControl(Dialog, IDOK, TRUE);
                EnableControl(Dialog, IDCANCEL, TRUE);
                EnableControl(Dialog, ID_BROWSE, TRUE);
                EnableControl(Dialog, ID_FILENAME, TRUE);
                EnableControl(Dialog, ID_PLAY, FALSE);
                EnableControl(Dialog, ID_CLOSE, FALSE);
                EnableControl(Dialog, ID_STEP, FALSE);
                EnableControl(Dialog, ID_STOP, FALSE);
                Closing = FALSE;
                if(FlicWindow)
                    {
                    DestroyWindow(FlicWindow);
                    FlicWindow  = 0;
                    }
                }
            }
        return TRUE;
        }
    else if(Message == WM_COMMAND)
        return DialogCommand(OnMainDialogCommand, Dialog, Param1, Param2);
    return FALSE; /* FALSE == we did not process msg */
    }


#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst,
                    LPSTR lpCmdLine, int nCmdShow)
{
    ThisInstance    = hInst;

    if (RegWndClass(hInst, szAppName) < 0)
        {
        MessageBox(NULL, "Could not register my window class!", "FlcPlay", MB_OK);
        return 0;
        }
    DialogBox(hInst, "FlcPlay", NULL, MainDialog);
    return 0;
}

//----------------------------------------------------------
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT wMsg,
                             WPARAM wParam, LPARAM lParam)
{
    if(wMsg == WM_DESTROY)
        {
        if(Flic && !FlicIsClosed(Flic))
            {
            MessageBox(NULL, "Oh oh!", "", MB_OK);
            }
        }
    return DefWindowProc(hWnd, wMsg, wParam, lParam);
}

//----------------------------------------------------------
BOOL RegWndClass(HINSTANCE hInstance, char *szAppName)
{
    WNDCLASS WndClass;
    
    memset(&WndClass, 0, sizeof(WndClass));
    WndClass.style         = CS_HREDRAW | CS_VREDRAW;
    WndClass.lpfnWndProc   = MainWndProc;
    WndClass.hInstance     = hInstance;
    WndClass.hIcon         =
                        LoadIcon(NULL, IDI_APPLICATION);
    WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    WndClass.lpszClassName = (LPSTR)szAppName;
        
    return RegisterClass((LPWNDCLASS)&WndClass) ? 0 : -1;
}
