/*
**
**   --- please read this ! ---
**
**  This source code is in "shrouded" form. It is distributed in this form
**  rather than as a library (.LIB) file because of the inconsistancies
**  between object files generated by different compilers. To support several
**  compilers would require a .LIB file for each compiler manufacturer, and
**  sometimes several versions of the .LIB file are needed for the different
**  versions of the same manufacturers compiler!
**
**  You can compile this code, but you will have to register with us in order
**  to get the normal (commented) C source code with normal variable names.
*/


#include "windows.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "pcl4w.h"
#include "accept.h"
#include "ascii.h"
#include "modem_io.h"
#include "term_io.h"
#include "paint.h"
#include "opcodes.h"
#include "wsi.h"
#include "xydriver.h"
#include "miscell.h"
#include "info.h"
#include "line.h"
#include "constants.h"

#define V34 0x55

#define V13   1024
#define V21   1024
#define V60    32
#define V6 1024


extern HWND hMainWnd;            
extern HWND hInfoWnd;            

static int V69 = IDLE;
static int V22 = FALSE;
static int V52 = -1;

static int V68 = 2;      
static BYTE V8 = 0;    
static int V12 = 0;       
static int V20 = 0;       
static int V59 = 0;     
static char V44;         
static int V45 = 1;     
static float PgmWait = 30.0; 
static float V48 = 0.125;
static int V43 = TRUE;   
static char V50 = 'X';      
static int V49 = -1;   
static int V46 = -1; 
static int V5;       
static OFSTRUCT V39;         
static char V26[15];    
static BYTE V10[V13];   
static char V17[V21];   
static BYTE V58[V60]; 
static int V3;
static int V42;
static int V18;
static int V61;
static int V25[10] =
  {0x180,0x0C0,0x060,0x030,0x018,0x00C,0x006,0x003,0x002,0x001};
static char V7[V6];
static char *V4[10] = {"300","600","1200","2400","4800","9600",
                             "19200","38400","57600","115200"};





static int BaudMatch(char *V54)
{int i;
 
 for(i=0;i<10;i++) if(strcmp(V4[i],V54)==0) return(i);
 return(-1);
}

static int V30(void)
{int i;
 static char V7[128];
 static int V33 = 0;
 static int V15 = 0;
 if(V33==V15)
   {V33 = 0;
    V15 = _lread(V5,V7,128);
    if(V15==EOF) return(ENG_UNEXPECTED_EOF);
   }
 i = 0x00ff & V7[V33++];
 V8 ^= (BYTE)i;
 return(i);
}

static int V55(int V32)
{if(V59==V60) return(ENG_STACK_OVERFLOW);
 V58[++V59] = V32;
 return(0);
}

static int V51(void)
{if(V59==0) return(ENG_STACK_UNDERFLOW);
 return (V58[V59--]);
}

static char V57(int V28)
{char c;
 if(V28) return('T');
 else return('F');
}

static int GetBaudCode(int V24)
{int i;
 for(i=0;i<10;i++) if(V24==V25[i]) return i;
 return -1;
}





void SaySiError(int V9)
{char V63[80];
 switch(V9)
   {case  ENG_CANNOT_OPEN:
      DisplayLine("Cannot open script binary\n");
      break;
    case  ENG_UNEXPECTED_EOF:
      DisplayLine("Unexpected EOF\n");
      break;
    case  ENG_NOT_SCRIPT_BINARY:
      DisplayLine("Not script binary\n");
      break;
    case  ENG_NOT_CURRENT_VERSION:
      DisplayLine("Incorrect script version\n");
      break;
    case  ENG_CODE_LENGTH_OVERFLOW:
      DisplayLine("V9 overflow\n");
      break;
    case  ENG_DATA_LENGTH_OVERFLOW:
      DisplayLine("Data overflow\n");
      break;
    case  ENG_BAD_OPCODE:
      DisplayLine("Bad opcode encountered\n");
      break;
    case  ENG_USER_ABORTS:
      DisplayLine("User aborting...\n");
      break;
    case  ENG_STACK_OVERFLOW:
      DisplayLine("Stack overflow\n");
      break;
    case  ENG_STACK_UNDERFLOW:
      DisplayLine("Stack underflow\n");
      break;
    case  ENG_BAD_CHECKSUM:
      DisplayLine("Bad checksum\n");
      break;
    default:
      sprintf(V63,"Script error %d\n",V9);
      DisplayLine(V63);
      break;
   }
}



int wsiStart(int V65,char *V27,int V23)
{int i;
 int V9;
 int V11;    
 int V19;    
 int V14;
 char V63[40];
 int V24;
 int V53;
 
 V22 = V23;
 V52 = V65;
 V24 = SioGetDiv(V52);
 V3 = GetBaudCode(V24);
 V53 = SioRead(V52,3);
 V18 = 0x03 & V53;
 V61 = 0x01 & (V53>>2);
 V42 = 0x07 & (V53>>3);
 
 for(i=0;i<V13;i++) V10[i] = OPC_HALT;
 for(i=0;i<V21;i++) V17[i] = 0;
 V8 = 0;
 V12 = 0;
 V20 = 0;
 V59 = 0;
 V44 = TRUE;
 V45 = 1;
 
 strncpy(V26,V27,12);
 
 V5 = OpenFile((LPSTR)V26,&V39,OF_READ);
 if(V5==-1) return (ENG_CANNOT_OPEN);
 
 if((V9=V30())<0) return V9;
 if(V9!=V34) return(ENG_NOT_SCRIPT_BINARY);
 
 if((V9=V30())<0) return V9;
 if(V9!=V68) return(ENG_NOT_CURRENT_VERSION);
 
 if((V9=V30())<0) return V9;
 V11 = 0x00ff & V9;
 if((V9=V30())<0) return V9;
 V11 = 256*V11 + (0x00ff&V9);
 if(V11>=V13) return(ENG_CODE_LENGTH_OVERFLOW);
 
 if((V9=V30())<0) return V9;
 V19 = 0x00ff & V9;
 if((V9=V30())<0) return V9;
 V19 = 256*V19 + (0x00ff&V9);
 if(V19>=V21) return(ENG_DATA_LENGTH_OVERFLOW);
 
 for(i=0;i<V11;i++)
   {if((V9=V30())<0) return V9;
    V10[V12++] = (BYTE)V9;
   }
 
 if((V9=V30())<0) return V9;
 if(V9!=V34) return(ENG_NOT_SCRIPT_BINARY);
 
 for(i=0;i<V19;i++)
   {if((V9=V30())<0) return V9;
    V17[V20++] = (BYTE)V9;
   }
 
 if((V9=V30())<0) return V9;
 if(V9!=V34) return(ENG_NOT_SCRIPT_BINARY);
 
 V14 = V8;
 if((V9=V30())<0) return V9;

 if((BYTE)V9!=V14)
   {
#if 1
    sprintf(V63,"Received V8=%d\n",(BYTE)V9);
    DisplayLine(V63);
    sprintf(V63,"Computed V8=%d\n",V14);
    DisplayLine(V63);
#endif
    return(ENG_BAD_CHECKSUM);
   }
 
 V12 = 0;
 V69 = !IDLE;
 return 0;
}



int wsiDriver(void)
{static long V35 = 0L;
 static int V36 = FALSE;
 static int V72 = FALSE;
 static int V70 = FALSE;
 static int V71 = FALSE;
 static int V1 = FALSE;
 static char V38 = 'C';
 static int V40; 
 static int V41;   
 static int V2;   
 int V31;
 char V56 = '"';
 int i, k;
 int V9;
 char c;
 char *V54;
 char V63[80];
 char V64[20];
 int V67;
 int V66;
 
 if(V69==IDLE) return IDLE;
 
 if(V35>0L)
   {if(GetCurrentTime() < V35) return !IDLE;
    
    V35 = 0L;
    if(V71)
       {V71 = FALSE;
        ShowWindow(hInfoWnd,SW_HIDE);
       }
    if(V70)
       {V70 = FALSE;
        
        SioRxFlush(V52);
        SioTxFlush(V52);
       }
   }
 
 if(V36)
   {if(ModemDriver()==IDLE)
      {V36 = FALSE;
       V44 = ModemResult();
      }
    else return !IDLE;
   }
 
 if(V72)
   {
    V67 = xyGetPacket();
    if(V67!=V49)
      {V49 = V67;
       InfoPacket(V67);
       SendMessage(hInfoWnd,WM_USER,0,0L);
      }
     
     V66 = xyGetNAKs();
     if(V66 != V46)
       {V46 = V66;
        InfoErrors(V66);
        SendMessage(hInfoWnd,WM_USER,0,0L);
       }
    
    if(xyDriver()==IDLE)
      {V72 = FALSE;
       V44 = ModemResult();
       MessageBeep(0);
       InfoStatus("Completed");
       SendMessage(hInfoWnd,WM_USER,0,0L);
       V71 = TRUE;
       V35 = GetTickCount() + 3000L;
      }
    else return !IDLE;
   }
 
 if(V1)
   {if(GetAcceptText(&V17[V2]))
       {
        V1 = FALSE;
       }
    else return !IDLE;
   }
 
 
 k = V10[V12++];
 V40 = 0x003F & k;
 V41 = (0x00C0 & k) << 2;
 if(V22)
   {V31 = MatchOpCode(V40);
    if(GetXposition()>0) DisplayLine("\n");
    sprintf(V64,"@%d",V12);
    sprintf(V63,"%4s: %s ",V64,GetOpText(V31));
    DisplayLine(V63);
   }
 
 if(V40>=8)
   {V2 = V41 | (0x00ff & V10[V12++]);
    if(V22) switch(GetOperType(V31))
      {case CODE_REF:
         sprintf(V63," %d\n",V2);
         DisplayLine(V63);
         break;
       case DATA_REF:
         sprintf(V63," %c%s%c\n",V56,&V17[V2],V56);
         DisplayLine(V63);
      }
   }
 
 switch(V40)
  {case OPC_HALT:
     V69 = IDLE;
     DisplayLine("...Script halted\n");
     MessageBeep(0);
     break;
   case OPC_STATUS:
     sprintf(V63,"V44=%c V15=%d Wait=%0.2f Pace=%0.2f Case=%c Protocol=%c\n",
        V44,V45,(float)PgmWait,(float)V48,V57(V43),V50);
     DisplayLine(V63);
     break;
   case OPC_DELAY:
     V35 = GetCurrentTime() + (long) (1000.0 * atof(&V17[V2]));
     break;
   case OPC_CALL:
     if((V9=V55(V12))<0) return V9;
     V12 = V2;
     break;
   case OPC_RETURN:
     if((V9=V51())<0) return V9;
     V12 = V9;
     break;
   case OPC_BAUD:
     i = BaudMatch(&V17[V2]);
     if(V3==-1) V44 = FALSE;
     else
       {V3 = i;
        SioBaud(V52,V3);
        V44 = TRUE;
       }
     break;
   case OPC_DATABITS:
     i = atoi(&V17[V2]);
     V44 = TRUE;
     switch(i)
       {case 7:
          V18 = WordLength7;
          break;
        case 8:
          V18 = WordLength8;
          break;
        default:
          V44 = FALSE;
          break;
       }
     if(V44) SioParms(V52,V42,V61,V18);
     break;
   case OPC_STOPBITS:
     i = atoi(&V17[V2]);
     V44 = TRUE;
     switch(i)
       {case 1:
          V61 = OneStopBit;
          break;
        case 2:
          V61 = TwoStopBits;
          break;
       default:
          V44 = FALSE;
          break;
       }
     if(V44) SioParms(V52,V42,V61,V18);
     break;
   case OPC_PARITY:
     c = V17[V2];
     V44 = TRUE;
     switch(c)
       {case 'N':
          V42 = NoParity;
          break;
        case 'E':
          V42 = EvenParity;
          break;
        case 'O':
          V42 = OddParity;
          break;
        default:
          V44 = FALSE;
          break;
       }
     if(V44) SioParms(V52,V42,V61,V18);
     break;
   case OPC_REPLY:
     ModemSendTo(V52,V48,&V17[V2]);
     V36 = TRUE;
     break;
   case OPC_SETCOUNT:
     V45 = atoi(&V17[V2]);
     break;
   case OPC_SETWAIT:
     PgmWait = atof(&V17[V2]);
     break;
   case OPC_LOOP:
     if(--V45>0) V12 = V2;
     break;
   case OPC_IFTRUE:
     if(V44) V12 = V2;
     break;
   case OPC_IFFALSE:
     if(!V44) V12 = V2;
     break;
   case OPC_IF:
     if(V44!=V17[V2]) V12 += 2;
     break;
   case OPC_IFNOT:
     if(V44==V17[V2]) V12 += 2;
     break;
   case OPC_GOTO:
     V12 = V2;
     break;
   case OPC_TEST:
     V44 = V17[V2];
     break;
   case OPC_ACCEPT:
     V1 = TRUE;
     SendMessage(hMainWnd,WM_USER,0,0L);
     break;
   case OPC_SAY:
     V54 = &V17[V2];
     for(i=0;;i++)
       {c = *V54++;
        if(c=='\0') break;
        if(c=='^') c = ( *V54++ ) - '@';
        DisplayChar(c);
       }
     FlushDisplay();
     break;
   case OPC_WAITFOR:
     ModemWaitFor(V52,PgmWait,V43,&V17[V2]);
     V36 = TRUE;
     break;
   case OPC_NOP:
     break;
   case OPC_SETPACE:
     V48 = atof(&V17[V2]);
     break;
   case OPC_SETCASE:
     c = toupper(V17[V2]);
     if(c=='T') V43 = TRUE;
     if(c=='F') V43 = FALSE;
     break;
   case OPC_QUIET:
     ModemQuiet(V52,atof(&V17[V2]));
     V36 = TRUE;
     break;
   case OPC_HANGUP:
     ModemHangup(V52);
     V36 = TRUE;
     break;
   case OPC_PROTOCOL:
     c = toupper(V17[V2]);
     if(c=='X')
       {V38 = NAK;
        V50 = 'X';
       }
     if(c=='Y')
       {V38 = 'C';
        V50 = 'Y';
       }
     break;
   case OPC_SEND:
     PortEcho(V52,500);
     V54 = &V17[V2];
     if(V50=='X')
       {
        xyInit(V52);
        xyStartTx(V54,FALSE,FALSE);
        WindowXY(V54);
        V49 = -1;
        V46 = 0;
        SetWindowText(hInfoWnd,"XMODEM Send");
        V72 = TRUE;
       }
     if(V50=='Y')
       {
        xyInit(V52);
        xyStartTx(V54,TRUE,TRUE);
        WindowXY(V54);
        V49 = -1;
        V46 = 0;
        SetWindowText(hInfoWnd,"YMODEM Send");
        V72 = TRUE;
       }
     
     V35 = GetTickCount() + 500L;
     V70 = TRUE;
     V72 = TRUE;
     break;
   case OPC_RECEIVE:
     PortEcho(V52,500);
     V54 = &V17[V2];
     if(V50=='X')
       {
        xyInit(V52);
        xyStartRx(V54,V38,FALSE);
        WindowXY(V54);
        V49 = -1;
        V46 = 0;
        SetTitle();
        SetWindowText(hInfoWnd,"XMODEM Receive");
       }
     if(V50=='Y')
       {
        xyInit(V52);
        xyStartRx("",V38,TRUE);
        WindowXY("");
        V49 = -1;
        V46 = 0;
        SetTitle();
        SetWindowText(hInfoWnd,"YMODEM Receive");
       }
     
     V35 = GetTickCount() + 500L;
     V70 = TRUE;
     V72 = TRUE;
     break;
   case OPC_USER1:
   case OPC_USER2:
   case OPC_USER3:
   case OPC_USER4:
   case OPC_USER5:
   case OPC_USER6:
   case OPC_USER7:
   case OPC_USER8:
     break;
   } 
 return !IDLE;
} 
