/* Install.CMD: Install Sheppard Software Utilities. */

'@Echo Off'

/* Initialize object title and program name(s) */

Title = 'Utility Pack Version 2.1'
Pgmname.0 = 7
Pgmname.1 = 'BMPView'
Pgmname.2 = 'Calclatr'
Pgmname.3 = 'Calendar'
Pgmname.4 = 'Compare'
Pgmname.5 = 'DiskSpac'
Pgmname.6 = 'FontView'
Pgmname.7 = 'StrngSch'

IconName.0 = 7
IconName.1 = 'BitmapViewer'
IconName.2 = 'Calculator'
IconName.3 = 'Calendar'
IconName.4 = 'CompareFiles'
IconName.5 = 'DiskSpace'
IconName.6 = 'FontView'
IconName.7 = 'StringSearch'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installing ' Title
Say ''


/* Verify the existence of the component files. */


Result = SysFileTree( Pgmname.1".Exe", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR:' Pgmname.1'.Exe not found!'
   Signal DONE
   End

Result = SysFileTree( Pgmname.1".Ico", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR:' Pgmname.1'.Ico not found!'
   Signal DONE
   End

Result = SysFileTree( Pgmname.1".Txt", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR:' Pgmname.1'.Txt not found!'
   Signal DONE
   End

Result = SysFileTree( "Register.Txt", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: Register.Txt not found!'
   Signal DONE
   End

Result = SysFileTree( "Read.Me", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: Read.Me not found!'
   Signal DONE
   End

Result = SysFileTree( "File_ID.Diz", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: File_ID.Diz not found!'
   Signal DONE
   End

Result = SysFileTree( "UtilPack.Ico", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERROR: UtilPack.Ico not found!'
   Signal DONE
   End

/* Find out where we are. */

curdir = directory()

/* Ask for the target directory name. */

Say 'Please enter the full name of the directory in which'
Say '  you want' Title' installed (default: 'curdir'): '
Pull InstDir
If InstDir = "" Then
  InstDir = curdir


/* Create the target directory if necessary. */

Result = SysFileTree(InstDir, 'Dirs', 'D')
If Dirs.0 = 0 Then
  Do
    Result = SysMkDir(InstDir)
    If Result == 0 Then
      Do
      End
    Else
      Do
        Say 'ERROR: Unable to create target directory.'
        Signal DONE
      End
  End
Say ''


/* Perform the installation. */

if InstDir <> curdir then
  Do
    i = 1
    Do until i > Pgmname.0
      Say 'Copying' Pgmname.i 'to' InstDir '...'
      Copy Pgmname.i".Exe" InstDir  '>NUL'
      Copy Pgmname.i".Ico" InstDir  '>NUL'
      Copy Pgmname.i".Txt" InstDir  '>NUL'
      i = i + 1
    End
    Copy Register.Txt InstDir  '>NUL'
    Copy Read.Me      InstDir  '>NUL'
    Copy File_ID.Diz  InstDir  '>NUL'
    Copy Install.Cmd  InstDir  '>NUL'
    Copy UtilPack.Ico InstDir  '>NUL'
    Copy Calclatr.Ini InstDir  '>NUL'
    Copy Calendar.Ini InstDir  '>NUL'
  End
Say 'Creating program folder...'
x = SysCreateObject("WPFolder",,
                    "Sheppard^Utilities",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<SSCUtil>;ICONFILE="||InstDir||"\UtilPack.Ico",,
                    "Update")
If x <> 1 Then
  Do 
    Say 'ERROR: Folder not created.'
    Signal DONE
  End
i = 1
Folder = '<SSCUtil>'
Do until i > Pgmname.0
  Say 'Creating program object for' IconName.i '...'
  Type = 'WPProgram'
  Parms = "EXENAME="InstDir"\"Pgmname.i".Exe;STARTUPDIR="InstDir
  If Pgmname.i = 'BMPView' then
    Parms = Parms";PARAMETERS=[]"
  If Pgmname.i = 'Compare' then
    Parms = Parms";PARAMETERS=[Enter file names]"
  If Pgmname.i = 'FontView' then
    Parms = Parms";PARAMETERS=[Enter size.Fontname]"
  x = SysCreateObject(Type,,
                      IconName.i,,
                      Folder,,
                      Parms,,
                      "Replace")
  If x <> 1 Then
    Do
      Say 'ERROR: Object not created.'
      Signal DONE
    End

  Say 'Creating documentation object for' IconName.i '...'
  Type = 'WPShadow'
  Parms = "SHADOWID="InstDir"\"Pgmname.i".Txt"
  x = SysCreateObject(Type,,
                      Pgmname.i||".Txt",,
                      Folder,,
                      Parms,,
                      "Replace")
  If x <> 1 Then
    Say 'ERROR: Shadow of' Pgmname.i'.Txt not created.'
  i = i + 1
End

Say 'Creating Register.Txt object...'
x = SysCreateObject("WPShadow",,
                    "Register.Txt",,
                    Folder,,
                    "SHADOWID="||InstDir||"\Register.Txt",,
                    "Replace")
If x <> 1 Then
  Say 'ERROR: Shadow of Register.Txt not created.'

Say 'Creating Read.Me object...'
x = SysCreateObject("WPShadow",,
                    "Read.Me",,
                    Folder,,
                    "SHADOWID="||InstDir||"\Read.Me",,
                    "Replace")
If x <> 1 Then
  Say 'ERROR: Shadow of Read.Me not created.'

Say 'Creating File_ID.Diz object...'
x = SysCreateObject("WPShadow",,
                    "File_ID.Diz",,
                    Folder,,
                    "SHADOWID="||InstDir||"\File_ID.Diz",,
                    "Replace")
If x <> 1 Then
  Say 'ERROR: Shadow of File_ID.Diz not created.'

say 'Install completed.'
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
