$COMPILE UNIT
$DEBUG PATH OFF
$DEBUG UNIT OFF
DECLARE FUNCTION SetOnExit%(BYVAL CodePntr???)
SHARED DOSadd???, DOSByte?, BIOSadd???, BIOSByte?
SHARED Cbrk?, CEHSeg??

CbrkRestore:
! Mov  dl,Cbrk?           ;dl = original BREAK flag state
! Mov  ax,&h3301          ;tell dos to reset it
! Int  &h21

! Les  bx,BIOSadd???      ;es:[bx] points to Ctrl-Break handler now
! Mov  al,BIOSByte?       ;put the original byte into al
! Cli                     ;shut off interrupts momentarily
! Mov  es:[bx],al         ;restore the byte to it's original value
! Sti                     ;allow interrupts again

! Les  bx,DOSadd???       ;es:[bx] points to Ctrl-C handler now
! Mov  al,DOSByte?        ;put the original byte into al
! Cli                     ;shut off interrupts momentarily
! Mov  es:[bx],al         ;restore the byte to it's original value
! Sti                     ;allow interrupts again
! RetF

FUNCTION CbrkDisable% PUBLIC
  LOCAL temp??, result%

! Mov  ax,&h3523          ;Get the Ctrl-C vector
! Int  &h21
! Mov  DOSadd???[+2],es   ;Save the segment
! Mov  DOSadd???,bx       ;and the offset
! Mov  al,&hCF            ;we want al set to &hCF for the move
! Cli                     ;turn off interrupts while we do this
! Xchg es:[bx],al         ;poke &hCF (Iret) into the interrupt routine
                          'and copy the current byte into al
! Mov  DOSByte?,al        ;now save it where we can find it later
! Sti                     ;turn interrupts back on

! Mov  ax,&h351B          ;Repeat the procedure for Ctrl-Break
! Int  &h21
! Mov  BIOSadd???[+2],es  
! Mov  BIOSadd???,bx
! Mov  al,&hCF
! Cli
! Xchg es:[bx],al
! Mov  BIOSByte?,al
! Sti

! Mov  ax,&h3300          ;Get the DOS BREAK flag state
! Int  &h21
! Mov  Cbrk?,dl           ;save it so we can restore it later
! Mov  ax,&h3301          ;al = 1 for set flag function
! Xor  dl,dl              ;dl = 0 tells DOS to stop checking during disk IO
! Int  &h21

! Mov  ax,&h3524          ;Get the Critical error handler vector
! Int  &h21
! Mov  CEHSeg??,es        ;Save the segment for use with ClrErDev

                          'emulate PowerBASICs CALL
! Push cs                 ;push the segment address on the stack first
  temp?? = CODEPTR(CbrkRestore)
! Push temp??             ;and then the offset
! Call SetOnExit          ;PowerBASIC takes care of the rest
! Mov  result%,ax
CbrkDisable% = result%
END FUNCTION

FUNCTION CritErr% PUBLIC
LOCAL t%                  'PB sets t% = 0 for us
! Mov  ax,CEHSeg??        ;set es = PB's critical error segment
! Mov  es,ax              ;using ax
! Mov  bx,&h00AE          ;es:[bx] -> PB's critical error flag
! Mov  ax,es:[bx]         ;copy its value into ax
! Or   al,al
! Jz   L1                 ;if the flag = 0 we are done
! Add  al,&h12            ;else add 12h to match Int 21h function 59h
! Mov  es:[bx+02],ax      ;copy the value into PB's ERDEV location
! Xor  al,al              ;clear ax (ah already equals 0)
! Mov  es:[bx],ax         ;clear the flag word for next CALL INTERRUPT
! Dec  t%                 ;return t% = -1 (TRUE)
L1:
CritErr% = t%
END FUNCTION
