/*------------------------------------------------------------------------------
   Copyright           : (c)1994 by Logical Operators
                         All Rights Reserved.
   Filename            : AlertTst.CPP
   Header File         : None
   Purpose             : Sample program demonstrating the use of the AlertDriver
                         classes.
   Compiler Directives : None

   Modification History:
   Version   Date    Programmer and Description of Changes
   ------- --------  --------------------------------------------------------
    1.00   01/20/94  Original version by Warren J. Hairston.
   ---------------------------------------------------------------------------*/



   #define Uses_TApplication   //for Borland Turbo Vision apps
   #define WIN30               //use Windows 3.0 API for Borland OWL



   //included files
   //--------------
   #include <INTEGER.H>   //AlertableObject class declaration
   #include <limits.h>     //for INT_MIN, INT_MAX declarations

   #ifdef BORLAND_OWL
      #include <owl.h>
   #endif   //BORLAND_OWL



/*============================================================================*/



#ifdef BORLAND_TV
   class TMyApp : public TApplication
   {
      public:
         TMyApp() :
            TProgInit(&TMyApp::initStatusLine, &TMyApp::initMenuBar,
                      &TMyApp::initDeskTop) {};
   };   //class TMyApp
#endif   //BORLAND_TV



#ifdef BORLAND_OWL
   class TMyApp : public TApplication
   {
      public:
         TMyApp(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
                LPSTR lpCmdLine, int nCmdShow) :
            TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow)
            {}
   };   //class TMyApp
#endif   //BORLAND_OWL


   void runDemo(void)
   /*---------------------------------------------------------------------------
      Purpose:  Platform independent code which executes the demo code.
      Parameters:  None.
      Return Value:  None.
      ------------------------------------------------------------------------*/
   {
      //test the defaultAlertDriver from a non-object
      defaultAlertDriver->HandleInfo("Preparing to create 2 Integer objects.");

      //allocate program variables which use the default driver
      Integer a(0), b(3);



      defaultAlertDriver->HandleInfo(
         "Preparing to test undefined Integer error codes and literals.");
      //run the Test function for Integer b
      b.TestAlertDriver();



      defaultAlertDriver->HandleInfo(
         "Preparing to divide an Integer by zero.");
      //invoke operations on the objects
      b = b/a;   //generates a divide by zero error



      defaultAlertDriver->HandleInfo(
         "Preparing to assign INT_MAX to an Integer.");
      b = INT_MAX;



      defaultAlertDriver->HandleInfo(
         "Now multiply the Integer by 2, generating an overflow error.");
      b = b * 2;   //when b == INT_MAX, this generates an overflow error
   };   //function runDemo



#ifdef TARGET_WINDOWS
   #ifdef __BORLANDC__
      #pragma argsused
   #endif   //__BORLANDC__
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine,
                   int nCmdShow)
#else   //TARGET_WINDOWS
void main(void)
#endif   //!TARGET_WINDOWS
{
   #ifdef BORLAND_TV
      TMyApp myApp;
      myApp.run();
   #endif   //BORLAND_TV

   #ifdef BORLAND_OWL
      TMyApp myApp("AlertDriver - OWL Demo - Close This Window", hInstance,
                   hPrevInstance, lpCmdLine, nCmdShow);
      myApp.Run();
   #endif   //BORLAND_OWL

   /*Remove the comments from the next two lines to attach a text file
     AlertDriver to the default driver*/
//   defaultAlertDriver->ChangeLinkedAlertDriver(
//      new TextFileAlertDriver("adtest.log", radFREERESOURCE));

   /*Enable error processing for all drivers in default chain.  By default,
     this is already enabled - shown here only for demo purposes.*/
   defaultAlertDriver->ChangeProcFlags(adfERROR, cfoENABLE | cfoCHAIN);

   runDemo();

   #ifdef TARGET_WINDOWS
      return 0;
   #endif   //TARGET_WINDOWS
};   //function main
