/******************************************************************
*
*	AmyGUI++ - AmyReq.h
*
*	Author: Erkki Tapola
*
*	$Id: amyreq.h 1.5 1994/04/01 12:10:33 Delta stabile $
*
*	AmyTextReq enables the user to show system requesters
*	which contain a title, a message and a set of reply
*	buttons.
*
*	AmyFileReq can be used to ask the user to choose a
*	file or a directory.
*
*	AmyFontReq and AmyScreenReq will eventually be implemented.
*
******************************************************************/

#ifndef AMYREQ_H
#define AMYREQ_H

#include "amywindow.h"

#include <intuition/intuition.h>

class AmyReq
{
protected:
    AmyWindow *window;

public:
    AmyReq();
};

class AmyTextReq : public AmyReq
{
protected:
    EasyStruct es;

public:

    AmyTextReq(AmyWindow *ParentWindow, const char *Title, const char *Text, const char *Reply);
    int Show();
};

class AmyAslReq {

protected:
    void *req;
    char *Error;
    int Result;
    AmyWindow *Parent;
    Dimension PosandSize;
    const char *Title, *Positive, *Negative;

public:
    AmyAslReq(AmyWindow *par, Dimension possiz, const char *t, const char *pos, const char *neg);
    ~AmyAslReq();
    const char *GetError() { return (Error ? Error : ""); }
    short IsError() { return Error != NULL; }
    int GetResult() { return Result; }
};

class AmyFileReq : public AmyAslReq {

protected:
    char Filename[128], Drawer[128];

public:
    AmyFileReq(AmyWindow *Parent)
	: AmyAslReq(Parent, Dimension(50,50,200,200), "File requester", "Load", "Cancel") {}
    AmyFileReq(AmyWindow *Parent, Dimension PosandSize,
	const char *Title, const char *PositiveReply, const char *NegativeReply);
    int Show();
    const char *GetFilePart() { return Filename; }
    const char *GetPathPart() { return Drawer; }
    const char *GetFilename();
};

#endif
