/****************************************************************************\

\****************************************************************************/


/****************************************************************************\

	int check_key(void)

			check_key() is my answer to a problem I got tired of encountering.
		It checks to see if a key has been pressed, returning -1 if none, or
		the extended key code (0x0159 for F1, 0x000D for CR, etc.) if one was
		pressed.  The reason for this is that although getch() will get a key
		without checking for ctrl-c or ctrl-break, it wait's for a key press.
		On the other hand kbhit() doesn't get the waiting key, but it DOES
		check for ctrl-c and ctrl-break.  DOS could use a couple more 0x21
		interrupt functions.

\****************************************************************************/
int check_key(void)
{

	asm {

		mov ax,0x0600;	//Function 0x06
		mov dx,0x00FF;	//Sub function 0xFF
		int 0x21;		//Get a keypress IF there was one

		jnz Keypress;	//Jump if key was pressed

		mov ax,0xFFFF;
		jmp End;			//Return -1 because no key was pressed

	}

Keypress:

	asm {

		and ax,0x00FF;	//Check status of al
		jnz End;			//Key is not extended key return character

		mov ax,0x0700;	//Get extended character we know it's there
		int 0x21;

		mov ah,0x01;	//Set high byte of AX to indicate extended key

	}

End:

	return(_AX);

}

