
/*/////////////////////////////////////////////////////////////////////
//                                                                   //
//                                                                   //
//  ZCMPLR.C -- compiler specific functions                          //
//                                                                   //
//   (c) 1991, Mike Dumdei, 6 Holly Lane, Texarkana TX, 75503        //
//                                                                   //
//////////////////////////////////////////////////////////////////// */
#ifndef __TURBOC__          /* defined by Turbo C compiler */
  #ifndef __ZTC__           /* defined by Zortech C compiler */
    #define __MSC__         /* assume Microsoft C if not TC or ZTC */
  #endif
#endif

/*/////////////////////////////////////////////////////////////////
//                                                               //
//                                                               //
//      Microsoft C  /  Quick C                                  //
//                                                               //
//                                                               //
//////////////////////////////////////////////////////////////// */
#ifdef __MSC__

#include <dos.h>
/*/////////////////////////////////////////////////////////
//  DosFindFirst -- find file (1st instance)             //
//////////////////////////////////////////////////:disk:/*/
int DosFindFirst(char *pathname, int atrib, struct find_t *fstruc)
{
    return (_dos_findfirst(pathname, atrib, fstruc));
}

/*/////////////////////////////////////////////////////////
//  DosFindNext -- find file (except 1st instance)       //
//////////////////////////////////////////////////:disk:/*/
int DosFindNext(struct find_t *fstruc)
{
    return (_dos_findnext(fstruc));
}

/*/////////////////////////////////////////////////////////
//  DosGetDiskFree -- gets free space left on disk       //
//////////////////////////////////////////////////:disk:/*/
long DosGetDiskFree(int drive)
{
    struct diskfree_t spc;
    _dos_getdiskfree(drive, &spc);
    return ((long)spc.avail_clusters * (long)spc.sectors_per_cluster *
     (long)spc.bytes_per_sector);
}

/*/////////////////////////////////////////////////////////
//  DosSetFileTime -- set file date/time                 //
//////////////////////////////////////////////////:disk:/*/
int DosSetFileTime(int handle, unsigned date, unsigned time)
{
    return (_dos_setftime(handle, date, time));
}

/*/////////////////////////////////////////////////////////
//  DosSetFileAttr -- set file attribute                 //
//////////////////////////////////////////////////:disk:/*/
int DosSetFileAttr(char *path, unsigned attrib)
{
    return (_dos_setfileattr(path, attrib));
}
#endif


/*/////////////////////////////////////////////////////////////////
//                                                               //
//                                                               //
//      Turbo C  /  Turbo C++                                    //
//                                                               //
//                                                               //
//////////////////////////////////////////////////////////////// */
#ifdef __TURBOC__

#include <dos.h>
#include <dir.h>
#include <io.h>

#if __TURBOC__ >= 0x0410
 #include <bios.h>
#else
/*/////////////////////////////////////////////////////////
//  _bios_keybrd --  link to Turbo C/C++ bios key        //
/////////////////////////////////////////////////////////*/
int _bios_keybrd(int flag)
{
    return bioskey(flag);
}
#endif

/*/////////////////////////////////////////////////////////
//  DosFindFirst -- find file (1st instance)             //
//////////////////////////////////////////////////:disk:/*/
int DosFindFirst(char *pathname, int atrib, struct ffblk *fstruc)
{
    return (findfirst(pathname, fstruc, atrib));
}

/*/////////////////////////////////////////////////////////
//  DosFindNext -- find file (except 1st instance)       //
//////////////////////////////////////////////////:disk:/*/
int DosFindNext(struct ffblk *fstruc)
{
    return (findnext(fstruc));
}

/*/////////////////////////////////////////////////////////
//  DosGetDiskFree -- gets free space left on disk       //
//////////////////////////////////////////////////:disk:/*/
long DosGetDiskFree(int drive)
{
    struct dfree spc;
    getdfree(drive, &spc);
    return ((long)spc.df_avail * (long)spc.df_sclus * (long)spc.df_bsec);
}

/*/////////////////////////////////////////////////////////
//  DosSetFileTime -- set file date/time                 //
//////////////////////////////////////////////////:disk:/*/
int DosSetFileTime(int handle, unsigned date, unsigned time)
{
    unsigned long ftim = ((unsigned long)date << 16) | (unsigned long)time;
    return (setftime(handle, (struct ftime *)&ftim));
}

/*/////////////////////////////////////////////////////////
//  DosSetFileAttr -- set file attribute                 //
//                                                       //
//   Older versions of TURBO C libraries (TC++ 1.00 for  //
//  sure) do not have the _dos_setfileattr function so   //
//  the call to it is #if'd out.  The defined version    //
//  (0x0400) corresponds to BC++ 3.0 which does have the //
//  _dos_setfileattr function.  Probably some versions   //
//  earlier than 4.0 do too but didn't have them to find //
//  out.  It is only used if an undocumented switch is   //
//  enabled so you probably will never miss it.          //
//////////////////////////////////////////////////:disk:/*/
int DosSetFileAttr(char *path, unsigned attrib)
{
  #if __TURBOC__ >= 0x0400
    return (_dos_setfileattr(path, attrib));
  #else
    return 0;
  #endif
}
#endif


/*/////////////////////////////////////////////////////////////////
//                                                               //
//                                                               //
//      Zortech C  /  Zortech C++                                //
//                                                               //
//                                                               //
//////////////////////////////////////////////////////////////// */
#ifdef __ZTC__

#define MSDOS 1
#include <dos.h>
long timezone = 0L;

/*/////////////////////////////////////////////////////////
//  DosFindFirst -- find file (1st instance)             //
//////////////////////////////////////////////////:disk: */
int DosFindFirst(char *pathname, int atrib, struct find_t *fstruc)
{
    return (_dos_findfirst(pathname, atrib, fstruc));
}

/*/////////////////////////////////////////////////////////
//  DosFindNext -- find file (except 1st instance)       //
//////////////////////////////////////////////////:disk: */
int DosFindNext(struct find_t *fstruc)
{
    return (_dos_findnext(fstruc));
}

/*/////////////////////////////////////////////////////////
//  DosGetDiskFree -- gets free space left on disk       //
//////////////////////////////////////////////////:disk: */
long DosGetDiskFree(int drive)
{
    return (dos_getdiskfreespace(drive));
}

/*/////////////////////////////////////////////////////////
//  DosSetFileTime -- set file date/time                 //
//////////////////////////////////////////////////:disk: */
int DosSetFileTime(int handle, unsigned date, unsigned time)
{
    return (dos_setftime(handle, date, time));
}

/*/////////////////////////////////////////////////////////
//  DosSetFileAttr -- set file attribute                 //
//////////////////////////////////////////////////:disk: */
int DosSetFileAttr(char *path, unsigned attrib)
{
    return (dos_setfileattr(path, attrib));
}
#endif


/*/////////////////////////////////////////////////////////////////////
//                                                                   //
//  The following math functions were added in TXZM version 2.15 in  //
//  order to solve the following problems:                           //
//                                                                   //
//   1.  There was a bug in TXZM.C that sometimes caused a divide    //
//       by zero error during ZMODEM restarts. This code prevents    //
//       division by 0.                                              //
//                                                                   //
//   2.  The helper functions used by various compilers differ       //
//       making precompiled libraries that used long division and    //
//       multiplication difficult to support.  By moving all long    //
//       multiply/divide operations to a set of functions you        //
//       have source code for it doesn't matter what your            //
//       compiler does to perform these operations.                  //
//                                                                   //
//////////////////////////////////////////////////////////////////// */
#ifdef __TURBOC__
  #pragma warn -par
#endif
unsigned long divzero(unsigned long n1)
{
#ifdef DEBUG
    extern vDisplay(int, int, char *, ...);
    int *p1 = (int *)&n1;

    vDisplay(24, 40, "divide by 0 at %04X, notify Mike\r", *(p1 + 3) - 3);
#endif
    return (1L);
}
#ifdef __TURBOC__
  #pragma warn +par
#endif

unsigned long uldiv(unsigned long n1, unsigned long n2)
{
    return (n2) ? (n1 / n2) : divzero(n1);
}

unsigned long ulmod(unsigned long n1, unsigned long n2)
{
    return (n2) ? (n1 % n2) : divzero(n1);
}

unsigned long ulmul(unsigned long n1, unsigned long n2)
{
    return (n1 * n2);
}

unsigned long ulshl(unsigned long n1, int shiftval)
{
    return (n1 << shiftval);
}



