************************** Western Europe map demo **************************
******************************** Main program *******************************

CLEAR
CLEAR ALL
RELEASE WINDOWS
HIDE WINDOW ALL
SET TALK OFF
SET READBORDER ON
SET COMPATIBLE FOXPLUS

SET LIBRARY TO FULLPATH('fpGOBLIN.DLL',1) ADDITIVE

********************************** PUBLICS **********************************

* Goblin's constants
PUBLIC GHBAD
GHBAD = -1

* publics
PUBLIC hoObject   && Currently selected Country
PUBLIC hoFlag     && Currently Selected Flag
PUBLIC hoFl       && Current Flag
PUBLIC WorkModeFl   && Flags display mode
PUBLIC WorkModeMp   && Map display mode
PUBLIC GobExist   && .T. if file GOBLIN.BMP exist 
PUBLIC LabelExist && .T. if file LABEL.BMP exist 
PUBLIC OptExist   && .T. if file OPTIONS.BMP exist 
PUBLIC ExitExist  && .T. if file EXIT.BMP exist 
PUBLIC h_BaseFlags
PUBLIC w_BaseFlags
PUBLIC x_BaseMap
PUBLIC y_BaseMap
PUBLIC h_BaseMap
PUBLIC w_BaseMap

hoObject  = GHBAD 
hoFlag    = GHBAD  
hoFl      = GHBAD  
hPic     = GHBAD
hFlag    = GHBAD
hFl      = GHBAD
GobExist   = .F.
LabelExist = .F.
OptExist   = .F. 
ExitExist  = .F.

h_BaseFlags = 863 - 0
w_BaseFlags = 658 - (-133)
x_BaseMap = 1522
y_BaseMap = 1900
h_BaseMap = 7500 - y_BaseMap
w_BaseMap = 9109 - x_BaseMap

left_fl  = 10
top_fl   = 650
right_fl = 170
bot_fl   = 530

left_map  = 0
top_map   = 0
right_map = 0
bot_map   = 0

*b3 = ' '
InitOk = .F.  && true if all are initialized sucsessfully

WorkmodeFl = 2 && Show ALL Flag
WorkmodeMp = 2 && Show all Countries

h_Label = 80.0  && height of bitmap LABEL.BMP in pixel
w_Label = 160.0  && width of bitmap LABEL.BMP in pixel

c_beg = wlcol('')   && column of top-left corner Main FoxPro window
r_beg = wlrow('')   && row of top-left corner Main FoxPro window
c_max = wcols('')   && max number of cols in Main FoxPro window
r_max = wrows('')   && max number of rows in Main Foxro window

IF r_max < 25
  r_max = 25
ENDIF

IF c_max < 60
  c_max = 60
ENDIF

h_pix = fontmetric(1,Wfont(1,""),Wfont(2,""),Wfont(3,""))  && height of character in pixel
w_pix = fontmetric(6,Wfont(1,""),Wfont(2,""),Wfont(3,""))  && width of character in pixel

var1 = 1.0* h_pix/w_pix
w_h_fl = 1.0*(top_fl - bot_fl) / (right_fl - left_fl) * var1 
w_h_fall = 1.0*w_BaseFlags / h_BaseFlags && * var1 
w_h_map = 1.0*w_BaseMap / h_BaseMap* var1

IF FILE( 'GOBLIN.BMP')
  GobExist   = .T.
ENDIF
IF FILE( 'LABEL.BMP')
  LabelExist = .T.
ENDIF
IF FILE( 'OPTION.BMP')
  OptExist   = .T. 
ENDIF
IF FILE( 'EXIT.BMP')
  ExitExist  = .T.
ENDIF

*************************** bases & indexes *********************************

USE LOCFILE( 'COUNTRY', 'DBF', 'LOCATE COUNTRY.DBF')

IF NOT FILE( 'ID.IDX')
   INDEX ON Id TO ID.IDX
ENDIF

IF NOT FILE( 'country.IDX')
   INDEX ON country TO country.IDX
ENDIF

SET INDEX TO      && close all indexes


*************************** LAYOUT definition *******************************

* Modify coordinate Main FoxPro window
MODIFY WINDOW SCREEN ;
  AT r_beg, c_beg SIZE r_max, c_max

* create MainWnd window
IF NOT WEXIST( 'MainWnd')
  DEFINE WINDOW MainWnd ;
    AT 0,0 SIZE r_max, c_max ;
    COLOR SCHEME 10
ENDIF

IF GobExist
* create background window BackMainWnd under MainWnd 
  IF NOT WEXIST( 'BackMainWnd')
    DEFINE WINDOW BackMainWnd ;
      AT 0,0 SIZE r_max, c_max ;
      COLOR SCHEME 10 ;
      fill file 'goblin.bmp'
  ENDIF
ENDIF

* create Message window
IF NOT WEXIST( 'MsgWnd')
  DEFINE WINDOW MsgWnd ;
    AT r_max - 1.8 ,2 SIZE 1.2,c_max-w_Label/w_pix-4 ;
    COLOR RGB( 255,0,0, 192,192,192);
    IN WINDOW MainWnd
*    AT r_max - 1.8 ,2 SIZE 1.2,44 ;
ENDIF

* create an image of the map
IF NOT WEXIST( 'Map')
  mtitle = 'Map'
  DEFINE WINDOW Map;
    FROM 0.2,c_max /2 +0.2 TO r_max - 2 - h_Label/h_pix,c_max ;
    TITLE (mtitle) ;
    SYSTEM NOCLOSE FLOAT GROW NOZOOM NOMINIMIZE;
    IN WINDOW MainWnd
	    
  * open Goblin's base with the map
  hPic = GBOpen ;
  ( ;
    LOCFILE( 'MAP.G'), ;
    LOCFILE( 'FLAGS.GR'), ;
    (mtitle), ;
    'DO GOnPic WITH <num>', ;
    'DO DoDoPic WITH "Point a country in the map..."', ;
    'DO OnSizePic WITH <h>, <w>', ;
    .T., ;   
    .T. ;   
  )

  IF hPic <> GHBAD
    IF WorkModeMp = 1
      = GBClip( 1522,1933, 7464,9109,.T.)
    ELSE
      = GBClip( 0,0, 0,0,.T.)
    ENDIF
  ENDIF
ENDIF

* create an image of all flags
IF NOT WEXIST( 'Flags')
  mtitle = 'Flags'
  DEFINE WINDOW Flags;
    FROM 0.2,0.2 TO  (c_max/2.0/var1 -0.4) - 2,c_max/2 -0.2 ;
    TITLE (mtitle) ;
    SYSTEM NOCLOSE FLOAT GROW NOZOOM NOMINIMIZE ;
    IN WINDOW MainWnd

  * open Goblin's base with flags
  hFlag = GBOpen ;
  ( ;
    LOCFILE( 'FLAGS.G'), ;
    LOCFILE( 'FLAGS.GR'), ;
    (mtitle), ;
    'DO GOnFlag WITH <num>', ;
    'DO DoDoFlag WITH "One flag mode"', ;
    'DO OnSizeFlag WITH <h>, <w>', ;
    .F., ;  
    .F. ;   
  )

  IF hFlag <> GHBAD
    IF WorkModeFl = 1
      = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
    ELSE
      = GBClip( 0,0, 0,0,.F.)
    ENDIF
  ENDIF
ENDIF

sc = wcols("FLAGS") /5.0
sr = wrows("FLAGS") /6.0

* create the image of the currently selected flag
IF NOT WEXIST( 'Selected Flag')
  mtitle = 'Selected Flag'
  DEFINE WINDOW Flag;
    AT -sysmetric(9) / ;
       fontmetric(1,Wfont(1,"Flags"),Wfont(2,"Flags"),Wfont(3,"Flags")) /2 ,;
       sc*3 + 0.0125*sc ;
    SIZE (sr*2) - 0.083*sr, sc*2 ;
    TITLE (mtitle) ;
    NOCLOSE NOFLOAT NOGROW NOZOOM NOMINIMIZE  ;
    IN WINDOW Flags

  * open Goblin's base
  hFl = GBOpen ;
  ( ;
    LOCFILE( 'FLAGS.G'), ;
    LOCFILE( 'FLAGS.GR'), ;
    (mtitle), ;
    'ACTIVATE WINDOW Flags', ;
    'DO DoDoFlag WITH "Point a Flag in the set... (Multi flags mode)"', ;
    '',;
    .F., ;  
    .F. ;   
  )

  IF hFl <> GHBAD
    = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
  ENDIF
ENDIF

IF GobExist
  SHOW WINDOW BackMainWnd
ENDIF

* create a window with countries list
IF NOT WEXIST( 'Countries')
  DEFINE WINDOW Countries;
    AT 15.7+ ;
        (sysmetric(4)+sysmetric(8)+sysmetric(13)) / ;
        fontmetric(1,Wfont(1),Wfont(2),Wfont(3)) , 0.2 ;
    SIZE 11.2,29.6 ;
    IN WINDOW MainWnd;
    TITLE 'Countries';
    SYSTEM NOCLOSE FLOAT 
ENDIF
    
ACTIVATE WINDOW Countries NOSHOW
MOVE WINDOW Countries CENTER

IF WVISIBLE("MainWnd")
        ACTIVATE WINDOW MainWnd SAME
ELSE
        ACTIVATE WINDOW MainWnd NOSHOW
ENDIF

DO FillMain   && Fill background of window MAINWND

IF NOT WVISIBLE("MainWnd")
        ACTIVATE WINDOW MainWnd
ENDIF

* Initialize 

* Prepare array of name of Countries
  GOTO TOP
  SET INDEX TO Country.IDX   && index on COUNTRY
  COPY TO ARRAY _Names FIELDS Country.Country

  GOTO TOP
  SET INDEX TO      && close all indexes

  SCATTER FIELDS Country,Id,Capital MEMVAR
  Msg = 'Country: '+ALLTRIM(m.Country)+' Capital: '+m.Capital
  ACTIVATE WINDOW MsgWnd SAME IN MainWnd
  @ 0,0 SAY Msg SIZE 1,200 FONT 'Ms San Serif', 11

  = GBSet( hFlag)
  hoFlag = GOSet( -1, ALLTRIM(m.Id))

* Draw FLAG of current object in enlarged mode
  = GBSet( hFl)
  hoFl = GOSet( -1, ALLTRIM(m.Id))

* Draw COUNTRY of current object in inverted mode
  = GBSet( hPic)
  hoObject = GOSet( -1, ALLTRIM(Id))
  = GOInvert()
  = GOPaint()

cur_Obj = 4            && number current GET object in window COUNTRIES
ActiveCountries = .T.  && .T. if window COUNTRIES is activated
*InitOk = .T.

ACTIVATE WINDOW MsgWnd 
ACTIVATE WINDOW Map 
ACTIVATE WINDOW Flags
IF WorkModeFl = 2
  SHOW WINDOW Flag 
ENDIF
ACTIVATE WINDOW Countries
IF GobExist
  HIDE WINDOW BackMainWnd
ENDIF

IF ExitExist
  @ 0.2,0.2 GET b1 ;
	PICTURE "@*BHN " + ;
		(LOCFILE("exit.bmp","BMP|ICO","Where is exit?")) ;
	SIZE 5.5,6.5 ;
	DEFAULT 1 ;
	VALID DoExit('Exit');
	WHEN Obj_WHEN( 1);
    MESSAGE 'Quit the program'
ELSE
  @ 0.2,0.2 GET b1 ;
	PICTURE "@*HN \?\<Exit" ;
	SIZE 5.5,6.5 ;
	DEFAULT 1 ;
	VALID DoExit('Exit');
	WHEN Obj_WHEN( 1);
    MESSAGE 'Quit the program'
ENDIF

IF OptExist
  @ 0.2,6.9 GET b2;
    PICTURE "@*BHN " + (LOCFILE("option.bmp","BMP|ICO","Where is options?")) ;
    SIZE 5.5,6.5, 0.667 ; 
    DEFAULT 1 ;
    VALID Options() ;
    WHEN Obj_WHEN( 2);
    MESSAGE 'Invoke Options dialog box'
ELSE
  @ 0.2,6.9 GET b2;
    PICTURE "@*HN \<Option" ;
    SIZE 5.5,6.5, 0.667 ; 
    DEFAULT 1 ;
    VALID Options() ;
    WHEN Obj_WHEN( 2);
    MESSAGE 'Invoke Options dialog box'
ENDIF

@ 5.9,0.2 GET b4 ;
	PICTURE "@*HN \<Rearrange" ;
	SIZE 3.5,13.2,1.0 ;
	DEFAULT 1 ;
	VALID Rearrange();
	WHEN Obj_WHEN( 3);
    MESSAGE 'Rearrange ALL Windows'

@ 0.2,13.6 GET b3;
 	PICTURE "@&N" ;
	FROM _Names ;
	DEFAULT _Names(1);
	SIZE 9.2,20.5 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "" ;
	VALID aa() ;
	WHEN _Draw_WHEN(4) ;
	MESSAGE 'Look Through'

IF NOT WVISIBLE("MainWnd")
        ACTIVATE WINDOW MainWnd
ENDIF


READ CYCLE;
       ACTIVATE a1() ;
       DEACTIVATE D1() ;
       WHEN init_OK();
       with Map, Flag, Flags, Countries

*       *********************************************************
*       *                                                         
*       *                Windows Closing Databases                
*       *                                                         
*       *********************************************************
*

IF USED("country")
    SELECT country
	USE
ENDIF

* SET READBORDER &rborder
=GBSET(hPic)
=GBCLOSE()
=GBSET(hFl)
=GBCLOSE()
=GBSET(hFlag)
=GBCLOSE()
RELEASE WINDOW MainWnd
CLEAR ALL
CLEAR
SHOW WINDOW ALL
RELEASE LIBRARY FULLPATH( 'fpGOBLIN.dll', 1)
RELEASE ALL
SET MESSAGE TO ' '

*************************************************************************
**  Procedures and Functions                                           **
*************************************************************************

*                                 init_Ok
*                                 =======
*
*  
*
FUNCTION init_Ok
private num, state, name
  num = 0
  state = 0
  name = ''

left_fl  = 10
top_fl   = 650
right_fl = 170
bot_fl   = 530
  = GBSet( hFlag)
  = GOSet( hoFlag, '')
  = GOGet( @num, @state, @name, @left_fl,@bot_fl, @right_fl,@top_fl)

left_map  = 0
top_map   = 0
right_map = 0
bot_map   = 0
  = GBSet( hPic)
  = GOSet( hoObject, '')
  = GOGet( @num, @state, @name, @left_map,@bot_map, @right_map,@top_map)

  IF NOT InitOk
    InitOk = .T.
  ENDIF

return .T.

*                                 FillMain
*                                 ========
*
*
*
PROCEDURE FillMain
  s = ' GOBLIN Library 1.00 '
  ss = ''
  for j = 0 to c_max step txtwidth( s, 'helv', 10, "N")
    ss = ss+s
  ENDFOR
  lenS = txtwidth( ss, 'helv', 10, "N")
  DO WHILE 1.0*lenS*fontmetric( 6, 'helv', 10, "N") /w_pix > c_max
    ss = substr( ss, 1, LEN(ss)-1)
    lenS = txtwidth( ss, 'helv', 10, "N")
  ENDDO
  ss = substr( ss, 1, LEN(ss)-1)
  s = REPLICATE( 'Q', txtwidth( " ", 'helv', 16, 'N')*1.0*fontmetric( 7, 'helv', 16, "N") /w_pix*c_max)
  for i = 0 to r_max step 1.0*fontmetric( 1, 'helv', 16, "N") /h_pix
    @ i, 0 SAY s font 'HELV', 16 STYLE " " color RGB( 192,192,192, 192,192,192)
    @ i, 0 SAY ss font 'HELV', 10 STYLE " " color RGB( 0,0,0, 192,192,192)
  ENDFOR

  IF LabelExist
* Bitmap LABEL.BMP to right bottom corner of screen
    @ r_max - h_Label/h_pix, c_max - w_Label/w_pix; 
      SAY "LABEL.BMP" BITMAP ;
     SIZE h_Label/h_pix+0.1,w_Label/w_pix+0.1;
     STYLE "Q"
  ELSE
* Information about Copyright to right bottom corner of screen
    @ r_max - h_Label/h_pix, c_max - w_Label/w_pix; 
      SAY "Soft Tver, 1994";
      SIZE h_Label/h_pix,w_Label/w_pix;
      STYLE "Q";
      COLOR RGB(0,0,0, 255, 255, 255)
  ENDIF
RETURN

*                                 ReArrange
*                                 =========
*
*
*
FUNCTION ReArrange

IF InitOk
  c_beg = wlcol('')   && column of top-left corner Main FoxPro window
  r_beg = wlrow('')   && row of top-left corner Main FoxPro window
  c_max = wcols('')   && max number of cols in Main FoxPro window
  r_max = wrows('')   && max number of rows in Main FoxPro window
  IF r_max < 25
    r_max = 25
  ENDIF

  IF c_max < 60
    c_max = 60
  ENDIF

* Modify coordinate Main FoxPro window
  MODIFY WINDOW SCREEN ; 
    AT r_beg, c_beg SIZE r_max, c_max

  ACTIVATE WINDOW MainWnd
  IF GobExist
    MODIFY WINDOW BackMainWn ;
     AT 0,0 SIZE r_max, c_max 
    SHOW WINDOW BackMainWnd
  ENDIF

  HIDE WINDOW MainWnd 
  MODIFY WINDOW MainWnd ;
    AT 0,0 SIZE r_max, c_max ;
    COLOR RGB( 255,0,0, 192,192,192)

  DO FillMain
* create Message window
  MODIFY WINDOW MsgWnd ;
    AT r_max - 1.8 ,2 SIZE 1.2,c_max-w_Label/w_pix-4 ;
    COLOR RGB( 255,0,0, 192,192,192)

  MOVE WINDOW Countries CENTER
* create an image of the map
  MODIFY WINDOW Map;
    FROM 0.2,c_max /2 +0.2 TO r_max - 2 - h_Label/h_pix,c_max 
	    
  MODIFY WINDOW Flags;
    FROM 0.2,0.2 TO  (c_max/2.0/var1 -0.4) - 2,c_max/2 -0.2 

  =DoRefresh()
  SHOW WINDOW MainWnd
  IF GobExist
    HIDE WINDOW BackMainWnd
  ENDIF
*  ACTIVATE WINDOW Countries
ENDIF
RETURN .F.

*                                 a1
*                                 ==
*
*  
*
FUNCTION a1
_CUROBJ = cur_Obj
return .T.

*                                 aa
*                                 ==
*
*  
*
FUNCTION aa
_CUROBJ = cur_Obj
return .T.

*                                 d1
*                                 ==
*
*
*
FUNCTION d1
ActiveCountries = .F.
return .F.

*                                 Obj_WHEN
*                                 ========
*
*
*
FUNCTION Obj_WHEN     
PARAMETER num_Obj
IF ActiveCountries
  CUR_OBJ = num_Obj
ENDIF
ActiveCountries = .T.
return 

*                                 _Draw_WHEN
*                                 ==========
*
*
*
FUNCTION _Draw_WHEN   
PARAMETER num_Obj
IF InitOk
IF m.country <> b3
  =Obj_When(num_Obj)
  SET INDEX TO country
  SEEK b3
  IF FOUND()
    SCATTER FIELDS Country,Id,Capital MEMVAR
  ENDIF
  =Redrwbase()
ENDIF
ENDIF
return 

*                                    GOnPic
*                                    =======
*
* Processing of selection in 'Map' window
* Show message
*
*
PROCEDURE GOnPic
PARAMETERS num
IF InitOk
  IF NOT WONTOP( 'Options')
   ACTIVATE WINDOW Map && SAME
   IF num = 0
     Msg = "No country was selected, try again..."
   ELSE
     *
     * Ask Goblin for selected country's Id
     *
     OCode = ''
     = GBSet( hPic)
     = GOSelected( -1, @OCode)
     *
     * get a name by its Id from DBF
     *
    IF ALLTRIM(OCode) <> ALLTRIM( Country.Id)
     SET INDEX TO Id
     SEEK (OCode)
     IF FOUND()
       SCATTER FIELDS Country,Id,Capital MEMVAR
     ENDIF
     =REDRWBase()
    ENDIF
   ENDIF
  ENDIF
ENDIF
RETURN .F.

*                                    GOnFlag
*                                    =======
*
* Selection processing in 'Flags' window
* Show message
*
*
PROCEDURE GOnFlag
PARAMETERS num
IF InitOk
 IF NOT WONTOP( 'OPtions')
  ACTIVATE WINDOW Flags 
  IF WorkmodeFl = 2  && show all flags 
    IF num = 0
      Msg = "No flag was selected, try again..."
    ELSE
      *
      * Ask Goblin for selected flag's Id
      *
      OCode = ''
      = GBSet( hFlag)
      = GOSelected( -1, @OCode)
      *
      * get name by Id from DBF
      *
     IF ALLTRIM(OCode) <> ALLTRIM( Country.Id)
      SET INDEX TO Id
      SEEK (OCode)
      IF FOUND()
        SCATTER FIELDS Country,Id,Capital MEMVAR
      ENDIF
      =ReDRWBase()
     ENDIF
    ENDIF
  ENDIF
 ENDIF
ENDIF
RETURN .F.

*                                 DoDoPic
*                                 =======
*  
*  
*
FUNCTION DoDoPic
PARAMETERS Text
 SET MESSAGE TO text
RETURN .F.

*                                 DoDoFlag
*                                 ========
*  
*  
*
FUNCTION DoDoFlag
PARAMETERS Text
 SET MESSAGE TO text
RETURN .F.

*                                 OnSizeFlag
*                                 ==========
*  	
*  
*
PROCEDURE OnSizeFlag
PARAMETERS height, width
IF InitOk
* Repaint Flags
  = GBSet( hFlag)
  IF WorkmodeFl = 1  && One Flag
*    IF WVISIBLE( 'Flag') 
*      HIDE WINDOW Flag
*    ENDIF
    = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
  ELSE
    IF WorkmodeFl = 2  && All Flags
      = GBClip( 0,0, 0,0,.F.)

      sc = width /5.0/fontmetric(6,Wfont(1,"Flags"),Wfont(2,"Flags"),Wfont(3,"Flags"))
      sr = height /6.0/fontmetric(1,Wfont(1,"Flags"),Wfont(2,"Flags"),Wfont(3,"Flags"))
      MODIFY WINDOW Flag ;
        AT -sysmetric(9) / ;
           fontmetric(1,Wfont(1,"Flags"),Wfont(2,"Flags"),Wfont(3,"Flags")) /2 ,;
           sc*3 + 0.0125*sc ;
        SIZE (sr*2) - 0.083*sr, sc*2 
      IF WVISIBLE( 'Flag') 
        HIDE WINDOW Flag 
      ENDIF

      = GBSet( hFl)
      = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
      IF NOT WVISIBLE( 'Flag') 
        SHOW WINDOW Flag SAME
      ENDIF
    ENDIF
  ENDIF
ENDIF
RETURN 

*                                 OnSizePic
*                                 =========
*  	
*  
*
PROCEDURE OnSizePic
PARAMETERS height, width
private x2,y2
IF InitOk
 && Repaint Map
  = GBSet( hPic)  && current map's base 
  IF WorkmodeMp = 1   && One country
    x2 = right_map - left_map
    y2 = bot_map - top_map
    = GBClip( left_map-x2,bot_map+y2, right_map+x2,top_map-y2,.T.)
  ELSE
    IF WorkmodeMp = 2  && All Countries
      = GBClip( 0,0, 0,0,.T.) && all base into window
    ENDIF
  ENDIF
ENDIF
RETURN 

*                                 DoExit
*                                 ======
*  
*  
*
FUNCTION DoExit
PARAMETER Text
  SET MESSAGE TO text
  CLEAR READ
RETURN .F.

*                                 DoRefresh
*                                 =========
*  
*  
*
FUNCTION DoRefresh
  &&  Redraw Flags
  =ReDrawFl()
  &&  Redraw Map
  =ReDrawMap()
  ACTIVATE WINDOW Countries
RETURN .F.

*                                 REDrawFl
*                                 ==========
*  	
*  
*
PROCEDURE REDrawFl
 && Repaint Flags
  = GBSet( hFlag)
  IF WorkmodeFl = 1  && One Flag
    IF WEXIST( 'Flag') 
      DEACTIVATE WINDOW Flag
    ENDIF
    = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
  ELSE
    IF WorkmodeFl = 2  && All Flags
      = GBClip( 0,0, 0,0,.F.)  && redraw base in window FLAGS

      sc = wcols("FLAGS") /5.0
      sr = wrows("FLAGS") /6.0
      MODIFY WINDOW Flag ;
        AT -sysmetric(9) / ;
            fontmetric(1,Wfont(1,"Flags"),Wfont(2,"Flags"),Wfont(3,"Flags")) /2 ,;
            sc*3 + 0.0125*sc ;
        SIZE (sr*2) - 0.083*sr, sc*2 

      = GBSet( hFl)
      = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
      IF NOT WVISIBLE( 'Flag') 
        SHOW WINDOW Flag SAME
      ENDIF
    ENDIF
  ENDIF
RETURN 

*                                 REDrawMap
*                                 =========
*  	
*  
*
PROCEDURE REDrawMap
private x2,y2
 && Repaint Map
  = GBSet( hPic)
  IF WorkmodeMp = 1   && One country
    x2 = right_map - left_map
    y2 = bot_map - top_map
    = GBClip( left_map-x2,bot_map+y2, right_map+x2,top_map-y2,.T.)
  ELSE
    IF WorkmodeMp = 2  && All Countries
      = GBClip( 0,0, 0,0,.T.)
    ENDIF
  ENDIF
RETURN 

*                                 REDRWBase
*                                 ==========
*  
*  
*
FUNCTION REDRWBase
private num, state, name
private x,y
  num = 0
  state = 0
  name = ''
 && Repaint Flag
  = GBSet( hFlag)
  = GOSet( hoFlag, '')
  hoFlag = GOSet( -1, ALLTRIM(m.Id))
  IF hoFlag <> GHBAD
    IF WorkmodeFl = 1
      IF WEXIST( 'Flag') 
        DEACTIVATE WINDOW Flag
      ENDIF
      = GOGet( @num, @state, @name, @left_fl,@bot_fl, @right_fl,@top_fl)
      = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
    ELSE
     IF WorkmodeFl = 2
        = GBSet( hFl)
        = GOSet( hoFl, '')
        hoFl = GOSet( -1, ALLTRIM(m.Id))
        IF hoFl <> GHBAD
          = GOGet( @num, @state, @name, @left_fl,@bot_fl, @right_fl,@top_fl)
          = GBClip( left_fl,bot_fl, right_fl,top_fl,.F.)
        ENDIF
        IF NOT WVISIBLE( 'Flag') 
*          SHOW WINDOW Flag SAME
        ENDIF
      ENDIF
    ENDIF
  ENDIF
  && Repaint Map
  = GBSet( hPic)
  = GOSet( hoObject, '')
  = GOInvert()
  = GOPaint()
  hoObject = GOSet( -1, ALLTRIM(m.Id))
  = GOInvert()
  IF hoObject <> GHBAD
    IF WorkmodeMp = 1   && One country
      num = 0
      state = 0
      name = ''
      = GOGet( @num, @state, @name, @left_map,@bot_map, @right_map,@top_map)
      x = right_map - left_map
      y = bot_map - top_map
      = GBClip( left_map-x/2,bot_map+y/2, ;
                right_map+x/2,top_map-y/2,.T.)
    ELSE
      = GOPaint()
    ENDIF
  ENDIF
  IF ALLTRIM(m.Country) <> ALLTRIM(b3)
    b3 = m.Country
    show gets
  ENDIF
  Msg = "Country: "+ALLTRIM(m.Country)+' Capital: '+m.Capital
  ACTIVATE WINDOW MsgWnd SAME
  @ 0,0 SAY Msg SIZE 1,200 FONT 'Ms San Serif', 11
RETURN .T.
