#ifndef LIBRARIES_GUITOOLS_H
#define LIBRARIES_GUITOOLS_H

/*
**    $VER: guitools.h 38.0 (23.01.94)
**
**    GUITools library structures, constants and definitions
**
**   (C) Copyright 1994 Carsten Ziegeler
**       Freeware, see GUITools-Documentation
*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef GRAPHICS_DISPLAYINFO_H
#include <graphics/displayinfo.h>
#endif

#ifndef GRAPHICS_TEXT_H
#include <graphics/text.h>
#endif

#ifndef INTUITION_INTUITION_H
#include <intuition/intuition.h>
#endif

#ifndef LIBRARIES_GADTOOLS_H
#include <libraries/gadtools.h>
#endif

/* ======================================================================= */
/*                              Constants                                  */
/* ======================================================================= */

#define GUIToolsName "guitools.library"

/* ------------- result from CreateGUIInfoTags in guiCreateError --------- */

#define cgiNoError        0   /* V38  everything seams to be OK*/
#define cgiNoWindow       1   /* V38  no window specified */
#define cgiNoVisualInfo   2   /* V38  couldn't get VisualInfo */
#define cgiNoMemory       3   /* V38  not enough memory */
#define cgiNoDrawInfo     4   /* V38  couldn't get DrawInfo */
#define cgiCreateContext  5   /* V38  error calling CreateContext */


/* ----------------- results from SetGUI / RedrawGUI --------------------- */

#define  guiSet            0    /* no error ,everything done */
#define  gadgetError       1    /* error calling CreateGadget */
#define  menuError         2    /* error calling CreateMenuA */
#define  memError          3    /* not enough memory */

#define  gadKeyDefTwice    4    /* V38  same key-equivalent for 2 gadgets */
#define  menuSetError      5    /* V38  error calling SetMenuStrip */
#define  menuLayoutError   6    /* V38  error calling LayoutMenusA */
#define  gadKeyNotAllowed  7    /* V38  key-Equivalent is not a letter */
#define  tooManyGadsError  8    /* V38  more gadgets as mentioned in Create*/
#define  tooManyMenusError 9    /* V38  more menu-items as mentioned Create*/
#define  gadKeyNotFound    10   /* V38  GT_Underscore-Tag found, but the char
                                        is missing in the text */
#define  noGadToolsGadKind 11   /* V38  no GadTools-Gadget */
#define  noGUIToolsGadKind 12   /* V38  no GUITools-Gadget */
#define  rdGUIContextError 13   /* V38  RedrawGUI: error calling
                                        CreateContext */


/* ---------------- OpenIntWindow/Tags width and height ------------------ */

#define  asScreen    -1


/* --------------------- ResizeGadget ------------------------------------ */

#define  preserve    -1         /* V38 */


/* ------------ predefined displayIDs for OpenIntScreen/Tags ------------- */

#define  hiresPalID  (HIRES_KEY + PAL_MONITOR_ID)
#define  hiresID     (HIRES_KEY + DEFAULT_MONITOR_ID)
#define  loresPalID  (LORES_KEY + PAL_MONITOR_ID)
#define  loresID     (LORES_KEY + DEFAULT_MONITOR_ID)


/* -------------------- CreateGUIInfo / CreateGUIInfoTags ---------------- */

#define  noGadgets  0      /* V38 */
#define  noMenu     0      /* V38 */


/* --------------------- Gadget-Kinds for CreateSpecialGadget ------------ */

#define guiToolsKinds          65535  /* V38  now follow GUITools-Gadgets */
#define progressIndicatorKind  65536  /* V38 */
#define bevelboxKind           65537  /* V38 */


/* -------------------- Requester-Kinds for ShowRequester ---------------- */

#define generalReqKind  0    /* V38 */
#define okReqKind       1    /* V38 */
#define doitReqKind     2    /* V38 */
#define yncReqKind      3    /* V38 */

/* ---------------------- results from ShowRequester --------------------- */

#define reqYes     1  /* V38  yncReqKind */
#define reqNo      2  /* V38 */
#define reqCancel  0  /* V38 */
#define reqOK      0  /* V38  okReqKind */
#define reqDo      1  /* V38  doitReqKind */
#define reqLeave   0  /* V38 */


/* ======================================================================= */
/*                                 Types                                   */
/* ======================================================================= */

/* ------------------------ Hook-Functions ------------------------------- */

/* Hook-Function for key-equivalents       V38

     GUITools calls the hook-function in this way:

     ULONG vk_Function(register __d0 char key,
                       register __a0 WORD  *nbr,
                       register __a1 WORD  *shift);

     D0 contains the key . A0 is a pointer to WORD. Through this WORD the
     hook-function specifies the gadget-number.
     A1 points to WORD. Should the key treated as a shifted key (0 = no/
     FALSE or 1 = yes/TRUE).
     The result must be TRUE, if the key is an equivalent.


   MenuFct:                             V38

     ULONG menu_Function(void)

                    This function is called, when an IDCMP_MenuPick-Message
                    arrives and the GFLG_CallMenuData-flag is set.
                    If you want to wait for further messages return
                    TRUE / 1, otherwise 0 / FALSE to exit the message-loop

*/


/* --------------------------- GUIInfoFlagSet ---------------------------- */


#define GFLG_StringNotify             0x0000001
                                    /* notifies the string-address */
#define GFLG_IntegerNotify            0x0000002
                                    /* GTIN_Number : &LONG */
#define GFLG_LinkEntryGads            0x0000004
                                    /* activate automatically the next
                                       entry-gadget */
#define GFLG_CycleEntryGads           0x0000008
                                    /* If you exit the last EntryGadget
                                       activate again the first one */
#define GFLG_ActivateFirstEGad        0x0000010
                                    /* after creating gadgets, activate
                                       the first entry-gadget */
#define GFLG_CycleNotify              0x0000020
                                    /* GTCY_Active : &UWORD */
#define GFLG_CheckboxNotify           0x0000040
                                    /* GTCB_Checked: &UBYTE */
#define GFLG_AutoUpdateEGads          0x0000080
                                    /* Copy the contents of the entry-
                                       gadgets in the variables when an
                                       IDCMP_GadgetUp-Message arrives */
#define GFLG_MXNotify                 0x0000100
                                    /* GTMX_Active : &UWORD */

#define GFLG_VanillaKeysNotify        0x0000200
                                    /* V38  notify key-equivalents */
#define GFLG_ConvertKeys              0x0000400
                                    /* V38  and convert them automatically
                                            into gadget-messages if hit */
#define GFLG_NoHandleIntMsgCall       0x0000800
                                    /* V38  do not call HandleIntMsg when
                                            using WaitIntMsg/GetIntMsg */
#define GFLG_SliderNotify             0x0001000
                                    /* V38  GTSL_Level : &WORD */
#define GFLG_ScrollerNotify           0x0002000
                                    /* V38  GTSC_Top   : &WORD */
#define GFLG_ListviewNotify           0x0004000
                                    /* V38  GTLV_Selected : &UWORD */
#define GFLG_InternMsgHandling        0x0008000
                                    /* V38  the messages that are complete
                                            processed by GUITools will not
                                            be send to the main-program */
#define GFLG_LVKeyClearTime           0x0010000
                                    /* V38  this clears the Sekonds-entry
                                            of the intui-message from a
                                            LISTVIEW_KIND-gadget if the
                                            key-equivalent was used */
#define GFLG_AllowAllVanillaKeys      0x0020000
                                    /* V38  All key-equivalents are allowed
                                            and not only letters */
#define GFLG_AddBorderDims            0x0040000
                                    /* V38  Adds when defining gadgets
                                            window->BorderLeft to left and
                                            window->BorderTop to top */
#define GFLG_CallVanillaKeyFct        0x0080000
                                    /* V38  calls the hook-function if
                                            GUITools can't handle the
                                            IDCMP_VanillaKey-Code */
#define GFLG_CallMenuData             0x0100000
                                    /* V38  jsr menuitem->MenuData */
#define GFLG_DoRefresh                0x0200000
                                    /* V38  automatic refresh */
#define GFLG_AddStdUnderscore         0x0400000
                                    /* V38  add GT_Underscore-Tag */
#define GFLG_PaletteNotify            0x0800000
                                    /* V38  GTPA_Color : &UWORD */


/* ---------------------------- GUIInfo ---------------------------------- */

struct gadmsg {
       WORD  gadID;                   /* with IDCMP_GadgetUp/GadgetDown-
                                         Msgs: gadgetID */
       struct Gadget *gadget;         /* and pointer to event-gadget */
       };
struct menumsg {
       WORD menuNum;                  /* corresponding numbers for */
       WORD itemNum;                  /* IDCMP_MenuPick and IDCMP_MenuHelp */
       WORD subNum;                   /* (*V38*) messages */
       };

struct GUIGadlist {
       struct Gadget *allGadgets[256];
       };

struct GUIMenulist {
       struct NewMenu allMenus[256];
       };

struct GUIInfo {

  struct Window *window;             /* pointer to the used window */
  struct Screen *screen;             /* pointer to window-screen */
  struct TextAttr  font;             /* Font for menus und gadgets (V37.3),
                                        can be changed. From (*38*) on only
                                        for gadgets when using
                                        CreateGUIInfoTags ! */
  APTR   visual;                     /* Pointer to screens VisualInfo */
  struct MsgPort *port;              /* Pointer to IDCMP-Port, kcan be
                                        changed for multiple windows with
                                        a shared port (not yet tested!) */
  struct Gadget *gadlist;            /* pointer to gadget-list */
  struct DrawInfo *drawinfo;         /* V38 Pointer to a copy of DrawInfo */
  struct NewGadget newgad;           /* used for CreateGadget,
                                        can be directly manipulated */
  WORD   actgad;                     /* actuel CreateGadget */
  WORD   private0;                   /* PRIVATE */
  struct GUIGadlist *gadgets;        /* max 256 ! */

  struct Menu  *menus;               /* Pointer to new menu */
  WORD   actmenu;                    /* same as with gadgets */
  WORD   private1;                   /* PRIVATE */
  struct GUIMenulist *newMenus;      /* max 256 ! */

  struct IntuiMessage im;            /* copy of IntuiMessage */

  union {
    struct gadmsg  gm;
    struct menumsg mm;
  } im_un;

  ULONG  flags;                      /* valid flags, to be changed */

  union {
    UWORD  cardCode;                 /* V38 copy of the IntuiMsg-code-entry*/
    WORD   intCode;                  /* V38 */
    struct oc {
      UBYTE boolCode;                /* V38 for CHECKBOX_KIND */
      char  charCode;                /* V38 */
    };
  } mc_un;

  WORD  gadNbr;                      /* V38 gadget-number in the
                                            gadgets-field */
  struct TextAttr *menuFont;         /* V38 pointer to menuFont. Is set to
                                        screens font with CreateGUIInfoTags
                                        and to GUIInfo->font with
                                        CreateGUIInfo */
  APTR   vanKeyHook;                 /* V38 Hook-Fct for key-equivalents */
  ULONG  msgClass;                   /* IntuiMessage-IDCMPFlags */

  union {
    struct MenuItem *itemAdr;        /* V38 Item-Address */
    struct NewMenu  *menuAdr;        /* V38 act. NewMenu */
  } ma_un;
};


/* --------------------------- GUIGadgetInfo ----------------------------- */

struct GUIGadgetInfo     /* a pointer to this structure is stored in
                            gadget^.userData */
{
  APTR  userData;        /* use this for own user-data */
  ULONG kind;            /* gadget-kind */
};


/* ======================================================================= */
/*                                 Tags                                    */
/* ======================================================================= */

/* -------------------- Tags for CreateGUIInfoTags ----------------------- */

#define GUI_Dummy             (TAG_USER + 0x15000)
#define GUI_ResizableGads     (GUI_Dummy + 1)   /* V38 UBYTE / 0 */
#define GUI_Flags             (GUI_Dummy + 2)   /* V38 ULONG / 0 */
#define GUI_GadFont           (GUI_Dummy + 3)   /* V38 *TextAttr /
                                                   window->Font =gui->font*/
#define GUI_MenuFont          (GUI_Dummy + 4)   /* V38 *TextAttr /
                                                   screen->Font */
#define GUI_VanKeyFct         (GUI_Dummy + 5)   /* V38 APTR / NULL */
#define GUI_CreateError       (GUI_Dummy + 6)   /* V38 *LONG / NULL */
#define GUI_SetProcessWindow  (GUI_Dummy + 7)   /* V38 UBYTE / 0 */
#define GUI_RestoreProcessWindow (GUI_Dummy+8)  /* V38 UBYTE / 0 */
#define GUI_RefreshWindowFrame   (GUI_Dummy+9)  /* V38 UBYTE */

/* -------------------- Tags for CreateSpecialGadget --------------------- */

#define SG_Dummy              (TAG_USER + 0x16000)
#define SG_GadgetText         (SG_Dummy + 1)    /* V38 APTR / NULL */
#define SG_GadgetFlags        (SG_Dummy + 2)    /* V38 ULONG / 0 */
#define SGPI_MaxValue         (SG_Dummy + 3)    /* V38 UWORD / 100 */
#define SGPI_CurrentValue     (SG_Dummy + 4)    /* V38 UWORD /   0 */
#define SGBB_Recessed         (SG_Dummy + 5)    /* UBYTE / 0 */


/* -------------------- Tags for ShowRequester --------------------------- */

#define SR_Dummy              (TAG_USER + 0x17000)
#define SG_Gadgets            (SR_Dummy + 1)    /* *char / NULL */
#define SG_Args               (SR_Dummy + 2)    /* APTR / NULL */
#define SG_Flags              (SR_Dummy + 3)    /* ULONG / 0 */
#define SG_Title              (SR_Dummy + 4)    /* *char / NULL */
#define SG_IDCMP              (SR_Dummy + 5)    /* *ULONG / NULL */
#define SG_ReqWindow          (SR_Dummy + 6)    /* *Window / gui->window */


/* --------- protos ------------- */

struct GUIInfo *CreateGUIInfo(struct window *, WORD, WORD);
void FreeGUIInfo(struct GUIInfo *);
WORD SetGUI(struct GUIInfo *);
void CreateGadgetTag(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                     struct TagItem *);
void CreateGadget(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                  ULONG, ...);
void CreateGadgetTextTag(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                         STRPTR, struct TagItem *);
void CreateGadgetText(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                      STRPTR, ULONG, ...);
void CreateGadgetFullTag(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                         STRPTR, ULONG, struct TagItem *);
void CreateGadgetFull(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                      STRPTR, ULONG, ULONG, ...);
void MakeMenuEntry(struct GUIInfo *, UBYTE, STRPTR, STRPTR);
void WaitIntMsg(struct GUIInfo *);
UBYTE GetIntMsg(struct GUIInfo *);
void EmptyIntMsgPort(struct GUIInfo *);
void DrawBox(struct GUIInfo *, WORD, WORD, WORD, WORD, UBYTE);      /* V38 */
void GadgetStatus(struct GUIInfo *, WORD, UBYTE);
void ModifyGadgetTag(struct GUIInfo *, WORD, struct TagItem *);
void ModifyGadget(struct GUIInfo *, WORD, ULONG, ...);
void UpdateEntryGadgets(struct GUIInfo *);
struct TextAttr *TopazAttr(void);
struct TextFont *GetOwnFont(STRPTR, UWORD, struct TextAttr *);
void RemOwnFont(struct TextFont *);
struct Screen *OpenIntScreen(ULONG, WORD, STRPTR, struct TextAttr *);
struct Window *OpenIntWindow(WORD, WORD, WORD, WORD, STRPTR, ULONG, ULONG,
                             struct Screen *);
void CloseIntWindow(struct Window *);
void CloseIntScreen(struct Screen *);
void HandleIntMsg(struct GUIInfo *);
void UpdateEGad(struct GUIInfo *, WORD);
void ConvKMsgToGMsg(struct GUIInfo *);                              /* V38 */
void VarToGad(struct GUIInfo *, WORD);                              /* V38 */
void AllVarsToGad(struct GUIInfo *);                                /* V38 */
void GadWithKey(struct GUIInfo *, WORD, UBYTE);                     /* V38 */
struct Screen *OpenIntScreenTagList(ULONG, WORD, STRPTR, struct TextAttr *,
                                    struct TagItem *);              /* V38 */
struct Screen *OpenIntScreenTags(ULONG, WORD, STRPTR, struct TextAttr *,
                                 ULONG, ...);                       /* V38 */
struct Window *OpenIntWindowTagList(WORD,WORD, WORD, WORD, STRPTR, ULONG,
                      ULONG, struct Screen *, struct TagItem *);    /* V38 */
struct Window *OpenIntWindowTags(WORD,WORD, WORD, WORD, STRPTR, ULONG,
                      ULONG, struct Screen *, ULONG, ...);          /* V38 */
WORD RedrawGadgets(struct GUIInfo *, UBYTE);                        /* V38 */
WORD RedrawMenu(struct GUIInfo *);                                  /* V38 */
void ResizeGadget(struct GUIInfo *, WORD, WORD, WORD, WORD, WORD);  /* V38 */
void NewGadgetFont(struct GUIInfo *, WORD, struct TextAttr *);      /* V38 */
void NewGadgetText(struct GUIInfo *, WORD, STRPTR);                 /* V38 */
void RemoveGadgets(struct GUIInfo *, UBYTE);                        /* V38 */
void RemoveMenu(struct GUIInfo *, UBYTE);                           /* V38 */
struct GUIInfo *CreateGUIInfoTagList(struct Window *, WORD, WORD,
                                  struct TagItem *);                /* V38 */
struct GUIInfo *CreateGUIInfoTags(struct Window *, WORD, WORD,
                                  ULONG, ...);                      /* V38 */
void NewFontAllGadgets(struct GUIInfo *, struct TextAttr *);        /* V38 */
void ClearWindow(struct GUIInfo *);                                 /* V38 */
void CreateSpecialGadgetTag(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                            struct TagItem *);                      /* V38 */
void CreateSpecialGadget(struct GUIInfo *, WORD, WORD, WORD, WORD, ULONG,
                         ULONG, ...);                               /* V38 */
void BeginRefresh(struct GUIInfo *);                                /* V38 */
void EndRefresh(struct GUIInfo *, UBYTE);                           /* V38 */
LONG ShowRequesterTag(struct GUIInfo *, STRPTR, ULONG,
                      struct TagItem *);                            /* V38 */
LONG ShowRequester(struct GUIInfo *, STRPTR, ULONG,
                   ULONG, ...);                                     /* V38 */
struct Window *SetProcessWindow(struct Window *);                   /* V38 */
LONG SimpleReq(STRPTR, ULONG);                                      /* V38 */


/* --------- pragmas ------------ */

extern struct Library *GUIToolsBase;

#pragma libcall GUIToolsBase CreateGUIInfo 1e 10803
#pragma libcall GUIToolsBase FreeGUIInfo 24 801
#pragma libcall GUIToolsBase SetGUI 2a 801
#pragma libcall GUIToolsBase CreateGadgetTag 30 943210807
#pragma tagcall GUIToolsBase CreateGadget 30 943210807
#pragma libcall GUIToolsBase CreateGadgetTextTag 36 A943210808
#pragma tagcall GUIToolsBase CreateGadgetText 36 A943210808
#pragma libcall GUIToolsBase CreateGadgetFullTag 3c A5943210809
#pragma tagcall GUIToolsBase CreateGadgetFull 3c A5943210809
#pragma libcall GUIToolsBase MakeMenuEntry 42 A90804
#pragma libcall GUIToolsBase WaitIntMsg 48 801
#pragma libcall GUIToolsBase GetIntMsg 4e 801
#pragma libcall GUIToolsBase EmptyIntMsgPort 54 801
#pragma libcall GUIToolsBase DrawBox 5a 43210806                /* V38 */
#pragma libcall GUIToolsBase GadgetStatus 60 10803
#pragma libcall GUIToolsBase ModifyGadgetTag 66 90803
#pragma tagcall GUIToolsBase ModifyGadget 66 90803
#pragma libcall GUIToolsBase UpdateEntryGadgets 6c 801
#pragma libcall GUIToolsBase TopazAttr 72 0
#pragma libcall GUIToolsBase GetOwnFont 78 90803
#pragma libcall GUIToolsBase RemOwnFont 7e 801
#pragma libcall GUIToolsBase OpenIntScreen 84 981004
#pragma libcall GUIToolsBase OpenIntWindow 8a 9548321008
#pragma libcall GUIToolsBase CloseIntWindow 90 801
#pragma libcall GUIToolsBase CloseIntScreen 96 801
#pragma libcall GUIToolsBase HandleIntMsg 9c 801
#pragma libcall GUIToolsBase UpdateEGad a2 0802
#pragma libcall GUIToolsBase ConvKMsgToGMsg a8 801          /* V38 */
#pragma libcall GUIToolsBase VarToGad ae 0802               /* V38 */
#pragma libcall GUIToolsBase AllVarsToGad b4 801            /* V38 */
#pragma libcall GUIToolsBase GadWithKey ba 10803            /* V38 */
#pragma libcall GUIToolsBase OpenIntScreenTagList c0 A981005   /* V38 */
#pragma tagcall GUIToolsBase OpenIntScreenTags c0 A981005      /* V38 */
#pragma libcall GUIToolsBase OpenIntWindowTagList c6 A9548321009  /* V38 */
#pragma tagcall GUIToolsBase OpenIntWindowTags c6 A9548321009     /* V38 */
#pragma libcall GUIToolsBase RedrawGadgets cc 0802          /* V38 */
#pragma libcall GUIToolsBase RedrawMenu d2 801              /* V38 */
#pragma libcall GUIToolsBase ResizeGadget d8 43210806       /* V38 */
#pragma libcall GUIToolsBase NewGadgetFont de 90803         /* V38 */
#pragma libcall GUIToolsBase NewGadgetText e4 90803         /* V38 */
#pragma libcall GUIToolsBase RemoveGadgets ea 0802          /* V38 */
#pragma libcall GUIToolsBase RemoveMenu f0 0802             /* V38 */
#pragma libcall GUIToolsBase CreateGUIInfoTagList f6 910804 /* V38 */
#pragma tagcall GUIToolsBase CreateGUIInfoTags f6 910804    /* V38 */
#pragma libcall GUIToolsBase NewFontAllGadgets fc 9802      /* V38 */
#pragma libcall GUIToolsBase ClearWindow 102 801            /* V38 */
#pragma libcall GUIToolsBase CreateSpecialGadgetTag 108 943210807  /* V38 */
#pragma tagcall GUIToolsBase CreateSpecialGadget 108 943210807     /* V38 */
#pragma libcall GUIToolsBase BeginRefresh 10e 801           /* V38 */
#pragma libcall GUIToolsBase EndRefresh 114 0802            /* V38 */
#pragma libcall GUIToolsBase ShowRequesterTag 11a A09804    /* V38 */
#pragma tagcall GUIToolsBase ShowRequester 11a A09804       /* V38 */
#pragma libcall GUIToolsBase SetProcessWindow 120 801       /* V38 */
#pragma libcall GUIToolsBase SimpleReq 126 0802             /* V38 */

#endif /* LIBRARIES_GUITOOLS_H */
