/**********************************************************************
:Program.    WBDemo.c
:Contents.   guitools.library demonstration
:Author.     Carsten Ziegeler
:Address.    Augustin-Wibbelt-Str.7, 33106 Paderborn
:Phone.      05254/67439
:Copyright.  Freeware, refer to documentation
:Language.   C
:Translator. SASC 6.51
:Remark.     OS 2.0 required
:Remark.     requires guitools.library V38.0
:History.    v1.1  Carsten Ziegeler  28-Jan-94
***********************************************************************)

/* ATTENTION: This modul is a direct translation of the modula2-demo.
              It's my SECOND working C-program. It may not take in some cases
              the easiest way to achive things, but it works ! */

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <intuition/intuition.h>
#include <libraries/gadtools.h>
#include <proto/exec.h>
#include "guitools.h"


struct Library *GUIToolsBase;


char *listviewALabs[] = {"Amiga 500", "Amiga 500+", "Amiga 600",
                         "Amiga 1000", "Amiga 1200", "Amiga 2000",
                         "Amiga 3000", "Amiga 4000/030",
                         "Amiga 4000/040", "Amiga XXXX/yyy"};

char *listviewCLabs[] = {"2086", "80286", "80386", "80486",
                         "Pentium", "MC 68000", "MC 68020",
                         "MC 68030", "MC 68040", "MC 68060"};


/* Libraries will be opened by the auto init code ! Except GUITools !!*/

void main(void)
{
  struct Window *win, *oldWin;
  struct GUIInfo *gui;

  WORD innerWidth, innerHeight;
  int  prg, ende;

  struct MinList alist, clist;        /* Lists for ListviewKind-Gadget */

    /* Creates two exec.lists. One contains some amiga-models and the other
       some cpu-kinds ! */
    struct Node *entry;
    int i;

    /* Init amiga-list & cpu-list */
    NewList(&alist);
    NewList(&clist);

    for(i=0; i<=9; i++)    /* make the list-entries */
    {
      entry = AllocMem(sizeof(struct Node), MEMF_CLEAR);
      if (entry)
      {
        entry->ln_Name = listviewALabs[i];
        Insert(&alist, entry, NULL);
      }
      entry = AllocMem(sizeof(struct Node), MEMF_CLEAR);
      if (entry)
      {
        entry->ln_Name = listviewCLabs[i];
        Insert(&clist, entry, NULL);
      }
    }

  /* open GUITools.library */

  GUIToolsBase = OpenLibrary(GUIToolsName, 38);

  if (GUIToolsBase == NULL)
    SimpleReq("You need at least the guitools.library V38.0 !", okReqKind);
  else
  {

    win = OpenIntWindowTags( 50, 50, 300, 150, "WB-Demo",
                            IDCMP_GADGETUP | IDCMP_CLOSEWINDOW |
                            IDCMP_NEWSIZE | IDCMP_REFRESHWINDOW |
                            IDCMP_VANILLAKEY,
                            WFLG_ACTIVATE | WFLG_SIZEGADGET |
                            WFLG_DEPTHGADGET | WFLG_CLOSEGADGET |
                            WFLG_DRAGBAR, NULL,
                            WA_MinWidth, 250,
                            WA_MinHeight,120,
                            WA_MaxWidth, 500,
                            WA_MaxHeight,200, NULL);
    if (win)
    {
      oldWin = SetProcessWindow(win);
      gui = CreateGUIInfoTags(win, 5, 0, GUI_ResizableGads, 1,
                   GUI_Flags, GFLG_AddBorderDims | GFLG_DoRefresh |
                              GFLG_VanillaKeysNotify | GFLG_ConvertKeys,
                   GUI_GadFont, TopazAttr(), NULL);
      if (gui)
      {
        innerWidth  = win->Width - win->BorderRight - win->BorderLeft;
        innerHeight = win->Height- win->BorderTop - win->BorderBottom;
        CreateSpecialGadget(gui, 20, 20, innerWidth-30, innerHeight-55,
                            progressIndicatorKind,
                            SG_GadgetText, "Progress",
                            SG_GadgetFlags, PLACETEXT_ABOVE, NULL);
        gui->flags = gui->flags +  GFLG_AddStdUnderscore; /* set bit */
        CreateGadgetFull(gui, 20, innerHeight-30, 70, 18, BUTTON_KIND,
                         "_Plus", PLACETEXT_IN, NULL);
        CreateGadgetText(gui, innerWidth-90, innerHeight-30, 70, 18,
                         BUTTON_KIND, "_Minus", NULL);
        gui->flags = gui->flags - GFLG_AddStdUnderscore; /* clear bit */
        if (SetGUI(gui) == guiSet)
        {
          prg = 0;
          ende = 0;
          while (ende == 0)
          {
            WaitIntMsg(gui);

            if (gui->msgClass == IDCMP_CLOSEWINDOW) ende = 1;
            if (gui->msgClass == IDCMP_GADGETUP)
            {
              if (gui->gadID == 1)
              {
                if (prg < 10) prg++;
                ModifyGadget(gui, 0, SGPI_CurrentValue, prg * 10, NULL);
              }
              if (gui->gadID == 2)
              {
                if (prg >  0) prg--;
                ModifyGadget(gui, 0, SGPI_CurrentValue, prg * 10, NULL);
              }
            }
            if (gui->msgClass == IDCMP_NEWSIZE)
            {
              innerWidth  = win->Width - win->BorderRight - win->BorderLeft;
              innerHeight = win->Height- win->BorderTop - win->BorderBottom;
              ResizeGadget(gui, 0, preserve, preserve,
                                   innerWidth-30, innerHeight-55);
              ResizeGadget(gui, 1, preserve, innerHeight-25,
                                   preserve, preserve);
              ResizeGadget(gui, 2, innerWidth-90, innerHeight-25,
                                   preserve, preserve);
              if (RedrawGadgets(gui, TRUE) != guiSet) ende = 1;
            }
          }
        }
        RemoveGadgets(gui, 1);
        ClearWindow(gui);

        innerWidth  = win->Width - win->BorderRight - win->BorderLeft;
        innerHeight = win->Height- win->BorderTop - win->BorderBottom;
        CreateGadget(gui, 20, 10, innerWidth-35, innerHeight-45,
                     LISTVIEW_KIND, GTLV_Labels, &alist, NULL);
        gui->flags = gui->flags + GFLG_AddStdUnderscore;  /* set bit */
        CreateGadgetFull(gui, 20, innerHeight-30, 70, 18, BUTTON_KIND,
                         "_Amigas", PLACETEXT_IN, NULL);
        CreateGadgetText(gui, innerWidth-90, innerHeight-30, 70, 18,
                         BUTTON_KIND, "_CPUs", NULL);
        CreateSpecialGadget(gui, 10, 5, innerWidth-15, innerHeight-10,
                            bevelboxKind, SGBB_Recessed, 1, NULL);
        if (SetGUI(gui) == guiSet)
        {
          ende = 0;
          while (ende == 0)
          {
            WaitIntMsg(gui);

            if (gui->msgClass == IDCMP_CLOSEWINDOW) ende = 1;
            if (gui->msgClass == IDCMP_GADGETUP)
            {
              if (gui->gadID == 1)    /* Amiga-list */
                ModifyGadget(gui, 0, GTLV_Labels, &alist, NULL);
              if (gui->gadID == 2)    /* CPU-list */
                ModifyGadget(gui, 0, GTLV_Labels, &clist, NULL);
            }
            if (gui->msgClass == IDCMP_NEWSIZE)
            {
              innerWidth  = win->Width - win->BorderRight - win->BorderLeft;
              innerHeight = win->Height- win->BorderTop - win->BorderBottom;
              ResizeGadget(gui, 0, preserve, preserve,
                                   innerWidth-35, innerHeight-45);
              ResizeGadget(gui, 1, preserve, innerHeight-30,
                                   preserve, preserve);
              ResizeGadget(gui, 2, innerWidth-90, innerHeight-30,
                                   preserve, preserve);
              ResizeGadget(gui, 3, preserve, preserve,
                                   innerWidth-15, innerHeight-10);
              if (RedrawGadgets(gui, 1) != guiSet) ende = 1;
            }
          }
        }
      }
      else
        SimpleReq("Unable to create gui-info-structure !", okReqKind);
    }
    else
      SimpleReq("Unable to open window !", okReqKind);

  }
  if (win != NULL)
  {
    SetProcessWindow(oldWin);
    CloseIntWindow(win);
  }
  while (alist.mlh_TailPred != &alist)  /* free list */
    FreeMem(RemTail(&alist), sizeof(struct Node));
  while (clist.mlh_TailPred != &clist)  /* free list */
    FreeMem(RemTail(&clist), sizeof(struct Node));

  if (GUIToolsBase) CloseLibrary(GUIToolsBase);
}
