/************************************************************************

   Demo_Prn.C     The Printer (tm) demo.  Copyright 1994, Rob W. Smetana

   << BEFORE running this, turn screen-swapping ON if appropriate. >>

   Purpose:       * Demonstrate reading printer code records.

                  * Show how one might display printer codes.

                    Something like this might be used inside a
                    program to show users which codes are
                    available (ie., not blank) and perhaps what
                    they should do to invoke each option.

      NOTE:       Some printer codes may contain control codes which
                  will screw up the display.  Try a different printer.
                  And in your own programs you might want to use an ASM
                  "quickprint" routine to overcome this problem.

   Requires:

    1. Printer.Cfg -- a 2k printer code file saved by Printer.Exe

    2. The_Prn.C   -- an include file with data structures (although
                      we won't use those structures here)

************************************************************************/

#include "the_prn.c"        /* for database structures */

#include <string.h>         /* for function prototypes */
#include <conio.h>          /* ditto */
#include <stdio.h>          /* ditto */

#include <dos.h>            /* for CLS (Clear Screen) and LOCATE */
#define  VIDEO  0x10        /* ditto */

/*
   For what we're about to do here, it's easier reading printer codes
   with some simple variables -- rather than our types.

   Printer.Cfg consists of 2 1024-byte records (Labels and Codes).
   Both records start with a 44-byte header, followed by 980 bytes
   of labels or printer codes.
*/

char Header [44];
char Labels [980];
char Codes  [980];


/* prototypes for local functions */
void locate (unsigned char , unsigned char);
void cls (unsigned char);
void PrintHeader (void);

/* locate the cursor using BIOS SetCursor function -- page 0 hardcoded */

void locate (row, col)
unsigned char row, col;
{
   union REGS reg;
   reg.h.ah = 2;
   reg.h.dh = row-1;           /* we use 1,1 as top, left; BIOS uses 0,0 */
   reg.h.dl = col-1;
   reg.h.bh = 0;
   int86(VIDEO, &reg, &reg);
}

/* CLS using BIOS Scroll function.  ALSO homes cursor:  Locate (1,1). */

void cls (colr)

unsigned char colr;

{
    union REGS reg;

    reg.h.ah = 6;           /* service 6 -- scroll up  */
    reg.h.al = 0;           /* scroll 0 lines -- clear */

    reg.h.ch = 0;           /* scroll 25 x 80 screen:  0,0 to 24,79 */
    reg.h.cl = 0;
    reg.h.dh = 24;
    reg.h.dl = 79;
    reg.h.bh = colr;
    int86(VIDEO, &reg, &reg);

    locate (1, 1);
}


/* print Manufacturer, model, etc. */

/*************************************************************************/
void PrintHeader ()
/*************************************************************************/

{
  unsigned char n;

  cls (27);

  for (n = 0; n < 44; ++n)            /* print our 44-byte header */
  {
    switch (n)
      {
      case 1:
        printf (" Manufacturer: ");
        break;
      case 16:
        printf ("  Model: ");
        break;
      case 30:
        printf ("  Emulates: ");
        break;
      }
     printf("%c",Header [n]);
  }
}


/************************************************************************/

int main (void)

   {

   char Cfg_File[64];
   FILE *fp;

   int c, offset;
   char n, row, col;

   /* home cursor */
   cls (27);

   strcpy (Cfg_File, "PRINTER.CFG");

   fp = fopen (Cfg_File, "rb");

   if (fp == NULL)
      {
        return(-999);     /* file not found */
      }

   /* Read 2 1024-byte records:  Labels and Printer Codes. */
   /* Both records begin with the same 44-byte header.     */

   fread (Header, sizeof Header, 1, fp);
   fread (Labels, sizeof Labels, 1, fp);

   PrintHeader();

   fread (Header, sizeof Header, 1, fp);
   fread (Codes, sizeof Codes, 1, fp);

   offset =1 ;
   row = 3;
   col = 4;

   for (n = 1; n < 71; ++n)
   {

     locate (row,col);

     /* Print the labels */
     for (c = 0; c < 14; ++c)
         printf("%c",Labels[offset+c-1]);

     printf("    ");

     /* and now the codes */
     for (c = 0; c < 14; ++c)
         printf("%c",Codes[offset+c-1]);

     /* move to the next Label/Printer Code */
     offset = offset + 14;

     /*
       There are more codes than will fit on a screen.
       So pause after 1st screen.
     */

     if (n == 42)
     {
       locate(25,15);
       printf ("There's more.   Press <SPACE> to continue . . .");
       getche();
       PrintHeader ();
       row = 2;
       col = 4;
     }

     row++;

     if (row > 23)
        {
         row =3;
         col = 40;
        }
   }

   locate (25, 15);
   printf ("That's all.     Press <SPACE> to continue . . .");
   getche();
   cls(7);
   return (0);

}

