/*
Auto:		smake ForceIcon
*/



/* $Revision Header built automatically *************** (do not edit) ************
**
**  Copyright by GuntherSoft
**
** File             : SnakeSYS:CPrgs/Utils/ForceIcon/Error.c
** Created on       : Saturday, 23.10.93 14:30:06
** Created by       : Kai Iske
** Current revision : V1.0
**
**
** Purpose
** -------
**   - Error-Handling for ForceIcon
**
** Revision V1.0
** --------------
** created on Saturday, 23.10.93 14:30:06  by  Kai Iske.   LogMessage :
**     --- Initial release ---
**
*********************************************************************************/




/**********************************************************************/
/*                          Internal errors                           */
/**********************************************************************/
char *InternalErrs[] =
{
	"%s could not be opened",
	"Sorry, out of memory",
	"Sorry, not all entries from DOS-List\ncould be collected.",
	"ForceIcon v%ld.%ld, (%s)\n"
		"by Kai Iske, GiftWare\n\n"
		"UserInterface done with GadToolsBox 2.0c (37.300)\n\n"
		"Reach me under\n"
		"   Kai Iske, Brucknerstrasse 18, 63452 Hanau, Germany\n"
		"                  Tel.: +49-(0)6181-850181\n"
		"or electronically\n"
		"   UseNet:   kai@iske.adsp.sub.org\n"
		"   Internet: iske@informatik.uni-frankfurt.de\n"
		"   Fido:     Kai Iske, 2:244/6302.11\n"
		"   ZNet:     KAI@SWEET.ZER",
		"GetFile Image could not be allocated.",
	"Volume\n%s\nhas already been selected.",
	"No negative values please."
};



/**********************************************************************/
/*                             IFF-Errors                             */
/**********************************************************************/
char *IFFErrs[] =
{
	"IFF-Error\nEnd of file reached before completing parse.",
	"IFF-Error\nAn IFF-Chunk could not be read.",
	"IFF-Error\nChunk-Contents didn`t reside at expected position.",
	"IFF-Error\nInternal memory could not be allocated.",
	"IFF-Error\nError while reading from file.\nFile could probably not be opened.",
	"IFF-Error\nError while writing to file.\nFile could probably not be opened.",
	"IFF-Error\nError while seeking through file.\n%s",
	"IFF-Error\nData within file corrupt.\n%s",
	"IFF-Error\nSyntax error within file.\n%s",
	"IFF-Error\n%s\nis not an IFF file."
};





/**********************************************************************/
/*                          Display an error                          */
/**********************************************************************/
void __stdargs DisplayError(LONG ErrCode, ULONG Arg1, ...)
{
	struct EasyStruct MyRequest =
	{
		sizeof(struct EasyStruct),
		0,
		NULL,
		NULL,
		NULL
	};

		// Set header for Requester

	MyRequest.es_Title		= "ForceIcon";
	MyRequest.es_GadgetFormat	= "Ok";


		// Set correct text

	if((ErrCode >= 0) && (ErrCode < 200))
	{
		MyRequest.es_TextFormat = InternalErrs[ErrCode];
		EasyRequestArgs(NULL, &MyRequest, NULL, &Arg1);
	}

	else if((ErrCode >= 200) && (ErrCode < 226))
	{
		char	Buffer[128];

		Fault(ErrCode, NULL, Buffer, 128);

		MyRequest.es_TextFormat = "DOS-Error %ld\n%s";
		EasyRequest(NULL, &MyRequest, NULL, ErrCode, Buffer, NULL);
	}

	else if(ErrCode < 0)
	{
		MyRequest.es_TextFormat = IFFErrs[((-ErrCode) - 1)];
		EasyRequestArgs(NULL, &MyRequest, NULL, &Arg1);
	}
}
