/*
Auto:		smake ForceIcon
*/



/* $Revision Header built automatically *************** (do not edit) ************
**
**  Copyright by GuntherSoft
**
** File             : SnakeSYS:CPrgs/Utils/ForceIcon/Interface.c
** Created on       : Friday, 22.10.93 16:28:10
** Created by       : Kai Iske
** Current revision : V1.0
**
**
** Purpose
** -------
**   - User-Interface for ForceIcon
**
** Revision V1.0
** --------------
** created on Friday, 22.10.93 16:28:10  by  Kai Iske.   LogMessage :
**     --- Initial release ---
**
*********************************************************************************/


#define	MainWinLeft	80
#define	MainWinTop	25
#define	MainWinWidth	457
#define	MainWinHeight	126
#define	EditWinLeft	102
#define	EditWinTop	52
#define	EditWinWidth	433
#define	EditWinHeight	102
#define	ManWinLeft	112
#define	ManWinTop	60
#define	ManWinWidth	438
#define	ManWinHeight	41



/**********************************************************************/
/*                      Routines for this module                      */
/**********************************************************************/
static struct VolEntry *AddNewVolume(char *Name, ULONG Type);
static void SetGetFileState(struct Gadget *Gad, struct Window *Win, BOOL State);





/**********************************************************************/
/*                        External structures                         */
/**********************************************************************/
extern struct List		VolumeList;
extern struct SignalSemaphore	MySemaphore;



/**********************************************************************/
/*                        Module`s structures                         */
/**********************************************************************/
struct	Window		*MainWinHandle	= NULL;		// Window handles
struct	Window		*EditWinHandle	= NULL;
struct	Window		*PosWinHandle	= NULL;
struct	Window		*ManWinHandle	= NULL;


static struct VisualInfo	*MainVisInfo	= NULL;
static struct VisualInfo	*EditVisInfo	= NULL;
static struct VisualInfo	*ManVisInfo	= NULL;
static struct Gadget		*MainWinGList	= NULL;
static struct Gadget		*EditWinGList	= NULL;
static struct Gadget		*ManWinGList	= NULL;
static struct Gadget		*MainWinGadgets[MAINWIN_CNT];
static struct Gadget		*EditWinGadgets[EDITWIN_CNT];
static struct Gadget		*ManWinGadgets[MANWIN_CNT];
static struct _Object		*EditWinGet	= NULL;
static struct TextAttr		MainWinTxtAttr,
				EditWinTxtAttr,
				ManWinTxtAttr;
static char			MainWinFontName[40],
				EditWinFontName[40],
				ManWinFontName[40];

static char			MainTypeStr[40];

static struct List		VolList;
static struct VolEntry		OrigEntry, *CloneEntry = NULL;
static WORD			SelVolume, SelEdVolume, PosMode, ManualType;
static LONG			SecsLeft, MinsLeft, SecsRight, MinsRight;
static WORD			LastLeft, LastRight;
static struct Requester		MainReq;





/**********************************************************************/
/*                         Window definitions                         */
/**********************************************************************/
static UBYTE *EditPos1Labels[] = {
	(UBYTE *)"Open position window",
	(UBYTE *)"Close position window",
	NULL };

static UBYTE *ManType2Labels[] = {
	(UBYTE *)"Device",
	(UBYTE *)"Volume",
	NULL };

static UWORD MainWinGTypes[] = {
	LISTVIEW_KIND,
	LISTVIEW_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	TEXT_KIND,
	BUTTON_KIND
};

static UWORD EditWinGTypes[] = {
	CYCLE_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	STRING_KIND,
	STRING_KIND,
	GENERIC_KIND,
	CHECKBOX_KIND,
	CYCLE_KIND,
	CHECKBOX_KIND,
	INTEGER_KIND,
	INTEGER_KIND
};

static UWORD ManWinGTypes[] = {
	STRING_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	CYCLE_KIND
};

static struct NewGadget MainWinNGad[] = {
	244, 17, 200, 56, (UBYTE *)"Ava_ilable Volumes/Devices", NULL, GD_MainVols, PLACETEXT_ABOVE|NG_HIGHLABEL, NULL, NULL,
	13, 17, 200, 56, (UBYTE *)"Used _Volumes/Devices", NULL, GD_MainUseVols, PLACETEXT_ABOVE|NG_HIGHLABEL, NULL, NULL,
	244, 69, 200, 12, (UBYTE *)"Add to _list", NULL, GD_MainAdd, PLACETEXT_IN, NULL, NULL,
	13, 81, 100, 12, (UBYTE *)"_Edit entry...", NULL, GD_MainEdit, PLACETEXT_IN, NULL, NULL,
	13, 93, 200, 12, (UBYTE *)"_Remove from list", NULL, GD_MainRemove, PLACETEXT_IN, NULL, NULL,
	5, 112, 85, 12, (UBYTE *)"_Save", NULL, GD_MainSave, PLACETEXT_IN, NULL, NULL,
	95, 112, 85, 12, (UBYTE *)"_Use", NULL, GD_MainUse, PLACETEXT_IN, NULL, NULL,
	367, 112, 85, 12, (UBYTE *)"_Quit", NULL, GD_MainQuit, PLACETEXT_IN, NULL, NULL,
	275, 112, 85, 12, (UBYTE *)"_Hide", NULL, GD_MainHide, PLACETEXT_IN, NULL, NULL,
	244, 81, 200, 12, (UBYTE *)"Add _manually...", NULL, GD_MainManual, PLACETEXT_IN, NULL, NULL,
	244, 93, 200, 12, (UBYTE *)"Resca_n list", NULL, GD_MainRescan, PLACETEXT_IN, NULL, NULL,
	185, 112, 85, 12, (UBYTE *)"_About...", NULL, GD_MainAbout, PLACETEXT_IN, NULL, NULL,
	13, 69, 200, 12, NULL, NULL, GD_MainType, 0, NULL, NULL,
	113, 81, 100, 12, (UBYTE *)"_Copy...", NULL, GD_MainCopy, PLACETEXT_IN, NULL, NULL
};

static struct NewGadget EditWinNGad[] = {
	108, 51, 202, 12, (UBYTE *)"_Position", NULL, GD_EditPos, PLACETEXT_LEFT, NULL, NULL,
	5, 88, 85, 12, (UBYTE *)"_Ok", NULL, GD_EditOk, PLACETEXT_IN, NULL, NULL,
	343, 88, 85, 12, (UBYTE *)"_Cancel", NULL, GD_EditCancel, PLACETEXT_IN, NULL, NULL,
	108, 6, 297, 14, (UBYTE *)"_Volume", NULL, GD_EditVol, PLACETEXT_LEFT, NULL, NULL,
	108, 69, 181, 14, (UBYTE *)"Ico_n", NULL, GD_EditIcon, PLACETEXT_LEFT, NULL, NULL,
	290, 69, 20, 14, NULL, NULL, GD_EditGet, 0, NULL, NULL,
	318, 69, 26, 11, (UBYTE *)"_Use Icon", NULL, GD_EditUseIcon, PLACETEXT_RIGHT, NULL, NULL,
	108, 21, 297, 12, (UBYTE *)"_Type", NULL, GD_EditType, PLACETEXT_LEFT, NULL, NULL,
	318, 51, 26, 11, (UBYTE *)"_IconPos", NULL, GD_EditIconPos, PLACETEXT_RIGHT, NULL, NULL,
	108, 36, 67, 14, (UBYTE *)"Current _X", NULL, GD_EditX, PLACETEXT_LEFT, NULL, NULL,
	338, 36, 67, 14, (UBYTE *)"Current _Y", NULL, GD_EditY, PLACETEXT_LEFT, NULL, NULL
};

static struct NewGadget ManWinNGad[] = {
	82, 7, 346, 14, (UBYTE *)"_Entry", NULL, GD_ManVol, PLACETEXT_LEFT, NULL, NULL,
	5, 27, 85, 12, (UBYTE *)"_Ok", NULL, GD_ManOk, PLACETEXT_IN, NULL, NULL,
	349, 27, 85, 12, (UBYTE *)"_Cancel", NULL, GD_ManCancel, PLACETEXT_IN, NULL, NULL,
	175, 27, 121, 12, (UBYTE *)"_Type", NULL, GD_ManType, PLACETEXT_LEFT, NULL, NULL
};

static ULONG MainWinGTags[] = {
	(GTLV_ShowSelected), NULL, (GT_Underscore), '_', (TAG_DONE),
	(GTLV_ShowSelected), NULL, (GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (GA_Disabled), TRUE, (TAG_DONE),
	(GT_Underscore), '_', (GA_Disabled), TRUE, (TAG_DONE),
	(GT_Underscore), '_', (GA_Disabled), TRUE, (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GTTX_Border), TRUE, (TAG_DONE),
	(GT_Underscore), '_', (GA_Disabled), TRUE, (TAG_DONE)
};

static ULONG EditWinGTags[] = {
	(GTCY_Labels), (ULONG)&EditPos1Labels[ 0 ], (GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(STRINGA_ExitHelp), TRUE, (GTST_MaxChars), 128, (GT_Underscore), '_', (TAG_DONE),
	(STRINGA_ExitHelp), TRUE, (GTST_MaxChars), 256, (GT_Underscore), '_', (TAG_DONE),
	(TAG_DONE),
	(GT_Underscore), '_', (GTCB_Scaled), TRUE, (TAG_DONE),
	(GTCY_Labels), (ULONG)&ManType2Labels[ 0 ], (GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (GTCB_Scaled), TRUE, (TAG_DONE),
	(STRINGA_ExitHelp), TRUE, (GTIN_Number), 0, (GTIN_MaxChars), 4, (GT_Underscore), '_', (TAG_DONE),
	(STRINGA_ExitHelp), TRUE, (GTIN_Number), 0, (GTIN_MaxChars), 4, (GT_Underscore), '_', (TAG_DONE)
};

static ULONG ManWinGTags[] = {
	(STRINGA_ExitHelp), TRUE, (GTST_MaxChars), 128, (GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GT_Underscore), '_', (TAG_DONE),
	(GTCY_Labels), (ULONG)&ManType2Labels[ 0 ], (GT_Underscore), '_', (TAG_DONE)
};












/**********************************************************************/
/*                       Handle the main window                       */
/**********************************************************************/
BOOL OpenMainWin(void)
{
		// Initialize volume list

	NewList(&VolList);

		// Get list of available volumes

	if(GetDevVolList(&VolList))
	{
			// Try to open main window

		if(OpenWin(MainWinLeft,
			MainWinTop,
			MainWinWidth,
			MainWinHeight,
			&MainWinGList,
			MAINWIN_CNT,
			NULL,
			MainWinNGad,
			MainWinGTypes,
			MainWinGTags,
			MainWinGadgets,
			&MainWinHandle,
			"ForceIcon v"REVISION" ("REVDATE") - GiftWare, Kai Iske",
			LISTVIEWIDCMP|BUTTONIDCMP|IDCMP_CLOSEWINDOW|IDCMP_VANILLAKEY|IDCMP_REFRESHWINDOW,
			WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE|WFLG_RMBTRAP,
			5,
			3,
			447,
			106,
			&MainWinTxtAttr,
			MainWinFontName,
		&MainVisInfo))
		{
				// Set right listview

			GT_SetGadgetAttrs(MainWinGadgets[GD_MainVols], MainWinHandle, NULL,
				GTLV_Labels,	&VolList,
			TAG_DONE);

				// Set left listview

			GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
				GTLV_Labels,	&VolumeList,
			TAG_DONE);

				// Set variables for Window handling

			SelVolume	= SelEdVolume = -1;
			LastLeft	= LastRight = -1;
			SecsLeft	= MinsLeft = SecsRight = MinsRight = -1;
		}
		else
			CloseMainWin();
	}
	else
		FreeDevVolList(&VolList);

	if(!MainWinHandle)
		DisplayError(ERR_NOMEM, NULL);

	return((BOOL)(MainWinHandle != NULL));
}







/**********************************************************************/
/*                      Close main window again                       */
/**********************************************************************/
void CloseMainWin(void)
{
		// Unbusy window first

	UnBusyWindow(MainWinHandle, &MainReq);

		// Close window

	CloseWin(&MainWinHandle, &MainWinGList, &MainVisInfo, NULL);

		// Free volume list

	FreeDevVolList(&VolList);
}






/**********************************************************************/
/*                          Open Edit window                          */
/**********************************************************************/
BOOL OpenEditWin(void)
{
		// Try to open editor window

	if(OpenWin(EditWinLeft,
		EditWinTop,
		EditWinWidth,
		EditWinHeight,
		&EditWinGList,
		EDITWIN_CNT,
		&EditWinGet,
		EditWinNGad,
		EditWinGTypes,
		EditWinGTags,
		EditWinGadgets,
		&EditWinHandle,
		"ForceIcon v"REVISION" ("REVDATE") - GiftWare, Kai Iske",
		LISTVIEWIDCMP|BUTTONIDCMP|IDCMP_CLOSEWINDOW|IDCMP_VANILLAKEY|IDCMP_REFRESHWINDOW,
		WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE|WFLG_RMBTRAP,
		5,
		3,
		423,
		83,
		&EditWinTxtAttr,
		EditWinFontName,
	&EditVisInfo))
	{
			// Set gadgets

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditVol], EditWinHandle, NULL,
			GTST_String,	OrigEntry.VolName,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditType], EditWinHandle, NULL,
			GTCY_Active,	(ManualType = !(OrigEntry.Link.ln_Type == LDF_DEVICES)),
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditX], EditWinHandle, NULL,
			GTIN_Number,	OrigEntry.Left,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditY], EditWinHandle, NULL,
			GTIN_Number,	OrigEntry.Top,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditIcon], EditWinHandle, NULL,
			GTST_String,	OrigEntry.IconName,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditUseIcon], EditWinHandle, NULL,
			GTCB_Checked,	OrigEntry.UseAlt,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditIcon], EditWinHandle, NULL,
			GA_Disabled,	!OrigEntry.UseAlt,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditX], EditWinHandle, NULL,
			GA_Disabled,	!OrigEntry.IconPos,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditY], EditWinHandle, NULL,
			GA_Disabled,	!OrigEntry.IconPos,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditPos], EditWinHandle, NULL,
			GA_Disabled,	!OrigEntry.IconPos,
		TAG_DONE);

		GT_SetGadgetAttrs(EditWinGadgets[GD_EditIconPos], EditWinHandle, NULL,
			GTCB_Checked,	OrigEntry.IconPos,
		TAG_DONE);

		SetGetFileState(EditWinGadgets[GD_EditGet], EditWinHandle, !OrigEntry.UseAlt);

			// Set work mode variable

		PosMode = 0;
	}
	else
		CloseEditWin();

	if(!EditWinHandle)
		DisplayError(ERR_NOMEM, NULL);

	return((BOOL)(EditWinHandle != NULL));
}






/**********************************************************************/
/*                        Close Editor window                         */
/**********************************************************************/
void CloseEditWin(void)
{
		// UnLock main window again

	UnBusyWindow(MainWinHandle, &MainReq);

		// Close position window

	ClosePosWin();

		// Close Editor window

	CloseWin(&EditWinHandle, &EditWinGList, &EditVisInfo, &EditWinGet);
}








/**********************************************************************/
/*                         Open manual window                         */
/**********************************************************************/
BOOL OpenManWin(void)
{
		// Try to open manual input window

	if(OpenWin(ManWinLeft,
		ManWinTop,
		ManWinWidth,
		ManWinHeight,
		&ManWinGList,
		MANWIN_CNT,
		NULL,
		ManWinNGad,
		ManWinGTypes,
		ManWinGTags,
		ManWinGadgets,
		&ManWinHandle,
		"ForceIcon v"REVISION" ("REVDATE") - GiftWare, Kai Iske",
		LISTVIEWIDCMP|BUTTONIDCMP|IDCMP_CLOSEWINDOW|IDCMP_VANILLAKEY|IDCMP_REFRESHWINDOW,
		WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE|WFLG_RMBTRAP,
		5,
		3,
		429,
		22,
		&ManWinTxtAttr,
		ManWinFontName,
	&ManVisInfo))
	{
		ManualType = 0;
		ActivateGadget(ManWinGadgets[GD_ManVol], ManWinHandle, NULL);
	}
	else
		CloseManWin();

	if(!ManWinHandle)
		DisplayError(ERR_NOMEM, NULL);

	return((BOOL)(ManWinHandle != NULL));
}







/**********************************************************************/
/*                        Close manual window                         */
/**********************************************************************/
void CloseManWin(void)
{
		// Unbusy main window first

	UnBusyWindow(MainWinHandle, &MainReq);

		// Close manual input window

	CloseWin(&ManWinHandle, &ManWinGList, &ManVisInfo, NULL);
}






/**********************************************************************/
/*                        Open position window                        */
/**********************************************************************/
BOOL OpenPosWin(void)
{
	struct	Screen		*WBScreen;

		// Get info about WBScreen

	if((WBScreen = LockPubScreen("Workbench")))
	{
		PosWinHandle = OpenWindowTags(NULL,
			WA_Left,	OrigEntry.Left,
			WA_Top,		OrigEntry.Top,
			WA_Width,	(EditWinHandle->IFont->tf_XSize * 8) + 30 + WBScreen->WBorLeft + WBScreen->WBorRight,
			WA_Height,	WBScreen->WBorTop + WBScreen->Font->ta_YSize + 1,
			WA_IDCMP,	IDCMP_CHANGEWINDOW,
			WA_Flags,	WFLG_DEPTHGADGET|WFLG_DRAGBAR|WFLG_RMBTRAP,
			WA_Title,	"IconPos",
			WA_PubScreen,	WBScreen,
		TAG_DONE);
			// Unlock screen

		UnlockPubScreen(NULL, WBScreen);
	}


	if(!PosWinHandle)
		DisplayError(ERR_NOMEM, NULL);

	return((BOOL)(PosWinHandle != NULL));
}




/**********************************************************************/
/*                       Close Position window                        */
/**********************************************************************/
void ClosePosWin(void)
{
	if(PosWinHandle)
		CloseWindow(PosWinHandle);
	PosWinHandle = NULL;
}



/**********************************************************************/
/*                 Check for inputs from main window                  */
/**********************************************************************/
BOOL HandleMainWin(BOOL *QuitIT)
{
	struct	IntuiMessage	*MyMsg;
	struct	Gadget		*MsgGad;
	ULONG	MsgClass, CurrentSecs, CurrentMins;
	UWORD	GadID, MsgQual, MsgCode;
	BOOL	CloseIT = FALSE, KeyUse;

		// Loop for all messages

	while((MyMsg = (struct IntuiMessage *)GT_GetIMsg(MainWinHandle->UserPort)))
	{
		MsgClass	= MyMsg->Class;
		MsgQual		= MyMsg->Qualifier;
		MsgCode		= MyMsg->Code;
		CurrentSecs	= MyMsg->Seconds;
		CurrentMins	= MyMsg->Micros;

		if((MsgClass & (IDCMP_GADGETUP|IDCMP_GADGETDOWN)))
		{
			MsgGad	= (struct Gadget *)MyMsg->IAddress;
			GadID	= MsgGad->GadgetID;
		}

		CheckKeys(&MsgClass, &MsgCode, &GadID, &KeyUse, &MsgGad, &MainWinGadgets[0], MAINWIN_CNT);

		GT_ReplyIMsg(MyMsg);

		switch(MsgClass)
		{
			case IDCMP_CLOSEWINDOW :
			{
				CloseIT	= TRUE;
				break;
			}
			case IDCMP_GADGETUP :
			{
				switch(GadID)
				{
						// Save prefs to env:

					case GD_MainUse :
					{
						SavePrefs(TRUE);
						CloseIT = TRUE;
						break;
					}
						// Save prefs to env: and envarc:

					case GD_MainSave :
					{
						SavePrefs(FALSE);
						CloseIT = TRUE;
						break;
					}
						// Display about

					case GD_MainAbout :
					{
						DisplayError(ERR_ABOUT, VERNUM, REVNUM, (ULONG)REVDATE, NULL);
						break;
					}

						// Quit it

					case GD_MainQuit :
					{
						*QuitIT	= TRUE;
						CloseIT	= TRUE;
						break;
					}
						// Hide all windows

					case GD_MainHide :
					{
						CloseIT	= TRUE;
						break;
					}
						// Selected a new volume from the available ones ???

					case GD_MainVols :
					{
						if((SelVolume = HandleListViewGad(MsgGad, MainWinHandle, KeyUse, MsgCode, MsgQual, SelVolume, 0, VolList.lh_Type - 1)) != -1)
						{
							GT_SetGadgetAttrs(MainWinGadgets[GD_MainAdd], MainWinHandle, NULL,
								GA_Disabled,	FALSE,
							TAG_DONE);

								// Check for double-click

							if(!KeyUse)
							{
								if(LastRight == SelVolume)
								{
									if(DoubleClick(SecsRight, MinsRight, CurrentSecs, CurrentMins))
									{
										struct	VolEntry	*ThisEntry	= (struct VolEntry *)GetListEntry(&VolList, SelVolume);

										AddNewVolume(ThisEntry->VolName, ThisEntry->Link.ln_Type);
									}
								}
								SecsRight	= CurrentSecs;
								MinsRight	= CurrentMins;
								LastRight	= SelVolume;
							}
						}
						break;
					}
					case GD_MainUseVols :
					{
							// Selected a new volume to edit ???

						if((SelEdVolume = HandleListViewGad(MsgGad, MainWinHandle, KeyUse, MsgCode, MsgQual, SelEdVolume, 0, VolumeList.lh_Type - 1)) != -1)
						{
							strcpy(MainTypeStr, "Type: ");
							strcat(MainTypeStr, ManType2Labels[!(((struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume))->Link.ln_Type == LDF_DEVICES)]);

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainType], MainWinHandle, NULL,
								GTTX_Text,	MainTypeStr,
							TAG_DONE);

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainEdit], MainWinHandle, NULL,
								GA_Disabled,	FALSE,
							TAG_DONE);

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainCopy], MainWinHandle, NULL,
								GA_Disabled,	FALSE,
							TAG_DONE);

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainRemove], MainWinHandle, NULL,
								GA_Disabled,	FALSE,
							TAG_DONE);

								// Check for double-click

							if(!KeyUse)
							{
								if(LastLeft == SelEdVolume)
								{
									if(DoubleClick(SecsLeft, MinsLeft, CurrentSecs, CurrentMins))
									{
										struct	VolEntry	*EditEntry;

										if((EditEntry = (struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume)))
										{
											strcpy(OrigEntry.VolName, EditEntry->VolName);
											strcpy(OrigEntry.IconName, EditEntry->IconName);
											OrigEntry.Link.ln_Type	= EditEntry->Link.ln_Type;
											OrigEntry.Left		= EditEntry->Left;
											OrigEntry.Top		= EditEntry->Top;
											OrigEntry.UseAlt	= EditEntry->UseAlt;
											OrigEntry.IconPos	= EditEntry->IconPos;

											if(OpenEditWin())
												BusyWindow(MainWinHandle, &MainReq);
										}
									}
								}
								SecsLeft	= CurrentSecs;
								MinsLeft	= CurrentMins;
								LastLeft	= SelEdVolume;
							}
						}
						break;
					}
						// Add new entry to list

					case GD_MainAdd :
					{
						struct	VolEntry	*VolEntry = (struct VolEntry *)GetListEntry(&VolList, SelVolume);

						if(SelVolume != -1)
							AddNewVolume(VolEntry->VolName, VolEntry->Link.ln_Type);
						break;
					}
						// Remove active entry from list

					case GD_MainRemove :
					{
						struct	VolEntry	*ThisEntry = (struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume);

						if(ThisEntry)
						{
								// Get semaphore

							ObtainSemaphore(&MySemaphore);

								// Remove list from ListView

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
								GTLV_Labels,	~0,
							TAG_DONE);

								// Remove entry and free memory

							Remove((struct Node *)ThisEntry);
							FreeVec(ThisEntry);

								// One entry less

							VolumeList.lh_Type--;

								// Set pointer to current entry

							if(SelEdVolume >= VolumeList.lh_Type)
								SelEdVolume--;

								// Still entries available ???

							if(SelEdVolume > -1)
							{
									// Reinstall list

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
									GTLV_Labels,	&VolumeList,
									GTLV_Selected,	SelEdVolume,
									GTLV_Top,	SelEdVolume,
								TAG_DONE);

								strcpy(MainTypeStr, "Type: ");
								strcat(MainTypeStr, ManType2Labels[!(((struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume))->Link.ln_Type == LDF_DEVICES)]);
								GT_SetGadgetAttrs(MainWinGadgets[GD_MainType], MainWinHandle, NULL,
									GTTX_Text,	MainTypeStr,
								TAG_DONE);
							}
							else
							{
									// Disable gadgets

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
									GTLV_Labels,	NULL,
								TAG_DONE);

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainEdit], MainWinHandle, NULL,
									GA_Disabled,	TRUE,
								TAG_DONE);

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainCopy], MainWinHandle, NULL,
									GA_Disabled,	TRUE,
								TAG_DONE);

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainRemove], MainWinHandle, NULL,
									GA_Disabled,	TRUE,
								TAG_DONE);

								strcpy(MainTypeStr, "");
								GT_SetGadgetAttrs(MainWinGadgets[GD_MainType], MainWinHandle, NULL,
									GTTX_Text,	MainTypeStr,
								TAG_DONE);
							}

							ReleaseSemaphore(&MySemaphore);
						}
						break;
					}
						// Edit current entry using the Editor window

					case GD_MainEdit :
					{
						struct	VolEntry	*EditEntry;

						if((EditEntry = (struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume)))
						{
								// Copy data from current entry to spare

							strcpy(OrigEntry.VolName, EditEntry->VolName);
							strcpy(OrigEntry.IconName, EditEntry->IconName);
							OrigEntry.Link.ln_Type	= EditEntry->Link.ln_Type;
							OrigEntry.Left		= EditEntry->Left;
							OrigEntry.Top		= EditEntry->Top;
							OrigEntry.UseAlt	= EditEntry->UseAlt;
							OrigEntry.IconPos	= EditEntry->IconPos;

							if(OpenEditWin())
								BusyWindow(MainWinHandle, &MainReq);
						}
						break;
					}
						// Copy entry ???

					case GD_MainCopy :
					{
						if((CloneEntry = (struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume)))
						{
							if(OpenManWin())
								BusyWindow(MainWinHandle, &MainReq);
						}
						break;
					}

						// Enter manually

					case GD_MainManual :
					{
						if(OpenManWin())
							BusyWindow(MainWinHandle, &MainReq);
						break;
					}
						// Recan volume list

					case GD_MainRescan :
					{
							// Remove list

						GT_SetGadgetAttrs(MainWinGadgets[GD_MainVols], MainWinHandle, NULL,
							GTLV_Labels,	~0,
						TAG_DONE);

							// Free old list and get new

						FreeDevVolList(&VolList);
						GetDevVolList(&VolList);

							// Set pointer to current entry

						if(SelVolume >= VolList.lh_Type)
							SelVolume = VolList.lh_Type - 1;

							// Reinstall gadget

						GT_SetGadgetAttrs(MainWinGadgets[GD_MainVols], MainWinHandle, NULL,
							GTLV_Labels,	&VolList,
						TAG_DONE);

							// Set gadget state

						if(!VolList.lh_Type)
						{
							GT_SetGadgetAttrs(MainWinGadgets[GD_MainAdd], MainWinHandle, NULL,
								GA_Disabled,	TRUE,
							TAG_DONE);
						}
						else
						{
							if(SelVolume != -1)
							{
								GT_SetGadgetAttrs(MainWinGadgets[GD_MainAdd], MainWinHandle, NULL,
									GA_Disabled,	FALSE,
								TAG_DONE);
							}
						}
						break;
					}
				}
				break;
			}
		}
	}

	return(CloseIT);
}





/**********************************************************************/
/*                  Handle inputs from Editor window                  */
/**********************************************************************/
BOOL HandleEditWin(void)
{
	struct	IntuiMessage	*MyMsg;
	struct	Gadget		*MsgGad;
	ULONG	MsgClass;
	UWORD	GadID, MsgQual, MsgCode;
	BOOL	CloseIT = FALSE, KeyUse;

		// Loop for all messages

	while((MyMsg = (struct IntuiMessage *)GT_GetIMsg(EditWinHandle->UserPort)))
	{
		MsgClass	= MyMsg->Class;
		MsgQual		= MyMsg->Qualifier;
		MsgCode		= MyMsg->Code;

		if((MsgClass & (IDCMP_GADGETUP|IDCMP_GADGETDOWN)))
		{
			MsgGad	= (struct Gadget *)MyMsg->IAddress;
			GadID	= MsgGad->GadgetID;
		}

		CheckKeys(&MsgClass, &MsgCode, &GadID, &KeyUse, &MsgGad, &EditWinGadgets[0], EDITWIN_CNT);

		GT_ReplyIMsg(MyMsg);

		switch(MsgClass)
		{
			case IDCMP_CLOSEWINDOW :
			{
				CloseIT	= TRUE;
				break;
			}
			case IDCMP_GADGETUP :
			{
				switch(GadID)
				{
						// Settings ok, copy to current entry

					case GD_EditOk :
					{
						struct	VolEntry	*ToEntry = (struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume);

						if(ToEntry)
						{
							LONG	NewSel = SelEdVolume;

								// Get semaphore

							ObtainSemaphore(&MySemaphore);

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
								GTLV_Labels,	~0,
							TAG_DONE);

								// Fill out structure

							strcpy(ToEntry->VolName, ((struct StringInfo *)EditWinGadgets[GD_EditVol]->SpecialInfo)->Buffer);
							strcpy(ToEntry->IconName, ((struct StringInfo *)EditWinGadgets[GD_EditIcon]->SpecialInfo)->Buffer);
							if(!strstr(ToEntry->IconName, ".info") && strlen(ToEntry->IconName))
								strcat(ToEntry->IconName, ".info");

								// Rearrange Node`s position

							if(ToEntry->Link.ln_Type != OrigEntry.Link.ln_Type)
							{
								Remove((struct Node *)ToEntry);

								if(OrigEntry.Link.ln_Type == LDF_DEVICES)
									AddTail(&VolumeList, (struct Node *)ToEntry);
								else
									AddHead(&VolumeList, (struct Node *)ToEntry);
								SelEdVolume	= -1;
								NewSel		= ~0;
							}

							ToEntry->Link.ln_Type	= OrigEntry.Link.ln_Type;
							ToEntry->Left		= OrigEntry.Left;
							ToEntry->Top		= OrigEntry.Top;
							ToEntry->UseAlt		= OrigEntry.UseAlt;
							ToEntry->IconPos	= OrigEntry.IconPos;

								// Sort List again

							if(NewSel == ~0)
								SortList(&VolumeList, TRUE);

								// Reset listview

							GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
								GTLV_Labels,	&VolumeList,
								GTLV_Selected,	NewSel,
								GTLV_Top,	0,
							TAG_DONE);

							if(NewSel == ~0)
							{
									// Disable edit and remove gadgets

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainEdit], MainWinHandle, NULL,
									GA_Disabled,	TRUE,
								TAG_DONE);

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainCopy], MainWinHandle, NULL,
									GA_Disabled,	TRUE,
								TAG_DONE);

								GT_SetGadgetAttrs(MainWinGadgets[GD_MainRemove], MainWinHandle, NULL,
									GA_Disabled,	TRUE,
								TAG_DONE);

								strcpy(MainTypeStr, "");
								GT_SetGadgetAttrs(MainWinGadgets[GD_MainType], MainWinHandle, NULL,
									GTTX_Text,	MainTypeStr,
								TAG_DONE);
							}
							else
							{
								strcpy(MainTypeStr, "Type: ");
								strcat(MainTypeStr, ManType2Labels[!(((struct VolEntry *)GetListEntry(&VolumeList, SelEdVolume))->Link.ln_Type == LDF_DEVICES)]);
								GT_SetGadgetAttrs(MainWinGadgets[GD_MainType], MainWinHandle, NULL,
									GTTX_Text,	MainTypeStr,
								TAG_DONE);
							}

								// Release our semaphore

							ReleaseSemaphore(&MySemaphore);
						}

						CloseIT = TRUE;
						break;
					}
						// Cancel Editor window

					case GD_EditCancel :
					{
						CloseIT = TRUE;
						break;
					}
						// Change Type of entry

					case GD_EditType :
					{
						ManualType = HandleCycleGad(MsgGad, EditWinHandle, KeyUse, MsgCode, MsgQual, ManualType, 0, 1);

						OrigEntry.Link.ln_Type = (!ManualType) ? LDF_DEVICES : LDF_VOLUMES;
						break;
					}
						// Set X position manually

					case GD_EditX :
					{
						if(OrigEntry.IconPos)
						{
							LONG	Val	= ((struct StringInfo *)MsgGad->SpecialInfo)->LongInt;

							if(Val >= 0)
							{
								OrigEntry.Left	= Val;
								if(PosWinHandle)
									MoveWindow(PosWinHandle, OrigEntry.Left - PosWinHandle->LeftEdge, 0);
							}
							else
							{
								DisplayError(ERR_NONEG, NULL);
								GT_SetGadgetAttrs(MsgGad, EditWinHandle, NULL,
									GTIN_Number,	OrigEntry.Left,
								TAG_DONE);
							}
						}
						break;
					}
						// Set Y position manually

					case GD_EditY :
					{
						if(OrigEntry.IconPos)
						{
							LONG	Val	= ((struct StringInfo *)MsgGad->SpecialInfo)->LongInt;

							if(Val >= 0)
							{
								OrigEntry.Top	= Val;
								if(PosWinHandle)
									MoveWindow(PosWinHandle, 0, OrigEntry.Top - PosWinHandle->TopEdge);
							}
							else
							{
								DisplayError(ERR_NONEG, NULL);
								GT_SetGadgetAttrs(MsgGad, EditWinHandle, NULL,
									GTIN_Number,	OrigEntry.Top,
								TAG_DONE);
							}
						}
						break;
					}

						// Open/Close position window

					case GD_EditPos :
					{
						if(OrigEntry.IconPos)
						{
							PosMode = HandleCycleGad(MsgGad, EditWinHandle, KeyUse, MsgCode, MsgQual, PosMode, 0, 1);

							if(PosMode)
							{
								if(!OpenPosWin())
								{
									PosMode = 0;
									GT_SetGadgetAttrs(EditWinGadgets[GD_EditPos], EditWinHandle, NULL,
										GTCY_Active, PosMode,
									TAG_DONE);
								}
							}
							else
								ClosePosWin();
						}
						break;
					}
						// Set mode for Icon position

					case GD_EditIconPos :
					{
						if(KeyUse)
							OrigEntry.IconPos	= !OrigEntry.IconPos;
						else
							OrigEntry.IconPos	= MsgCode;

						GT_SetGadgetAttrs(EditWinGadgets[GD_EditIconPos], EditWinHandle, NULL,
							GTCB_Checked,	OrigEntry.IconPos,
						TAG_DONE);

						GT_SetGadgetAttrs(EditWinGadgets[GD_EditX], EditWinHandle, NULL,
							GA_Disabled,	!OrigEntry.IconPos,
						TAG_DONE);

						GT_SetGadgetAttrs(EditWinGadgets[GD_EditY], EditWinHandle, NULL,
							GA_Disabled,	!OrigEntry.IconPos,
						TAG_DONE);

						GT_SetGadgetAttrs(EditWinGadgets[GD_EditPos], EditWinHandle, NULL,
							GA_Disabled,	!OrigEntry.IconPos,
						TAG_DONE);
						break;
					}
					case GD_EditGet :
					{
						char	BackName[256];

							// Allowed to use alternative icon ???

						if(OrigEntry.UseAlt)
						{
								// Get it using ListView

							strcpy(BackName, OrigEntry.IconName);
							if(!GetFileName(EditWinHandle, "Select an icon", OrigEntry.IconName))
								strcpy(OrigEntry.IconName, BackName);
							else
							{
								if(!strstr(OrigEntry.IconName, ".info"))
									strcat(OrigEntry.IconName, ".info");
							}

							GT_SetGadgetAttrs(EditWinGadgets[GD_EditIcon], EditWinHandle, NULL,
								GTST_String,	OrigEntry.IconName,
							TAG_DONE);
						}
						break;
					}
					case GD_EditUseIcon :
					{
						if(KeyUse)
							OrigEntry.UseAlt = !OrigEntry.UseAlt;
						else
							OrigEntry.UseAlt = MsgCode;

						GT_SetGadgetAttrs(MsgGad, EditWinHandle, NULL,
							GTCB_Checked,	OrigEntry.UseAlt,
						TAG_DONE);

						GT_SetGadgetAttrs(EditWinGadgets[GD_EditIcon], EditWinHandle, NULL,
							GA_Disabled,	!OrigEntry.UseAlt,
						TAG_DONE);

						SetGetFileState(EditWinGadgets[GD_EditGet], EditWinHandle, !OrigEntry.UseAlt);
						break;
					}
				}
				break;
			}
			case IDCMP_GADGETDOWN :
			{
				switch(GadID)
				{
					case GD_EditVol :
					{
						ActivateGadget(MsgGad, EditWinHandle, NULL);
						break;
					}
					case GD_EditIcon :
					{
						if(OrigEntry.UseAlt)
						{
							if(KeyUse && (MsgQual & (IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)))
							{
								char	BackName[256];

								strcpy(BackName, OrigEntry.IconName);
								if(!GetFileName(EditWinHandle, "Select an icon", OrigEntry.IconName))
									strcpy(OrigEntry.IconName, BackName);
								else
								{
									if(!strstr(OrigEntry.IconName, ".info"))
										strcat(OrigEntry.IconName, ".info");
								}

								GT_SetGadgetAttrs(EditWinGadgets[GD_EditIcon], EditWinHandle, NULL,
									GTST_String,	OrigEntry.IconName,
								TAG_DONE);
							}
							else
								ActivateGadget(MsgGad, EditWinHandle, NULL);
						}
						break;
					}
					case GD_EditX :
					case GD_EditY :
					{
						if(OrigEntry.IconPos)
							ActivateGadget(MsgGad, EditWinHandle, NULL);
						break;
					}
				}
				break;
			}
			case IDCMP_ACTSTRGAD :
			{
				ActivateGadget(MsgGad, EditWinHandle, NULL);
				break;
			}
		}
	}

	return(CloseIT);
}




/**********************************************************************/
/*                  Handle input from manual window                   */
/**********************************************************************/
BOOL HandleManWin(void)
{
	struct	IntuiMessage	*MyMsg;
	struct	Gadget		*MsgGad;
	ULONG	MsgClass;
	UWORD	GadID, MsgCode, MsgQual;
	BOOL	CloseIT = FALSE, KeyUse;

		// Loop for all messages

	while((MyMsg = (struct IntuiMessage *)GT_GetIMsg(ManWinHandle->UserPort)))
	{
		MsgClass	= MyMsg->Class;
		MsgCode		= MyMsg->Code;
		MsgQual		= MyMsg->Qualifier;

		if((MsgClass & (IDCMP_GADGETUP|IDCMP_GADGETDOWN)))
		{
			MsgGad	= (struct Gadget *)MyMsg->IAddress;
			GadID	= MsgGad->GadgetID;
		}

		CheckKeys(&MsgClass, &MsgCode, &GadID, &KeyUse, &MsgGad, &ManWinGadgets[0], EDITWIN_CNT);

		GT_ReplyIMsg(MyMsg);

		switch(MsgClass)
		{
			case IDCMP_CLOSEWINDOW :
			{
				CloneEntry	= NULL;
				CloseIT		= TRUE;
				break;
			}
			case IDCMP_GADGETUP :
			{
				switch(GadID)
				{
						// On Ok, add a new volume to the list

					case GD_ManOk :
					{
						if(!CheckExists(((struct StringInfo *)ManWinGadgets[GD_ManVol]->SpecialInfo)->Buffer))
						{
							struct	VolEntry	*ThisEntry = AddNewVolume(((struct StringInfo *)ManWinGadgets[GD_ManVol]->SpecialInfo)->Buffer, (!ManualType) ? LDF_DEVICES : LDF_VOLUMES);

								// Currently cloning an entry ??

							if(CloneEntry && ThisEntry)
							{
									// Clone remaining parts of entry

								strcpy(ThisEntry->IconName, CloneEntry->IconName);
								ThisEntry->Left		= CloneEntry->Left;
								ThisEntry->Top		= CloneEntry->Top;
								ThisEntry->UseAlt	= CloneEntry->UseAlt;
								ThisEntry->IconPos	= CloneEntry->IconPos;
							}

							CloneEntry	= NULL;
							CloseIT		= TRUE;
						}
						else
						{
							CloneEntry	= NULL;
							DisplayError(ERR_EXISTS, (ULONG)((struct StringInfo *)ManWinGadgets[GD_ManVol]->SpecialInfo)->Buffer, NULL);
						}
						break;
					}
					case GD_ManCancel :
					{
						CloneEntry	= NULL;
						CloseIT		= TRUE;
						break;
					}
					case GD_ManType :
					{
						 ManualType = HandleCycleGad(MsgGad, ManWinHandle, KeyUse, MsgCode, MsgQual, ManualType, 0, 1);
						 break;
					}
				}
				break;
			}
			case IDCMP_GADGETDOWN :
			{
				switch(GadID)
				{
					case GD_ManVol :
					{
						ActivateGadget(MsgGad, ManWinHandle, NULL);
						break;
					}
				}
				break;
			}
			case IDCMP_ACTSTRGAD :
			{
				ActivateGadget(MsgGad, ManWinHandle, NULL);
				break;
			}
		}
	}
	return(CloseIT);
}







/**********************************************************************/
/*                 Handle input from Position window                  */
/**********************************************************************/
void HandlePosWin(void)
{
	struct	IntuiMessage	*MyMsg;
	ULONG	MsgClass;

	while((MyMsg = (struct IntuiMessage *)GT_GetIMsg(PosWinHandle->UserPort)))
	{
		MsgClass	= MyMsg->Class;

		GT_ReplyIMsg(MyMsg);

			// Window was moved, so set the new values to the number gadgets

		if(MsgClass == IDCMP_CHANGEWINDOW)
		{
			OrigEntry.Left	= PosWinHandle->LeftEdge;
			OrigEntry.Top	= PosWinHandle->TopEdge;

			GT_SetGadgetAttrs(EditWinGadgets[GD_EditX], EditWinHandle, NULL,
				GTIN_Number,	OrigEntry.Left,
			TAG_DONE);

			GT_SetGadgetAttrs(EditWinGadgets[GD_EditY], EditWinHandle, NULL,
				GTIN_Number,	OrigEntry.Top,
			TAG_DONE);
		}
	}
}



/**********************************************************************/
/*                 Add a new entry to the volume list                 */
/**********************************************************************/
static struct VolEntry *AddNewVolume(char *Name, ULONG Type)
{
	struct	VolEntry	*NewEntry = NULL;

		// Check for exitance

	if(CheckExists(Name))
	{
		DisplayError(ERR_EXISTS, (ULONG)Name, NULL);
		return(NewEntry);
	}

		// Try to get our semaphore

	ObtainSemaphore(&MySemaphore);

		// Get memory for new entry

	if((NewEntry = AllocVec(sizeof(struct VolEntry), MEMF_CLEAR)))
	{
		GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
			GTLV_Labels,	~0,
		TAG_DONE);

		VolumeList.lh_Type++;
		SelEdVolume = -1;

			// Add entry and fill out structure

		if(Type == LDF_VOLUMES)
			AddHead(&VolumeList, (struct Node *)NewEntry);
		else
			AddTail(&VolumeList, (struct Node *)NewEntry);

		NewEntry->Link.ln_Name	= NewEntry->VolName;
		NewEntry->Link.ln_Type	= Type;
		strcpy(NewEntry->VolName, Name);

			// Sort the list again

		SortList(&VolumeList, TRUE);

			// reset listview

		GT_SetGadgetAttrs(MainWinGadgets[GD_MainUseVols], MainWinHandle, NULL,
			GTLV_Labels,	&VolumeList,
			GTLV_Selected,	~0,
			GTLV_Top,	0,
		TAG_DONE);

			// Disable edit and remove gadgets

		GT_SetGadgetAttrs(MainWinGadgets[GD_MainEdit], MainWinHandle, NULL,
			GA_Disabled,	TRUE,
		TAG_DONE);

		GT_SetGadgetAttrs(MainWinGadgets[GD_MainCopy], MainWinHandle, NULL,
			GA_Disabled,	TRUE,
		TAG_DONE);

		GT_SetGadgetAttrs(MainWinGadgets[GD_MainRemove], MainWinHandle, NULL,
			GA_Disabled,	TRUE,
		TAG_DONE);

		strcpy(MainTypeStr, "");
		GT_SetGadgetAttrs(MainWinGadgets[GD_MainType], MainWinHandle, NULL,
			GTTX_Text,	MainTypeStr,
		TAG_DONE);
	}
	else
	{
		DisplayError(ERR_NOMEM, NULL);
		NewEntry	= NULL;
	}

		// Free our semaphore

	ReleaseSemaphore(&MySemaphore);

	return(NewEntry);
}



/**********************************************************************/
/*              Sets the state of a generic_kind gadget               */
/**********************************************************************/
static void SetGetFileState(struct Gadget *Gad, struct Window *Win, BOOL State)
{
	RemoveGList(Win, Gad, 1);

	if(!State)
		Gad->Flags &= ~GFLG_DISABLED;
	else
		Gad->Flags |= GFLG_DISABLED;

	AddGList(Win, Gad, -1, 1, NULL);
	RefreshGList(Gad, Win, NULL, 1);
}
