// BROWSE.CPP Part of VULCAN
// Copyright (c) 1993 John Deurbrouck
#include<windows.h>
#include<stdio.h>
#include<dos.h>
#include<fcntl.h>
#include<time.h>
#include<commdlg.h>
#include<sys\types.h>
#include<sys\stat.h>
#include"browse.hpp"
#include"cancel.hpp"
#include"vulcan.hpp"
#include"filedate.hpp"
#include"resource.h"
#include"vcn.hpp"

static const int FILENAME_BUFFER_SIZE=130;//per OPENFILENAME info on nMaxFile
static const int BROWSE_BUF_ITEMS=512;

static FARPROC lpfnBrowseDlgProc=NULL;
HWND hBrowseDlg=NULL;
static long browse_buf[BROWSE_BUF_ITEMS];

static int nuke_and_fill_listbox();
static int restore_file(vcn_info& vi,char* target_name=NULL);// 0=wanna quit
static int get_saveas_location(vcn_info& vi,char* buf,size_t siz);//1=success

BOOL FAR PASCAL _export BrowseDlgProc(HWND hDlg,unsigned message,WORD wParam,
LONG lParam){
    switch(message){
    case WM_COMMAND:
        switch(wParam){
        case IDC_BLIST: // LBN_xxx
            switch(HIWORD(lParam)){
            case LBN_SETFOCUS:
            case LBN_SELCHANGE:
                // first enable/disable appropriate buttons
                LRESULT numitems=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,
                    LB_GETSELCOUNT,0,0L);
                if(!numitems){ // disable all but cancel
                    EnableWindow(GetDlgItem(hDlg,IDC_BRESTORE),  FALSE);
                    EnableWindow(GetDlgItem(hDlg,IDC_BRESTOREAS),FALSE);
                    EnableWindow(GetDlgItem(hDlg,IDC_BDELETE),   FALSE);
                }
                else if(numitems==1){ // enable all
                    EnableWindow(GetDlgItem(hDlg,IDC_BRESTORE),  TRUE );
                    EnableWindow(GetDlgItem(hDlg,IDC_BRESTOREAS),TRUE );
                    EnableWindow(GetDlgItem(hDlg,IDC_BDELETE),   TRUE );
                }
                else{ // enable all but Restore As...
                    EnableWindow(GetDlgItem(hDlg,IDC_BRESTORE),  TRUE );
                    EnableWindow(GetDlgItem(hDlg,IDC_BRESTOREAS),FALSE);
                    EnableWindow(GetDlgItem(hDlg,IDC_BDELETE),   TRUE );
                }
                // user moved cursor, paint appropriate file data
                LRESULT l=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,
                    LB_GETCARETINDEX,0,0L);
                LRESULT idx=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,
                    LB_GETITEMDATA,(WPARAM)l,0L);
                vcn_info vi;
                if(vcnGetInfo((long)idx,vi)){
                                                        // IDC_BS_FILENAME
                    wsprintf(pacBigScratchBuffer,"Name: %s",
                        (LPSTR)vi.FileName);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_FILENAME,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                                                        // IDC_BS_SSIZE
                    wsprintf(pacBigScratchBuffer,"File size: %ld",
                        vi.StoredSize);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_SSIZE,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                                                        // IDC_BS_SDT
                    get_ascii_time(pacBigScratchBuffer2,
                        vi.StoredTime,vi.StoredDate);
                    wsprintf(pacBigScratchBuffer,"When stored: %s",
                        (LPSTR)pacBigScratchBuffer2);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_SDT,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                                                        // IDC_BS_INDEX
                    wsprintf(pacBigScratchBuffer,"Vulcan name: %08ld.VCN",
                        vi.Index);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_INDEX,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
#ifdef COMPRESSION
                                                        // IDC_BS_COMPRESSED
                    wsprintf(pacBigScratchBuffer,"File is%scompressed",
                        (LPSTR)(vi.compressed?" ":" not "));
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_COMPRESSED,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
#endif
                                                        // IDC_BS_OSIZE
                    wsprintf(pacBigScratchBuffer,"File size: %ld",
                        vi.FileSize);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_OSIZE,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                                                        // IDC_BS_OATTR
                    if(!(vi.Attrib&(_A_ARCH|_A_HIDDEN|_A_SYSTEM|_A_RDONLY)))
                        lstrcpy(pacBigScratchBuffer,"Attributes: --none--");
                    else{
                        lstrcpy(pacBigScratchBuffer,"Attributes:");
                        if(vi.Attrib&_A_ARCH)
                            lstrcat(pacBigScratchBuffer," Arch");
                        if(vi.Attrib&_A_RDONLY)
                            lstrcat(pacBigScratchBuffer," R/O");
                        if(vi.Attrib&_A_HIDDEN)
                            lstrcat(pacBigScratchBuffer," Hid");
                        if(vi.Attrib&_A_SYSTEM)
                            lstrcat(pacBigScratchBuffer," Sys");
                    }
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_OATTR,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                                                        // IDC_BS_ODT
                    get_ascii_time(pacBigScratchBuffer2,
                        vi.FileTime,vi.FileDate);
                    wsprintf(pacBigScratchBuffer,"Date && time: %s",
                        (LPSTR)pacBigScratchBuffer2);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_ODT,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                                                        // IDC_BS_FULLPATH
                    wsprintf(pacBigScratchBuffer,"Path: %s",
                        (LPSTR)vi.FullName);
                    SendDlgItemMessage(hBrowseDlg,IDC_BS_FULLPATH,
                        WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
                }
                break;
            }
            return FALSE;
        case IDM_GETSTARTED:
            if(!nuke_and_fill_listbox()){
                MessageBox(CURR_WINDOW,"Can't load list box",
                    szAppErrorTitle,MB_OK);
            }
            SetFocus(GetDlgItem(hDlg,IDC_BLIST));
            return FALSE; // because set focus
        case IDCANCEL:
            EndDialog(hDlg,0); //==++
            hBrowseDlg=NULL;
            EnableWindow(hMainWindow,TRUE);
            return TRUE;
        case IDC_BRESTORE:
        case IDC_BRESTOREAS:
        case IDC_BDELETE:
            for(;;){ // just keep driving until done...
                LRESULT numitems=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,
                    LB_GETSELCOUNT,0,0L);
                if(numitems>BROWSE_BUF_ITEMS){
                    wsprintf(pacBigScratchBuffer,"You selected %ld files. "
                        "Vulcan can handle no more than %ld.\n\n"
                        "Please alter your selection and try again.",
                        (long)numitems,(long)BROWSE_BUF_ITEMS);
                    MessageBox(CURR_WINDOW,pacBigScratchBuffer,
                        szAppErrorTitle,MB_OK);
                    break;
                }
                LRESULT actual=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,
                    LB_GETSELITEMS,
                    BROWSE_BUF_ITEMS,(LPARAM)(LPSTR)browse_buf);
                if((actual!=numitems)||(actual<1)||
                ((wParam==IDC_BRESTOREAS)&&(actual!=(LRESULT)1))){
                    MessageBox(CURR_WINDOW,"Could not process command. "
                        "Please try again.",szAppErrorTitle,MB_OK);
                    break;
                }
                // ok now translate list box indexes to actual numbers
                // work from end of int array to beginning, writing
                //  into long array occupying same space
                int x=(int)actual;
                int *intptr=(int *)browse_buf;
                while(x--){
                    LRESULT idx=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,
                        LB_GETITEMDATA,(WPARAM)intptr[x],0L);
                    vcn_info vi;
                    if(!vcnGetInfo((long)idx,vi)){
                        actual=0;
                        break;
                    }
                    browse_buf[x]=vi.Index;
                }
                if(!actual){
                    MessageBox(CURR_WINDOW,"Could not retrieve information "
                        "on file. Please close VULCAN and try again.",
                        szAppErrorTitle,MB_OK);
                    break;
                }
                start_cancel_dialog_box(); // so we can show progress
                // now we have array of 'actual' longs in browse_buf
                // these are vcn_info.Index values, on which the action
                //  should be taken...so do it
                while(actual--){ // now actual is index into browse_buf
                    char *p;
                    switch(wParam){ // first prepare cancel dialog box
                    case IDC_BRESTOREAS:p="Restoring this file elsewhere";
                                                            break;
                    case IDC_BRESTORE:  p="Restoring";      break;
                    case IDC_BDELETE:   p="Deleting";       break;
                    }
                    vcn_info vi; // now get data on file by Index no
                    if(!vcnGetInfo(browse_buf[actual],vi)){
                        wsprintf(pacBigScratchBuffer,"Couldn't get data on "
                            "%08ld.VCN. File skipped.",browse_buf[actual]);
                        MessageBox(CURR_WINDOW,pacBigScratchBuffer,
                            szAppErrorTitle,MB_OK);
                        continue;
                    }
                    // show cancel box text
                    set_cancel_dialog_box_text(p,vi.FullName);
                    // perform deletes here
                    if(wParam==IDC_BDELETE){
                        if(check_cancel_dialog_box())break;
                        vcnDeleteItem(vi.Index);
                        continue; // delete processing all done
                    }
                    // for Restore As... must get user's target filename
                    char target_filename[FILENAME_BUFFER_SIZE];
                    if(wParam==IDC_BRESTOREAS){
                        if(!get_saveas_location(vi,target_filename,
                        sizeof(target_filename))){
                            break;
                        }
                        // got location, show new data
                        wsprintf(pacBigScratchBuffer,
                            "Saving %s to",(LPSTR)vi.FileName);
                        set_cancel_dialog_box_text(pacBigScratchBuffer,
                            target_filename);
                    }
                    // now restore the file...bail out if user quit
                    if(!restore_file(vi,wParam==IDC_BRESTOREAS?
                    target_filename:NULL)){
                        break;
                    }
                }
                end_cancel_dialog_box(); // so browse box lives again
                // refresh listbox if deleted items
                if(wParam==IDC_BDELETE)nuke_and_fill_listbox();
                break;
            }
            // for all these, gather the selections
            return TRUE;
        }
        return TRUE;
    case WM_INITDIALOG:
        hBrowseDlg=hDlg;
        PostMessage(hDlg,WM_COMMAND,IDM_GETSTARTED,0L);
        return TRUE;
    default:
        return FALSE;
    }
}
void start_browse_dialog_box(void){
    lpfnBrowseDlgProc=MakeProcInstance((int(__far __pascal *)
        (void))BrowseDlgProc,hMainInstance);
    DialogBox(hMainInstance,
        MAKEINTRESOURCE(IDD_BROWSEDIALOG),CURR_WINDOW,lpfnBrowseDlgProc);
    hBrowseDlg=NULL;
//    if(hCancelDlg!=NULL)EnableWindow(hMainWindow,FALSE); ==++
}
static int nuke_and_fill_listbox(){
    // 1 is success, 0 is fail
    SendDlgItemMessage(hBrowseDlg,IDC_BLIST,LB_RESETCONTENT,0,0L); //empty it
	// initialize static text fields too
	lstrcpy(pacBigScratchBuffer," ");
    SendDlgItemMessage(hBrowseDlg,IDC_BS_FILENAME,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
    SendDlgItemMessage(hBrowseDlg,IDC_BS_SSIZE,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
    SendDlgItemMessage(hBrowseDlg,IDC_BS_SDT,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
    SendDlgItemMessage(hBrowseDlg,IDC_BS_INDEX,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
#ifdef COMPRESSION
    SendDlgItemMessage(hBrowseDlg,IDC_BS_COMPRESSED,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
#endif
    SendDlgItemMessage(hBrowseDlg,IDC_BS_OSIZE,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
    SendDlgItemMessage(hBrowseDlg,IDC_BS_OATTR,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
    SendDlgItemMessage(hBrowseDlg,IDC_BS_ODT,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
    SendDlgItemMessage(hBrowseDlg,IDC_BS_FULLPATH,
    	WM_SETTEXT,0,(LONG)(LPSTR)pacBigScratchBuffer);
	// also turn RESTORE, RESTORE AS... and DELETE buttons off
    EnableWindow(GetDlgItem(hBrowseDlg,IDC_BRESTORE),  FALSE);
    EnableWindow(GetDlgItem(hBrowseDlg,IDC_BRESTOREAS),FALSE);
    EnableWindow(GetDlgItem(hBrowseDlg,IDC_BDELETE),   FALSE);
    // now set the tab stops for the listbox control
    int tabstops=100;
    SendDlgItemMessage(hBrowseDlg,IDC_BLIST,LB_SETTABSTOPS,1,
        (LPARAM)(int FAR*)&tabstops);
    // now loop through all items, adding to list box
    long head,tail;
    vcnGetFilenumberRange(tail,head);
    if(head<tail)return 1; // no items, return
    vcn_info vi;
    if(!vcnGetInfo(head,vi))return 0;
    do{
        wsprintf(pacBigScratchBuffer,"%s\t%c",
            (LPSTR)vi.FileName,(char)vi.DispChar);
        LRESULT res=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,LB_ADDSTRING,0,
            (LPARAM)(LPCSTR)pacBigScratchBuffer);
        if(res==LB_ERR)return 0;
        res=SendDlgItemMessage(hBrowseDlg,IDC_BLIST,LB_SETITEMDATA,
            (WPARAM)res,(LPARAM)vi.Index);
        if(res==LB_ERR)return 0;
    }while(vcnGetRecordBefore(vi.Index,vi));
    return 1;
}
static int restore_file(vcn_info& vi,char* target_name){
    // 0=wanna quit nonzero=user wants to continue
    // will return nonzero even if file doesn't copy
    // first open the origin file
    int ifh,ofh; // input and output file handle
    wsprintf(pszTargetDirFile,"%08ld.VCN",vi.Index);
    {
        vcn_info junker;
        if(_dos_open(szTargetDirectory,_O_RDONLY,&ifh)|| // input no open
        !vcnReadEntry(&junker,pacBigScratchBuffer,ifh)){
            wsprintf(pacBigScratchBuffer,"Could not open or read %s. "
                "Restore failed.",(LPSTR)szTargetDirectory);
            MessageBox(CURR_WINDOW,pacBigScratchBuffer,szAppErrorTitle,MB_OK);
            return 1; // all done
        }
    } // now ifh is queued up to beginning of file data
    // now check if target file exists, confirm if necessary
    LPSTR target_pointer;
    if(target_name==NULL){ // destination is vi.FullName
        struct _stat statbuf;
        target_pointer=vi.FullName;
        if(WarnOnOverwrite){ // see if file exists already
            lstrcpy(pacBigScratchBuffer,target_pointer);
            if(!_stat(pacBigScratchBuffer,&statbuf)){ // yep it's there
                wsprintf(pacBigScratchBuffer,
                    "Restoring %s will overwrite a file. Do you want to "
                    "proceed?\n\n"
                    "YES means go ahead and overwrite.\n\n"
                    "NO means cancel restoration of this file\n\n",
                    target_pointer);
                switch(MessageBox(CURR_WINDOW,pacBigScratchBuffer,
                szAppWarningTitle,MB_YESNO)){
                case IDYES:                             break; // go ahead
                case IDNO:          _dos_close(ifh);    return 1; // quit
                }
            }
        }
    }
    else{
        target_pointer=(LPSTR)target_name; // overwrite already confirmed
    }
    // delete target file if it exists
    lstrcpy(pacBigScratchBuffer,target_pointer);
    _dos_setfileattr(pacBigScratchBuffer,_A_NORMAL);
    remove(pacBigScratchBuffer);
    // create the target file
    if(_dos_creat(pacBigScratchBuffer,vi.Attrib,&ofh)){
        wsprintf(pacBigScratchBuffer2,
            "Could not create output file %s.\n\nRestore failed.",
            (LPSTR)pacBigScratchBuffer);
        MessageBox(CURR_WINDOW,pacBigScratchBuffer2,szAppErrorTitle,MB_OK);
        _dos_close(ifh);
        return 1;
    } // now ifh and ofh ready to go
    // pacBigScratchBuffer also hold output filename
    // read a buffer of data at a time
    long filebytes=vi.FileSize;
    while(filebytes){
        unsigned thistime=(unsigned)sizeof(pacBigScratchBuffer2);
        int userquit=0;
        unsigned actual_read,actual_write;
        if((long)thistime>filebytes)thistime=(unsigned)filebytes;
        if((userquit=check_cancel_dialog_box())|| // user quit
        _dos_read(ifh,pacBigScratchBuffer2,thistime,&actual_read)|| // input
        actual_read!=thistime|| // didn't get enough data
        _dos_write(ofh,pacBigScratchBuffer2,thistime,&actual_write)|| //out
        actual_write!=thistime   // didn't write all data
        ){                      // handle failure case by shutting down
            _dos_close(ifh);
            _dos_close(ofh);
            _dos_setfileattr(pacBigScratchBuffer,_A_NORMAL);
            remove(pacBigScratchBuffer);
            if(!userquit){
                wsprintf(pacBigScratchBuffer2,
                    "Read or write error copying to %s. Restore "
                    "aborted.",(LPSTR)pacBigScratchBuffer);
                MessageBox(CURR_WINDOW,pacBigScratchBuffer2,
                    szAppErrorTitle,MB_OK);
            }
            return userquit?0:1;
        }
        filebytes-=(long)thistime; // well, this buffer-full went ok
    } // after loop, file is copied
    // now close input file
    _dos_close(ifh);
    // set file date, time
    _dos_setftime(ofh,vi.FileDate,vi.FileTime);
    // close output file
    _dos_close(ofh);
    return 1;
}
static int get_saveas_location(vcn_info& vi,char* buf,size_t bufsiz){
    // 1=success, filename copied to buf
    // 0=fail, user pressed cancel
    // copy incoming filename to buf
    lstrcpy(buf,vi.FileName);
    // now create initial directory string
    char dirbuf[FILENAME_BUFFER_SIZE];
    lstrcpy(dirbuf,vi.FullName);
    // now complete name is in dirbuf...let's strip off filename
    {
        char *p=dirbuf;
        while(*p)p++; // point at null terminator
        while(*p!='\\')*p--; // point at trailing backslash
        if(p[-1]==':')p++; // don't kill backslash if root
        *p=0;
    }
    // create title bar
    wsprintf(pacBigScratchBuffer,"Vulcan -- Restore %s as",
        (LPSTR)vi.FileName);
    OPENFILENAME ofn;
    // setup structure for common dialog box
    ofn.lStructSize=sizeof(ofn);
    ofn.hwndOwner=CURR_WINDOW;
    ofn.hInstance=hMainInstance;
    ofn.lpstrFilter="All files\0*.*\0";
    ofn.lpstrCustomFilter=NULL;
    ofn.nMaxCustFilter=0;
    ofn.nFilterIndex=1;
    ofn.lpstrFile=buf; // full path name to existing file
    ofn.nMaxFile=bufsiz;
    ofn.lpstrFileTitle=NULL;
    ofn.nMaxFileTitle=0;
    ofn.lpstrInitialDir=dirbuf;
    ofn.lpstrTitle=pacBigScratchBuffer;
    ofn.Flags=OFN_HIDEREADONLY|     // Save As read-only???
        OFN_PATHMUSTEXIST;          // can't restore to nonexistent place
    if(WarnOnOverwrite)
        ofn.Flags|=OFN_OVERWRITEPROMPT; // let user know overwriting...
    ofn.nFileOffset=0;
    ofn.nFileExtension=0;
    ofn.lpstrDefExt=NULL;
    ofn.lCustData=NULL;
    ofn.lpfnHook=NULL;
    ofn.lpTemplateName=NULL;
    // call common dialog box
    if(!GetSaveFileName(&ofn))return 0;
    // anaylze return...valid?
    return 1;
}
