@ECHO OFF
REM Batch file calls CHECK.EXE. This program can check on the amount of free XMS memory, 
REM the amount of free disk space, and whether you are running under Windows. The program
REM sets the DOS error level.


CHECK MEMORY 4000000   
IF ERRORLEVEL 2 GOTO CONFIG1  REM Windows
IF ERRORLEVEL 1 GOTO CONFIG2  REM Less than 4 MB
IF ERRORLEVEL 0 GOTO CONFIG1  REM More than 4 MB XMS

:CONFIG1
REM If error level was 2, user is running under Windows. Don't need to set the Alpha Four
REM virtual memory manager parameters because Alpha Four will use the Windows virtual memory
REM manager. Call alphart.exe to start the Runtime program.

REM If error level was 0, user is running under DOS. User has more than 4 MB of free XMS
REM  memory, and therefore Alpha Four will not need to create a virtual memory swap file on disk.
REM Call alphart.exe to start the Runtime program.

ALPHART -A#1995_e
GOTO DONE

:CONFIG2
REM User is not running under Windows, but has less than 4 MB of free XMS memory.
REM User will therefore have to use the Alpha Four virtual memory manager. 

REM Check to see that there is a minimum of 2 MB of free XMS memory.
CHECK MEMORY 2048000   
IF ERRORLEVEL 1 GOTO FAIL2 REM Less than 2 MB

REM Check to see if the Alpha Four virtual memory swap file already exists. If not check
REM to see if there is sufficient disk space to create it.

IF EXIST A4.SWP GOTO CONTINUE
CHECK DISKSPACE 4100000
IF ERRORLEVEL 1 GOTO FAIL

:CONTINUE
REM The DOS4GVM environment variable tells Alpha Four where to find the the A4.VMC file.
REM The A4.VMC file sets the parameters for Alpha Four's virtual memory manager.
SET DOS4GVM=@A4.VMC

ALPHART -A#1995_e
GOTO DONE

:FAIL
ECHO  WARNING!! You do not have enough free disk space to create the swap file 
ECHO  necessary to run Alpha Four.  You need to have at lease 4.1 MB free.
GOTO DONE

:FAIL2
ECHO WARNING!! You do not have enough free XMS memory to run Alpha Four.
ECHO You need to have a minimum of 2 MB of free XMS memory. You may be able
ECHO to increase free XMS memory by reducing the amount of memory used by your
ECHO disk caching software.
GOTO DONE
 
:Done

