{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

PROGRAM star_date_maker;
USES DOS, NumDays;

PROCEDURE showhelp (errornum : BYTE);
VAR
  message : STRING [60];
BEGIN
  WriteLn;
  WriteLn ('  Usage :  RD2SD mm-dd-yyyy hour');
  WriteLn ('   or   :  RD2SD c  <- Current date will be converted');
  WriteLn ('   or   :  RD2SD p  <- Prompt for a date to be converted');
  WriteLn;
  IF errornum > 0 THEN BEGIN
    CASE errornum OF
      2 : message := 'Couldn''t find sufficient numbers on the command line.';
      3 : message := 'First number out of range for a MONTH value.';
      4 : message := 'Second number out of range for a DAY value.';
      5 : message := 'Third number out of range for a YEAR value.';
      6 : message := 'Fourth number out of range for a HOUR value.';
      ELSE  message := 'Unanticipated error of unknown type.';
    END;
    WriteLn;
    WriteLn ('ERROR: (#', errornum, ') - ', message);
  END;
  Halt (errornum);
END;

FUNCTION GetNumeric (w: STRING; rLow, rHigh :WORD) : INTEGER;
VAR
  s : STRING;
  n,
  vErr : INTEGER;
BEGIN
  REPEAT
    Write ('Please specify a', w, ', in the range ', rLow, ' to ', rHigh, ': ');
    ReadLn (s);
    Val (s, n, vErr);
  UNTIL (vErr = 0) AND (n >= rLow) AND (n <= rHigh);
  GetNumeric := n;
END;

PROCEDURE GetUserDate (VAR cDay, cMonth, cYear : INTEGER; VAR cHour: REAL);
BEGIN
  WriteLn;
  cMonth := GetNumeric (' month', 1, 12);
  cDay   := GetNumeric (' date', 1, 31);
  cYear  := GetNumeric (' year', 1583, 9999);
  cHour  := GetNumeric ('n hour', 0, 23);
END;

PROCEDURE GetCurrDate (VAR cDay, cMonth, cYear : INTEGER; VAR cHour: REAL);
VAR
  y, m, d, w,
  h, n, s, c : WORD;

BEGIN
  GetDate (y, m, d, w);
  GetTime (h, n, s, c);

  cDay := d;
  cMonth := m;
  cYear := y;
  cHour := h;
END;

FUNCTION BuildCommandLine: STRING;
VAR
  i : BYTE;
  CmdLine : STRING;
BEGIN
  CmdLine := '';
  FOR i := 1 to ParamCount DO
    CmdLine := CmdLine + #32 + ParamStr (i);
  BuildCommandLine := CmdLine + #32;
END;

FUNCTION ParseNumber (CmdLine: STRING; VAR i: BYTE): STRING;
VAR
  s: STRING;
BEGIN
  REPEAT
    Inc (i);
    IF (i > Length (CmdLine)) THEN ShowHelp (2);
  UNTIL (CmdLine[i] IN ['0'..'9']);

  s := '';
  REPEAT
    s := s + CmdLine[i];
    Inc (i);
    IF (i > Length (CmdLine)) THEN ShowHelp (2);
  UNTIL (NOT (CmdLine[i] IN ['0'..'9']));
  ParseNumber := s;
END;

PROCEDURE GetParmDate (VAR cDay, cMonth, cYear : INTEGER; VAR cHour: REAL);
VAR
  cYearStr,
  cMonthStr,
  cDayStr,
  cHourStr : STRING;

  i : BYTE;
  CmdLine : STRING;
  vErr : INTEGER;

BEGIN
  CmdLine := BuildCommandLine;
  i := 0;

  cMonthStr := ParseNumber (CmdLine, i);
  cDayStr   := ParseNumber (CmdLine, i);
  cYearStr  := ParseNumber (CmdLine, i);
  cHourStr  := ParseNumber (CmdLine, i);

  Val (cMonthStr, cMonth, vErr);
    IF (vErr <> 0) OR (cMonth < 1) OR (cMonth > 12) THEN ShowHelp (3);

  Val (cDayStr, cDay, vErr);
    IF (vErr <> 0) OR (cDay < 1) OR (cDay > 31) THEN ShowHelp (4);

  Val (cYearStr, cYear, vErr);
    IF (vErr <> 0) THEN
      ShowHelp (5)
    ELSE BEGIN
      IF ((cYear >= 0) AND (cYear < 80)) THEN
        cYear := 2000 + cYear
      ELSE
      IF ((cYear >= 80) AND (cYear <= 99)) THEN
        cYear := 1900 + cYear
      ELSE
      IF ((cYear < 1583) OR (cYear > 9999)) THEN ShowHelp (5);
    END;

  Val (cHourStr, cHour, vErr);
    IF (vErr <> 0) OR (cHour < 0) OR (cHour > 23) THEN ShowHelp (6);
END;

VAR
  HoursInYear,
  Days,
  Hours,
  stardate : REAL;

  cDay,
  cMonth,
  cYear : INTEGER;

  CurrentDate,
  FirstOfYear : Date;

  sdStr : STRING;

BEGIN
  WriteLn ('RD2SD v1.00 - Free DOS tool: real date to star date convertor.');
  WriteLn ('April 11, 1996. Copyright (c) 1996 by David Daniel Anderson - Reign Ware.');

  IF (ParamCount = 0) THEN ShowHelp (0);

  IF (ParamStr (1) = 'p')
    THEN GetUserDate (cDay, cMonth, cYear, Hours) ELSE
  IF (ParamStr (1) = 'c')
    THEN GetCurrDate (cDay, cMonth, cYear, Hours)
    ELSE GetParmDate (cDay, cMonth, cYear, Hours);

  WITH CurrentDate DO
  BEGIN
    CASE cMonth OF
      1 : Mo := Jan;
      2 : Mo := Feb;
      3 : Mo := Mar;
      4 : Mo := Apr;
      5 : Mo := May;
      6 : Mo := Jun;
      7 : Mo := Jul;
      8 : Mo := Aug;
      9 : Mo := Sep;
     10 : Mo := Oct;
     11 : Mo := Nov;
     12 : Mo := Dec;
    END;
    Da := cDay;
    Yr := cYear;
  END;
  WITH FirstOfYear DO
  BEGIN
    Mo := Jan;
    Da := 1;
    Yr := CurrentDate.Yr;
  END;

  Days := 1 + NumOfDays (CurrentDate) - NumOfDays (FirstOfYear);
  IF IsLeapYear (CurrentDate.Yr)
    THEN HoursInYear := 8784
    ELSE HoursInYear := 8760;

  stardate := ((((Days - 1) * 24) + Hours) * (1000 / HoursInYear));
  Str (stardate:0:2, sdStr);
  WHILE (Length (sdStr) < 6) DO sdStr := '0'+sdStr;

  WriteLn;
  WITH CurrentDate DO
    WriteLn ('Real date = ', Ord (mo) + 1, '-', da, '-', yr, ' ', Hours:0:0, ':00');
  WriteLn;
  WriteLn ('Star date = ',  CurrentDate.Yr-2323, ',', sdStr);
  WriteLn;
END.
