{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

PROGRAM real_date_maker;
USES NumDays;

PROCEDURE showhelp (errornum : BYTE);
VAR
  message : STRING [60];
BEGIN
  WriteLn;
  WriteLn ('  Usage :  SD2RD star date');
  WriteLn;
  WriteLn ('Example :  SD2RD 41153.7');
  WriteLn;
  IF errornum > 0 THEN BEGIN
    CASE errornum OF
      0 : message := '';
      ELSE  message := 'Unanticipated error of unknown type.';
    END;
    WriteLn;
    WriteLn ('ERROR: (#', errornum, ') - ', message);
  END;
  Halt (errornum);
END;

FUNCTION lz (w : WORD) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w: 0, s);
  IF Length (s) = 1 THEN
    s := '0' + s;
  lz := s;
END;

PROCEDURE sMonths (Year: INTEGER; VAR Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec : WORD; VAR HoursInYear:REAL);
BEGIN
  HoursInYear := 8760;

  Jan := 31*24;
  Feb := 28*24 + Jan;

  IF IsLeapYear (Year) THEN
  BEGIN
    HoursInYear := HoursInYear + 24;
    Inc (Feb, 24);
  END;

  Mar := 31*24 + Feb;
  Apr := 30*24 + Mar;
  May := 31*24 + Apr;
  Jun := 30*24 + May;
  Jul := 31*24 + Jun;
  Aug := 31*24 + Jul;
  Sep := 30*24 + Aug;
  Oct := 31*24 + Sep;
  Nov := 30*24 + Oct;
  Dec := 31*24 + Nov;
END;

PROCEDURE ConvertDate (mStr: STRING; VAR Month: STRING; VAR Day, Hours: REAL; Days: WORD);
BEGIN
  Month := mStr;
  Day := Trunc (1 + ((Hours - Days) / 24));
  Hours := 24 + Hours - ((Day * 24) + Days);
END;

VAR
  stardate,
  Hours,
  HoursInYear : REAL;

  Month : STRING;

  Day  : REAL;
  Year : INTEGER;
  Minutes : REAL;
  Min : WORD;

  Jan, Feb, Mar,
  Apr, May, Jun,
  Jul, Aug, Sep,
  Oct, Nov, Dec : WORD;

  vErr : INTEGER;

BEGIN
  WriteLn ('SD2RD v1.00 - Free DOS tool: star date to real date convertor.');
  WriteLn ('April 11, 1996. Copyright (c) 1996 by David Daniel Anderson - Reign Ware.');

  IF (ParamCount = 0) THEN ShowHelp (0);

  Val (ParamStr (1), stardate, vErr);
  Year := 2323 + Trunc (stardate / 1000);

  sMonths (Year, Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec, HoursInYear);

  stardate := stardate - 1000 * (Trunc (stardate / 1000));
  Hours := stardate * HoursInYear / 1000;

  IF (Hours > Nov) THEN
    ConvertDate ('December', Month, Day, Hours, Nov) ELSE
  IF (Hours > Oct) THEN
    ConvertDate ('November', Month, Day, Hours, Oct) ELSE
  IF (Hours > Sep) THEN
    ConvertDate ('October', Month, Day, Hours, Sep) ELSE
  IF (Hours > Aug) THEN
    ConvertDate ('September', Month, Day, Hours, Aug) ELSE
  IF (Hours > Jul) THEN
    ConvertDate ('August', Month, Day, Hours, Jul) ELSE
  IF (Hours > Jun) THEN
    ConvertDate ('July', Month, Day, Hours, Jun) ELSE
  IF (Hours > May) THEN
    ConvertDate ('June', Month, Day, Hours, May) ELSE
  IF (Hours > Apr) THEN
    ConvertDate ('May', Month, Day, Hours, Apr) ELSE
  IF (Hours > Mar) THEN
    ConvertDate ('April', Month, Day, Hours, Mar) ELSE
  IF (Hours > Feb) THEN
    ConvertDate ('March', Month, Day, Hours, Feb) ELSE
  IF (Hours > Jan) THEN
    ConvertDate ('February', Month, Day, Hours, Jan)
  ELSE
    ConvertDate ('January', Month, Day, Hours, 0);

  WriteLn;
  Write ('Star date ', ParamStr (1), ' is ');
  Minutes := (Hours - Trunc (Hours));
  Min := Round (Minutes * 60);
  WriteLn (Month, ' ', Day:0:0, ', ', Year, ', at ', Trunc (Hours), ':', lz (Min), ' o''clock.');
END.
